/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.CapitalStockTypeEnum;
import com.kingdee.eas.fm.fs.app.AbstractRptCapitalStockFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptCapitalStockFacadeControllerBean
extends AbstractRptCapitalStockFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.RptCapitalStockFacadeControllerBean");

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    private String genCapital(Context ctx, RptParams params) {
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        String currencyId = (String)params.getObject("comboCurrency.value");
        int type = ((CapitalStockTypeEnum)((Object)params.getObject("comboType.value"))).getValue();
        Date beginDate = (Date)params.getObject("pkBeginDate.value");
        Date endDate = (Date)params.getObject("pkEndDate.value");
        String tblName = this.createTempTable(ctx);
        return tblName;
    }

    private Map setRelevantPeriod(Context ctx, Set companyIdSet, Date date, Map companyPeriodMap) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT b.FID companyId, a.FID periodId, a.FBeginDate, a.FEndDate ").append(" FROM T_BD_Period a ").append(" JOIN T_Org_Company b ON a.FTypeId = b.FAccountPeriodId ").append(" WHERE a.FBeginDate <= ? AND a.FEndDate >= ? ").append(FMHelper.buildIn((String)"b.FId", (Object[])companyIdSet.toArray()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{date, date});
        try {
            String companyId = null;
            CompanyPeriodInfo info = null;
            while (rs.next()) {
                companyId = rs.getString("companyId");
                if (!companyPeriodMap.containsKey(companyId)) continue;
                info = (CompanyPeriodInfo)companyPeriodMap.get(companyId);
                info.setRelevantPeriodId(rs.getString("periodId"));
                info.setRelevantPeriod_beginDae(rs.getDate("FBeginDate"));
                info.setRelevantPeriod_endDate(rs.getDate("FEndDate"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return companyPeriodMap;
    }

    private Map getValidCompanyPeriod(Map map, Date beginDate, Date endDate) {
        HashMap<String, CompanyPeriodInfo> validMap = new HashMap<String, CompanyPeriodInfo>();
        CompanyPeriodInfo info = null;
        for (Map.Entry entry : map.entrySet()) {
            info = (CompanyPeriodInfo)entry.getValue();
            if (endDate.compareTo(info.getStartPeriod_beginDate()) < 0) continue;
            info.setBeginDate(beginDate);
            info.setEndDate(endDate);
            validMap.put(info.getCompanyId(), info);
        }
        return validMap;
    }

    private Map getCompanyPeriod(Context ctx, Set companyIdSet) throws BOSException {
        HashMap<String, CompanyPeriodInfo> map = new HashMap<String, CompanyPeriodInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ss.FCompanyId, sp.FID spId, sp.FBeginDate spBeginDate, sp.FEndDate spEndDate \n").append("\tcp.FID cpId, cp.FBeginDate cpBeginDate, cp.FEndDate cpEndDate \n").append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp \n").append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid \n").append(" and ss.FSystemStatusId in (select fid from t_bd_systemstatus  where fname =7) \n").append(" and ss.fisstart = 1 ").append(" and ").append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companyIdSet.toArray()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String companyId = null;
        CompanyPeriodInfo info = null;
        try {
            while (rs.next()) {
                companyId = rs.getString("FCompanyId");
                info = new CompanyPeriodInfo();
                info.setCompanyId(companyId);
                info.setStartPeriodId(rs.getString("spId"));
                info.setStartPeriod_beginDate(rs.getDate("spBeginDate"));
                info.setStartPeriod_endDate(rs.getDate("spEndDate"));
                info.setCurrentPeriodId(rs.getString("cpId"));
                info.setCurrentPeriod_beginDate(rs.getDate("spBeginDate"));
                info.setCurrentPeriod_endDate(rs.getDate("spBeginDate"));
                map.put(companyId, info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private void genFinalCapital(Context ctx, String tblName, RptParams params) {
    }

    private void genCapitalChange(Context ctx, String tblName, RptParams params) {
    }

    private void genPeriodStartCapital1(Context ctx, String tblName, RptParams params) {
    }

    private void genPeriodStartCapital2(Context ctx, String tblName, RptParams params) {
    }

    private void genPeriodStartCapital3(Context ctx, String tblName, RptParams params) {
    }

    private void genDebitCreditAmt(Context ctx, String tblName, String companyId, Date beginDate, Date endDate) {
    }

    private String createTempTable(Context ctx) {
        String tblName = null;
        return tblName;
    }

    private class CompanyPeriodInfo {
        String companyId;
        String startPeriodId;
        Date startPeriod_beginDate;
        Date startPeriod_endDate;
        String currentPeriodId;
        Date currentPeriod_beginDate;
        Date currentPeriod_endDate;
        String relevantPeriodId;
        Date relevantPeriod_beginDae;
        Date relevantPeriod_endDate;
        Date beginDate;
        Date endDate;

        private CompanyPeriodInfo() {
        }

        public String getCompanyId() {
            return this.companyId;
        }

        public void setCompanyId(String companyId) {
            this.companyId = companyId;
        }

        public Date getCurrentPeriod_beginDate() {
            return this.currentPeriod_beginDate;
        }

        public void setCurrentPeriod_beginDate(Date currentPeriod_beginDate) {
            this.currentPeriod_beginDate = currentPeriod_beginDate;
        }

        public Date getCurrentPeriod_endDate() {
            return this.currentPeriod_endDate;
        }

        public void setCurrentPeriod_endDate(Date currentPeriod_endDate) {
            this.currentPeriod_endDate = currentPeriod_endDate;
        }

        public String getCurrentPeriodId() {
            return this.currentPeriodId;
        }

        public void setCurrentPeriodId(String currentPeriodId) {
            this.currentPeriodId = currentPeriodId;
        }

        public Date getStartPeriod_beginDate() {
            return this.startPeriod_beginDate;
        }

        public void setStartPeriod_beginDate(Date startPeriod_beginDate) {
            this.startPeriod_beginDate = startPeriod_beginDate;
        }

        public Date getStartPeriod_endDate() {
            return this.startPeriod_endDate;
        }

        public void setStartPeriod_endDate(Date startPeriod_endDate) {
            this.startPeriod_endDate = startPeriod_endDate;
        }

        public String getStartPeriodId() {
            return this.startPeriodId;
        }

        public void setStartPeriodId(String startPeriodId) {
            this.startPeriodId = startPeriodId;
        }

        public Date getRelevantPeriod_beginDae() {
            return this.relevantPeriod_beginDae;
        }

        public void setRelevantPeriod_beginDae(Date relevantPeriod_beginDae) {
            this.relevantPeriod_beginDae = relevantPeriod_beginDae;
        }

        public Date getRelevantPeriod_endDate() {
            return this.relevantPeriod_endDate;
        }

        public void setRelevantPeriod_endDate(Date relevantPeriod_endDate) {
            this.relevantPeriod_endDate = relevantPeriod_endDate;
        }

        public String getRelevantPeriodId() {
            return this.relevantPeriodId;
        }

        public void setRelevantPeriodId(String relevantPeriodId) {
            this.relevantPeriodId = relevantPeriodId;
        }

        public Date getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(Date beginDate) {
            this.beginDate = beginDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }
    }
}

