/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ReceiveAccountFactory;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.fm.fs.SendAccountCollection;
import com.kingdee.eas.fm.fs.SendAccountException;
import com.kingdee.eas.fm.fs.SendAccountInfo;
import com.kingdee.eas.fm.fs.SendAcctReceiveAcctBuilder;
import com.kingdee.eas.fm.fs.SendAcctStatusEnum;
import com.kingdee.eas.fm.fs.app.AbstractSendAccountControllerBean;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class SendAccountControllerBean
extends AbstractSendAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.SendAccountControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SendAccountInfo info = (SendAccountInfo)model;
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        if (FMHelper.isEmpty((String)info.getNumber())) {
            throw new SendAccountException(SendAccountException.NUMBERISNULL);
        }
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SendAccountInfo info = (SendAccountInfo)this._getValue(ctx, pk);
        if (!info.getStatus().equals((Object)SendAcctStatusEnum.UNDEALED) && !info.getStatus().equals((Object)SendAcctStatusEnum.BACKED)) {
            throw new SendAccountException(SendAccountException.REMOVEERROR, new Object[]{info.getNumber()});
        }
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        super._delete(ctx, pk);
    }

    @Override
    protected void _check(Context ctx, Set idSet) throws BOSException, EASBizException {
        IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iContextHelper.getCurrentCompany();
        UserInfo user = iContextHelper.getCurrentUser();
        boolean isNotSamePerson = false;
        SendAccountCollection coll = this.getColl(ctx, idSet);
        SendAccountInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            this.check(ctx, info, user, isNotSamePerson);
        }
    }

    private SendAccountCollection getColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelector());
        return this.getSendAccountCollection(ctx, evi);
    }

    private void check(Context ctx, SendAccountInfo sendInfo, UserInfo user, boolean isNotSamePerson) throws EASBizException, BOSException {
        String sendBillId = sendInfo.getId().toString();
        if (!sendInfo.getStatus().equals((Object)SendAcctStatusEnum.UNDEALED)) {
            throw new SendAccountException(SendAccountException.CHECKERROR, new String[]{sendInfo.getNumber()});
        }
        if (isNotSamePerson && user.getId().toString().equals(sendInfo.getCreator().getId().toString())) {
            throw new SendAccountException(SendAccountException.CHECKPARAMERROR, new String[]{sendInfo.getNumber()});
        }
        java.util.Date submitDate = sendInfo.getSubmitCH().getSettleDate();
        this.signCheck(ctx, sendBillId, submitDate);
        SendAcctReceiveAcctBuilder builder = new SendAcctReceiveAcctBuilder();
        ReceiveAccountInfo recInfo = builder.getReceiveAcctInfo(ctx, sendBillId);
        ReceiveAccountFactory.getLocalInstance(ctx).save((CoreBaseInfo)recInfo);
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put(sendBillId, recInfo.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, idMap);
        String downBillId = recInfo.getId().toString();
        this._writeDownBillId(ctx, sendBillId, downBillId);
    }

    private void signCheck(Context ctx, String billId, java.util.Date submitDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_FS_SendAccount SET FSubmitDate = ?, FCheckerID = ?, ").append(" FLastHandlerID = ?, FStatus = ? WHERE FID = ? ");
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String userId = user.getId().toString();
        String status = "checked";
        Object[] params = new Object[]{new Date(submitDate.getTime()), userId, userId, status, billId};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("submitCH.*");
        return sic;
    }

    @Override
    protected void _writeResult(Context ctx, String billId, String result) throws BOSException, EASBizException {
        String sql = "UPDATE T_FS_SendAccount SET FResult = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{result, billId});
    }

    @Override
    protected void _writeStatusAndResult(Context ctx, String billId, SendAcctStatusEnum status, String result) throws BOSException, EASBizException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String userId = user.getId().toString();
        String sql = "UPDATE T_FS_SendAccount SET FStatus = ? , FResult = ?, FLastHandlerId = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{status.getValue(), result, userId, billId});
    }

    @Override
    protected void _writeDownBillId(Context ctx, String billId, String downBillId) throws BOSException, EASBizException {
        String sql = "UPDATE T_FS_SendAccount SET FDownBillId = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{downBillId, billId});
    }
}

