/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementBillSourceEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class SettleCheckUtil {
    public static final int ACCEPT = 1;
    public static final int CANCEL_ACCEPT = 2;
    public static final int APPROVE = 3;
    public static final int UNTI_APPROVE = 4;
    public static final int SETTLE = 5;
    public static final int UN_SETTLE = 6;
    public static final String resourcePath = "com.kingdee.eas.fm.fs.SettlementBillUI";

    public static boolean checkSettleBill(Context ctx, Set ids, int action) throws BOSException, EASBizException {
        String getSettleBillCollLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettleFacadeControllerBean.settleOld-SettleCheckUtil.checkSettleBill.getSettleBillColl");
        SettlementBillCollection coll = SettleCheckUtil.getSettleBillColl(ctx, ids);
        PerfLogRecorder.endRecord((String)getSettleBillCollLogId);
        switch (action) {
            case 1: {
                SettleCheckUtil.checkAccept(ctx, coll);
                break;
            }
            case 2: {
                SettleCheckUtil.checkCancleAccept(ctx, coll);
                break;
            }
            case 3: {
                SettleCheckUtil.checkApprove(ctx, coll);
                break;
            }
            case 4: {
                SettleCheckUtil.checkUnitApprove(ctx, coll);
                break;
            }
            case 5: {
                SettleCheckUtil.checkSettle(ctx, coll);
                break;
            }
            case 6: {
                SettleCheckUtil.checkUnSettle(ctx, coll);
            }
        }
        return true;
    }

    private static void checkUnSettle(Context ctx, SettlementBillCollection coll) throws FSException {
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo info = coll.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "HasNotSettled")});
            }
            if (info.getSource().equals((Object)SettlementBillSourceEnum.TRANSFERBILL)) {
                throw new FSException(FSException.ANTIRECPAYERROR, new String[]{info.getNumber()});
            }
            if (!info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) && !info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getSettleConfirmCH() == null) continue;
            throw new FSException(FSException.ANTIRECPAYERROR2, new String[]{info.getNumber()});
        }
    }

    private static void checkSettle(Context ctx, SettlementBillCollection coll) throws EASBizException, BOSException {
        String checkSettleLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettleFacadeControllerBean.settleOld-SettleCheckUtil.checkSettleBill-Param-TM012");
        boolean tm012 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(coll.get(0).getCompany().getId().toString()));
        PerfLogRecorder.endRecord((String)checkSettleLogId);
        String cur = "";
        for (int i = 0; i < coll.size(); ++i) {
            String beforegetSettlementBillLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettleFacadeControllerBean.settleOld-SettleCheckUtil.checkSettleBill-Before-SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo");
            SettlementBillInfo info = coll.get(i);
            SettBizTypeEnum bizType = info.getBizType().getType();
            if (tm012 && (bizType == SettBizTypeEnum.PAYOUTSIDE || bizType == SettBizTypeEnum.LINKPAY || bizType == SettBizTypeEnum.PAYOUTDIFFCUR) && EmptyUtil.isEmpty((CoreBaseInfo)info.getAuditor())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "notApprove")});
            }
            String id = info.getId().toString();
            if (!(info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.RECINSIDEDIF) || info.getType().equals((Object)SettBizTypeEnum.PAYINSIDEDIF) || info.getType().equals((Object)SettBizTypeEnum.PAYOUTDIFFCUR) || info.getType().equals((Object)SettBizTypeEnum.LINKPAY))) {
                throw new FSException(FSException.WRONGTYPE, new String[]{info.getNumber()});
            }
            PerfLogRecorder.endRecord((String)beforegetSettlementBillLogId);
            String getSettlementBillLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettleFacadeControllerBean.settleOld-SettleCheckUtil.checkSettleBill-SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo");
            SettlementBillInfo settlementBillInfo = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            PerfLogRecorder.endRecord((String)getSettlementBillLogId);
            String aftergetSettlementBillLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettleFacadeControllerBean.settleOld-SettleCheckUtil.checkSettleBill-After-SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo");
            if ((bizType == SettBizTypeEnum.PAYINSIDEDIF || bizType == SettBizTypeEnum.RECINSIDEDIF || bizType == SettBizTypeEnum.PAYOUTDIFFCUR) && settlementBillInfo.getPayeeBankAcct() == null && settlementBillInfo.getPayerBankAcct() == null) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "noCenterBankAcct")});
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "HasSettled")});
            }
            if (bizType == SettBizTypeEnum.PAYOUTDIFFCUR && info.getPayCurrency().getBaseUnit() != null) {
                if (i == 0 && info.getPayCurrency().getBaseUnit() != null) {
                    cur = info.getPayCurrency().getBaseUnit();
                }
                if (i != 0 && !cur.equals(info.getPayCurrency().getBaseUnit())) {
                    throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "msgCurDif")});
                }
            }
            PerfLogRecorder.endRecord((String)aftergetSettlementBillLogId);
        }
    }

    private static void checkUnitApprove(Context ctx, SettlementBillCollection coll) throws FSException {
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo info = coll.get(i);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "180_Settlement")});
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getAuditor())) {
                throw new FSException(FSException.HASNOTAPPROVEERRER);
            }
            if (info.getType().getValue() != 100 || !EmptyUtil.isEmpty((CoreBaseInfo)info.getAuditor())) continue;
            throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "alreadyApprove")});
        }
    }

    private static void checkApprove(Context ctx, SettlementBillCollection coll) throws FSException {
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo info = coll.get(i);
            if (info.getType().getValue() == 100 && !EmptyUtil.isEmpty((CoreBaseInfo)info.getAuditor())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "alreadyApprove")});
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getAcceptor())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "NotAccepted")});
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier())) continue;
            throw new FSException(FSException.HASSETTLEDERRER);
        }
    }

    private static void checkCancleAccept(Context ctx, SettlementBillCollection coll) throws EASBizException, BOSException {
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo info = coll.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getAcceptor())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "NotAccepted")});
            }
            Date settleDate = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString()).getSettleDate();
            if (info.getAcceptedDate().before(settleDate)) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "HasDailySettle")});
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "HasSettled")});
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getAuditor())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "unaccept")});
            }
            SettlementBillSourceEnum bizEnum = info.getSource();
            String source = bizEnum.getValue();
            if (source.equals("recAcct") || source.equals("transBill")) {
                throw new FSException(FSException.REMOVEERROR);
            }
            if (!info.isFiVouchered()) continue;
            throw new FSException(FSException.COMMON, new Object[]{SettleCheckUtil.getResource(ctx, "HasVouchered")});
        }
    }

    private static void checkAccept(Context ctx, SettlementBillCollection coll) throws BTPException, BOSException, BEException {
        for (int index = 0; index < coll.size(); ++index) {
            SettlementBillInfo info = coll.get(index);
            if (EmptyUtil.isEmpty((String)info.getSourceBillId()) || !BOSObjectType.create((String)"40284E81").equals((Object)BOSUuid.read((String)info.getSourceBillId()).getType())) continue;
            Set idsSet = BOTPUtil.getDestBillIdSet((Context)ctx, (String)info.getSourceBillId());
            Iterator it = idsSet.iterator();
            boolean isExistSettle = false;
            while (it.hasNext()) {
                String id = (String)it.next();
                if (!BOSUuid.read((String)id).getType().equals((Object)BOSObjectType.create((String)"6E41E17C"))) continue;
                if (isExistSettle) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"380_SettleCheckUtil", (Locale)ctx.getLocale())});
                }
                isExistSettle = true;
            }
        }
    }

    private static String getResource(Context ctx, String name) {
        return ResourceBase.getString((String)resourcePath, (String)name, (Locale)ctx.getLocale());
    }

    public static SettlementBillCollection getSettleBillColl(Context ctx, Set ids) throws BOSException {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("payeeInnerAcct.id");
        cel.add("payeeInnerAcct.name");
        cel.add("payeeInnerAcct.*");
        cel.add("payeeInnerAcct.company");
        cel.add("payeeInnerAcct.clhClassification.id");
        cel.add("payeeInnerAcct.clhClassification.*");
        cel.add("payerInnerAcct.id");
        cel.add("payerInnerAcct.name");
        cel.add("payerInnerAcct.*");
        cel.add("payerInnerAcct.number");
        cel.add("payerInnerAcct.clhClassification.id");
        cel.add("payerInnerAcct.clhClassification.*");
        cel.add("payerInnerAcct.company");
        cel.add("settleAcceptCH.*");
        cel.add("payerInnerAcct.applyUnit.*");
        cel.add("payeeInnerAcct.applyUnit.*");
        cel.add("payeeInnerAcct.isReckoning");
        cel.add("payerInnerAcct.isReckoning");
        cel.add("payerBankAcct.*");
        cel.add("payeeBankAcct.*");
        cel.add("bizType.isSendDownUnit");
        cel.add("bizType.type");
        cel.add("payCurrency.baseUnit");
        return SettleCheckUtil.getSettleBillCoBySelector(ctx, ids, cel);
    }

    private static SettlementBillCollection getSettleBillCoBySelector(Context ctx, Set ids, SelectorItemCollection cel) throws BOSException {
        ISettlementBill iSettlementBill = SettlementBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)cel);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        SettlementBillCollection coll = iSettlementBill.getSettlementBillCollection(view);
        return coll;
    }
}

