/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

public class SettlementBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    protected SettlementBillInfo info = null;
    protected String tm109 = null;
    protected PeriodInfo currPeriod = null;
    private boolean isCommitToBE = false;

    public SettlementBillBookNotifyBuilder() {
    }

    public SettlementBillBookNotifyBuilder(SettlementBillInfo info, String tm109, PeriodInfo currPeriod) {
        this.info = info;
        this.tm109 = tm109;
        this.currPeriod = currPeriod;
    }

    public SettlementBillBookNotifyBuilder(SettlementBillInfo info, String tm109, PeriodInfo currPeriod, boolean isCommitToBE) {
        this.info = info;
        this.tm109 = tm109;
        this.currPeriod = currPeriod;
        this.isCommitToBE = isCommitToBE;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("company.baseCurrency.id");
        cel.add("company.baseExchangeTable.id");
        cel.add("payerBankAcct.*");
        cel.add("payerBankAcct.currency.id");
        cel.add("payerBankAcct.account.id");
        cel.add("payeeBankAcct.*");
        cel.add("payeeBankAcct.account.id");
        cel.add("payeeAcct.*");
        cel.add("payerAcct.*");
        cel.add("bizType.*");
        cel.add("payCurrency.*");
        cel.add("payerInnerAcct.*");
        cel.add("payerInnerAcct.applyUnit.*");
        cel.add("payerInnerAcct.clearingHouse.*");
        cel.add("payeeInnerAcct.*");
        cel.add("payeeInnerAcct.applyUnit.*");
        cel.add("payeeInnerAcct.clearingHouse.*");
        return cel;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        AccountViewInfo payerAcct;
        JournalCollection journalCollection = new JournalCollection();
        SettlementBillInfo settleBillInfo = this.info;
        if (settleBillInfo == null) {
            settleBillInfo = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billId)), this.getSelector());
        }
        String tm109 = null;
        if (this.tm109 != null) {
            tm109 = this.tm109;
        } else {
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap param = new HashMap();
            param.put("TM109", settleBillInfo.getCompany().getId().toString());
            param = pc.getParamHashMap(param);
            tm109 = (String)param.get("TM109");
        }
        boolean isMinusReverse = tm109 != null && tm109.equals("1");
        AccountViewInfo payeeAcct = settleBillInfo.getPayeeAcct();
        if (payeeAcct != null) {
            BigDecimal amount;
            JournalInfo journalInfo;
            if (payeeAcct.isIsBank()) {
                if (settleBillInfo.getPayeeBankAcct() != null && settleBillInfo.getPayeeBankAcct().getCompany() != null && settleBillInfo.getCompany().getId().equals((Object)settleBillInfo.getPayeeBankAcct().getCompany().getId())) {
                    journalInfo = this.createBaseJournal(ctx, settleBillInfo);
                    amount = settleBillInfo.getAmount();
                    if (isMinusReverse && amount.compareTo(FMConstants.ZERO) < 0) {
                        journalInfo.setCreditAmount(amount.abs());
                        journalInfo.setDebitAmount(Constants.ZERO);
                    } else {
                        journalInfo.setDebitAmount(amount);
                        journalInfo.setCreditAmount(Constants.ZERO);
                    }
                    journalInfo.setType(JournalTypeEnum.BANK);
                    journalInfo.setAccountBank(settleBillInfo.getPayeeBankAcct());
                    journalInfo.setAccountView(payeeAcct);
                    journalCollection.add(journalInfo);
                }
            } else if (payeeAcct.isIsCash()) {
                journalInfo = this.createBaseJournal(ctx, settleBillInfo);
                amount = settleBillInfo.getAmount();
                if (isMinusReverse && amount.compareTo(FMConstants.ZERO) < 0) {
                    journalInfo.setCreditAmount(amount.abs());
                    journalInfo.setDebitAmount(Constants.ZERO);
                } else {
                    journalInfo.setDebitAmount(amount);
                    journalInfo.setCreditAmount(Constants.ZERO);
                }
                journalInfo.setType(JournalTypeEnum.CASH);
                journalInfo.setAccountView(payeeAcct);
                journalCollection.add(journalInfo);
            }
        }
        if ((payerAcct = settleBillInfo.getPayerAcct()) != null) {
            JournalInfo journalInfo;
            if (payerAcct.isIsBank()) {
                if (settleBillInfo.getPayerBankAcct() != null && settleBillInfo.getPayerBankAcct().getCompany() != null && settleBillInfo.getCompany().getId().equals((Object)settleBillInfo.getPayerBankAcct().getCompany().getId())) {
                    journalInfo = this.createBaseJournal(ctx, settleBillInfo);
                    BigDecimal amount = Constants.ZERO;
                    amount = settleBillInfo.getBizType().getType().getValue() == 100 ? settleBillInfo.getPayAmount() : settleBillInfo.getAmount();
                    if (isMinusReverse && amount.compareTo(FMConstants.ZERO) < 0) {
                        journalInfo.setDebitAmount(amount.abs());
                        journalInfo.setCreditAmount(Constants.ZERO);
                    } else {
                        journalInfo.setCreditAmount(amount);
                        journalInfo.setDebitAmount(Constants.ZERO);
                    }
                    journalInfo.setType(JournalTypeEnum.BANK);
                    journalInfo.setAccountBank(settleBillInfo.getPayerBankAcct());
                    journalInfo.setAccountView(payerAcct);
                    journalCollection.add(journalInfo);
                }
            } else if (payerAcct.isIsCash()) {
                journalInfo = this.createBaseJournal(ctx, settleBillInfo);
                BigDecimal amount = Constants.ZERO;
                amount = settleBillInfo.getBizType().getType().getValue() == 100 ? settleBillInfo.getPayAmount() : settleBillInfo.getAmount();
                if (isMinusReverse && amount.compareTo(FMConstants.ZERO) < 0) {
                    journalInfo.setDebitAmount(amount.abs());
                    journalInfo.setCreditAmount(Constants.ZERO);
                } else {
                    journalInfo.setCreditAmount(amount);
                    journalInfo.setDebitAmount(Constants.ZERO);
                }
                journalInfo.setType(JournalTypeEnum.CASH);
                journalInfo.setAccountView(payerAcct);
                journalCollection.add(journalInfo);
            }
        }
        return journalCollection;
    }

    private JournalInfo createBaseJournal(Context ctx, SettlementBillInfo settleBillInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(settleBillInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(settleBillInfo.getId().toString());
        Date date = settleBillInfo.getBizDate();
        CompanyOrgUnitInfo companyInfo2 = settleBillInfo.getCompany();
        PeriodInfo currPeriodInfo = null;
        currPeriodInfo = this.currPeriod != null ? this.currPeriod : SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo2);
        int CS104 = this.getCS104(ctx);
        if (CS104 == 1 || CS104 == 2 && this.isCommitToBE) {
            date = new Date();
        }
        if (currPeriodInfo != null && date.before(currPeriodInfo.getBeginDate())) {
            date = currPeriodInfo.getBeginDate();
        }
        journalInfo.setCreateDate(date);
        journalInfo.setBizDate(settleBillInfo.getBizDate());
        currPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)companyInfo2);
        journalInfo.setPeriod(currPeriodInfo);
        if (settleBillInfo.getType() == SettBizTypeEnum.RECOUTSIDE) {
            if (settleBillInfo.getPayerFullName() != null) {
                journalInfo.setOppUnit(settleBillInfo.getPayerFullName());
            }
            if (settleBillInfo.getPayerBank() != null) {
                journalInfo.setOppBank(settleBillInfo.getPayerBank());
            }
            if (settleBillInfo.getPayerBankAcctNum() != null) {
                journalInfo.setOppAcctNumber(settleBillInfo.getPayerBankAcctNum());
            }
        }
        if (settleBillInfo.getType() == SettBizTypeEnum.PAYOUTSIDE || settleBillInfo.getType() == SettBizTypeEnum.PAYOUTDIFFCUR) {
            if (settleBillInfo.getPayeeFullName() != null) {
                journalInfo.setOppUnit(settleBillInfo.getPayeeFullName());
            }
            if (settleBillInfo.getPayeeBank() != null) {
                journalInfo.setOppBank(settleBillInfo.getPayeeBank());
            }
            if (settleBillInfo.getPayeeBankAcctNum() != null) {
                journalInfo.setOppAcctNumber(settleBillInfo.getPayeeBankAcctNum());
            }
        }
        if (settleBillInfo.getType() == SettBizTypeEnum.LINKPAY) {
            if (settleBillInfo.getPayerFullName() != null) {
                journalInfo.setOppUnit(settleBillInfo.getPayerFullName());
            }
            if (settleBillInfo.getSubAccount() != null) {
                journalInfo.setOppAcctNumber(settleBillInfo.getSubAccount());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("bank.*");
                filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)settleBillInfo.getSubAccount(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.name", (Object)settleBillInfo.getPayerFullName(), CompareType.EQUALS));
                view.setFilter(filter);
                view.setSelector(sic);
                AccountBankCollection acctColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                if (acctColl.size() > 0) {
                    journalInfo.setOppBank(acctColl.get(0).getBank().getName());
                }
            }
        }
        if (settleBillInfo.getType() == SettBizTypeEnum.RECINSIDEDIF && !EmptyUtil.isEmpty((Object)settleBillInfo.getPayerInnerAcct())) {
            if (!EmptyUtil.isEmpty((Object)settleBillInfo.getPayerInnerAcct().getApplyUnit())) {
                journalInfo.setOppUnit(settleBillInfo.getPayerInnerAcct().getApplyUnit().getName());
            }
            if (!EmptyUtil.isEmpty((Object)settleBillInfo.getPayerInnerAcct().getClearingHouse())) {
                journalInfo.setOppBank(settleBillInfo.getPayerInnerAcct().getClearingHouse().getName());
            }
            journalInfo.setOppAcctNumber(settleBillInfo.getPayerInnerAcct().getAcctNumber());
        }
        if (settleBillInfo.getType() == SettBizTypeEnum.PAYINSIDEDIF && !EmptyUtil.isEmpty((Object)settleBillInfo.getPayeeInnerAcct())) {
            if (!EmptyUtil.isEmpty((Object)settleBillInfo.getPayeeInnerAcct().getApplyUnit())) {
                journalInfo.setOppUnit(settleBillInfo.getPayeeInnerAcct().getApplyUnit().getName());
            }
            if (!EmptyUtil.isEmpty((Object)settleBillInfo.getPayeeInnerAcct().getClearingHouse())) {
                journalInfo.setOppBank(settleBillInfo.getPayeeInnerAcct().getClearingHouse().getName());
            }
            journalInfo.setOppAcctNumber(settleBillInfo.getPayeeInnerAcct().getAcctNumber());
        }
        journalInfo.setBillType(BillTypeEnum.settlementBill);
        journalInfo.setBillNumber(settleBillInfo.getNumber());
        if (EmptyUtil.isEmpty((Object)settleBillInfo.getPayerBankAcct())) {
            journalInfo.setCurrency(settleBillInfo.getCurrency());
        } else if (EmptyUtil.isEmpty((Object)settleBillInfo.getPayerBankAcct().getCurrency())) {
            journalInfo.setCurrency(settleBillInfo.getCurrency());
        } else {
            journalInfo.setCurrency(settleBillInfo.getPayerBankAcct().getCurrency());
        }
        if (settleBillInfo.getBizType().getType().getValue() == 100) {
            journalInfo.setCurrency(settleBillInfo.getPayCurrency());
        }
        journalInfo.setDescription(settleBillInfo.getDescription());
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setSettlementType(settleBillInfo.getSettleType());
        journalInfo.setSettlementNumber(settleBillInfo.getOuterSettleNumber());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setBankCheckFlag(settleBillInfo.getReqSeqNo());
        return journalInfo;
    }

    private int getCS104(Context ctx) throws BOSException, EASBizException {
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        String strValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS104");
        int val = Integer.parseInt(strValue);
        return val;
    }
}

