/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AntiRepeatSettingFactory;
import com.kingdee.eas.fi.cas.AntiRepeatSettingInfo;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.OperateBillEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillLogFactory;
import com.kingdee.eas.fi.cas.PaymentBillLogInfo;
import com.kingdee.eas.fi.cas.PaymentOperateType;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.RepeatBillTypeEnum;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.util.BizRelateReceivableBillUtil;
import com.kingdee.eas.fm.common.util.ReceivableBillEntryVO;
import com.kingdee.eas.fm.fd.FDException;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingFactory;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.ISettleFacade;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettleMutilTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementBillSourceEnum;
import com.kingdee.eas.fm.fs.SettlementBillStatusEnum;
import com.kingdee.eas.fm.fs.UpReckoningTypeEnum;
import com.kingdee.eas.fm.fs.app.AbstractSettlementBillControllerBean;
import com.kingdee.eas.fm.fs.app.OverDraftCheckHelper;
import com.kingdee.eas.fm.fs.app.SettleBillDataVerify;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.EndorseStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillEntryCollection;
import com.kingdee.eas.fm.nt.EndorsementBillEntryInfo;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementSettleEntryInfo;
import com.kingdee.eas.fm.nt.EndorsementTypeEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SettlementBillControllerBean
extends AbstractSettlementBillControllerBean {
    private static Logger logger = Logger.getLogger((String)SettlementBillControllerBean.class.getName());
    private static final String resourcePath = "com.kingdee.eas.fm.fs.FSAutoGenerateResource";
    private static final String BIZTYPE = "\u4e1a\u52a1\u79cd\u7c7b";
    private static final String PAYEEFULLNAME = "\u6536\u6b3e\u5355\u4f4d";
    private static final String PAYEEBANKACCTNUM = "\u6536\u6b3e\u8d26\u53f7";
    private static final String PAYEEBANK = "\u6536\u6b3e\u94f6\u884c";
    private static final String PAYERFULLNAME = "\u4ed8\u6b3e\u5355\u4f4d";
    private static final String PAYERINNERACCT = "\u4ed8\u6b3e\u8d26\u6237";
    private static final String INNERPAYERACCT = "\u4ed8\u6b3e\u79d1\u76ee";
    private static final String SUBACCOUNT = "\u5b50\u516c\u53f8\u94f6\u884c\u8d26\u6237";
    private static final String FUNDFLOWITEMOUT = "\u8d44\u91d1\u6d41\u91cf\u9879\u76ee";
    private static final String ISFORCEMANUAL = "\u5f3a\u5236\u843d\u5730";
    private static final String SWIFTCODE = "swiftcode";
    private static final String ISURGENT = "\u662f\u5426\u52a0\u6025";
    private static final String AMOUNT = "\u91d1\u989d";
    private static final String CURRENCY = "\u5e01\u522b";
    private static final String EXCHANGE = "\u6c47\u7387";
    private static final String PAYERBANKACCT = "\u4ed8\u6b3e\u4e2d\u5fc3\u8d26\u6237";
    private static final String PAYERACCT = "\u4ed8\u6b3e\u4e2d\u5fc3\u79d1\u76ee";
    private static final String PAYERBANK = "\u4ed8\u6b3e\u94f6\u884c";
    private static final String SETTLETYPE = "\u5916\u90e8\u7ed3\u7b97\u65b9\u5f0f";
    private static final String USAGE = "\u7528\u9014";
    private static final String EXPECTDEALTIME = "\u671f\u671b\u4ea4\u6613\u65e5\u671f";
    private static final String FRECCOUNTRY = "\u6536\u6b3e\u65b9\u56fd\u5bb6";
    private static final String RECPROVINCESTR = "\u6536\u6b3e\u65b9\u7701";
    private static final String RECCITYSTR = "\u6536\u6b3e\u65b9\u5e02/\u53bf";
    private static final String BANKACCTNAME = "\u6536\u6b3e\u4eba\u5b9e\u540d";
    private static final String BANKNUMBER = "\u6536\u6b3e\u884c\u884c\u53f7";
    private static final String FINPAYERINACCT = "\u5b9e\u4ed8\u5185\u90e8\u8d26\u6237";
    private static final String FINPAYERBANKACT = "\u5b9e\u4ed8\u4e2d\u5fc3\u8d26\u6237";

    @Override
    protected void _addBatch(Context ctx, IObjectCollection settStatements) throws EASBizException, BOSException {
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (int i = 0; i < settStatements.size(); ++i) {
            SettlementBillInfo info = (SettlementBillInfo)settStatements.getObject(i);
            String sourceBillId = info.getSourceBillId();
            if (!FMHelper.isEmpty((String)sourceBillId)) {
                idMap.put(sourceBillId, info.getId().toString());
            }
            if (info.isHasEffected()) {
                this.submit(ctx, (CoreBaseInfo)info);
                continue;
            }
            this.save(ctx, (CoreBaseInfo)info);
        }
        FMHelper.saveBOTRelation((Context)ctx, idMap);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk, boolean isNeedInvokeWf) throws BOSException, EASBizException {
        if (isNeedInvokeWf) {
            this.delete(ctx, pk);
        } else {
            this._delete(ctx, pk);
        }
    }

    @Override
    protected int _batchRemove(Context ctx, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("auditor.id");
        evi.getSelector().add("acceptor.id");
        evi.getSelector().add("acceptDate");
        SettlementBillCollection coll = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(evi);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            SettlementBillInfo bill = coll.get(i);
            this.verifyCanRemove(ctx, bill);
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()));
        }
        return size;
    }

    protected void verifyCanRemove(Context ctx, SettlementBillInfo bill) throws BOSException, EASBizException {
        if (bill.getAuditor() != null) {
            throw new FSException(FSException.APPROVEDNOTDELETE);
        }
        if (bill.getAcceptor() != null || bill.getAcceptedDate() != null) {
            throw new FSException(FSException.ACCEPTEDNOTDELETE);
        }
        ArrayList<FilterItemInfo> filterInfo = new ArrayList<FilterItemInfo>();
        filterInfo.add(new FilterItemInfo("destObjectID", (Object)bill.getId().toString(), CompareType.EQUALS));
        filterInfo.add(new FilterItemInfo("srcEntityID", (Object)"380D4F63", CompareType.NOTEQUALS));
        Set src = FMHelper.getSrcBillIdSet((Context)ctx, filterInfo);
        if (src != null && src.size() > 0) {
            throw new FSException(FSException.BOTPTRANSNOTDELETE);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        NTTypeInfo ntInfo;
        HashSet<String> idSet;
        RecPayHelper helper;
        SettlementBillInfo info = this.getSettlementBillInfo(ctx, pk, this.getSelector());
        if (info.isIsAccepted() || info.isFiVouchered()) {
            throw new FSException(FSException.HASACCEPTEDERRER);
        }
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        SettlementBillSourceEnum source = info.getSource();
        String srcId = info.getSourceBillId();
        if (srcId != null && !source.equals((Object)SettlementBillSourceEnum.BETRANSDETAIL)) {
            helper = new RecPayHelper();
            idSet = new HashSet<String>();
            idSet.add(srcId);
            helper.SignUnSubmitSymbol(ctx, idSet);
        }
        if (srcId != null && source.equals((Object)SettlementBillSourceEnum.PAYMENTBILL)) {
            try {
                helper = new RecPayHelper();
                idSet = new HashSet();
                idSet.add(srcId);
                helper.updateFundDisPlan(ctx, idSet);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new FDException(FDException.UPDATE_PAY_ERROR);
            }
        }
        if (info.getType() != null && info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) && info.getSettleType() != null && info.getSettleType().getNtType() != null && ("004".equals((ntInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(info.getSettleType().getNtType().getId()))).getNumber()) || "005".equals(ntInfo.getNumber()))) {
            ReceivableBillFactory.getLocalInstance((Context)ctx).lockReceivanleBill((CoreBaseInfo)info, "delete");
        }
        if (srcId != null && source.equals((Object)SettlementBillSourceEnum.PAYMENTBILL)) {
            AutoMatchAcctSettingFactory.getLocalInstance(ctx).delRecord(srcId, null, null);
        }
        if (srcId != null && source.equals((Object)SettlementBillSourceEnum.BETRANSDETAIL)) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(srcId);
            HashMap valueMap = new HashMap();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("isReced", Boolean.FALSE);
            value.put("recedBillType", info.getBOSType());
            value.put("recedBillNumber", info.getNumber());
            valueMap.put(srcId, value);
            TransDetailFactory.getLocalInstance((Context)ctx).disposeRecInfo(ids, valueMap);
        }
        String boName = "com.kingdee.eas.fm.fs.app.SettlementBill";
        AttachmentManagerFactory.getServerManager((Context)ctx).deleteAttachemtsByBoID(pk.toString());
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        logger.info((Object)("settlementbill recycleNumber :" + info.getNumber()));
        BizRelateReceivableBillUtil.deleteReceivableEntry((Context)ctx, (CoreBaseInfo)info, (IObjectPK)pk);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("settleType.*"));
        return sic;
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        NTTypeInfo ntInfo;
        String settNum;
        String s;
        BOSUuid sbid;
        SettlementBillInfo info = (SettlementBillInfo)model;
        if (info.getSource() == null) {
            info.setSource(SettlementBillSourceEnum.MANUAL);
        }
        this.initNumber(ctx, info);
        if (info.getEntrys().size() > 0) {
            info.setIsHaveEntrys(true);
        }
        info.setMutilType(info.genMutilType(ctx));
        this.checkNumberDup(ctx, model);
        this.setDefaultPayeeBankAcctF7(ctx, info);
        this.setDefalutPayerInnerAcct(ctx, info);
        this.setDefaultPayerBankAcctF7(ctx, info);
        this.setDefalutPayeeInnerAcct(ctx, info);
        FSHelper.setDlByRecPay(ctx, info);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        if (!FMHelper.isEmpty((String)info.getSourceBillId()) && (sbid = BOSUuid.read((String)info.getSourceBillId())).getType().equals((Object)new PaymentBillInfo().getBOSType()) && (info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.LINKPAY))) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payeeFullName");
            if (!FMHelper.isEmpty((String)info.getPayeeBank())) {
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payeeBankAcctNum");
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"description");
        }
        if ((s = info.getBankAcctName()) != null && s.length() > 255) {
            info.setBankAcctName(s.substring(0, 255));
        }
        if ((settNum = info.getOuterSettleNumber()) != null && settNum.length() > 2000) {
            info.setOuterSettleNumber(settNum.substring(0, 2000));
        }
        IObjectPK pk = super._addnew(ctx, model);
        if (info.isIsCopyAdd()) {
            BizobjectFacadeFactory.getLocalInstance((Context)ctx).copyBizRelation(info.getSourceBillId(), pk.toString());
        }
        if (info.getType() != null && info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) && info.getSettleType() != null && info.getSettleType().getNtType() != null && !info.isIsGenPaymentBill() && ("004".equals((ntInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(info.getSettleType().getNtType().getId()))).getNumber()) || "005".equals(ntInfo.getNumber())) && EmptyUtil.isEmpty((Object)ctx.get((Object)"fromVerifyChongFu"))) {
            ReceivableBillFactory.getLocalInstance((Context)ctx).lockReceivanleBill((CoreBaseInfo)info, "addNew");
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new SettlementBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_settlementBill_add", (String)info.getCompany().getId().toString(), (String)"\u7ed3\u7b97\u5355\u65b0\u589e");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        BizRelateReceivableBillUtil.relateReceivableBill((Context)ctx, (CoreBaseInfo)info, (IObjectPK)pk);
        return pk;
    }

    protected void initNumber(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!FMHelper.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent;
            if (FMHelper.isEmpty((String)(numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())))) {
                return;
            }
            info.setNumber(numberSilent);
        } while (this._exists(ctx, filter = FMHelper.getCheckNumberDupFilter((IObjectValue)info, (boolean)true)) && ++i < 10);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String settNum;
        String s;
        SettlementBillInfo info = (SettlementBillInfo)model;
        FSHelper.setDlByRecPay(ctx, (SettlementBillInfo)model);
        if (info.getCashier() != null) {
            info.setBillStatus(SettlementBillStatusEnum.SETTLEMENTED);
        } else if (info.getAuditor() != null) {
            info.setBillStatus(SettlementBillStatusEnum.AUDIT);
        } else if (info.getAcceptor() != null) {
            info.setBillStatus(SettlementBillStatusEnum.ACCEPTED);
        } else if (info.isHasEffected()) {
            info.setBillStatus(SettlementBillStatusEnum.SUBMITED);
        } else {
            info.setBillStatus(SettlementBillStatusEnum.SAVED);
        }
        if (info.getType() != null) {
            info.setMutilType(info.genMutilType(ctx));
        }
        if ((s = info.getBankAcctName()) != null && s.length() > 255) {
            info.setBankAcctName(s.substring(0, 255));
        }
        if ((settNum = info.getOuterSettleNumber()) != null && settNum.length() > 2000) {
            info.setOuterSettleNumber(settNum.substring(0, 2000));
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean CS127;
        NTTypeInfo ntInfo;
        SettlementBillInfo value;
        PaymentBillInfo payinfo;
        BOSUuid sbid;
        String be022;
        SettlementBillInfo oldInfo;
        Pattern pattern;
        Matcher isNum;
        SettlementBillInfo info = (SettlementBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((SettlementBillInfo)model));
        if (!EmptyUtil.isEmpty((String)info.getPayeeBankAcctNum()) && !(isNum = (pattern = Pattern.compile("^[^\\s]*$")).matcher(info.getPayeeBankAcctNum().toString())).matches()) {
            throw new CasException(CasException.ISNOTNUMBER);
        }
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = this.getSettlementBillInfo(ctx, "select * where id='" + info.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        if (info.getMutilType() != null && (info.getType() == SettBizTypeEnum.RECINSIDEDIF || info.getType() == SettBizTypeEnum.PAYINSIDEDIF)) {
            switch (info.getMutilType().getValue()) {
                case 1: {
                    if (info.getInnerPayeeAcct() == null) {
                        throw new FSException(FSException.MUSTINNERPAYEEVIEW);
                    }
                    if (info.getPayeeBankAcct() == null && info.getInnerPayerAcct() == null) {
                        throw new FSException(FSException.MUSTPAYEEBANKACCTORPAYERVIEW);
                    }
                    if (info.getPayeeBankAcct() == null || info.getPayerInnerAcct() == null || !info.getPayeeBankAcct().isIsReckoning() || !info.getPayerInnerAcct().isIsReckoning()) break;
                    throw new FSException(FSException.PAYEEBANKACCTANDPAYERACCTRECK);
                }
                case 2: {
                    if (info.getInnerPayerAcct() == null) {
                        throw new FSException(FSException.MUSTINNERPAYERVIEW);
                    }
                    if (info.getPayerBankAcct() == null && info.getInnerPayeeAcct() == null) {
                        throw new FSException(FSException.MUSTPAYERBANKACCTORPAYEEVIEW);
                    }
                    if (info.getPayerBankAcct() == null || info.getPayeeInnerAcct() == null || !info.getPayerBankAcct().isIsReckoning() || !info.getPayeeInnerAcct().isIsReckoning()) break;
                    throw new FSException(FSException.PAYERBANKACCTANDPAYEEACCTRECK);
                }
                case 3: {
                    if (info.getInnerPayeeAcct() != null && info.getInnerPayerAcct() != null) break;
                    throw new FSException(FSException.MUSTHAVEINNERSIDEACCTVIEW);
                }
            }
        }
        if (info.getSource() == null) {
            info.setSource(SettlementBillSourceEnum.MANUAL);
        }
        if (info.getPayeeInnerAcct() != null && (!info.getPayeeInnerAcct().isIsUsed() || info.getPayeeInnerAcct().isClosed())) {
            throw new FSException(FSException.INNERACCTCANTUSE, new String[]{info.getPayeeInnerAcct().getName()});
        }
        if (info.getPayerInnerAcct() != null && (!info.getPayerInnerAcct().isIsUsed() || info.getPayerInnerAcct().isClosed())) {
            throw new FSException(FSException.INNERACCTCANTUSE, new String[]{info.getPayerInnerAcct().getName()});
        }
        if (info.getSettleType() != null && info.getSettleType().isPayThroughBE() && (SettBizTypeEnum.PAYOUTSIDE.equals((Object)info.getType()) || SettBizTypeEnum.PAYOUTDIFFCUR.equals((Object)info.getType()) || SettBizTypeEnum.LINKPAY.equals((Object)info.getType())) && (be022 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("BE022", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()))) != null && "1".equals(be022)) {
            String beBankNumber = info.getBankNumber();
            String beBankName = info.getPayeeBank();
            String province = info.getRecProvinceStr();
            String city = info.getRecCityStr();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)beBankNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)beBankName, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("State", (Object)1, CompareType.EQUALS));
            if (!EmptyUtil.isEmpty((String)province)) {
                filter.getFilterItems().add(new FilterItemInfo("BeProvince", (Object)province, CompareType.EQUALS));
            }
            if (!EmptyUtil.isEmpty((String)city)) {
                filter.getFilterItems().add(new FilterItemInfo("BeCity", (Object)city, CompareType.EQUALS));
            }
            view.setFilter(filter);
            BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
            if (coll == null || coll.size() == 0) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)resourcePath, (String)"500_SettlementBillControllerBean", (Locale)ctx.getLocale())});
            }
        }
        this.setAccountView(info);
        this.setSettleConfirmCH(ctx, info);
        FSHelper.setDlByRecPay(ctx, info);
        String pk = info.getSourceBillId();
        if (pk != null && !"".equals(pk) && (sbid = BOSUuid.read((String)pk)).getType().equals((Object)new PaymentBillInfo().getBOSType()) && (payinfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectStringPK(pk), this.getSelectors())) != null && payinfo.getPayBillType().isIsFinanceTranUp()) {
            info.setType(SettBizTypeEnum.RECOUTSIDE);
        }
        info.setMutilType(info.genMutilType(ctx));
        if (info.getId() != null && this.exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (value = (SettlementBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))).isIsAccepted()) {
            throw new FSException(FSException.HASACCEPTEDERRER);
        }
        this.initNumber(ctx, info);
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        SettleBillDataVerify.verifyInfo(ctx, info);
        if (!info.isHasEffected()) {
            OverDraftCheckHelper.checkOverDraft(ctx, model, 0, false, Constants.ZERO, false);
        } else {
            OverDraftCheckHelper.checkOverDraft(ctx, model, 1, false, Constants.ZERO, false);
        }
        if (info.getId() != null && SettlementBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
            String boName = "com.kingdee.eas.fm.fs.app.SettlementBill";
            FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
        this.setAutoBankAcct(ctx, model);
        if (info.getType() != null && info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) && info.getSettleType() != null && info.getSettleType().getNtType() != null && info.getOuterSettleNumber() != null && ("004".equals((ntInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(info.getSettleType().getNtType().getId()))).getNumber()) || "005".equals(ntInfo.getNumber()))) {
            ReceivableBillFactory.getLocalInstance((Context)ctx).lockReceivanleBill((CoreBaseInfo)info, "edit");
            if (this.isExistReceivableBill(ctx, info)) {
                this.updateSourceBill(ctx, info);
            }
        }
        if ((CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()))) && (info.getType() == SettBizTypeEnum.PAYOUTSIDE || info.getType() == SettBizTypeEnum.LINKPAY)) {
            this.recordPayInfoLog(ctx, info, PaymentOperateType.SUBMIT);
        }
        IObjectPK objectPK = super._submit(ctx, model);
        BizRelateReceivableBillUtil.relateReceivableBill((Context)ctx, (CoreBaseInfo)info, (IObjectPK)objectPK);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u63d0\u4ea4\u7ed3\u7b97\u5355", (BOSObjectType)new SettlementBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_settlementBill_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        SettlementBillInfo sumbittedInfo = this.getSettlementBillInfo(ctx, "select * where id='" + objectPK.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)objectPK, (IFMBgUsed)sumbittedInfo);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)objectPK);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (info.isBotpGen()) {
            return objectPK;
        }
        BankInfo clearingHouseInfo = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString());
        if (clearingHouseInfo == null) {
            return objectPK;
        }
        CompanyOrgUnitInfo clearingHouseCompany = clearingHouseInfo.getRelatedCompany();
        boolean val = false;
        if (currentCompany.getId().toString().equals(clearingHouseCompany.getId().toString()) && (val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM004", (IObjectPK)new ObjectUuidPK(currentCompany.getId())))) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(objectPK.toString());
            ISettleFacade iSettleFacade = SettleFacadeFactory.getLocalInstance(ctx);
            iSettleFacade.innerAccetp(ids);
        }
        if (info.getOuterSettleNumber() != null && info.getType().getValue() == 2) {
            String[] numbers = info.getOuterSettleNumber().split(";");
            ArrayList<String> numberList = new ArrayList<String>();
            for (int i = 0; i < numbers.length; ++i) {
                numberList.add(numbers[i]);
            }
            this._submitOutSettNumber(ctx, objectPK, numberList);
        }
        if (!val) {
            String sql = " update t_fs_settlementbill set fbillstatus = 2  where fid = '" + objectPK + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (info.getSettleType() != null && info.getSettleType().isPayThroughBE() && !EmptyUtil.isEmpty((String)info.getPayeeBankAcctNum())) {
            char[] chars_test2 = info.getPayeeBankAcctNum().toCharArray();
            for (int i = 0; i < chars_test2.length; ++i) {
                String temp = String.valueOf(chars_test2[i]);
                if (!temp.matches("[^\\x00-\\xff]")) continue;
                throw new CasException(CasException.RECACCT_CANNOT_FULL);
            }
        }
        return objectPK;
    }

    private boolean isExistReceivableBill(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        String[] billNumber = info.getOuterSettleNumber().replace(" ", "").split(";");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < billNumber.length; ++i) {
            set.add(billNumber[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("draftNumber", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
        return ReceivableBillFactory.getLocalInstance((Context)ctx).exists(filter);
    }

    private void updateSourceBill(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        if (info.getSourceBillId() != null && info.getOuterSettleNumber() != null) {
            String sql;
            Map map = this.getPaySchDetailBill(ctx, info.getSourceBillId(), info.getCompany().getId().toString());
            if (!EmptyUtil.isEmpty(map.get("payment"))) {
                PaymentBillInfo payMentBillInfo = (PaymentBillInfo)map.get("payment");
                sql = "update T_CAS_PaymentBill set fsettlementNumber=? where Fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getOuterSettleNumber().replaceAll(" ", ""), payMentBillInfo.getId().toString()});
            }
            if (!EmptyUtil.isEmpty(map.get("paySchDetail"))) {
                PaySchDetailBillInfo paySchDetailBillInfo = (PaySchDetailBillInfo)map.get("paySchDetail");
                sql = "delete from T_PP_PaySchDetailBillNTs where FParentID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{paySchDetailBillInfo.getId().toString()});
                String[] billNumber = info.getOuterSettleNumber().replace(" ", "").split(";");
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < billNumber.length; ++i) {
                    set.add(billNumber[i]);
                }
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                view.setSelector(sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("draftNumber", set, CompareType.INCLUDE));
                view.setFilter(filter);
                ReceivableBillCollection receColl = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(view);
                for (int i = 0; i < receColl.size(); ++i) {
                    PaySchDetailBillNTsInfo nTsInfo = new PaySchDetailBillNTsInfo();
                    nTsInfo.setParent(paySchDetailBillInfo);
                    nTsInfo.setReceivableBill(receColl.get(i));
                    PaySchDetailBillNTsFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)nTsInfo);
                }
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        NTTypeInfo ntInfo;
        SettlementBillInfo info = (SettlementBillInfo)model;
        if (info.getSource() == null) {
            info.setSource(SettlementBillSourceEnum.MANUAL);
        }
        if (info.getId() != null && this.exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            SettlementBillInfo value = (SettlementBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            if (value.isHasEffected()) {
                throw new FSException(FSException.HASSUBMITERRER);
            }
            if (value.isIsAccepted()) {
                throw new FSException(FSException.HASACCEPTEDERRER);
            }
        }
        this.setAccountView(info);
        this.setSettleConfirmCH(ctx, info);
        FSHelper.setDlByRecPay(ctx, info);
        info.setMutilType(info.genMutilType(ctx));
        if (info.getUpReckoningType() == null || info.getUpReckoningType() == UpReckoningTypeEnum.SOURCEBILL) {
            // empty if block
        }
        this.initNumber(ctx, info);
        if (!info.isHasEffected()) {
            OverDraftCheckHelper.checkOverDraft(ctx, model, 0, false, Constants.ZERO, false);
        } else {
            OverDraftCheckHelper.checkOverDraft(ctx, model, 1, false, Constants.ZERO, false);
        }
        this.setAutoBankAcct(ctx, (IObjectValue)info);
        if (info.getType() != null && info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) && info.getSettleType() != null && info.getSettleType().getNtType() != null && ("004".equals((ntInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(info.getSettleType().getNtType().getId()))).getNumber()) || "005".equals(ntInfo.getNumber()))) {
            ReceivableBillFactory.getLocalInstance((Context)ctx).lockReceivanleBill((CoreBaseInfo)info, "edit");
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new SettlementBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_settlementBill_save", (String)info.getCompany().getId().toString(), (String)"\u6682\u5b58\u7ed3\u7b97\u5355");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        boolean CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (CS127 && (info.getType() == SettBizTypeEnum.PAYOUTSIDE || info.getType() == SettBizTypeEnum.LINKPAY)) {
            this.recordPayInfoLog(ctx, info, PaymentOperateType.SAVE);
        }
        IObjectPK pk = super._save(ctx, model);
        BizRelateReceivableBillUtil.relateReceivableBill((Context)ctx, (CoreBaseInfo)info, (IObjectPK)pk);
        return pk;
    }

    private void setSettleConfirmCH(Context ctx, SettlementBillInfo info) throws EASBizException, BOSException {
        if (info.getSource() == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)resourcePath, (String)"62_SettlementBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.getSource().equals((Object)SettlementBillSourceEnum.RECEIVEACCOUNT)) {
            return;
        }
        String companyId = info.getCompany().getId().toString();
        BankInfo acceptCH = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(companyId);
        info.setSettleAcceptCH(acceptCH);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        String pfLogIdgenerateVoucher = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._generateVoucher");
        String pfLogIdgenerateVoucher_beforeGenVoucher = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._generateVoucher_beforeGenVoucher");
        this.beforeGenVoucher(ctx, (CoreBillBaseCollection)sourceBillCollection);
        PerfLogRecorder.endRecord((String)pfLogIdgenerateVoucher_beforeGenVoucher);
        String pfLogIdgenerateVoucher__supergenerateVoucher = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._generateVoucher_supergenerateVoucher");
        DAPTransformResult result = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        PerfLogRecorder.endRecord((String)pfLogIdgenerateVoucher__supergenerateVoucher);
        PerfLogRecorder.endRecord((String)pfLogIdgenerateVoucher);
        return result;
    }

    private void beforeGenVoucher(Context ctx, CoreBillBaseCollection billColl) throws EASBizException, BOSException {
        String pfLogIdbeforeGenVoucher = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._beforeGenVoucher");
        String pfLogIdbeforeGenVoucher_getIdSet = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._beforeGenVoucher_getIdSet");
        Set idSet = this.getIdSet(billColl);
        PerfLogRecorder.endRecord((String)pfLogIdbeforeGenVoucher_getIdSet);
        String pfLogIdbeforeGenVoucher_lockedIds = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._beforeGenVoucher_lockedIds");
        this.lockedIds(ctx, new ArrayList(idSet));
        PerfLogRecorder.endRecord((String)pfLogIdbeforeGenVoucher_lockedIds);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        String pfLogIdbeforeGenVoucher_getColl = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._beforeGenVoucher_getColl ");
        SettlementBillCollection coll = this.getSettlementBillCollection(ctx, evi);
        PerfLogRecorder.endRecord((String)pfLogIdbeforeGenVoucher_getColl);
        SettlementBillInfo info = null;
        String pfLogIdbeforeGenVoucher_for = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._beforeGenVoucher_for ");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String pfLogIdbeforeGenVoucher_for_getcoll = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._beforeGenVoucher_for_getcoll ");
            info = coll.get(i);
            PerfLogRecorder.endRecord((String)pfLogIdbeforeGenVoucher_for_getcoll);
            if (info.getSource().equals((Object)SettlementBillSourceEnum.RECEIVEACCOUNT) || info.getSource().equals((Object)SettlementBillSourceEnum.TRANSFERBILL)) {
                throw new FSException(FSException.GENVOUCHERERROR);
            }
            if ((info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.LINKPAY)) && info.getSettleConfirmCH() == null && info.getCashier() == null) {
                throw new FSException(FSException.GENVOUCHERERRORNOTSETTLE);
            }
            if (info.isFiVouchered()) {
                throw new FSException(FSException.ALREADYGENVOUCHER);
            }
            String pfLogIdbeforeGenVoucher_for_4wf = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._beforeGenVoucher_for_4WF ");
            this.voucher4WF(ctx, info.getId().toString());
            PerfLogRecorder.endRecord((String)pfLogIdbeforeGenVoucher_for_4wf);
        }
        PerfLogRecorder.endRecord((String)pfLogIdbeforeGenVoucher_for);
        PerfLogRecorder.endRecord((String)pfLogIdbeforeGenVoucher);
    }

    private Set getIdSet(CoreBillBaseCollection coll) {
        HashSet<String> idSet = new HashSet<String>();
        String pfLogId_gETIDS = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._gETIDS ");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(coll.get(i).getId().toString());
        }
        PerfLogRecorder.endRecord((String)pfLogId_gETIDS);
        return idSet;
    }

    @Override
    protected void _voucher4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _updatePrintCount(Context ctx, Set ids, int count) throws BOSException, EASBizException {
        String inIds = FMHelper.setTran2String((Set)ids);
        String sql = " update t_fs_settlementbill set FPrintCount = isnull(FPrintCount,0) +" + count + " where fid in " + inIds;
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }

    private void setAccountView(SettlementBillInfo info) {
        if (info.getPayeeBankAcct() != null && info.getPayeeAcct() == null) {
            info.setPayeeAcct(info.getPayeeBankAcct().getAccount());
        }
        if (info.getPayerBankAcct() != null && info.getPayerAcct() == null) {
            info.setPayerAcct(info.getPayerBankAcct().getAccount());
        }
        if (info.getInnerPayeeAcct() == null && info.getPayeeInnerAcct() != null) {
            info.setInnerPayeeAcct(info.getPayeeInnerAcct().getAcctView());
        }
        if (info.getInnerPayerAcct() == null && info.getPayerInnerAcct() != null) {
            info.setInnerPayerAcct(info.getPayerInnerAcct().getAcctView());
        }
        if (info.getType() == SettBizTypeEnum.RECINSIDE || info.getType() == SettBizTypeEnum.PAYINSIDE) {
            info.setFinPayeeInAcct(info.getPayeeInnerAcct());
            info.setFinPayerInAcct(info.getPayerInnerAcct());
        }
        if (info.getPayeeAcct() != null && info.getPayeeAcct().getCompanyID() != null && !info.getCompany().getId().equals((Object)info.getPayeeAcct().getCompanyID().getId())) {
            info.setPayeeAcct(null);
        }
        if (info.getPayerAcct() != null && info.getPayerAcct().getCompanyID() != null && !info.getCompany().getId().equals((Object)info.getPayerAcct().getCompanyID().getId())) {
            info.setPayerAcct(null);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._reverseSave");
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        String settleInfogetvalue = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._reverseSave\u2014\u2014settleInfogetvalse");
        SettlementBillInfo settleInfo = (SettlementBillInfo)this.getValue(ctx, srcBillPK, sic);
        PerfLogRecorder.endRecord((String)settleInfogetvalue);
        if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                settleInfo.setFiVouchered(false);
                settleInfo.setVoucher(null);
                settleInfo.setVoucherType(null);
            } else {
                settleInfo.setFiVouchered(true);
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
                settleInfo.setVoucher(voucherInfo);
                settleInfo.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        String CoreBillBase = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._reverseSave\u2014\u2014CoreBillBase");
        super._reverseSave(ctx, srcBillPK, (IObjectValue)settleInfo, bOTBillOperStateEnum, bOTRelationInfo);
        PerfLogRecorder.endRecord((String)CoreBillBase);
        PerfLogRecorder.endRecord((String)pfLogId);
    }

    public void lockedIds(Context ctx, List ids) throws BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        int size = ids.size();
        if (size == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("update T_FS_SettlementBill set FLastUpdateUserID = '" + user.getId().toString() + "'  where fid in ('" + ids.get(0) + "'");
        for (int i = 1; i < size; ++i) {
            sql.append(", '" + ids.get(i) + "'");
        }
        sql.append(")");
        this.executeUpdateSql(ctx, sql);
    }

    private void executeUpdateSql(Context ctx, StringBuffer sql) throws SQLDataException, BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql.toString());
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private void setDefalutPayerInnerAcct(Context ctx, SettlementBillInfo info) {
        if (info.getPayerInnerAcct() != null) {
            return;
        }
        if (FMHelper.isEmpty((String)info.getSourceBillId())) {
            return;
        }
        try {
            InnerAccountInfo innerAcct = info.getFinPayerInAcct();
            if (innerAcct != null && (info.getType() == SettBizTypeEnum.RECINSIDEDIF || info.getType() == SettBizTypeEnum.PAYINSIDEDIF)) {
                InnerAccountInfo defInnerAccount;
                innerAcct = InnerAccountFactory.getLocalInstance(ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcct.getId()), this.getInnerAcctSelector());
                if (info.getMutilType() == SettleMutilTypeEnum.TRANS && !innerAcct.getCompany().getId().equals((Object)info.getCompany().getId())) {
                    defInnerAccount = null;
                    defInnerAccount = this.getDownDefaultInnerAcct(ctx, info, innerAcct);
                    if (defInnerAccount != null) {
                        info.setPayerInnerAcct(defInnerAccount);
                        info.setPayerFullName(defInnerAccount.getApplyUnit().getName());
                        if (info.getInnerPayerAcct() == null) {
                            info.setInnerPayerAcct(defInnerAccount.getAcctView());
                        }
                    }
                }
                if (info.getPayerInnerAcct() == null) {
                    if (innerAcct.getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
                        info.setPayerInnerAcct(innerAcct);
                        if (info.getInnerPayerAcct() == null) {
                            info.setInnerPayerAcct(innerAcct.getAcctView());
                            info.setPayerFullName(innerAcct.getApplyUnit().getName());
                            info.setPayeeAcct(null);
                            info.setPayeeBankAcct(null);
                        }
                    } else {
                        defInnerAccount = null;
                        defInnerAccount = this.getDownDefaultInnerAcct(ctx, info, innerAcct);
                        if (defInnerAccount != null) {
                            info.setPayerInnerAcct(defInnerAccount);
                            info.setPayerFullName(defInnerAccount.getApplyUnit().getName());
                            if (info.getInnerPayerAcct() == null) {
                                info.setInnerPayerAcct(defInnerAccount.getAcctView());
                            }
                        }
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setDefaultPayeeBankAcctF7(Context ctx, SettlementBillInfo info) {
        if (info.getPayeeBankAcct() != null) {
            return;
        }
        try {
            BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString());
            CompanyOrgUnitInfo chCompany = clearingHouse.getRelatedCompany();
            InnerAccountInfo innerAcct = info.getFinPayeeInAcct();
            if (innerAcct != null) {
                if (info.getType() == SettBizTypeEnum.RECINSIDEDIF || info.getType() == SettBizTypeEnum.PAYINSIDEDIF) {
                    innerAcct = InnerAccountFactory.getLocalInstance(ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcct.getId()), this.getInnerAcctSelector());
                    if (info.getMutilType() == SettleMutilTypeEnum.REC) {
                        IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
                        AccountBankInfo model = new AccountBankInfo();
                        model.setIsDefaultReck(true);
                        model.setIsReckoning(true);
                        model.setCompany(chCompany);
                        model.setBank(clearingHouse.getParentInGroup());
                        AccountBankInfo defAccountBank = iAccountBank.getDefault(model);
                        if (defAccountBank != null) {
                            info.setPayeeBankAcct(defAccountBank);
                            info.setPayeeBankAcctNum(defAccountBank.getBankAccountNumber());
                            info.setPayeeAcct(defAccountBank.getAccount());
                        }
                    }
                }
            } else if (clearingHouse != null && clearingHouse.getParentInGroup() != null && (info.getType() == SettBizTypeEnum.RECINSIDEDIF || info.getType() == SettBizTypeEnum.PAYINSIDEDIF) && info.getMutilType() == SettleMutilTypeEnum.REC) {
                IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
                AccountBankInfo model = new AccountBankInfo();
                model.setIsDefaultReck(true);
                model.setIsReckoning(true);
                model.setCompany(chCompany);
                model.setBank(clearingHouse.getParentInGroup());
                AccountBankInfo defAccountBank = iAccountBank.getDefault(model);
                if (defAccountBank != null) {
                    info.setPayeeBankAcct(defAccountBank);
                    info.setPayeeBankAcctNum(defAccountBank.getBankAccountNumber());
                    info.setPayeeAcct(defAccountBank.getAccount());
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setDefalutPayeeInnerAcct(Context ctx, SettlementBillInfo info) {
        if (info.getPayeeInnerAcct() != null) {
            return;
        }
        if (FMHelper.isEmpty((String)info.getSourceBillId())) {
            return;
        }
        try {
            InnerAccountInfo innerAcct = info.getFinPayeeInAcct();
            if (innerAcct != null && (info.getType() == SettBizTypeEnum.RECINSIDEDIF || info.getType() == SettBizTypeEnum.PAYINSIDEDIF)) {
                InnerAccountInfo defInnerAccount;
                innerAcct = InnerAccountFactory.getLocalInstance(ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcct.getId()), this.getInnerAcctSelector());
                if (info.getMutilType() == SettleMutilTypeEnum.TRANS && !innerAcct.getCompany().getId().equals((Object)info.getCompany().getId())) {
                    defInnerAccount = null;
                    defInnerAccount = this.getDownDefaultInnerAcct(ctx, info, innerAcct);
                    if (defInnerAccount != null) {
                        info.setPayeeInnerAcct(defInnerAccount);
                        info.setPayeeFullName(defInnerAccount.getApplyUnit().getName());
                        if (info.getInnerPayeeAcct() == null) {
                            info.setInnerPayeeAcct(defInnerAccount.getAcctView());
                        }
                    }
                }
                if (info.getPayeeInnerAcct() == null) {
                    if (innerAcct.getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
                        info.setPayeeInnerAcct(innerAcct);
                        if (info.getInnerPayeeAcct() == null) {
                            info.setInnerPayeeAcct(innerAcct.getAcctView());
                            info.setPayeeFullName(innerAcct.getApplyUnit().getName());
                            info.setPayerAcct(null);
                            info.setPayerBankAcct(null);
                        }
                    } else {
                        defInnerAccount = null;
                        defInnerAccount = this.getDownDefaultInnerAcct(ctx, info, innerAcct);
                        if (defInnerAccount != null) {
                            info.setPayeeInnerAcct(defInnerAccount);
                            info.setPayeeFullName(defInnerAccount.getApplyUnit().getName());
                            if (info.getInnerPayeeAcct() == null) {
                                info.setInnerPayeeAcct(defInnerAccount.getAcctView());
                            }
                        }
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setDefaultPayerBankAcctF7(Context ctx, SettlementBillInfo info) {
        if (info.getPayerBankAcct() != null) {
            return;
        }
        try {
            BankInfo clearingHouse = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString());
            CompanyOrgUnitInfo chCompany = clearingHouse.getRelatedCompany();
            InnerAccountInfo innerAcct = info.getFinPayerInAcct();
            if (innerAcct != null) {
                if (info.getType() == SettBizTypeEnum.RECINSIDEDIF || info.getType() == SettBizTypeEnum.PAYINSIDEDIF) {
                    innerAcct = InnerAccountFactory.getLocalInstance(ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcct.getId()), this.getInnerAcctSelector());
                    if (info.getMutilType() == SettleMutilTypeEnum.PAY) {
                        IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
                        AccountBankInfo model = new AccountBankInfo();
                        model.setIsDefaultReck(true);
                        model.setIsReckoning(true);
                        model.setCompany(chCompany);
                        model.setBank(clearingHouse.getParentInGroup());
                        AccountBankInfo defAccountBank = iAccountBank.getDefault(model);
                        if (defAccountBank != null) {
                            info.setPayerBankAcct(defAccountBank);
                            info.setPayerBankAcctNum(defAccountBank.getBankAccountNumber());
                            info.setPayerAcct(defAccountBank.getAccount());
                        }
                    }
                }
            } else if (clearingHouse != null && clearingHouse.getParentInGroup() != null && (info.getType() == SettBizTypeEnum.RECINSIDEDIF || info.getType() == SettBizTypeEnum.PAYINSIDEDIF) && info.getMutilType() == SettleMutilTypeEnum.PAY) {
                IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
                AccountBankInfo model = new AccountBankInfo();
                model.setIsDefaultReck(true);
                model.setIsReckoning(true);
                model.setCompany(chCompany);
                model.setBank(clearingHouse.getParentInGroup());
                AccountBankInfo defAccountBank = iAccountBank.getDefault(model);
                if (defAccountBank != null) {
                    info.setPayerBankAcct(defAccountBank);
                    info.setPayerBankAcctNum(defAccountBank.getBankAccountNumber());
                    info.setPayerAcct(defAccountBank.getAccount());
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        return super._getValue(ctx, pk, selector, sorter);
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        return super._getValue(ctx, pk, sorter);
    }

    @Override
    protected Map _saveBatch(Context ctx, List idList) throws BOSException, EASBizException {
        StringBuffer errmsg = new StringBuffer();
        SettlementBillCollection settlementBillCol = this.getSettlementBillCollection(ctx, this.getEntityViewByIDList(idList));
        int size = settlementBillCol.size();
        SettlementBillInfo info = null;
        for (int i = 0; i < size; ++i) {
            info = settlementBillCol.get(i);
            if (!info.isHasEffected()) {
                info.setHasEffected(true);
            }
            try {
                super.submit(ctx, (CoreBaseInfo)info);
                continue;
            }
            catch (Exception e) {
                errmsg.append(info.getNumber() + e.getMessage() + "\n");
            }
        }
        HashMap<String, CharSequence> map = new HashMap<String, CharSequence>();
        if (errmsg != null && errmsg.toString() != null && errmsg.toString().length() > 0) {
            map.put("error", errmsg);
        } else {
            map.put("error", "");
        }
        return map;
    }

    private EntityViewInfo getEntityViewByIDList(List idList) {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        env.setFilter(f);
        SelectorItemCollection sic = this.getSettlementBillSelectors();
        int size = sic.size();
        for (int i = 0; i < size; ++i) {
            env.getSelector().add(sic.get(i));
        }
        return env;
    }

    protected SelectorItemCollection getSettlementBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.*"));
        sic.add(new SelectorItemInfo("payerBankAcct.*"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("payerPlanItem.number"));
        sic.add(new SelectorItemInfo("payerPlanItem.name"));
        sic.add(new SelectorItemInfo("payeePlanItem.number"));
        sic.add(new SelectorItemInfo("payeePlanItem.name"));
        sic.add(new SelectorItemInfo("applyUnit.id"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("applyUnit.number"));
        sic.add(new SelectorItemInfo("payeeBankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payeeBankAcct.bank.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.bank.name"));
        sic.add(new SelectorItemInfo("payeeBankAcct.bank.number"));
        sic.add(new SelectorItemInfo("payeeBankAcct.account.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.account.name"));
        sic.add(new SelectorItemInfo("payeeBankAcct.account.number"));
        sic.add(new SelectorItemInfo("payeeBankAcct.account.companyID.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.company.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.ctrlStrategy"));
        sic.add(new SelectorItemInfo("payeeBankAcct.ctrlStrategy.overdraftCtrl"));
        sic.add(new SelectorItemInfo("payerBankAcct.isSetBankInterface"));
        sic.add(new SelectorItemInfo("payerBankAcct.bank.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.bank.name"));
        sic.add(new SelectorItemInfo("payerBankAcct.bank.number"));
        sic.add(new SelectorItemInfo("payerBankAcct.account.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.account.name"));
        sic.add(new SelectorItemInfo("payerBankAcct.account.number"));
        sic.add(new SelectorItemInfo("payerBankAcct.account.companyID.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.company.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.bankInterfaceType"));
        sic.add(new SelectorItemInfo("payerBankAcct.ctrlStrategy"));
        sic.add(new SelectorItemInfo("payerBankAcct.ctrlStrategy.overdraftCtrl"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.applyUnit.id"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.applyUnit.name"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.applyUnit.number"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.isUsed"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.closed"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.id"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.number"));
        sic.add(new SelectorItemInfo("payerInnerAcct.isUsed"));
        sic.add(new SelectorItemInfo("payerInnerAcct.closed"));
        sic.add(new SelectorItemInfo("payerInnerAcct.name"));
        sic.add(new SelectorItemInfo("settleType.payThroughBE"));
        return sic;
    }

    private SelectorItemCollection getInnerAcctSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("clearingHouse.relatedCompany.id");
        sic.add("clearingHouse.parentInGroup.id");
        sic.add("clearingHouse.longNumberInGroup");
        sic.add("applyUnit.name");
        sic.add("acctView.id");
        sic.add("acctView.name");
        sic.add("acctView.number");
        return sic;
    }

    private InnerAccountInfo getDownDefaultInnerAcct(Context ctx, SettlementBillInfo info, InnerAccountInfo innerAcct) throws BOSException, EASBizException {
        InnerAccountInfo defInnerAccount = null;
        String longNumberInGroup = innerAcct.getClearingHouse().getLongNumberInGroup();
        BankInfo curClearhouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(info.getCompany().getId().toString());
        String curClearhouseNumber = curClearhouse.getNumber();
        String nextClearhousrNumber = "";
        BankInfo nextClearhouse = null;
        String[] numbers = longNumberInGroup.split("!");
        for (int i = 0; i < numbers.length; ++i) {
            if (!numbers[i].equals(curClearhouseNumber) || i + 1 >= numbers.length) continue;
            nextClearhousrNumber = numbers[i + 1];
            break;
        }
        if (!FMHelper.isEmpty((String)nextClearhousrNumber)) {
            IInnerAccount iInnerAccount = InnerAccountFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("*");
            evi.getSelector().add("relatedCompany.*");
            evi.getSelector().add("parentInGroup.*");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("inGroup", (Object)new Boolean(true)));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)nextClearhousrNumber));
            evi.setFilter(filterInfo);
            BankCollection collection = BankFactory.getLocalInstance((Context)ctx).getBankCollection(evi);
            if (collection.size() == 1) {
                nextClearhouse = collection.get(0);
            }
            if (nextClearhouse != null) {
                InnerAccountInfo model = new InnerAccountInfo();
                model.setIsDefaultReck(true);
                model.setIsReckoning(true);
                model.setApplyUnit(nextClearhouse.getRelatedCompany());
                model.setClearingHouse(nextClearhouse.getParentInGroup());
                defInnerAccount = iInnerAccount.getDefault(model);
            }
        }
        return defInnerAccount;
    }

    private void setAutoBankAcct(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SettlementBillInfo info = (SettlementBillInfo)model;
        String sourceBillId = info.getSourceBillId();
        IInnerAccount iInnerAcct = InnerAccountFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("deFaultAcctBank.*");
        sic.add("deFaultAcctBank.account.*");
        sic.add("deFaultAcctBank.bank.*");
        InnerAccountInfo innerAcctInfo = null;
        if (sourceBillId != null) {
            if (info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) && info.getPayeeBankAcct() == null && info.getPayeeInnerAcct() != null && (innerAcctInfo = iInnerAcct.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(info.getPayeeInnerAcct().getId()), sic)).getDeFaultAcctBank() != null) {
                info.setPayeeBankAcct(innerAcctInfo.getDeFaultAcctBank());
                info.setPayeeBankAcctNum(innerAcctInfo.getDeFaultAcctBank().getNumber());
                info.setPayeeAcct(innerAcctInfo.getDeFaultAcctBank().getAccount());
                info.setPayeeBank(innerAcctInfo.getDeFaultAcctBank().getBank().getName());
            }
            if ((info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.LINKPAY)) && info.getPayerBankAcct() == null && info.getPayerInnerAcct() != null && (innerAcctInfo = iInnerAcct.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(info.getPayerInnerAcct().getId()), sic)).getDeFaultAcctBank() != null) {
                info.setPayerBankAcct(innerAcctInfo.getDeFaultAcctBank());
                info.setPayerAcct(innerAcctInfo.getDeFaultAcctBank().getAccount());
                info.setPayerBank(innerAcctInfo.getDeFaultAcctBank().getBank().getName());
            }
        }
    }

    @Override
    protected void _bitBack(Context ctx, Set paySet) throws BOSException, EASBizException {
        if (paySet.size() < 0) {
            return;
        }
        Iterator it = paySet.iterator();
        PaymentBillInfo info = null;
        while (it.hasNext()) {
            BOSUuid sbid;
            String pk = it.next().toString();
            if (pk != null && !"".equals(pk) && (sbid = BOSUuid.read((String)pk)).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
                info = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(pk), this.getSelectors());
            }
            if (info == null || !info.getPayBillType().isIsFinanceTranUp()) continue;
            throw new RecPayException(RecPayException.CANNOTBITBACKPAYMENTBILL);
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payBillType.*"));
        return sic;
    }

    protected void _bitToBack(Context ctx, IObjectPK[] ids, String msg) throws BOSException, EASBizException {
    }

    @Override
    protected void _submitOutSettNumber(Context ctx, IObjectPK pk, List ids) throws BOSException, EASBizException {
        String num;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new SettlementBillInfo().getBOSType().toString()));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("operatorID", (Object)"RecSett"));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new ReceivableBillInfo().getBOSType().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IBOTRelation iBOTR = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botRel = iBOTR.getCollection(view);
        for (int i = 0; i < botRel.size(); ++i) {
            iBOTR.delete((IObjectPK)new ObjectUuidPK(botRel.get(i).getId()));
        }
        if (ids.size() <= 0) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("settleType.*");
        sic.add("settleType.ntType.number");
        sic.add("id");
        SettlementBillInfo info = this.getSettlementBillInfo(ctx, pk, sic);
        if (info.getSettleType() != null && info.getSettleType().getNtType() != null && info.getSettleType().getNtType().getNumber() != null && ("004".equals(num = info.getSettleType().getNtType().getNumber()) || "005".equals(num))) {
            HashSet<String> numberSet = new HashSet<String>();
            for (int i = 0; i < ids.size(); ++i) {
                numberSet.add(ids.get(i).toString().trim());
            }
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(company.getId()));
            FilterInfo filterNew = new FilterInfo();
            filterNew.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            filterNew.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId().toString()));
            if (NT011) {
                filterNew.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(8)));
            } else {
                filterNew.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(1)));
            }
            EntityViewInfo vi = new EntityViewInfo();
            vi.setFilter(filterNew);
            ReceivableBillCollection receivable = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(vi);
            for (int i = 0; i < receivable.size(); ++i) {
                ReceivableBillInfo receivableInfo = receivable.get(i);
                BOTRelationInfo botRelInfo = new BOTRelationInfo();
                botRelInfo.setSrcObjectID(pk.toString());
                botRelInfo.setSrcEntityID(new SettlementBillInfo().getBOSType().toString());
                botRelInfo.setDestObjectID(receivableInfo.getId().toString());
                botRelInfo.setDestEntityID(new ReceivableBillInfo().getBOSType().toString());
                botRelInfo.setOperatorID("RecSett");
                botRelInfo.setIsEffected(true);
                botRelInfo.setType(0);
                iBOTR.addnew(botRelInfo);
            }
        }
    }

    @Override
    protected boolean _isInnerAcctLinkPay(Context ctx, String id) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        String PLpfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._batchReverseSave");
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("bOTRelationInfos.length:" + bOTRelationInfos.size()));
        if (bOTRelationInfos.size() < 1) {
            return;
        }
        String botRelationlog = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean._batchReverseSave_botRelation");
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        PerfLogRecorder.endRecord((String)botRelationlog);
        logger.debug((Object)("botRelation.destEntityId:" + botRelation.getDestEntityID()));
        logger.debug((Object)("botRelation.srcEntityId:" + botRelation.getSrcEntityID()));
        if (!new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            return;
        }
        ArrayList<String> settlementBillIdList = new ArrayList<String>();
        ArrayList<String> voucherIdList = new ArrayList<String>();
        int size = bOTRelationInfos.size();
        for (int i = 0; i < size; ++i) {
            if (!"6E41E17C".equals(bOTRelationInfos.get(i).getSrcEntityID())) continue;
            settlementBillIdList.add(bOTRelationInfos.get(i).getSrcObjectID());
            voucherIdList.add(bOTRelationInfos.get(i).getDestObjectID());
        }
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            StringBuffer sqlBuf = new StringBuffer("update t_fs_settlementbill set ffivouchered=0, FVoucheerID=null, fvouchertypeid=null where fid in ('NE'");
            for (int i = 0; i < settlementBillIdList.size(); ++i) {
                sqlBuf.append(",'" + (String)settlementBillIdList.get(i) + "'");
            }
            sqlBuf.append(")");
            String exeLog = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean.execute");
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
            PerfLogRecorder.endRecord((String)exeLog);
        } else {
            String sql = "update t_fs_settlementbill set ffivouchered=1, FVoucheerID=? where fid=?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (int i = 0; i < settlementBillIdList.size(); ++i) {
                paramsList.add(new Object[]{voucherIdList.get(i), settlementBillIdList.get(i)});
            }
            String executeBatchLog = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean.executeBatchLog");
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            PerfLogRecorder.endRecord((String)executeBatchLog);
            StringBuffer sqlBuf = new StringBuffer("update t_fs_settlementbill set fvouchertypeid=(select fvoucherTypeid from T_GL_Voucher where fid=t_fs_settlementbill.FVoucheerID) where fid in ('NE'");
            for (int i = 0; i < settlementBillIdList.size(); ++i) {
                sqlBuf.append(",'" + (String)settlementBillIdList.get(i) + "'");
            }
            sqlBuf.append(")");
            String UpdateexecuteLog = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"SettlementBillControllerBean.Update");
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
            PerfLogRecorder.endRecord((String)UpdateexecuteLog);
        }
        PerfLogRecorder.endRecord((String)PLpfLogId);
    }

    @Override
    protected Map _openSmart(Context ctx, Set idSet) throws BOSException {
        HashSet<String> validIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("isSmart"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SettlementBillCollection recCol = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(view);
        BatchExecuteResult result = new BatchExecuteResult();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)recCol)) {
            for (int i = 0; i < recCol.size(); ++i) {
                SettlementBillInfo info = recCol.get(i);
                if (info.getIsSmart().getValue() == 2 || info.getIsSmart().getValue() == 4) {
                    validIds.add(info.getId().toString());
                    continue;
                }
                result.getDetailMsgList().add(info.getNumber() + ResourceBase.getString((String)resourcePath, (String)"503_SettlementBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        if (!EmptyUtil.isEmpty(validIds)) {
            String sql = "update T_FS_SettlementBill set FIsSmart=1  where fid in ('" + validIds.toArray()[0] + "'";
            for (int i = 1; i < validIds.toArray().length; ++i) {
                sql = sql + ", '" + validIds.toArray()[i] + "'";
            }
            sql = sql + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (!EmptyUtil.isEmpty(validIds) && validIds.size() == idSet.size()) {
            result.setError(0);
            result.setSummaryMsg(idSet.size() + ResourceBase.getString((String)resourcePath, (String)"504_SettlementBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            result.setError(1);
            int success = validIds == null ? 0 : validIds.size();
            result.setSummaryMsg(success + ResourceBase.getString((String)resourcePath, (String)"505_SettlementBillControllerBean", (Locale)ctx.getLocale()) + (idSet.size() - success) + ResourceBase.getString((String)resourcePath, (String)"506_SettlementBillControllerBean", (Locale)ctx.getLocale()));
        }
        if (!EmptyUtil.isEmpty((Collection)idSet)) {
            String numbers = this.getNumbers(ctx, idSet);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u7ed3\u7b97\u5355\u5f00\u542f\u6536\u4ed8\u673a\u5668\u4eba", (BOSObjectType)new SettlementBillInfo().getBOSType(), null, (String)numbers, (String)"fs_settlementBill_openSmart");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return result;
    }

    @Override
    protected Map _closeSmart(Context ctx, Set idSet) throws BOSException {
        HashSet<String> validIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("isSmart"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SettlementBillCollection recCol = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(view);
        BatchExecuteResult result = new BatchExecuteResult();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)recCol)) {
            for (int i = 0; i < recCol.size(); ++i) {
                SettlementBillInfo info = recCol.get(i);
                if (info.getIsSmart().getValue() == 1 || info.getIsSmart().getValue() == 3) {
                    validIds.add(info.getId().toString());
                    continue;
                }
                result.getDetailMsgList().add(info.getNumber() + ResourceBase.getString((String)resourcePath, (String)"508_SettlementBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        if (!EmptyUtil.isEmpty(validIds)) {
            String sql = "update T_FS_SettlementBill set FIsSmart=2  where fid in ('" + validIds.toArray()[0] + "'";
            for (int i = 1; i < validIds.toArray().length; ++i) {
                sql = sql + ", '" + validIds.toArray()[i] + "'";
            }
            sql = sql + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (!EmptyUtil.isEmpty(validIds) && validIds.size() == idSet.size()) {
            result.setError(0);
            result.setSummaryMsg(idSet.size() + ResourceBase.getString((String)resourcePath, (String)"509_SettlementBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            result.setError(1);
            int success = validIds == null ? 0 : validIds.size();
            result.setSummaryMsg(success + ResourceBase.getString((String)resourcePath, (String)"510_SettlementBillControllerBean", (Locale)ctx.getLocale()) + (idSet.size() - success) + ResourceBase.getString((String)resourcePath, (String)"511_SettlementBillControllerBean", (Locale)ctx.getLocale()));
        }
        if (!EmptyUtil.isEmpty((Collection)idSet)) {
            String numbers = this.getNumbers(ctx, idSet);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u7ed3\u7b97\u5355\u5173\u95ed\u6536\u4ed8\u673a\u5668\u4eba", (BOSObjectType)new SettlementBillInfo().getBOSType(), null, (String)numbers, (String)"fs_settlementBill_closeSmart");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return result;
    }

    private String getNumbers(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        SettlementBillCollection coll = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(evi);
        SettlementBillInfo info = null;
        StringBuffer numbers = new StringBuffer();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            numbers.append(info.getNumber());
            if (i == size - 1) continue;
            numbers.append(",");
        }
        return numbers.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _autoMatchAcct(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        int success = 0;
        String summary = ResourceBase.getString((String)resourcePath, (String)"430_BillSum", (Locale)ctx.getLocale(), (Object[])new String[]{idSet.size() + ""});
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        HashSet permissionSet = new HashSet();
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("sourceBillId"));
            view.getSelector().add(new SelectorItemInfo("payerBankAcct.id"));
            view.getSelector().add(new SelectorItemInfo("company.id"));
            view.getSelector().add(new SelectorItemInfo("company.name"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("cashier.id"));
            view.getSelector().add(new SelectorItemInfo("auditor.id"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SettlementBillCollection settleCol = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(view);
            for (int i = 0; i < settleCol.size(); ++i) {
                SettlementBillInfo info = settleCol.get(i);
                try {
                    Boolean noLocked = (Boolean)requestMap.get(info.getId().toString());
                    if (!noLocked.booleanValue()) {
                        result.getDetailMsgList().add(ResourceBase.getString((String)resourcePath, (String)"438_Match_Fail_Reason", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), ResourceBase.getString((String)resourcePath, (String)"431_Bill_Locked", (Locale)ctx.getLocale())}));
                        continue;
                    }
                    if (EmptyUtil.isEmpty((String)info.getSourceBillId()) || !BOSUuid.read((String)info.getSourceBillId()).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
                        result.getDetailMsgList().add(ResourceBase.getString((String)resourcePath, (String)"438_Match_Fail_Reason", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), ResourceBase.getString((String)resourcePath, (String)"432_NO_PAYBILL", (Locale)ctx.getLocale())}));
                        continue;
                    }
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier()) || !EmptyUtil.isEmpty((CoreBaseInfo)info.getAuditor())) {
                        result.getDetailMsgList().add(ResourceBase.getString((String)resourcePath, (String)"438_Match_Fail_Reason", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), ResourceBase.getString((String)resourcePath, (String)"440_BillStatus_Error", (Locale)ctx.getLocale())}));
                        continue;
                    }
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBankAcct())) {
                        result.getDetailMsgList().add(ResourceBase.getString((String)resourcePath, (String)"438_Match_Fail_Reason", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), ResourceBase.getString((String)resourcePath, (String)"433_Acct_Not_Null", (Locale)ctx.getLocale())}));
                        continue;
                    }
                    AccountBankInfo bankInfo = AutoMatchAcctSettingFactory.getLocalInstance(ctx).getAutoMatchAcctInfo(info.getCompany().getId().toString(), info.getSourceBillId());
                    if (EmptyUtil.isEmpty((CoreBaseInfo)bankInfo)) {
                        result.getDetailMsgList().add(ResourceBase.getString((String)resourcePath, (String)"438_Match_Fail_Reason", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), ResourceBase.getString((String)resourcePath, (String)"434_No_Match_Setting", (Locale)ctx.getLocale())}));
                        continue;
                    }
                    info.setPayerBankAcct(bankInfo);
                    info.setPayerAcct(bankInfo.getAccount());
                    if (bankInfo.getBank() != null) {
                        info.setPayerBank(bankInfo.getBank().getName());
                    }
                    this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(ResourceBase.getString((String)resourcePath, (String)"438_Match_Fail_Reason", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), ResourceBase.getString((String)resourcePath, (String)"435_System_Error", (Locale)ctx.getLocale())}));
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        summary = success == idSet.size() ? summary + ResourceBase.getString((String)resourcePath, (String)"436_All_Match_Success", (Locale)ctx.getLocale()) : summary + ResourceBase.getString((String)resourcePath, (String)"437_Match_Ttile", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _batchEndorseOut(Context ctx, Set idSet, Date endorseDate) throws BOSException, EASBizException {
        int success = 0;
        StringBuffer message = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("settleType.ntType");
        selector.add("settleType.ntType.group");
        selector.add("settleType.ntType.superGroup");
        view.setFilter(fi);
        view.setSelector(selector);
        SettlementBillCollection coll = this.getSettlementBillCollection(ctx, view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo info = coll.get(i);
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean request = false;
            try {
                request = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!request) {
                    throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)resourcePath, (String)"431_Bill_Locked", (Locale)ctx.getLocale())});
                }
                if (info.getSettleType() != null && info.getSettleType().getNtType() != null && info.getSettleType().getNtType().getSuperGroup() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)info.getSettleType().getNtType().getSuperGroup()) && info.getOuterSettleNumber() != null) {
                    List entryList = BizRelateReceivableBillUtil.getReceivableEntryList((Context)ctx, (CoreBaseInfo)info);
                    HashSet<String> idSetRec = new HashSet<String>();
                    HashSet<String> numSet = new HashSet<String>();
                    for (int j = 0; j < entryList.size(); ++j) {
                        ReceivableBillEntryVO entryVO = (ReceivableBillEntryVO)entryList.get(j);
                        if (entryVO.getReceivableBillID() != null) {
                            idSetRec.add(entryVO.getReceivableBillID());
                            continue;
                        }
                        numSet.add(entryVO.getReceivableBillNum());
                    }
                    EntityViewInfo query = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("*");
                    sic.add("currency.*");
                    sic.add("ntType.*");
                    sic.add("company.baseCurrency.id");
                    sic.add("company.baseExchangeTable.id");
                    query.getSelector().addObjectCollection((IObjectCollection)sic);
                    FilterInfo filter = new FilterInfo();
                    query.setFilter(filter);
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)new Integer(1)));
                    filter.getFilterItems().add(new FilterItemInfo("isDisPledge", (Object)new Integer(1)));
                    boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
                    boolean NT009 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT009", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
                    if (NT011) {
                        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(8)));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(1)));
                    }
                    NTTypeInfo ntInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(info.getSettleType().getNtType().getId()));
                    filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)ntInfo.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("isCollect", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isPoolPledge", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isPoolTrustee", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isPoolTrustee", null));
                    if (idSetRec.size() > 0) {
                        filter.getFilterItems().add(new FilterItemInfo("id", idSetRec, CompareType.INCLUDE));
                    } else if (numSet.size() > 0) {
                        filter.getFilterItems().add(new FilterItemInfo("draftNumber", numSet, CompareType.INCLUDE));
                    } else {
                        String[] billNumber = null;
                        HashSet<String> billNumberSet = new HashSet<String>();
                        billNumber = info.getOuterSettleNumber().replace(" ", "").split(";");
                        for (int j = 0; j < billNumber.length; ++j) {
                            billNumberSet.add(billNumber[j]);
                        }
                        filter.getFilterItems().add(new FilterItemInfo("draftNumber", billNumberSet, CompareType.INCLUDE));
                    }
                    if (!NT009) {
                        filter.getFilterItems().add(new FilterItemInfo("expiredDate", (Object)DateUtil.getSQLBegin((Date)new Date()), CompareType.GREATER_EQUALS));
                        filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4)) AND #5 AND #6 AND #7 AND #8 AND (#9 OR #10) AND #11 AND #12");
                    } else {
                        filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4)) AND #5 AND #6 AND #7 AND #8 AND (#9 OR #10) AND #11");
                    }
                    ReceivableBillCollection receivableBillCollection = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(query);
                    if (receivableBillCollection == null || receivableBillCollection.size() == 0) {
                        throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)resourcePath, (String)"CanNot_Endorse", (Locale)ctx.getLocale())});
                    }
                    this.checkReceivableBillAmountRight(ctx, info, receivableBillCollection);
                    if (receivableBillCollection.size() > 1) {
                        boolean isSameSource = this.isSameSource((IObjectCollection)receivableBillCollection);
                        if (!isSameSource) {
                            throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)resourcePath, (String)"BILLSOURCE_NOTSAME", (Locale)ctx.getLocale())});
                        }
                        boolean isSame = this.isSameBillMedium((IObjectCollection)receivableBillCollection);
                        if (!isSame) {
                            throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)resourcePath, (String)"BILLMEDIUM_NOTSAME", (Locale)ctx.getLocale())});
                        }
                    }
                    EndorsementBillInfo endorsementBill = this.createEndorsementBill(ctx, info, receivableBillCollection, endorseDate);
                    EndorsementBillFactory.getLocalInstance((Context)ctx).outSubmit(endorsementBill, false);
                    ++success;
                    continue;
                }
                throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)resourcePath, (String)"CanNot_Endorse", (Locale)ctx.getLocale())});
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                message.append(info.getNumber() + ": " + e.getMessage() + ";");
                message.append("\n");
                continue;
            }
            finally {
                if (request) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        int failed = idSet.size() - success;
        String totalMessage = ResourceBase.getString((String)resourcePath, (String)"423_Message", (Locale)ctx.getLocale(), (Object[])new Object[]{idSet.size(), success, failed});
        String result = totalMessage + "#" + message.toString();
        return result;
    }

    private void checkReceivableBillAmountRight(Context ctx, SettlementBillInfo info, ReceivableBillCollection coll) throws FSException {
        BigDecimal totalRecAmt = Constants.ZERO;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo recInfo = coll.get(i);
            totalRecAmt = totalRecAmt.add(recInfo.getBillAmt());
        }
        if (totalRecAmt.compareTo(info.getAmount()) != 0) {
            throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)resourcePath, (String)"ReceivableBillAmtWrong", (Locale)ctx.getLocale(), (Object[])new String[]{totalRecAmt.toString()})});
        }
    }

    private boolean isSameSource(IObjectCollection coll) {
        boolean isSame = true;
        BillSourceEnum billSource = null;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo info = (ReceivableBillInfo)coll.getObject(i);
            if (i == 0) {
                billSource = info.getSource();
                continue;
            }
            if (billSource == info.getSource()) continue;
            isSame = false;
            break;
        }
        return isSame;
    }

    private boolean isSameBillMedium(IObjectCollection coll) {
        boolean isSame = true;
        BillMediumEnum billMedium = null;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo info = (ReceivableBillInfo)coll.getObject(i);
            if (i == 0) {
                billMedium = info.getBillMedium();
                continue;
            }
            if (billMedium == info.getBillMedium()) continue;
            isSame = false;
            break;
        }
        return isSame;
    }

    private EndorsementBillInfo createEndorsementBill(Context ctx, SettlementBillInfo settlementInfo, ReceivableBillCollection receivablecoll, Date endorseDate) throws EASBizException, BOSException {
        ObjectBaseInfo csInfo;
        EndorsementBillInfo endorsementBill = new EndorsementBillInfo();
        ReceivableBillInfo recInfo = receivablecoll.get(0);
        int precision = recInfo.getCurrency().getPrecision();
        CurrencyInfo currency = recInfo.getCurrency();
        BigDecimal amt = Constants.ZERO;
        String billNumber = "";
        EndorsementBillEntryInfo entryInfo = null;
        EndorsementBillEntryCollection entryCol = new EndorsementBillEntryCollection();
        for (int i = 0; i < receivablecoll.size(); ++i) {
            ReceivableBillInfo info = receivablecoll.get(i);
            amt = amt.add(info.getBillAmt());
            if ((billNumber + info.getDraftNumber()).length() < 80) {
                billNumber = billNumber + info.getDraftNumber() + ";";
            }
            entryInfo = new EndorsementBillEntryInfo();
            entryInfo.setReceivableBill(info);
            entryInfo.setEndorseAmt(info.getBillAmt());
            entryCol.add(entryInfo);
            DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FLockAmt =0 where FId=?", (Object[])new Object[]{info.getId().toString()});
            info.setAvailableAmt(BigDecimal.ZERO);
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        ExchangeRateInfo exchangeInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)currency, (CurrencyInfo)company.getBaseCurrency(), (CompanyOrgUnitInfo)company, (Date)endorseDate);
        BigDecimal exRate = Constants.ONE.setScale(5);
        if (exchangeInfo != null) {
            exRate = exchangeInfo.getConvertRate();
            exRate = exRate != null ? exRate.setScale(exchangeInfo.getPrecision(), 4) : Constants.ONE.setScale(5);
        }
        endorsementBill.setCurrency(currency);
        endorsementBill.setExRate(exRate);
        endorsementBill.setEndorseAmt(amt.setScale(precision, 4));
        endorsementBill.setLocalAmount(amt.multiply(exRate).setScale(precision, 4));
        endorsementBill.setBillMedium(recInfo.getBillMedium());
        endorsementBill.setEndorseDate(endorseDate);
        endorsementBill.setCompany(company);
        endorsementBill.setBillType(EndorsementTypeEnum.OUT);
        endorsementBill.setState(EndorseStateEnum.Submit);
        endorsementBill.setCreateTime(DateUtil.getTimeStampDayBegin());
        endorsementBill.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        endorsementBill.setFromCompany(company);
        endorsementBill.setDeliver(recInfo.getDeliver());
        endorsementBill.setBdgControlAmt(Constants.ONE.setScale(5));
        billNumber = billNumber.substring(0, billNumber.length() - 1);
        endorsementBill.setNoteBillNumber(billNumber);
        endorsementBill.setLinkbillId(settlementInfo.getId().toString());
        endorsementBill.setSource(recInfo.getSource());
        endorsementBill.setIsTransfer(true);
        endorsementBill.setDescription(settlementInfo.getUsage());
        if (settlementInfo.getPayeeFullName() != null) {
            endorsementBill.setEndorsee(settlementInfo.getPayeeFullName());
            endorsementBill.setEndorseeAccountName(settlementInfo.getPayeeBankAcctNum());
            endorsementBill.setEndorseeBankName(settlementInfo.getPayeeBank());
            if (settlementInfo.getPayeeBank() != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)settlementInfo.getPayeeBank(), CompareType.EQUALS));
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("number");
                view.setFilter(filter);
                view.setSelector(sic);
                BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                if (coll != null && coll.get(0) != null) {
                    endorsementBill.setEndorseeBankNum(coll.get(0).getNumber());
                }
                endorsementBill.setEndorseeBank(coll.get(0));
            }
        }
        endorsementBill.getReceivableEntrys().addCollection(receivablecoll);
        EndorsementSettleEntryInfo settleEntryInfo = new EndorsementSettleEntryInfo();
        if (settlementInfo.getPayeeFullName() != null && (csInfo = NTHelper.getCSInfoByNumber((Context)ctx, (String)settlementInfo.getPayeeFullName())) != null) {
            if (csInfo instanceof SupplierInfo) {
                endorsementBill.setEndorsedSupplier((SupplierInfo)csInfo);
                settleEntryInfo.setSupplier((SupplierInfo)csInfo);
            } else if (csInfo instanceof CustomerInfo) {
                endorsementBill.setEndorsedCustomer((CustomerInfo)csInfo);
                settleEntryInfo.setCustomer((CustomerInfo)csInfo);
            }
        }
        settleEntryInfo.setSettleAmount(amt.setScale(precision, 4));
        endorsementBill.getSettleEntrys().add(settleEntryInfo);
        endorsementBill.getEntrys().addCollection(entryCol);
        boolean isAudit = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "NT019"));
        endorsementBill.setIsAudit(isAudit);
        endorsementBill.setIsEdit(false);
        endorsementBill.setRpBillId(settlementInfo.getId().toString());
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)endorsementBill);
        return endorsementBill;
    }

    @Override
    protected Map _getPaySchDetailBill(Context ctx, String id, String companyId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        EntityViewInfo paymentView = new EntityViewInfo();
        SelectorItemCollection paymentSic = new SelectorItemCollection();
        paymentSic.add(new SelectorItemInfo("id"));
        paymentSic.add(new SelectorItemInfo("entries.id"));
        paymentView.setSelector(paymentSic);
        FilterInfo paymentFilter = new FilterInfo();
        paymentFilter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        paymentView.setFilter(paymentFilter);
        PaymentBillCollection paymentcoll = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(paymentView);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)paymentcoll)) {
            map.put("payment", paymentcoll.get(0));
            EntityViewInfo paySchDetailBillView = new EntityViewInfo();
            SelectorItemCollection paySchDetailBillSic = new SelectorItemCollection();
            paySchDetailBillSic.add(new SelectorItemInfo("id"));
            paySchDetailBillSic.add(new SelectorItemInfo("company"));
            paySchDetailBillSic.add(new SelectorItemInfo("isCrossOrg"));
            paySchDetailBillSic.add(new SelectorItemInfo("nts.*"));
            paySchDetailBillSic.add(new SelectorItemInfo("nts.receivableBill.company"));
            paySchDetailBillView.setSelector(paySchDetailBillSic);
            FilterInfo paySchDetailBillFilter = new FilterInfo();
            paySchDetailBillFilter.getFilterItems().add(new FilterItemInfo("ntPayBill.id", (Object)id, CompareType.EQUALS));
            paySchDetailBillView.setFilter(paySchDetailBillFilter);
            PaySchDetailBillCollection paySchDetailBillColl = PaySchDetailBillFactory.getLocalInstance((Context)ctx).getPaySchDetailBillCollection(paySchDetailBillView);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)paySchDetailBillColl)) {
                PaySchDetailBillNTsCollection ntsColl = paySchDetailBillColl.get(0).getNts();
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)ntsColl)) {
                    boolean isCrossOrg = ntsColl.get(0).getReceivableBill().getCompany() != paySchDetailBillColl.get(0).getCompany();
                    map.put("isCrossOrg", isCrossOrg);
                }
                if (paySchDetailBillColl.size() == 1) {
                    map.put("paySchDetail", paySchDetailBillColl.get(0));
                }
            }
        }
        return map;
    }

    private void recordPayInfoLog(Context ctx, SettlementBillInfo info, PaymentOperateType operateType) throws BOSException, EASBizException {
        if (info.getId() == null || !SettlementBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            return;
        }
        SettlementBillInfo oldInfo = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getSelectorForLog());
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection logCollection = new CoreBaseCollection();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getBizType()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getBizType()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getBizType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getBizType()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getBizType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getBizType()) && !oldInfo.getBizType().getId().equals((Object)info.getBizType().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, BIZTYPE);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getPayeeFullName()) && EmptyUtil.isEmpty((String)info.getPayeeFullName()) || EmptyUtil.isEmpty((String)oldInfo.getPayeeFullName()) && !EmptyUtil.isEmpty((String)info.getPayeeFullName()) || !EmptyUtil.isEmpty((String)oldInfo.getPayeeFullName()) && !EmptyUtil.isEmpty((String)info.getPayeeFullName()) && !oldInfo.getPayeeFullName().equals(info.getPayeeFullName())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYEEFULLNAME);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getPayeeBankAcctNum()) && EmptyUtil.isEmpty((String)info.getPayeeBankAcctNum()) || EmptyUtil.isEmpty((String)oldInfo.getPayeeBankAcctNum()) && !EmptyUtil.isEmpty((String)info.getPayeeBankAcctNum()) || !EmptyUtil.isEmpty((String)oldInfo.getPayeeBankAcctNum()) && !EmptyUtil.isEmpty((String)info.getPayeeBankAcctNum()) && !oldInfo.getPayeeBankAcctNum().equals(info.getPayeeBankAcctNum())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYEEBANKACCTNUM);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getPayeeBank()) && EmptyUtil.isEmpty((String)info.getPayeeBank()) || EmptyUtil.isEmpty((String)oldInfo.getPayeeBank()) && !EmptyUtil.isEmpty((String)info.getPayeeBank()) || !EmptyUtil.isEmpty((String)oldInfo.getPayeeBank()) && !EmptyUtil.isEmpty((String)info.getPayeeBank()) && !oldInfo.getPayeeBank().equals(info.getPayeeBank())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYEEBANK);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getPayerFullName()) && EmptyUtil.isEmpty((String)info.getPayerFullName()) || EmptyUtil.isEmpty((String)oldInfo.getPayerFullName()) && !EmptyUtil.isEmpty((String)info.getPayerFullName()) || !EmptyUtil.isEmpty((String)oldInfo.getPayerFullName()) && !EmptyUtil.isEmpty((String)info.getPayerFullName()) && !oldInfo.getPayerFullName().equals(info.getPayerFullName())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYERFULLNAME);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerInnerAcct()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerInnerAcct()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerInnerAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerInnerAcct()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerInnerAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerInnerAcct()) && !oldInfo.getPayerInnerAcct().getId().equals((Object)info.getPayerInnerAcct().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYERINNERACCT);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getInnerPayerAcct()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getInnerPayerAcct()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getInnerPayerAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getInnerPayerAcct()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getInnerPayerAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getInnerPayerAcct()) && !oldInfo.getInnerPayerAcct().getId().equals((Object)info.getInnerPayerAcct().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, INNERPAYERACCT);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getSubAccount()) && EmptyUtil.isEmpty((String)info.getSubAccount()) || EmptyUtil.isEmpty((String)oldInfo.getSubAccount()) && !EmptyUtil.isEmpty((String)info.getSubAccount()) || !EmptyUtil.isEmpty((String)oldInfo.getSubAccount()) && !EmptyUtil.isEmpty((String)info.getSubAccount()) && !oldInfo.getSubAccount().equals(info.getSubAccount())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, SUBACCOUNT);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFundFlowItemOut()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getFundFlowItemOut()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFundFlowItemOut()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getFundFlowItemOut()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFundFlowItemOut()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getFundFlowItemOut()) && !oldInfo.getFundFlowItemOut().getId().equals((Object)info.getFundFlowItemOut().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, FUNDFLOWITEMOUT);
        }
        if (info.isIsForceManual() != oldInfo.isIsForceManual()) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, ISFORCEMANUAL);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getSwiftCode()) && EmptyUtil.isEmpty((String)info.getSwiftCode()) || EmptyUtil.isEmpty((String)oldInfo.getSwiftCode()) && !EmptyUtil.isEmpty((String)info.getSwiftCode()) || !EmptyUtil.isEmpty((String)oldInfo.getSwiftCode()) && !EmptyUtil.isEmpty((String)info.getSwiftCode()) && !oldInfo.getSwiftCode().equals(info.getSwiftCode())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, SWIFTCODE);
        }
        if (!(EmptyUtil.isEmpty((Object)oldInfo.getIsUrgent()) || EmptyUtil.isEmpty((Object)info.getIsUrgent()) || oldInfo.getIsUrgent().equals((Object)info.getIsUrgent()))) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, ISURGENT);
        }
        if (!oldInfo.getAmount().equals(info.getAmount())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, AMOUNT);
        }
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getCurrency()) || EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency()) || oldInfo.getCurrency().getId().equals((Object)info.getCurrency().getId()))) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, CURRENCY);
        }
        if (oldInfo.getExchange().compareTo(info.getExchange()) != 0) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, EXCHANGE);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerBankAcct()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBankAcct()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerBankAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBankAcct()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerBankAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBankAcct()) && !oldInfo.getPayerBankAcct().getId().equals((Object)info.getPayerBankAcct().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYERBANKACCT);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAcct()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAcct()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAcct()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAcct()) && !oldInfo.getPayerAcct().getId().equals((Object)info.getPayerAcct().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYERACCT);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getPayerBank()) && EmptyUtil.isEmpty((String)info.getPayerBank()) || EmptyUtil.isEmpty((String)oldInfo.getPayerBank()) && !EmptyUtil.isEmpty((String)info.getPayerBank()) || !EmptyUtil.isEmpty((String)oldInfo.getPayerBank()) && !EmptyUtil.isEmpty((String)info.getPayerBank()) && !oldInfo.getPayerBank().equals(info.getPayerBank())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYERBANK);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettleType()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getSettleType()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettleType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSettleType()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettleType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSettleType()) && !oldInfo.getSettleType().getId().equals((Object)info.getSettleType().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, SETTLETYPE);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getUsage()) && EmptyUtil.isEmpty((String)info.getUsage()) || EmptyUtil.isEmpty((String)oldInfo.getUsage()) && !EmptyUtil.isEmpty((String)info.getUsage()) || !EmptyUtil.isEmpty((String)oldInfo.getUsage()) && !EmptyUtil.isEmpty((String)info.getUsage()) && !oldInfo.getUsage().equals(info.getUsage())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, USAGE);
        }
        if (!EmptyUtil.isEmpty((Object)oldInfo.getExpectDealTime()) && EmptyUtil.isEmpty((Object)info.getExpectDealTime()) || EmptyUtil.isEmpty((Object)oldInfo.getExpectDealTime()) && !EmptyUtil.isEmpty((Object)info.getExpectDealTime()) || !EmptyUtil.isEmpty((Object)oldInfo.getExpectDealTime()) && !EmptyUtil.isEmpty((Object)info.getExpectDealTime()) && !oldInfo.getExpectDealTime().equals(info.getExpectDealTime())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, EXPECTDEALTIME);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFRecCountry()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFRecCountry()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFRecCountry()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry()) && !oldInfo.getFRecCountry().getId().equals((Object)info.getFRecCountry().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, FRECCOUNTRY);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getRecProvinceStr()) && EmptyUtil.isEmpty((String)info.getRecProvinceStr()) || EmptyUtil.isEmpty((String)oldInfo.getRecProvinceStr()) && !EmptyUtil.isEmpty((String)info.getRecProvinceStr()) || !EmptyUtil.isEmpty((String)oldInfo.getRecProvinceStr()) && !EmptyUtil.isEmpty((String)info.getRecProvinceStr()) && !oldInfo.getRecProvinceStr().equals(info.getRecProvinceStr())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, RECPROVINCESTR);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getRecCityStr()) && EmptyUtil.isEmpty((String)info.getRecCityStr()) || EmptyUtil.isEmpty((String)oldInfo.getRecCityStr()) && !EmptyUtil.isEmpty((String)info.getRecCityStr()) || !EmptyUtil.isEmpty((String)oldInfo.getRecCityStr()) && !EmptyUtil.isEmpty((String)info.getRecCityStr()) && !oldInfo.getRecCityStr().equals(info.getRecCityStr())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, RECCITYSTR);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getBankAcctName()) && EmptyUtil.isEmpty((String)info.getBankAcctName()) || EmptyUtil.isEmpty((String)oldInfo.getBankAcctName()) && !EmptyUtil.isEmpty((String)info.getBankAcctName()) || !EmptyUtil.isEmpty((String)oldInfo.getBankAcctName()) && !EmptyUtil.isEmpty((String)info.getBankAcctName()) && !oldInfo.getBankAcctName().equals(info.getBankAcctName())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, BANKACCTNAME);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getBankNumber()) && EmptyUtil.isEmpty((String)info.getBankNumber()) || EmptyUtil.isEmpty((String)oldInfo.getBankNumber()) && !EmptyUtil.isEmpty((String)info.getBankNumber()) || !EmptyUtil.isEmpty((String)oldInfo.getBankNumber()) && !EmptyUtil.isEmpty((String)info.getBankNumber()) && !oldInfo.getBankNumber().equals(info.getBankNumber())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, BANKNUMBER);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFinPayerInAcct()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getFinPayerInAcct()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFinPayerInAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getFinPayerInAcct()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFinPayerInAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getFinPayerInAcct()) && !oldInfo.getFinPayerInAcct().getId().equals((Object)info.getFinPayerInAcct().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, FINPAYERINACCT);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFinPayerBankAct()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getFinPayerBankAct()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFinPayerBankAct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getFinPayerBankAct()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFinPayerBankAct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getFinPayerBankAct()) && !oldInfo.getFinPayerBankAct().getId().equals((Object)info.getFinPayerBankAct().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, FINPAYERBANKACT);
        }
        Date DestDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(-30));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("operateTime", (Object)DestDate, CompareType.LESS_EQUALS));
        PaymentBillLogFactory.getLocalInstance((Context)ctx).delete(filter);
        PaymentBillLogFactory.getLocalInstance((Context)ctx).addnewBatchData(logCollection);
    }

    private void createPaymentLogInfo(Context ctx, CoreBaseCollection logCollection, SettlementBillInfo info, SettlementBillInfo oldInfo, UserInfo userInfo, Timestamp currTime, PaymentOperateType operateType, String column) {
        PaymentBillLogInfo logInfo = new PaymentBillLogInfo();
        logInfo.setIP(ctx.getClientHostIP());
        logInfo.setBillNumber(info.getNumber());
        logInfo.setOperateTime(currTime);
        logInfo.setUserName(userInfo.getName());
        logInfo.setUserNumber(userInfo.getNumber());
        logInfo.setOperateType(operateType);
        logInfo.setCompany(info.getCompany());
        if (info.getType() == SettBizTypeEnum.PAYOUTSIDE) {
            logInfo.setOperateBillEnum(OperateBillEnum.SettlementBill_PayOut);
        } else if (info.getType() == SettBizTypeEnum.LINKPAY) {
            logInfo.setOperateBillEnum(OperateBillEnum.SettlementBill_LinkPay);
        } else {
            return;
        }
        if (BIZTYPE.equals(column)) {
            logInfo.setUpdateColumn(BIZTYPE);
            if (oldInfo.getBizType() != null) {
                logInfo.setUpdateBefore(oldInfo.getBizType().getName());
            }
            if (info.getBizType() != null) {
                logInfo.setUpdateAfter(info.getBizType().getName());
            }
        } else if (PAYEEFULLNAME.equals(column)) {
            logInfo.setUpdateColumn(PAYEEFULLNAME);
            if (oldInfo.getPayeeFullName() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayeeFullName());
            }
            if (info.getPayeeFullName() != null) {
                logInfo.setUpdateAfter(info.getPayeeFullName());
            }
        } else if (PAYEEBANKACCTNUM.equals(column)) {
            logInfo.setUpdateColumn(PAYEEBANKACCTNUM);
            if (oldInfo.getPayeeBankAcctNum() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayeeBankAcctNum());
            }
            if (info.getPayeeBankAcctNum() != null) {
                logInfo.setUpdateAfter(info.getPayeeBankAcctNum());
            }
        } else if (PAYEEBANK.equals(column)) {
            logInfo.setUpdateColumn(PAYEEBANK);
            if (oldInfo.getPayeeBank() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayeeBank());
            }
            if (info.getPayeeBank() != null) {
                logInfo.setUpdateAfter(info.getPayeeBank());
            }
        } else if (PAYERFULLNAME.equals(column)) {
            logInfo.setUpdateColumn(PAYERFULLNAME);
            if (oldInfo.getPayerFullName() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayerFullName());
            }
            if (info.getPayerFullName() != null) {
                logInfo.setUpdateAfter(info.getPayerFullName());
            }
        } else if (PAYERINNERACCT.equals(column)) {
            logInfo.setUpdateColumn(PAYERINNERACCT);
            if (oldInfo.getPayerInnerAcct() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayerInnerAcct().getName());
            }
            if (info.getPayerInnerAcct() != null) {
                logInfo.setUpdateAfter(info.getPayerInnerAcct().getName());
            }
        } else if (INNERPAYERACCT.equals(column)) {
            logInfo.setUpdateColumn(INNERPAYERACCT);
            if (oldInfo.getInnerPayerAcct() != null) {
                logInfo.setUpdateBefore(oldInfo.getInnerPayerAcct().getName());
            }
            if (info.getInnerPayerAcct() != null) {
                logInfo.setUpdateAfter(info.getInnerPayerAcct().getName());
            }
        } else if (SUBACCOUNT.equals(column)) {
            logInfo.setUpdateColumn(SUBACCOUNT);
            if (oldInfo.getSubAccount() != null) {
                logInfo.setUpdateBefore(oldInfo.getSubAccount());
            }
            if (info.getSubAccount() != null) {
                logInfo.setUpdateAfter(info.getSubAccount());
            }
        } else if (FUNDFLOWITEMOUT.equals(column)) {
            logInfo.setUpdateColumn(FUNDFLOWITEMOUT);
            if (oldInfo.getFundFlowItemOut() != null) {
                logInfo.setUpdateBefore(oldInfo.getFundFlowItemOut().getName());
            }
            if (info.getFundFlowItemOut() != null) {
                logInfo.setUpdateAfter(info.getFundFlowItemOut().getName());
            }
        } else if (ISFORCEMANUAL.equals(column)) {
            logInfo.setUpdateColumn(ISFORCEMANUAL);
            if (oldInfo.isIsForceManual()) {
                logInfo.setUpdateBefore("true");
            } else {
                logInfo.setUpdateBefore("false");
            }
            if (info.isIsForceManual()) {
                logInfo.setUpdateAfter("true");
            } else {
                logInfo.setUpdateAfter("false");
            }
        } else if (SWIFTCODE.equals(column)) {
            logInfo.setUpdateColumn(SWIFTCODE);
            if (oldInfo.getSwiftCode() != null) {
                logInfo.setUpdateBefore(oldInfo.getSwiftCode());
            }
            if (info.getSwiftCode() != null) {
                logInfo.setUpdateAfter(info.getSwiftCode());
            }
        } else if (ISURGENT.equals(column)) {
            logInfo.setUpdateColumn(ISURGENT);
            if (oldInfo.getIsUrgent() != null) {
                logInfo.setUpdateBefore(oldInfo.getIsUrgent().getAlias());
            }
            if (info.getIsUrgent() != null) {
                logInfo.setUpdateAfter(info.getIsUrgent().getAlias());
            }
        } else if (AMOUNT.equals(column)) {
            logInfo.setUpdateColumn(AMOUNT);
            logInfo.setUpdateBefore(String.valueOf(oldInfo.getAmount().setScale(4, 4)));
            logInfo.setUpdateAfter(String.valueOf(info.getAmount().setScale(4, 4)));
        } else if (CURRENCY.equals(column)) {
            logInfo.setUpdateColumn(CURRENCY);
            if (oldInfo.getCurrency() != null) {
                logInfo.setUpdateBefore(oldInfo.getCurrency().getName());
            }
            if (info.getCurrency() != null) {
                logInfo.setUpdateAfter(info.getCurrency().getName());
            }
        } else if (EXCHANGE.equals(column)) {
            logInfo.setUpdateColumn(EXCHANGE);
            if (oldInfo.getExchange() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getExchange()));
            }
            if (info.getExchange() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getExchange()));
            }
        } else if (PAYERBANKACCT.equals(column)) {
            logInfo.setUpdateColumn(PAYERBANKACCT);
            if (oldInfo.getPayerBankAcct() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayerBankAcct().getName());
            }
            if (info.getPayerBankAcct() != null) {
                logInfo.setUpdateAfter(info.getPayerBankAcct().getName());
            }
        } else if (PAYERACCT.equals(column)) {
            logInfo.setUpdateColumn(PAYERACCT);
            if (oldInfo.getPayerAcct() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayerAcct().getName());
            }
            if (info.getPayerAcct() != null) {
                logInfo.setUpdateAfter(info.getPayerAcct().getName());
            }
        } else if (PAYERBANK.equals(column)) {
            logInfo.setUpdateColumn(PAYERBANK);
            if (oldInfo.getPayerBank() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayerBank());
            }
            if (info.getPayerBank() != null) {
                logInfo.setUpdateAfter(info.getPayerBank());
            }
        } else if (SETTLETYPE.equals(column)) {
            logInfo.setUpdateColumn(SETTLETYPE);
            if (oldInfo.getSettleType() != null) {
                logInfo.setUpdateBefore(oldInfo.getSettleType().getName());
            }
            if (info.getSettleType() != null) {
                logInfo.setUpdateAfter(info.getSettleType().getName());
            }
        } else if (USAGE.equals(column)) {
            logInfo.setUpdateColumn(USAGE);
            if (oldInfo.getUsage() != null) {
                logInfo.setUpdateBefore(oldInfo.getUsage());
            }
            if (info.getUsage() != null) {
                logInfo.setUpdateAfter(info.getUsage());
            }
        } else if (EXPECTDEALTIME.equals(column)) {
            logInfo.setUpdateColumn(EXPECTDEALTIME);
            if (oldInfo.getExpectDealTime() != null) {
                logInfo.setUpdateBefore(oldInfo.getExpectDealTime().toString());
            }
            if (info.getExpectDealTime() != null) {
                logInfo.setUpdateAfter(info.getExpectDealTime().toString());
            }
        } else if (FRECCOUNTRY.equals(column)) {
            logInfo.setUpdateColumn(FRECCOUNTRY);
            if (oldInfo.getFRecCountry() != null) {
                logInfo.setUpdateBefore(oldInfo.getFRecCountry().getName());
            }
            if (info.getFRecCountry() != null) {
                logInfo.setUpdateAfter(info.getFRecCountry().getName());
            }
        } else if (RECPROVINCESTR.equals(column)) {
            logInfo.setUpdateColumn(RECPROVINCESTR);
            if (oldInfo.getRecProvinceStr() != null) {
                logInfo.setUpdateBefore(oldInfo.getRecProvinceStr());
            }
            if (info.getRecProvinceStr() != null) {
                logInfo.setUpdateAfter(info.getRecProvinceStr());
            }
        } else if (RECCITYSTR.equals(column)) {
            logInfo.setUpdateColumn(RECCITYSTR);
            if (oldInfo.getRecCityStr() != null) {
                logInfo.setUpdateBefore(oldInfo.getRecCityStr());
            }
            if (info.getRecCityStr() != null) {
                logInfo.setUpdateAfter(info.getRecCityStr());
            }
        } else if (BANKACCTNAME.equals(column)) {
            logInfo.setUpdateColumn(BANKACCTNAME);
            if (oldInfo.getBankAcctName() != null) {
                logInfo.setUpdateBefore(oldInfo.getBankAcctName());
            }
            if (info.getBankAcctName() != null) {
                logInfo.setUpdateAfter(info.getBankAcctName());
            }
        } else if (BANKNUMBER.equals(column)) {
            logInfo.setUpdateColumn(BANKNUMBER);
            if (oldInfo.getBankNumber() != null) {
                logInfo.setUpdateBefore(oldInfo.getBankNumber());
            }
            if (info.getBankNumber() != null) {
                logInfo.setUpdateAfter(info.getBankNumber());
            }
        } else if (FINPAYERINACCT.equals(column)) {
            logInfo.setUpdateColumn(FINPAYERINACCT);
            if (oldInfo.getFinPayerInAcct() != null) {
                logInfo.setUpdateBefore(oldInfo.getFinPayerInAcct().getName());
            }
            if (info.getFinPayerInAcct() != null) {
                logInfo.setUpdateAfter(info.getFinPayerInAcct().getName());
            }
        } else if (FINPAYERBANKACT.equals(column)) {
            logInfo.setUpdateColumn(FINPAYERBANKACT);
            if (oldInfo.getFinPayerBankAct() != null) {
                logInfo.setUpdateBefore(oldInfo.getFinPayerBankAct().getName());
            }
            if (info.getFinPayerBankAct() != null) {
                logInfo.setUpdateAfter(info.getFinPayerBankAct().getName());
            }
        }
        logCollection.add((CoreBaseInfo)logInfo);
    }

    private SelectorItemCollection getSelectorForLog() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.id"));
        sic.add(new SelectorItemInfo("payerInnerAcct.name"));
        sic.add(new SelectorItemInfo("innerPayerAcct.id"));
        sic.add(new SelectorItemInfo("innerPayerAcct.name"));
        sic.add(new SelectorItemInfo("fundFlowItemOut.id"));
        sic.add(new SelectorItemInfo("fundFlowItemOut.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("payerBankAcct.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.name"));
        sic.add(new SelectorItemInfo("payerAcct.id"));
        sic.add(new SelectorItemInfo("payerAcct.name"));
        sic.add(new SelectorItemInfo("settleType.id"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("fRecCountry.id"));
        sic.add(new SelectorItemInfo("fRecCountry.name"));
        sic.add(new SelectorItemInfo("finPayerInAcct.id"));
        sic.add(new SelectorItemInfo("finPayerInAcct.name"));
        sic.add(new SelectorItemInfo("finPayerBankAct.id"));
        sic.add(new SelectorItemInfo("finPayerBankAct.name"));
        return sic;
    }

    private Date getSrcDate(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + days);
        return calendar.getTime();
    }

    @Override
    protected int _acceptBatch(Context ctx, List ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)this.getSelectorsForRow());
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        SettlementBillCollection coll = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            SettlementBillInfo bill = coll.get(i);
            this.verifyCanAccept(ctx, bill);
            this.writeCheckInfo(ctx, bill);
            ArrayList<String> id = new ArrayList<String>();
            id.add(bill.getId().toString());
            try {
                SettleFacadeFactory.getLocalInstance(ctx).accept(ids);
                continue;
            }
            catch (Exception e) {
                String returnMsg = e.getMessage();
                if (returnMsg != null && returnMsg.split("#").length > 1) {
                    returnMsg = returnMsg.split("#")[0];
                }
                throw new BOSException(returnMsg);
            }
        }
        return size;
    }

    @Override
    protected int _cancelAcceptBatch(Context ctx, List ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)this.getSelectorsForRow());
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        SettlementBillCollection coll = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            SettlementBillInfo bill = coll.get(i);
            this.verifyCanCancelAccept(ctx, bill);
            ArrayList<String> id = new ArrayList<String>();
            id.add(bill.getId().toString());
            SettleFacadeFactory.getLocalInstance(ctx).cancelAccept(ids);
        }
        return size;
    }

    protected void verifyCanAccept(Context ctx, SettlementBillInfo bill) throws BOSException, EASBizException {
        this.verifyRowNormalData(ctx, bill);
        int type = bill.getType().getValue();
        switch (type) {
            case 3: {
                this.checkPayeeByRow4Accept(ctx, bill);
                this.checkPayerByRow4Accept(ctx, bill);
                break;
            }
            case 4: {
                this.checkPayeeByRow4Accept(ctx, bill);
                this.checkPayerByRow4Accept(ctx, bill);
                break;
            }
            case 1: {
                this.checkPayeeByRow4Accept(ctx, bill);
                break;
            }
            case 2: 
            case 100: {
                this.checkPayerByRow4Accept(ctx, bill);
                break;
            }
            case 51: {
                this.verifyForMutil(ctx, bill);
                break;
            }
            case 52: {
                this.verifyForMutil(ctx, bill);
                break;
            }
        }
    }

    protected void verifyRowNormalData(Context ctx, SettlementBillInfo bill) throws BOSException, EASBizException {
        if (bill.getAcceptor() != null) {
            throw new FSException(FSException.HASACCEPTEDERRER);
        }
        if (!bill.isHasEffected()) {
            throw new FSException(FSException.BILLINVALIDATION);
        }
        if (EmptyUtil.isEmpty((String)bill.getNumber())) {
            throw new FSException(FSException.SETTLEBILLNUMBERNULL);
        }
        if (EmptyUtil.isEmpty((Object)((Object)bill.getType()))) {
            throw new FSException(FSException.NONETYPE);
        }
        if (EmptyUtil.isEmpty((Object)bill.getExchange()) || bill.getExchange().compareTo(Constants.ZERO) == 0) {
            throw new FSException(FSException.NONEEXCHANGERATE);
        }
        if (EmptyUtil.isEmpty((Object)bill.getAmount()) || bill.getAmount().compareTo(Constants.ZERO) == 0) {
            throw new FSException(FSException.NONEAMOUNT);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)bill.getCreator())) {
            throw new FSException(FSException.NONECREATOR);
        }
        if (EmptyUtil.isEmpty((Object)bill.getBizDate())) {
            throw new FSException(FSException.NONECREATETIME);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)bill.getCurrency())) {
            throw new FSException(FSException.NONECURRENCY);
        }
    }

    protected void checkPayeeByRow4Accept(Context ctx, SettlementBillInfo bill) throws BOSException, EASBizException {
        if (bill.getInnerPayeeAcct() == null) {
            throw new FSException(FSException.NONEINNERPAYEEACCT);
        }
    }

    protected void checkPayerByRow4Accept(Context ctx, SettlementBillInfo bill) throws BOSException, EASBizException {
        if (bill.getInnerPayerAcct() == null) {
            throw new FSException(FSException.NONEINNERPAYEEACCT);
        }
    }

    protected void verifyForMutil(Context ctx, SettlementBillInfo bill) throws BOSException, EASBizException {
        int mutilType = bill.getMutilType().getValue();
        switch (mutilType) {
            case 1: {
                if (bill.getInnerPayeeAcct() == null) {
                    throw new FSException(FSException.MUSTINNERPAYEEVIEW);
                }
                if (bill.getPayeeBank() != null || bill.getInnerPayerAcct() != null) break;
                throw new FSException(FSException.MUSTPAYEEBANKACCTORPAYERVIEW);
            }
            case 2: {
                if (bill.getInnerPayerAcct() == null) {
                    throw new FSException(FSException.MUSTINNERPAYERVIEW);
                }
                if (bill.getPayerBankAcct() != null || bill.getInnerPayeeAcct() != null) break;
                throw new FSException(FSException.MUSTPAYERBANKACCTORPAYEEVIEW);
            }
            case 3: {
                if (bill.getInnerPayeeAcct() != null && bill.getInnerPayerAcct() != null) break;
                throw new FSException(FSException.MUSTHAVEINNERSIDEACCTVIEW);
            }
        }
    }

    protected void writeCheckInfo(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        if (info.getType().getValue() == 2 || info.getType().getValue() == 4) {
            boolean val = false;
            if (info.getPayerInnerAcct() != null && info.getPayerInnerAcct().getApplyUnit() != null) {
                val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM009", (IObjectPK)new ObjectUuidPK(info.getPayerInnerAcct().getApplyUnit().getId()));
            }
            if (val && info.getInnerSettleNumber() != null) {
                String msg = "";
                try {
                    msg = SettleFacadeFactory.getLocalInstance(ctx).checkFindCheck((IObjectPK)new ObjectUuidPK(info.getId()));
                }
                catch (EASBizException e) {
                    throw new FSException(FSException.COMMON, new Object[]{e.getMessage()});
                }
                catch (BOSException e) {
                    throw new FSException(FSException.COMMON, new Object[]{e.getMessage()});
                }
                if (!EmptyUtil.isEmpty((String)msg)) {
                    throw new FSException(FSException.COMMON, new Object[]{msg});
                }
            }
        }
    }

    protected void verifyCanCancelAccept(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getAcceptor())) {
            throw new FSException(FSException.HASNOTACCEPTERRER);
        }
        BankInfo clearingHouseInfo = FSHelper.getClearingHouseInfo(ctx, info.getCompany().getId().toString());
        if (info.getAcceptedDate().before(clearingHouseInfo.getSettleDate())) {
            throw new FSException(FSException.UNSETTLENOTPERMISSION, new Object[]{info.getNumber()});
        }
        if (info.getCashier() != null) {
            throw new FSException(FSException.HASSETTLEDERRER);
        }
        String source = info.getSource().getValue();
        if (source.equals("recAcct") || source.equals("transBill")) {
            throw new FSException(FSException.REMOVEERROR);
        }
        if (info.isFiVouchered()) {
            throw new FSException(FSException.HASVOUCHERED);
        }
    }

    private SelectorItemCollection getSelectorsForRow() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.id"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.number"));
        sic.add(new SelectorItemInfo("payeeBankAcct.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.name"));
        sic.add(new SelectorItemInfo("payeeBankAcct.number"));
        sic.add(new SelectorItemInfo("payerBankAcct.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.number"));
        sic.add(new SelectorItemInfo("payerBankAcct.name"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.id"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.number"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.id"));
        sic.add(new SelectorItemInfo("payerInnerAcct.number"));
        sic.add(new SelectorItemInfo("payerInnerAcct.name"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("settleType.id"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.company.id"));
        sic.add(new SelectorItemInfo("payerInnerAcct.company.id"));
        sic.add(new SelectorItemInfo("payeeInnerAcct.applyUnit.id"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.id"));
        sic.add(new SelectorItemInfo("payeeBankAcct.company.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.company.id"));
        sic.add("settleType.ntType.group");
        sic.add(new SelectorItemInfo("innerPayeeAcct.id"));
        sic.add(new SelectorItemInfo("innerPayeeAcct.name"));
        sic.add(new SelectorItemInfo("innerPayeeAcct.number"));
        sic.add(new SelectorItemInfo("innerPayerAcct.id"));
        sic.add(new SelectorItemInfo("innerPayerAcct.name"));
        sic.add(new SelectorItemInfo("innerPayerAcct.number"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList _batchSubmitWithReturn(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> massageList = new ArrayList<BankPayResult>();
        if (EmptyUtil.isEmpty((Collection)idSet)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("company.id"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        ISettlementBill iSettlementBill = SettlementBillFactory.getLocalInstance(ctx);
        SettlementBillCollection settlementBillCollection = iSettlementBill.getSettlementBillCollection(viewInfo);
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < settlementBillCollection.size(); ++i) {
            SettlementBillInfo settlementBillInfo = settlementBillCollection.get(i);
            String id = settlementBillInfo.getId().toString();
            String number = settlementBillInfo.getNumber();
            boolean isLock = false;
            try {
                String returnMsg;
                isLock = iMutex.requestBizObjIDForUpdate(id);
                if (!isLock) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)resourcePath, (String)"412_reqMutex_ERR", (Locale)ctx.getLocale())});
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(settlementBillInfo.getCompany().getId()), (String)"fs_settlement_submit");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_SUBMIT_AUTHRIZED);
                }
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(id);
                Map map = iSettlementBill.saveBatch(ids);
                if (map == null || map.get("error") == null || (returnMsg = map.get("error").toString()).equals("")) continue;
                BankPayResult payResult = new BankPayResult(id, number, null, returnMsg);
                payResult.setErrorDetail(returnMsg);
                massageList.add(payResult);
                continue;
            }
            catch (Exception e) {
                String returnMsg = e.getMessage();
                BankPayResult payResult = new BankPayResult(id, number, null, returnMsg);
                payResult.setErrorDetail(returnMsg);
                massageList.add(payResult);
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(id);
                }
            }
        }
        return massageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList _batchAccept(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> massageList = new ArrayList<BankPayResult>();
        if (EmptyUtil.isEmpty((Collection)idSet)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getSelectorsForRow());
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        ISettlementBill iSettlementBill = SettlementBillFactory.getLocalInstance(ctx);
        ISettleFacade iSettleFacade = SettleFacadeFactory.getLocalInstance(ctx);
        SettlementBillCollection settlementBillCollection = iSettlementBill.getSettlementBillCollection(viewInfo);
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map resultRequest = iMutex.batchRequestObjIDForUpdate(FMHelper.set2List((Set)idSet));
        ArrayList<String> lockIdList = new ArrayList<String>();
        try {
            for (int i = 0; i < settlementBillCollection.size(); ++i) {
                SettlementBillInfo settlementBillInfo = settlementBillCollection.get(i);
                String id = settlementBillInfo.getId().toString();
                Boolean boolResult = (Boolean)resultRequest.get(id);
                if (!boolResult.booleanValue()) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"198_PaymentBillControllerBean", (Locale)ctx.getLocale())});
                }
                lockIdList.add(id);
                String number = settlementBillInfo.getNumber();
                try {
                    this.verifyCanAccept(ctx, settlementBillInfo);
                    this.writeCheckInfo(ctx, settlementBillInfo);
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(settlementBillInfo.getCompany().getId()), (String)"FS_ST_04ACCEPT");
                    if (!isPermission) {
                        throw new BEException(BEException.NO_ACCEPT_AUTHRIZED);
                    }
                    ArrayList<String> ids = new ArrayList<String>();
                    ids.add(id);
                    iSettleFacade.accept(ids);
                    continue;
                }
                catch (Exception e) {
                    String returnMsg = e.getMessage();
                    if (returnMsg != null && returnMsg.split("#").length > 1) {
                        returnMsg = returnMsg.split("#")[0];
                    }
                    BankPayResult payResult = new BankPayResult(id, number, null, returnMsg);
                    payResult.setErrorDetail(returnMsg);
                    massageList.add(payResult);
                }
            }
        }
        finally {
            if (!EmptyUtil.isEmpty(lockIdList)) {
                iMutex.batchReleaseObjIDForUpdate(lockIdList);
            }
        }
        return massageList;
    }

    @Override
    protected Map _verifyChongFuNew(Context ctx, List idList, int actionType) throws BOSException, EASBizException {
        if (idList.size() == 0) {
            return null;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection s = new SelectorItemCollection();
        s.add("*");
        view.setSelector(s);
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("amount");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        item = new SorterItemInfo("number");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        view.setSorter(sorter);
        SettlementBillCollection coll = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(view);
        HashMap<String, SettlementBillCollection> companyPayMap = new HashMap<String, SettlementBillCollection>();
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo billInfo = coll.get(i);
            if (billInfo.getSource() != null && billInfo.getSource().equals((Object)SettlementBillSourceEnum.BETRANSDETAIL) || EmptyUtil.isEmpty((CoreBaseInfo)billInfo.getCompany())) continue;
            String key = billInfo.getCompany().getId().toString();
            SettlementBillCollection values = (SettlementBillCollection)((Object)companyPayMap.get(key));
            if (EmptyUtil.isEmpty((AbstractObjectCollection)values)) {
                values = new SettlementBillCollection();
            }
            if ((actionType == 2 || actionType == 3) && (SettlementBillStatusEnum.AUDIT.equals((Object)billInfo.getBillStatus()) || SettlementBillStatusEnum.ACCEPTED.equals((Object)billInfo.getBillStatus()))) {
                values.add(billInfo);
            } else if (actionType == 0 && (SettlementBillStatusEnum.SAVED.equals((Object)billInfo.getBillStatus()) || SettlementBillStatusEnum.SUBMITED.equals((Object)billInfo.getBillStatus()) || SettlementBillStatusEnum.AUDIT.equals((Object)billInfo.getBillStatus()) || SettlementBillStatusEnum.ACCEPTED.equals((Object)billInfo.getBillStatus()) || SettlementBillStatusEnum.SETTLEMENTED.equals((Object)billInfo.getBillStatus()))) {
                values.add(billInfo);
            } else if (actionType == 1 && (SettlementBillStatusEnum.SUBMITED.equals((Object)billInfo.getBillStatus()) || SettlementBillStatusEnum.AUDIT.equals((Object)billInfo.getBillStatus()) || SettlementBillStatusEnum.ACCEPTED.equals((Object)billInfo.getBillStatus()) || SettlementBillStatusEnum.SETTLEMENTED.equals((Object)billInfo.getBillStatus()))) {
                values.add(billInfo);
            }
            companyPayMap.put(key, values);
            companySet.add(key);
        }
        if (coll.size() == 0) {
            return null;
        }
        HashMap result = new HashMap();
        Map settIngMap = new HashMap();
        boolean isCommitToBe = false;
        settIngMap = AntiRepeatSettingFactory.getLocalInstance((Context)ctx).getAntiRepeatSettingResult(companySet, RepeatBillTypeEnum.SettlementBillQuery.getValue(), 0);
        for (String companyId : companyPayMap.keySet()) {
            HashMap<String, Map> comPanyMap;
            Date SrcDate;
            Date DestDate;
            int newDays;
            int days;
            SettlementBillCollection settleColl = (SettlementBillCollection)((Object)companyPayMap.get(companyId));
            if (settleColl == null || settleColl.size() == 0) continue;
            AntiRepeatSettingInfo settingInfo = (AntiRepeatSettingInfo)settIngMap.get(companyId);
            if (actionType == 2 || actionType == 3) {
                days = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("TM117", (IObjectPK)new ObjectUuidPK(companyId));
                if (days == 0) continue;
                newDays = days;
                DestDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(newDays));
                SrcDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(1 - newDays));
                if (settleColl == null || settleColl.size() <= 0 || days <= 0) continue;
                comPanyMap = new HashMap();
                Map CS116Map = this.getChongFuSettleMapNew(ctx, settleColl, DestDate, SrcDate, false, null, actionType);
                if (CS116Map == null) continue;
                CS116Map.put("days", days);
                comPanyMap.put(companyId, CS116Map);
                result.putAll(comPanyMap);
                continue;
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)settingInfo) || (!settingInfo.isIsSummit() || actionType != 0) && (!settingInfo.isIsApprove() || actionType != 1)) continue;
            newDays = days = settingInfo.getDays();
            if (days == 0) {
                newDays = 1;
            }
            DestDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(newDays));
            SrcDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(1 - newDays));
            comPanyMap = new HashMap<String, Map>();
            Map settIngMapOne = this.getChongFuSettleMapNew(ctx, settleColl, DestDate, SrcDate, false, settingInfo, actionType);
            if (settIngMapOne == null) continue;
            comPanyMap.put(companyId, settIngMapOne);
            result.putAll(comPanyMap);
        }
        return result;
    }

    @Override
    protected Map _verifyChongFuByInfo(Context ctx, SettlementBillInfo info, int actionType) throws BOSException, EASBizException {
        IObjectPK pk = null;
        if (info.getId() == null || !SettlementBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            ctx.put((Object)"fromVerifyChongFu", (Object)true);
            pk = super._save(ctx, (IObjectValue)info);
            ctx.remove((Object)"fromVerifyChongFu");
            HashMap result = new HashMap();
            Map settIngMap = new HashMap();
            boolean isCommitToBe = false;
            HashSet<String> companySet = new HashSet<String>();
            SettlementBillCollection coll = new SettlementBillCollection();
            coll.add(info);
            companySet.add(info.getCompany().getId().toString());
            settIngMap = AntiRepeatSettingFactory.getLocalInstance((Context)ctx).getAntiRepeatSettingResult(companySet, RepeatBillTypeEnum.SettlementBillQuery.getValue(), 0);
            String companyId = info.getCompany().getId().toString();
            AntiRepeatSettingInfo settingInfo = (AntiRepeatSettingInfo)settIngMap.get(companyId);
            StringBuffer chongFumessage = new StringBuffer();
            StringBuffer chongFuIdStr = new StringBuffer();
            if (!EmptyUtil.isEmpty((CoreBaseInfo)settingInfo) && settingInfo.isIsSummit() && actionType == 0) {
                int days;
                int newDays = days = settingInfo.getDays();
                if (days == 0) {
                    newDays = 1;
                }
                Date DestDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(newDays));
                Date SrcDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(1 - newDays));
                HashMap comPanyMap = new HashMap();
                Map map = this.getChongFuSettleMapNew(ctx, coll, DestDate, SrcDate, false, settingInfo, actionType);
                if (map != null) {
                    List likeIdAndNumList = (List)map.get(pk.toString());
                    String repeatNumber = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"481_CasPaymentPayRepeat", (Object[])new Object[]{""});
                    chongFumessage.append(ResourceBase.getString((String)resourcePath, (String)"513_SettlementBillControllerBean", (Locale)ctx.getLocale()) + info.getCompany().getName() + ResourceBase.getString((String)resourcePath, (String)"514_SettlementBillControllerBean", (Locale)ctx.getLocale()) + repeatNumber + "\n");
                    for (int i = 0; i < likeIdAndNumList.size(); ++i) {
                        String likedIdAndNum = (String)likeIdAndNumList.get(i);
                        String[] likedIdAndNumArr = likedIdAndNum.split(";");
                        chongFumessage.append(likedIdAndNumArr[1] + "     ");
                        chongFuIdStr.append(likedIdAndNum).append(",");
                    }
                    chongFumessage.append("\n");
                }
            }
            if (chongFumessage.length() > 0) {
                throw new BOSException(chongFumessage.toString() + "&&" + chongFuIdStr.toString());
            }
            throw new BOSException("hasNotchongFu");
        }
        pk = new ObjectUuidPK(info.getId());
        SettlementBillInfo oldInfo = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo(pk);
        HashMap result = new HashMap();
        Map settIngMap = new HashMap();
        boolean isCommitToBe = false;
        HashSet<String> companySet = new HashSet<String>();
        SettlementBillCollection coll = new SettlementBillCollection();
        SettlementBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
        coll.add(info);
        companySet.add(info.getCompany().getId().toString());
        settIngMap = AntiRepeatSettingFactory.getLocalInstance((Context)ctx).getAntiRepeatSettingResult(companySet, RepeatBillTypeEnum.SettlementBillQuery.getValue(), 0);
        String companyId = info.getCompany().getId().toString();
        AntiRepeatSettingInfo settingInfo = (AntiRepeatSettingInfo)settIngMap.get(companyId);
        StringBuffer chongFumessage = new StringBuffer();
        StringBuffer chongFuIdStr = new StringBuffer();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)settingInfo) && settingInfo.isIsSummit() && actionType == 0) {
            int days;
            int newDays = days = settingInfo.getDays();
            if (days == 0) {
                newDays = 1;
            }
            Date DestDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(newDays));
            Date SrcDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(1 - newDays));
            HashMap comPanyMap = new HashMap();
            Map map = this.getChongFuSettleMapNew(ctx, coll, DestDate, SrcDate, false, settingInfo, actionType);
            if (map != null) {
                List likeIdAndNumList = (List)map.get(pk.toString());
                String repeatNumber = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"481_CasPaymentPayRepeat", (Object[])new Object[]{""});
                chongFumessage.append(ResourceBase.getString((String)resourcePath, (String)"513_SettlementBillControllerBean", (Locale)ctx.getLocale()) + info.getCompany().getName() + ResourceBase.getString((String)resourcePath, (String)"514_SettlementBillControllerBean", (Locale)ctx.getLocale()) + repeatNumber + "\n");
                for (int i = 0; i < likeIdAndNumList.size(); ++i) {
                    String likedIdAndNum = (String)likeIdAndNumList.get(i);
                    String[] likedIdAndNumArr = likedIdAndNum.split(";");
                    chongFumessage.append(likedIdAndNumArr[1] + "     ");
                    chongFuIdStr.append(likedIdAndNum).append(",");
                }
                chongFumessage.append("\n");
            }
        }
        SettlementBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)oldInfo);
        if (chongFumessage.length() > 0) {
            throw new BOSException(chongFumessage.toString() + "&&" + chongFuIdStr.toString());
        }
        return null;
    }

    private Map getChongFuSettleMapNew(Context ctx, SettlementBillCollection coll, Date DestDate, Date SrcDate, boolean isCS128, AntiRepeatSettingInfo settingInfo, int actionType) throws BOSException, EASBizException {
        LinkedHashMap map = new LinkedHashMap();
        boolean isConfirm = false;
        HashSet<String> typeSet = new HashSet<String>();
        typeSet.add("manual");
        typeSet.add("recBill");
        typeSet.add("payBill");
        typeSet.add("recAcct");
        typeSet.add("transBill");
        typeSet.add("settleBill");
        typeSet.add("finBill");
        typeSet.add("ivtBill");
        int TM117_01 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("TM117_01", (IObjectPK)new ObjectUuidPK(coll.get(0).getCompany().getId()));
        if (settingInfo == null) {
            HashSet<Integer> billStatusSet = new HashSet<Integer>();
            billStatusSet.add(2);
            billStatusSet.add(3);
            billStatusSet.add(4);
            billStatusSet.add(5);
            for (int i = 0; i < coll.size(); ++i) {
                SettlementBillInfo info = coll.get(i);
                if (info.getType() != SettBizTypeEnum.PAYOUTSIDE && info.getType() != SettBizTypeEnum.LINKPAY || info.getSource() != null && info.getSource().equals((Object)SettlementBillSourceEnum.BETRANSDETAIL)) continue;
                EntityViewInfo entifyView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("payeeBankAcctNum", (Object)info.getPayeeBankAcctNum()));
                filter.getFilterItems().add(new FilterItemInfo("amount", (Object)info.getAmount()));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
                if (info.getApplyUnit() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)info.getApplyUnit().getId().toString()));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", null));
                }
                filter.getFilterItems().add(new FilterItemInfo("billStatus", billStatusSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("source", typeSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)DestDate, CompareType.LESS));
                filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)SrcDate, CompareType.GREATER_EQUALS));
                if (info.getId() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
                }
                if (TM117_01 == 0) {
                    if (!EmptyUtil.isEmpty((String)info.getDescription()) && !EmptyUtil.isEmpty((String)info.getUsage())) {
                        filter.getFilterItems().add(new FilterItemInfo("description", (Object)info.getDescription()));
                        filter.getFilterItems().add(new FilterItemInfo("description", null, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("description", (Object)" ", CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("usage", (Object)info.getUsage()));
                        filter.getFilterItems().add(new FilterItemInfo("usage", null, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("usage", (Object)" ", CompareType.EQUALS));
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9 AND (#10 OR #11 OR #12 OR #13 OR #14 OR #15)");
                    } else {
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9");
                    }
                } else if (TM117_01 == 1) {
                    if (!EmptyUtil.isEmpty((String)info.getDescription())) {
                        filter.getFilterItems().add(new FilterItemInfo("description", (Object)info.getDescription()));
                        filter.getFilterItems().add(new FilterItemInfo("description", null, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("description", (Object)" ", CompareType.EQUALS));
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9 AND (#10 OR #11 OR #12)");
                    } else {
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9");
                    }
                } else if (TM117_01 == 2) {
                    if (!EmptyUtil.isEmpty((String)info.getUsage())) {
                        filter.getFilterItems().add(new FilterItemInfo("usage", (Object)info.getUsage()));
                        filter.getFilterItems().add(new FilterItemInfo("usage", null, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("usage", (Object)" ", CompareType.EQUALS));
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9 AND (#10 OR #11 OR #12)");
                    } else {
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9");
                    }
                } else if (TM117_01 == 3) {
                    if (EmptyUtil.isEmpty((String)info.getUsage()) && EmptyUtil.isEmpty((String)info.getDescription())) {
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9");
                    } else if (EmptyUtil.isEmpty((String)info.getUsage())) {
                        filter.getFilterItems().add(new FilterItemInfo("description", (Object)info.getDescription()));
                        filter.getFilterItems().add(new FilterItemInfo("description", null, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("description", (Object)" ", CompareType.EQUALS));
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9 AND (#10 OR #11 OR #12)");
                    } else if (EmptyUtil.isEmpty((String)info.getDescription())) {
                        filter.getFilterItems().add(new FilterItemInfo("usage", (Object)info.getUsage()));
                        filter.getFilterItems().add(new FilterItemInfo("usage", null, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("usage", (Object)" ", CompareType.EQUALS));
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9 AND (#10 OR #11 OR #12)");
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("description", (Object)info.getDescription()));
                        filter.getFilterItems().add(new FilterItemInfo("description", null, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("description", (Object)" ", CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("usage", (Object)info.getUsage()));
                        filter.getFilterItems().add(new FilterItemInfo("usage", null, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("usage", (Object)" ", CompareType.EQUALS));
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 AND #8 AND #9 AND (#10 OR #11 OR #12) AND (#13 OR #14 OR #15)");
                    }
                }
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("type");
                entifyView.setFilter(filter);
                entifyView.setSelector(selector);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("number");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                entifyView.setSorter(sorter);
                SettlementBillCollection paycoll = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(entifyView);
                if (paycoll == null || paycoll.size() <= 0) continue;
                ArrayList<String> idList = new ArrayList<String>();
                for (int j = 0; j < paycoll.size(); ++j) {
                    SettlementBillInfo billInfo = paycoll.get(j);
                    if (billInfo.getType() != SettBizTypeEnum.PAYOUTSIDE && billInfo.getType() != SettBizTypeEnum.LINKPAY) continue;
                    idList.add(billInfo.getId().toString() + ";" + billInfo.getNumber());
                }
                if (idList == null || idList.size() <= 0) continue;
                map.put(info.getId().toString(), idList);
                isConfirm = true;
            }
        } else {
            LinkedHashMap<String, SettlementBillInfo> isInfoMap = new LinkedHashMap<String, SettlementBillInfo>();
            SettlementBillCollection newColl = new SettlementBillCollection();
            LinkedHashSet<String> orignalSet = new LinkedHashSet<String>();
            LinkedHashSet filterSet = new LinkedHashSet();
            for (int i = 0; i < coll.size(); ++i) {
                isInfoMap.put(coll.get(i).getId().toString(), coll.get(i));
                orignalSet.add(coll.get(i).getId().toString());
            }
            try {
                if (!EmptyUtil.isEmpty((String)settingInfo.getFilterAct())) {
                    String filterStr = settingInfo.getFilterAct().replaceAll("EMPTY", "NULL");
                    FilterInfo filterSett = new FilterInfo(filterStr);
                    FilterInfo filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("id", orignalSet, CompareType.INCLUDE));
                    filterSett.mergeFilter(filterNew, "AND");
                    EntityViewInfo entifyViewSett = new EntityViewInfo();
                    entifyViewSett.setFilter(filterSett);
                    entifyViewSett.getSelector().add(new SelectorItemInfo("id"));
                    entifyViewSett.getSelector().add(new SelectorItemInfo("number"));
                    SorterItemCollection sorter = new SorterItemCollection();
                    SorterItemInfo item = new SorterItemInfo("amount");
                    item.setSortType(SortType.ASCEND);
                    sorter.add(item);
                    item = new SorterItemInfo("number");
                    item.setSortType(SortType.ASCEND);
                    sorter.add(item);
                    entifyViewSett.setSorter(sorter);
                    SettlementBillCollection paycollSett = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(entifyViewSett);
                    HashSet idSet = new HashSet();
                    for (int j = 0; j < paycollSett.size(); ++j) {
                        newColl.add((SettlementBillInfo)isInfoMap.get(paycollSett.get(j).getId().toString()));
                    }
                } else {
                    newColl = coll;
                }
            }
            catch (ParserException e1) {
                e1.printStackTrace();
            }
            for (int i = 0; i < newColl.size(); ++i) {
                FilterInfo filterNew;
                HashSet<Integer> billStatusSet;
                SettlementBillInfo info = newColl.get(i);
                if (info.getType() != SettBizTypeEnum.PAYOUTSIDE && info.getType() != SettBizTypeEnum.LINKPAY || info.getSource() != null && info.getSource().equals((Object)SettlementBillSourceEnum.BETRANSDETAIL)) continue;
                EntityViewInfo entifyView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)DestDate, CompareType.LESS));
                filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)SrcDate, CompareType.GREATER_EQUALS));
                if (info.getId() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("payeeBankAcctNum", (Object)info.getPayeeBankAcctNum()));
                filter.getFilterItems().add(new FilterItemInfo("amount", (Object)info.getAmount()));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
                if (settingInfo.isIsSourceSystem()) {
                    if (info.getSource() != null) {
                        filter.getFilterItems().add(new FilterItemInfo("source", (Object)info.getSource().getValue()));
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("source", typeSet, CompareType.INCLUDE));
                }
                if (actionType == 0) {
                    billStatusSet = new HashSet<Integer>();
                    billStatusSet.add(2);
                    billStatusSet.add(3);
                    billStatusSet.add(4);
                    billStatusSet.add(5);
                    filter.getFilterItems().add(new FilterItemInfo("billStatus", billStatusSet, CompareType.INCLUDE));
                } else if (actionType == 1) {
                    billStatusSet = new HashSet();
                    billStatusSet.add(3);
                    billStatusSet.add(4);
                    billStatusSet.add(5);
                    filter.getFilterItems().add(new FilterItemInfo("billStatus", billStatusSet, CompareType.INCLUDE));
                }
                if (settingInfo.isIsUsge() && !EmptyUtil.isEmpty((String)info.getUsage())) {
                    filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("usage", (Object)info.getUsage()));
                    filterNew.getFilterItems().add(new FilterItemInfo("usage", null, CompareType.EQUALS));
                    filterNew.getFilterItems().add(new FilterItemInfo("usage", (Object)" ", CompareType.EQUALS));
                    filterNew.setMaskString("#0 OR #1 OR #2");
                    filter.mergeFilter(filterNew, "AND");
                }
                if (settingInfo.isIsSummary() && !EmptyUtil.isEmpty((String)info.getDescription())) {
                    filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("description", (Object)info.getDescription()));
                    filterNew.getFilterItems().add(new FilterItemInfo("description", null, CompareType.EQUALS));
                    filterNew.getFilterItems().add(new FilterItemInfo("description", (Object)" ", CompareType.EQUALS));
                    filterNew.setMaskString("#0 OR #1 OR #2");
                    filter.mergeFilter(filterNew, "AND");
                }
                if (settingInfo.isIsBizTpye()) {
                    filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("type", (Object)info.getType().getValue()));
                    filter.mergeFilter(filterNew, "AND");
                }
                if (settingInfo.isIsSourceId() && !EmptyUtil.isEmpty((String)info.getSourceBillId())) {
                    filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getSourceBillId()));
                    filterNew.getFilterItems().add(new FilterItemInfo("sourceBillId", null, CompareType.EQUALS));
                    filterNew.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)" ", CompareType.EQUALS));
                    filterNew.setMaskString("#0 OR #1 OR #2");
                    filter.mergeFilter(filterNew, "AND");
                }
                if (settingInfo.isIsActualName() && !EmptyUtil.isEmpty((String)info.getBankAcctName())) {
                    filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("bankAcctName", (Object)info.getBankAcctName()));
                    filterNew.getFilterItems().add(new FilterItemInfo("bankAcctName", null, CompareType.EQUALS));
                    filterNew.getFilterItems().add(new FilterItemInfo("bankAcctName", (Object)" ", CompareType.EQUALS));
                    filterNew.setMaskString("#0 OR #1 OR #2");
                    filter.mergeFilter(filterNew, "AND");
                }
                if (settingInfo.isIsUsgeSummary() && !EmptyUtil.isEmpty((String)info.getDescription()) && !EmptyUtil.isEmpty((String)info.getUsage())) {
                    filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("description", (Object)info.getDescription()));
                    filterNew.getFilterItems().add(new FilterItemInfo("description", null, CompareType.EQUALS));
                    filterNew.getFilterItems().add(new FilterItemInfo("description", (Object)" ", CompareType.EQUALS));
                    filterNew.getFilterItems().add(new FilterItemInfo("usage", (Object)info.getUsage()));
                    filterNew.getFilterItems().add(new FilterItemInfo("usage", null, CompareType.EQUALS));
                    filterNew.getFilterItems().add(new FilterItemInfo("usage", (Object)" ", CompareType.EQUALS));
                    filterNew.setMaskString("#0 OR #1 OR #2 OR #3 OR #4 OR #5");
                    filter.mergeFilter(filterNew, "AND");
                }
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("type");
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("amount");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                item = new SorterItemInfo("number");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                entifyView.setSorter(sorter);
                entifyView.setFilter(filter);
                entifyView.setSelector(selector);
                SettlementBillCollection paycoll = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillCollection(entifyView);
                if (paycoll == null || paycoll.size() <= 0) continue;
                ArrayList<String> idList = new ArrayList<String>();
                for (int j = 0; j < paycoll.size(); ++j) {
                    SettlementBillInfo billInfo = paycoll.get(j);
                    if (billInfo.getType() != SettBizTypeEnum.PAYOUTSIDE && billInfo.getType() != SettBizTypeEnum.LINKPAY) continue;
                    idList.add(billInfo.getId().toString() + ";" + billInfo.getNumber());
                }
                if (idList == null || idList.size() <= 0) continue;
                map.put(info.getId().toString(), idList);
                isConfirm = true;
            }
        }
        if (!isConfirm) {
            return null;
        }
        return map;
    }

    @Override
    protected ArrayList _batchPayWithRerturn(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> massageList = new ArrayList<BankPayResult>();
        if (EmptyUtil.isEmpty((Collection)idSet)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("company.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("cashier.id"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        ISettlementBill iSettlementBill = SettlementBillFactory.getLocalInstance(ctx);
        SettlementBillCollection settlementBillCollection = iSettlementBill.getSettlementBillCollection(viewInfo);
        ISettleFacade iSettleFacade = SettleFacadeFactory.getLocalInstance(ctx);
        ArrayList idList = new ArrayList(idSet);
        for (int i = 0; i < settlementBillCollection.size(); ++i) {
            SettlementBillInfo settlementBillInfo = settlementBillCollection.get(i);
            String id = settlementBillInfo.getId().toString();
            String number = settlementBillInfo.getNumber();
            ArrayList<String> eachSet = new ArrayList<String>();
            eachSet.add(id);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(settlementBillInfo.getCompany().getId()), (String)"FS_ST_06SETTLE");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_PAY_AUTHRIZED);
                }
                if (settlementBillInfo.getCashier() != null && settlementBillInfo.getCashier().getId() != null) {
                    throw new BEException(BEException.COMMON, new Object[]{"\u5df2\u7ed3\u7b97"});
                }
                iSettleFacade.settle(eachSet, true);
                continue;
            }
            catch (Exception e) {
                String returnMsg = e.getMessage();
                BankPayResult payResult = new BankPayResult(id, number, null, returnMsg);
                payResult.setErrorDetail(returnMsg);
                massageList.add(payResult);
            }
        }
        return massageList;
    }
}

