/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.TransDownModeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.subacct.ISubAccountBookFacade;
import com.kingdee.eas.fi.cas.subacct.SubAccountBookFacadeFactory;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransDownBillCollection;
import com.kingdee.eas.fm.be.BankTransDownBillEntryCollection;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransDownBillFactory;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.IBankTransDownBill;
import com.kingdee.eas.fm.common.CtrlNodeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.fs.ApplyTransDownFactory;
import com.kingdee.eas.fm.fs.ApplyTransDownInfo;
import com.kingdee.eas.fm.fs.ApplyTransDownStateEnum;
import com.kingdee.eas.fm.fs.AutoTransCollection;
import com.kingdee.eas.fm.fs.AutoTransFactory;
import com.kingdee.eas.fm.fs.AutoTransHistoryCollection;
import com.kingdee.eas.fm.fs.AutoTransHistoryFactory;
import com.kingdee.eas.fm.fs.AutoTransHistoryInfo;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.ITransDownBill;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerFrozenDepositFactory;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransDownBill2BankBillBuilder;
import com.kingdee.eas.fm.fs.TransDownBillBookNotifyBuilder;
import com.kingdee.eas.fm.fs.TransDownBillBookSubsidiaryProvider;
import com.kingdee.eas.fm.fs.TransDownBillCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryFactory;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillHelper;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillStateEnum;
import com.kingdee.eas.fm.fs.app.AbstractTransDownBillFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransDownBillFacadeControllerBean
extends AbstractTransDownBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)TransDownBillFacadeControllerBean.class.getName());
    private static final String resClassName = "com.kingdee.eas.fm.fs.TransBillResource";

    @Override
    protected Map _getTransDownAcctBankAmt(Context ctx, String motherAcctBankId, String currencyId) throws BOSException, EASBizException {
        Date date = new Date();
        HashMap<String, TransAmtInfo> map = new HashMap<String, TransAmtInfo>();
        AccountBankCollection acctBankColl = TransDownBillHelper.getTransDownAcctBankColl(ctx, motherAcctBankId, date);
        Map balanceMap = TransDownBillHelper.getAcctBankBalance(ctx, acctBankColl, currencyId, date);
        AccountBankInfo acctBankInfo = null;
        AccountMgrStrategyInfo acctMgrInfo = null;
        TransAmtInfo transAmtInfo = null;
        TransDownModeEnum mode = null;
        String key = null;
        BigDecimal balance = Constants.ZERO;
        BigDecimal transDownAmt = Constants.ZERO;
        int size = acctBankColl.size();
        for (int i = 0; i < size; ++i) {
            ProvinceCollection coll;
            acctBankInfo = acctBankColl.get(i);
            acctMgrInfo = acctBankInfo.getCtrlStrategy();
            key = acctBankInfo.getId().toString() + "_" + currencyId;
            if (acctMgrInfo == null) {
                transDownAmt = Constants.ZERO;
            } else {
                BigDecimal N;
                mode = acctMgrInfo.getTransDownMode();
                balance = (BigDecimal)balanceMap.get(key);
                transDownAmt = Constants.ZERO;
                if (balance == null) {
                    balance = new BigDecimal(0);
                }
                if (mode.equals((Object)TransDownModeEnum.MANUAL)) {
                    transDownAmt = Constants.ZERO;
                } else if (mode.equals((Object)TransDownModeEnum.NORM)) {
                    transDownAmt = acctMgrInfo.getTransDownNormAmt();
                } else if (mode.equals((Object)TransDownModeEnum.SUPPLY)) {
                    if (acctMgrInfo.getTransDownFixedAmt().subtract(balance).compareTo(acctMgrInfo.getTransDownMinAmt()) >= 0) {
                        transDownAmt = acctMgrInfo.getTransDownFixedAmt().subtract(balance);
                    }
                } else if (mode.equals((Object)TransDownModeEnum.INC) && acctMgrInfo.getTransDownFixedAmt().subtract(balance).compareTo(Constants.ZERO) >= 0 && balance.add(transDownAmt = (N = acctMgrInfo.getTransDownFixedAmt().subtract(balance).divideToIntegralValue(acctMgrInfo.getTransDownIncAmt())).multiply(acctMgrInfo.getTransDownIncAmt())).compareTo(acctMgrInfo.getTransDownFixedAmt()) < 0) {
                    transDownAmt = transDownAmt.add(acctMgrInfo.getTransDownIncAmt());
                }
            }
            transAmtInfo = new TransAmtInfo();
            transAmtInfo.setAcctBank(acctBankInfo);
            transAmtInfo.setCurrencyId(currencyId);
            transAmtInfo.setUnitInnerAcct(acctBankInfo.getInnerAcct());
            transAmtInfo.setUnit(acctBankInfo.getCompany());
            transAmtInfo.setAmount(transDownAmt);
            transAmtInfo.setRecBankF7(acctBankInfo.getBank());
            if (acctBankInfo.getBank() != null) {
                transAmtInfo.setRecBank(acctBankInfo.getBank().getName());
            }
            if (acctBankInfo.getOpenArea() != null && !EmptyUtil.isEmpty((String)acctBankInfo.getOpenArea().getProvince())) {
                transAmtInfo.setRecProvince(acctBankInfo.getOpenArea().getProvince());
                coll = ProvinceFactory.getLocalInstance((Context)ctx).getProvinceCollection(this.getEntityViewInfo(acctBankInfo.getOpenArea().getProvince()));
                if (coll != null && coll.size() > 0) {
                    transAmtInfo.setRecProvinceF7(coll.get(0));
                }
            }
            if (acctBankInfo.getOpenArea() != null && !EmptyUtil.isEmpty((String)acctBankInfo.getOpenArea().getName())) {
                transAmtInfo.setRecCity(acctBankInfo.getOpenArea().getName());
                coll = CityFactory.getLocalInstance((Context)ctx).getCityCollection(this.getEntityViewInfo(acctBankInfo.getOpenArea().getName()));
                if (coll != null && coll.size() > 0) {
                    transAmtInfo.setRecCityF7(coll.get(0));
                }
            }
            map.put(key, transAmtInfo);
        }
        return map;
    }

    private EntityViewInfo getEntityViewInfo(String name) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        fi.getFilterItems().add(new FilterItemInfo("name", (Object)name.trim()));
        return evi;
    }

    @Override
    protected List _getOverdraftTransAmtList(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        String getOverdraftTransAmtListLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._getOverdraftTransAmtList218");
        TransDownBillInfo transInfo = (TransDownBillInfo)info;
        ArrayList transAmtList = new ArrayList();
        String getMotherOverdraftListLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._getOverdraftTransAmtList218_getMotherOverdraftListLogId");
        List motherList = this.getMotherOverdraftList(ctx, transInfo);
        PerfLogRecorder.endRecord((String)getMotherOverdraftListLogId);
        String getacctBankInnerAcctOverdraftListLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._getOverdraftTransAmtList218_getacctBankInnerAcctOverdraftListLogId");
        List subAcctInnerList = this.getacctBankInnerAcctOverdraftList(ctx, transInfo);
        PerfLogRecorder.endRecord((String)getacctBankInnerAcctOverdraftListLogId);
        transAmtList.addAll(motherList);
        transAmtList.addAll(subAcctInnerList);
        PerfLogRecorder.endRecord((String)getOverdraftTransAmtListLogId);
        return transAmtList;
    }

    private List getacctBankInnerAcctOverdraftList(Context ctx, TransDownBillInfo transInfo) throws BOSException, EASBizException {
        TransAmtInfo transAmtInfo = null;
        Map subAcctMgrMap = this.getAcctBankInnerMgrStregetyMap(ctx, transInfo);
        HashMap<String, TransAmtInfo> tempMap = new HashMap<String, TransAmtInfo>();
        ArrayList<TransAmtInfo> transAmtList = new ArrayList<TransAmtInfo>();
        BigDecimal tempAmt = Constants.ZERO;
        AccountBankInfo subAcctInfo = null;
        String key = null;
        int size = transInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            subAcctInfo = transInfo.getEntrys().get(i).getUnitAcctBank();
            subAcctInfo.setInnerAcct(this.getAcctBankInnerAcct(ctx, subAcctInfo.getId().toString()));
            if (EmptyUtil.isEmpty((CoreBaseInfo)subAcctInfo.getInnerAcct())) continue;
            key = subAcctInfo.getInnerAcct().getId().toString();
            if (tempMap.containsKey(key)) {
                transAmtInfo = (TransAmtInfo)tempMap.get(key);
                tempAmt = transAmtInfo.getAmount().add(transInfo.getEntrys().get(i).getAmount());
                transAmtInfo.setAmount(tempAmt);
            } else {
                transAmtInfo = new TransAmtInfo();
                transAmtInfo.setAcctId(key);
                transAmtInfo.setAcctNumber(subAcctInfo.getInnerAcct().getNumber());
                transAmtInfo.setUnitInnerAcct(subAcctInfo.getInnerAcct());
                transAmtInfo.setAmount(transInfo.getEntrys().get(i).getAmount());
                transAmtInfo.setAcctMgrInfo((AccountMgrStrategyInfo)subAcctMgrMap.get(key));
                transAmtInfo.setType(4);
                tempMap.put(key, transAmtInfo);
            }
            String currencyId = transInfo.getCurrency().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("company.id");
            sic.add("company.name");
            sic.add("company.number");
            InnerAccountInfo inAcct = InnerAccountFactory.getLocalInstance(ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(subAcctInfo.getInnerAcct().getId()), sic);
            ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
            CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
            String companyNumber = chCompany.getNumber();
            Date unSettleDate = FSHelper.getClearingHouseInfo(ctx, chCompany.getId().toString()).getSettleDate();
            BigDecimal currentBalance = InAcctFactory.getLocalInstance(ctx).inAcct(companyNumber, inAcct.getNumber(), transInfo.getCurrency().getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
            BigDecimal totalFrozenAmt = this.getFrozenBalanceValue(ctx, currencyId, inAcct.getId().toString());
            BigDecimal transitAmt = BigDecimal.ZERO;
            if (this.getTM110(ctx, chCompanyPk.toString())) {
                transitAmt = this.getTransitAmt(ctx, currencyId, inAcct.getId().toString(), transInfo.getId().toString());
            }
            BigDecimal subAcctBalance = currentBalance.subtract(totalFrozenAmt).subtract(transitAmt);
            transAmtInfo.setBalance(subAcctBalance);
            transAmtList.add(transAmtInfo);
        }
        return transAmtList;
    }

    private boolean getTM110(Context ctx, String companyid) {
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        return localInstance.getBooleanParam("TM110", (IObjectPK)new ObjectUuidPK(companyid));
    }

    private List getInnerAcctApplyOverdraftList(Context ctx, ApplyTransDownInfo transInfo) throws BOSException, EASBizException {
        ArrayList<TransAmtInfo> transAmtList = new ArrayList<TransAmtInfo>();
        String currencyId = transInfo.getCurrency().getId().toString();
        AccountBankInfo subAcctInfo = transInfo.getAccountBank();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("InnerAcct.*");
        sic.add("InnerAcct.company.id");
        sic.add("InnerAcct.company.name");
        sic.add("InnerAcct.company.number");
        sic.add("InnerAcct.ctrlParam.*");
        subAcctInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(subAcctInfo.getId().toString()), sic);
        if (subAcctInfo != null && subAcctInfo.getInnerAcct() != null) {
            String key = subAcctInfo.getInnerAcct().getId().toString();
            InnerAccountInfo inAcct = subAcctInfo.getInnerAcct();
            ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
            CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
            String companyNumber = chCompany.getNumber();
            Date unSettleDate = FSHelper.getClearingHouseInfo(ctx, chCompany.getId().toString()).getSettleDate();
            BigDecimal currentBalance = InAcctFactory.getLocalInstance(ctx).inAcct(companyNumber, inAcct.getNumber(), transInfo.getCurrency().getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
            BigDecimal totalFrozenAmt = this.getFrozenBalanceValue(ctx, currencyId, inAcct.getId().toString());
            BigDecimal subAcctBalance = currentBalance.subtract(totalFrozenAmt);
            TransAmtInfo transAmtInfo = new TransAmtInfo();
            transAmtInfo.setAcctId(key);
            transAmtInfo.setAcctNumber(subAcctInfo.getInnerAcct().getNumber());
            transAmtInfo.setUnitInnerAcct(subAcctInfo.getInnerAcct());
            transAmtInfo.setAmount(transInfo.getAmount());
            transAmtInfo.setAcctMgrInfo(subAcctInfo.getInnerAcct().getCtrlParam());
            transAmtInfo.setType(4);
            transAmtInfo.setBalance(subAcctBalance);
            transAmtList.add(transAmtInfo);
        }
        return transAmtList;
    }

    private BigDecimal getFrozenBalanceValue(Context ctx, String currencyId, String innerAcctId) throws EASBizException, BOSException {
        if (currencyId == null || innerAcctId == null) {
            return Constants.ZERO;
        }
        BigDecimal fozenBalance = InnerFrozenDepositFactory.getLocalInstance(ctx).getTotalFrozenAmt(innerAcctId, currencyId);
        if (fozenBalance == null) {
            return Constants.ZERO;
        }
        return fozenBalance;
    }

    private BigDecimal getTransitAmt(Context ctx, String currencyId, String innerAcctId, String transDownId) throws EASBizException, BOSException {
        BigDecimal transitAmt = Constants.ZERO;
        if (currencyId == null || innerAcctId == null) {
            return transitAmt;
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select sum(ENTRYS.FLocalAmt) result from T_FS_TransDownBill AS transDown  LEFT OUTER JOIN T_FS_TransDownBillEntry AS ENTRYS ON transDown.FID = ENTRYS.FParentID  LEFT OUTER JOIN T_BD_AccountBanks AS UNITACCTBANK ON ENTRYS.FUnitAcctBankID = UNITACCTBANK.FID  where transDown.fid != '" + transDownId + "' and (transDown.FState=2 or transDown.fState=3 ) and  UNITACCTBANK.FInnerAcctId = '");
        sqlBuffer.append(innerAcctId);
        sqlBuffer.append("' and transDown.FCurrencyID = '");
        sqlBuffer.append(currencyId);
        sqlBuffer.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        try {
            if (rs != null && rs.next() && rs.getBigDecimal("result") != null) {
                transitAmt = rs.getBigDecimal("result");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return transitAmt;
    }

    private List getMotherOverdraftList(Context ctx, TransDownBillInfo transInfo) throws EASBizException, BOSException {
        ArrayList<TransAmtInfo> transAmtList = new ArrayList<TransAmtInfo>();
        TransAmtInfo transAmtInfo = new TransAmtInfo();
        Date date = new Date();
        String currencyId = transInfo.getCurrency().getId().toString();
        String motherAcctBankId = transInfo.getMotherAcctBank().getId().toString();
        AccountMgrStrategyInfo motherAcctBankMgrInfo = this.getAcctBankMgrStrategy(ctx, motherAcctBankId);
        if (motherAcctBankMgrInfo == null) {
            return transAmtList;
        }
        AccountBankCollection acctBankColl = new AccountBankCollection();
        AccountBankInfo acctBankInfo = new AccountBankInfo();
        acctBankInfo.setId(BOSUuid.read((String)motherAcctBankId));
        acctBankInfo.setCtrlStrategy(motherAcctBankMgrInfo);
        acctBankColl.add(acctBankInfo);
        Map motherAcctBankBalanceMap = TransDownBillHelper.getAcctBankBalance(ctx, acctBankColl, currencyId, date);
        String key = motherAcctBankId + "_" + currencyId;
        BigDecimal motherAcctBankBalance = (BigDecimal)motherAcctBankBalanceMap.get(key);
        String acctNumber = transInfo.getMotherAcctBank().getNumber();
        transAmtInfo.setAcctId(motherAcctBankId);
        transAmtInfo.setAcctNumber(acctNumber);
        transAmtInfo.setAmount(transInfo.getTotalAmt());
        transAmtInfo.setBalance(motherAcctBankBalance);
        transAmtInfo.setAcctMgrInfo(motherAcctBankMgrInfo);
        transAmtInfo.setType(1);
        transAmtList.add(transAmtInfo);
        return transAmtList;
    }

    @Override
    protected Map _getMotherOverdraftList(Context ctx, String motherAcctBankId, String currencyId) throws BOSException, EASBizException {
        Date date = new Date();
        AccountMgrStrategyInfo motherAcctBankMgrInfo = this.getAcctBankMgrStrategy(ctx, motherAcctBankId);
        if (motherAcctBankMgrInfo == null) {
            return null;
        }
        AccountBankCollection acctBankColl = new AccountBankCollection();
        AccountBankInfo acctBankInfo = new AccountBankInfo();
        acctBankInfo.setId(BOSUuid.read((String)motherAcctBankId));
        acctBankInfo.setCtrlStrategy(motherAcctBankMgrInfo);
        acctBankColl.add(acctBankInfo);
        Map motherAcctBankBalanceMap = TransDownBillHelper.getAcctBankBalance(ctx, acctBankColl, currencyId, date);
        return motherAcctBankBalanceMap;
    }

    private List getMotherApplyOverdraftList(Context ctx, ApplyTransDownInfo transInfo) throws EASBizException, BOSException {
        ArrayList<TransAmtInfo> transAmtList = new ArrayList<TransAmtInfo>();
        TransAmtInfo transAmtInfo = new TransAmtInfo();
        Date date = new Date();
        String currencyId = transInfo.getCurrency().getId().toString();
        String motherAcctBankId = transInfo.getSubAccountBank().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ctrlStrategy.*"));
        AccountBankInfo acctBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(motherAcctBankId), sic);
        AccountMgrStrategyInfo motherAcctBankMgrInfo = acctBankInfo.getCtrlStrategy();
        if (motherAcctBankMgrInfo == null) {
            return transAmtList;
        }
        AccountBankCollection acctBankColl = new AccountBankCollection();
        acctBankColl.add(acctBankInfo);
        Map motherAcctBankBalanceMap = TransDownBillHelper.getAcctBankBalance(ctx, acctBankColl, currencyId, date);
        String key = motherAcctBankId + "_" + currencyId;
        BigDecimal motherAcctBankBalance = (BigDecimal)motherAcctBankBalanceMap.get(key);
        String acctNumber = acctBankInfo.getNumber();
        transAmtInfo.setAcctId(motherAcctBankId);
        transAmtInfo.setAcctNumber(acctNumber);
        transAmtInfo.setAmount(transInfo.getAmount());
        transAmtInfo.setBalance(motherAcctBankBalance);
        transAmtInfo.setAcctMgrInfo(motherAcctBankMgrInfo);
        transAmtInfo.setType(1);
        transAmtList.add(transAmtInfo);
        return transAmtList;
    }

    private AccountMgrStrategyInfo getAcctBankMgrStrategy(Context ctx, String motherAcctBankId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("ctrlStrategy.*");
        IAccountBank iAcctBank = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankInfo acctBankInfo = iAcctBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(motherAcctBankId), sic);
        return acctBankInfo.getCtrlStrategy();
    }

    private InnerAccountInfo getAcctBankInnerAcct(Context ctx, String acctBankId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("InnerAcct.*");
        IAccountBank iAcctBank = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankInfo acctBankInfo = iAcctBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctBankId), sic);
        return acctBankInfo.getInnerAcct();
    }

    private Map getAcctBankInnerMgrStregetyMap(Context ctx, TransDownBillInfo info) throws BOSException {
        HashMap<String, AccountMgrStrategyInfo> map = new HashMap<String, AccountMgrStrategyInfo>();
        HashSet<String> idSet = new HashSet<String>();
        TransDownBillEntryCollection entryColl = info.getEntrys();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(entryColl.get(i).getUnitAcctBank().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("InnerAcct");
        evi.getSelector().add("InnerAcct.id");
        evi.getSelector().add("InnerAcct.ctrlParam.*");
        evi.setFilter(filter);
        IAccountBank iAcct = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection coll = iAcct.getAccountBankCollection(evi);
        AccountBankInfo acctInfo = null;
        int size2 = coll.size();
        for (int i = 0; i < size2; ++i) {
            acctInfo = coll.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)acctInfo.getInnerAcct()) || EmptyUtil.isEmpty((CoreBaseInfo)acctInfo.getInnerAcct().getCtrlParam())) continue;
            map.put(acctInfo.getInnerAcct().getId().toString(), acctInfo.getInnerAcct().getCtrlParam());
        }
        return map;
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransDownBillCollection coll = this.getColl(ctx, idSet);
        TransDownBillInfo info = new TransDownBillInfo();
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getState().getValue() != 2) {
                throw new TransBillException(TransBillException.STATEERRORAUDIT);
            }
            FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info, (CtrlNodeEnum)CtrlNodeEnum.audit);
            this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), false);
            FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CtrlNodeEnum)CtrlNodeEnum.audit);
            numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (currentUser == null) {
            currentUser = info.getCreator();
        }
        String sql = "UPDATE T_FS_TransDownBill SET FState = ?, FAuditorId = ? WHERE FId IN " + ids;
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), currentUser.getId().toString()});
        if (coll.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transdownbill_audit", (String)companyID, (String)"\u4e0b\u62e8\u5355\u5ba1\u6279");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, boolean isWfInvoked) throws BOSException, EASBizException {
        if (!isWfInvoked) {
            return;
        }
        TransDownBillInfo info = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillInfo(pk);
        if (info.getState().getValue() != 2) {
            throw new TransBillException(TransBillException.STATEERRORAUDIT);
        }
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CtrlNodeEnum)CtrlNodeEnum.audit);
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String sql = "UPDATE T_FS_TransDownBill SET FState = ?, FAuditorId = ? WHERE FId = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), userId, info.getId().toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransDownBillCollection coll = this.getColl(ctx, idSet);
        TransDownBillInfo info = null;
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getState().getValue() != 3) {
                throw new TransBillException(TransBillException.STATEERRORANTIAUDIT);
            }
            if (info.isIsCommittoBe()) {
                throw new TransBillException(TransBillException.COMMITTOBECANUNTIAUDIT);
            }
            this.antiAudit4WF(ctx, info.getId().toString());
            FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CtrlNodeEnum)CtrlNodeEnum.audit);
            numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        String sql = "UPDATE T_FS_TransDownBill SET FState = ?, FAuditorId = Null WHERE FId IN " + ids;
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2)});
        if (coll.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transdownbill_unAudit", (String)companyID, (String)"\u4e0b\u62e8\u5355\u53cd\u5ba1\u6279");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
    }

    @Override
    protected void _antiAudit4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _confirm(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        TransDownBillInfo downInfo = (TransDownBillInfo)info;
        String checkBeforeConfirmLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._confirm_checkBeforeConfirmLogId");
        this.checkBeforeConfirm(ctx, downInfo, TransDownBillStateEnum.AUDITED);
        PerfLogRecorder.endRecord((String)checkBeforeConfirmLogId);
        String checkBizUnitInfoLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._confirm_checkBizUnitInfoLogId");
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info, (CtrlNodeEnum)CtrlNodeEnum.confirm);
        PerfLogRecorder.endRecord((String)checkBizUnitInfoLogId);
        String billId = downInfo.getId().toString();
        String updateConfirmInfoLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._confirm_updateConfirmInfoLogId");
        this.updateConfirmInfo(ctx, downInfo);
        PerfLogRecorder.endRecord((String)updateConfirmInfoLogId);
        String bookSubsidiaryLedgerLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._confirm_bookSubsidiaryLedgerLogId");
        this.bookSubsidiaryLedger(ctx, billId);
        PerfLogRecorder.endRecord((String)bookSubsidiaryLedgerLogId);
        String bookBankJournalLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._confirm_bookBankJournalLogId");
        this.bookBankJournal(ctx, billId);
        PerfLogRecorder.endRecord((String)bookBankJournalLogId);
        String sendReceiptLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._confirm_sendReceiptLogId");
        BOSUuid tempCompanyID = null;
        try {
            CompanyOrgUnitInfo billOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(downInfo.getCompany().getId().toString()));
            if (billOrgUnit != null && billOrgUnit.getCU() != null) {
                if (billOrgUnit.isIsCU() && !ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().equals((Object)billOrgUnit.getId())) {
                    tempCompanyID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                    ContextUtil.getCurrentCtrlUnit((Context)ctx).setId(billOrgUnit.getId());
                } else if (!ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().equals((Object)billOrgUnit.getCU().getId())) {
                    tempCompanyID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                    ContextUtil.getCurrentCtrlUnit((Context)ctx).setId(billOrgUnit.getCU().getId());
                }
            }
            this.sendReceipt(ctx, downInfo, true, false);
        }
        finally {
            if (tempCompanyID != null) {
                ContextUtil.getCurrentCtrlUnit((Context)ctx).setId(tempCompanyID);
            }
        }
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(billId), (CtrlNodeEnum)CtrlNodeEnum.confirm);
        PerfLogRecorder.endRecord((String)sendReceiptLogId);
        String confirm4WFLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._confirm_confirm4WFLogId");
        this.confirm4WF(ctx, downInfo);
        PerfLogRecorder.endRecord((String)confirm4WFLogId);
        String disposeFromApplyTransDownByConfirmAndUnConfirmLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._confirm_disposeFromApplyTransDownByConfirmAndUnConfirmLogId");
        this.disposeFromApplyTransDownByConfirmAndUnConfirm(ctx, downInfo, true);
        PerfLogRecorder.endRecord((String)disposeFromApplyTransDownByConfirmAndUnConfirmLogId);
        return 1;
    }

    private void checkBeforeConfirm(Context ctx, TransDownBillInfo downInfo, TransDownBillStateEnum billState) throws EASBizException, BOSException {
        TransDownBillEntryCollection entryColl = downInfo.getEntrys();
        boolean isNoneConfirm = true;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            if (!entryColl.get(i).isIsSuccessed()) continue;
            isNoneConfirm = false;
            break;
        }
        if (isNoneConfirm) {
            throw new TransBillException(TransBillException.DOWNCONFIRMERRORNOSUCCESS);
        }
        TransDownBillInfo dbInfo = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(downInfo.getId().toString()));
        if (billState.getValue() == 3 && dbInfo.getState() != billState) {
            throw new TransBillException(TransBillException.STATEERRORDOWNCONFIRM);
        }
        if (billState.getValue() == 4 && dbInfo.getState() != billState) {
            throw new TransBillException(TransBillException.STATEERRORCONFIRMCHANGE1, new Object[]{dbInfo.getNumber()});
        }
    }

    private void updateConfirmInfo(Context ctx, TransDownBillInfo downInfo) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((CoreBaseInfo)downInfo.getCashier())) {
            UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            downInfo.setCashier(user);
        }
        downInfo.setState(TransDownBillStateEnum.CONFIRMED);
        ObjectUuidPK pk = new ObjectUuidPK(downInfo.getId());
        TransDownBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)downInfo);
    }

    private void bookSubsidiaryLedger(Context ctx, String billId) throws BOSException, EASBizException {
        ISubsidiaryLedger facade = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        facade.book(billId, TransDownBillBookSubsidiaryProvider.class.getName());
    }

    private void bookBankJournal(Context ctx, String billId) throws BOSException, EASBizException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.book(TransDownBillBookNotifyBuilder.class.getName(), billId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _unConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransDownBillCollection coll = this.getColl(ctx, idSet);
        TransDownBillInfo info = null;
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            int i;
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(new ArrayList(idSet));
            for (Object id : idSet) {
                Boolean boolResult = (Boolean)resultRequest.get(id);
                if (!boolResult.booleanValue()) continue;
                appliedList.add(id);
            }
            if (appliedList.size() < idSet.size()) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
            }
            int size = coll.size();
            for (int i2 = 0; i2 < size; ++i2) {
                info = coll.get(i2);
                this.unConfimCheck(info, true);
                FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CtrlNodeEnum)CtrlNodeEnum.confirm);
                this.unConfirm4WF(ctx, info.getId().toString());
                this.disposeFromApplyTransDownByConfirmAndUnConfirm(ctx, info, false);
            }
            this.antiBook(ctx, idSet);
            this.updateUnConfrimProp(ctx, coll);
            int size2 = coll.size();
            for (i = 0; i < size2; ++i) {
                this.withdrawReceipt(ctx, coll.get(i), true);
            }
            int a = coll.size();
            for (i = 0; i < a; ++i) {
                TransDownBillInfo tinfo = coll.get(i);
                numbers = EmptyUtil.isEmpty((String)numbers) ? tinfo.getNumber() : numbers + "," + tinfo.getNumber();
            }
            if (coll.size() > 0 && numbers != "") {
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transdownbill_Unconfirm", (String)companyID, (String)"\u4e0b\u62e8\u5355\u4e0b\u62e8\u53cd\u786e\u8ba4");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            int n = size2;
            return n;
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    private void unConfimCheck(TransDownBillInfo info, boolean isUnConfirm) throws TransBillException {
        if (info.getState().getValue() != 4) {
            if (isUnConfirm) {
                throw new TransBillException(TransBillException.STATEERRORUNCONFIRM1, new Object[]{info.getNumber()});
            }
            throw new TransBillException(TransBillException.STATEERRORCONFIRMCHANGE1, new Object[]{info.getNumber()});
        }
        if (info.isFivouchered()) {
            if (isUnConfirm) {
                throw new TransBillException(TransBillException.STATEERRORUNCONFIRM2, new Object[]{info.getNumber()});
            }
            throw new TransBillException(TransBillException.STATEERRORCONFIRMCHANGE2, new Object[]{info.getNumber()});
        }
    }

    private void antiBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        IBookNotifyFacade journalFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        ISubAccountBookFacade subAcctFacade = SubAccountBookFacadeFactory.getLocalInstance((Context)ctx);
        ISubsidiaryLedger subLedgerFacade = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        String billId = null;
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            billId = iter.next().toString();
            journalFacade.antiBook(billId);
            subAcctFacade.antiBook(billId);
            subLedgerFacade.cancelBook(billId);
        }
        this.antiBookEntry(ctx, idSet);
    }

    private void antiBookEntry(Context ctx, Set idSet) throws BOSException, EASBizException {
        IBookNotifyFacade journalFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        ISubAccountBookFacade subAcctFacade = SubAccountBookFacadeFactory.getLocalInstance((Context)ctx);
        ISubsidiaryLedger subLedgerFacade = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add("id");
        TransDownBillEntryCollection colls = TransDownBillEntryFactory.getLocalInstance(ctx).getTransDownBillEntryCollection(evi);
        TransDownBillEntryInfo entryInfo = null;
        Iterator iter = colls.iterator();
        while (iter.hasNext()) {
            entryInfo = (TransDownBillEntryInfo)iter.next();
            journalFacade.antiBook(entryInfo.getId().toString());
            subAcctFacade.antiBook(entryInfo.getId().toString());
            subLedgerFacade.cancelBook(entryInfo.getId().toString());
        }
    }

    private void updateUnConfrimProp(Context ctx, TransDownBillCollection coll) throws EASBizException, BOSException {
        ITransDownBill iTransBill = TransDownBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = null;
        TransDownBillInfo info = null;
        TransDownBillEntryCollection entryColl = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            entryColl = info.getEntrys();
            int entrySize = entryColl.size();
            for (int j = 0; j < entrySize; ++j) {
                entryColl.get(j).setIsSuccessed(false);
                entryColl.get(j).setHasChange(true);
            }
            info.setConfirmedAmt(Constants.ZERO);
            info.setConfirmedCounts(0);
            info.setConfirmedLocalAmt(Constants.ZERO);
            info.setState(TransDownBillStateEnum.AUDITED);
            info.setCashier(null);
            pk = new ObjectUuidPK(info.getId());
            iTransBill.update((IObjectPK)pk, (CoreBaseInfo)info);
        }
    }

    @Override
    protected int _sendReceipt(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransDownBillCollection coll = this.getColl(ctx, idSet);
        int successCounts = 0;
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.get(i).getState().equals((Object)TransDownBillStateEnum.CONFIRMED)) {
                throw new TransBillException(TransBillException.STATEERRORSENDRECEIPT, new Object[]{coll.get(i).getNumber()});
            }
            successCounts += this.sendReceipt(ctx, coll.get(i), false, false);
            numbers = EmptyUtil.isEmpty((String)numbers) ? coll.get(i).getNumber() : numbers + "," + coll.get(i).getNumber();
            this.sendReceipt4WF(ctx, coll.get(i).getId().toString());
        }
        if (coll.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transdownbill_sendreceipt", (String)companyID, (String)"\u4e0b\u62e8\u5355\u53d1\u9001\u56de\u5355");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return successCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendReceipt(Context ctx, TransDownBillInfo info, boolean isSendWithConfirm, boolean isConfirmChange) throws BOSException, EASBizException {
        TransDownBillInfo cloneInfo = (TransDownBillInfo)info.clone();
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        TransDownBillEntryCollection entryColl = cloneInfo.getEntrys();
        TransDownBillEntryInfo entryInfo = null;
        TransDownBillEntryCollection entryCollOld = info.getEntrys();
        TransDownBillEntryInfo entryInfoOld = null;
        CompanyOrgUnitInfo company = null;
        boolean isConfirm = info.getState() == TransDownBillStateEnum.CONFIRMED;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestBizObjIDForUpdate(info.getId().toString());
            if (!isLock) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
            }
            int successCounts = 0;
            for (int i = entryColl.size() - 1; i >= 0; --i) {
                entryInfo = entryColl.get(i);
                entryInfoOld = entryCollOld.get(i);
                if (isConfirm && isSendWithConfirm) {
                    entryInfo.setIsSendReceipt(false);
                    entryInfo.setReceiptBillId(null);
                    entryInfoOld.setIsSendReceipt(false);
                    entryInfoOld.setReceiptBillId(null);
                }
                if (!entryInfo.isIsSuccessed() || entryInfo.isIsSendReceipt()) {
                    entryColl.remove(entryInfo);
                    continue;
                }
                company = entryInfo.getUnit();
                if (isSendWithConfirm && !this.isAutoSendReceipt(ctxHelper, company.getId())) {
                    entryColl.remove(entryInfo);
                    continue;
                }
                entryInfo.setIsSendReceipt(true);
                entryInfoOld.setIsSendReceipt(true);
                ++successCounts;
            }
            if (!isSendWithConfirm && entryColl.isEmpty()) {
                throw new TransBillException(TransBillException.STATEERRORSENDRECEIPT2, new Object[]{info.getNumber()});
            }
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            TransDownBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
            if (entryColl.isEmpty()) {
                int n = 0;
                return n;
            }
            CoreBillBaseCollection srcBillColl = new CoreBillBaseCollection();
            srcBillColl.add((CoreBillBaseInfo)cloneInfo);
            BOSObjectType destObjType = new ReceivingBillInfo().getBOSType();
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_transdownbill_sendreceipt", (String)info.getCompany().getId().toString(), (String)"\u4e0b\u62e8\u5355\u53d1\u9001\u56de\u5355");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            this.botpTransfromSubmit(ctx, srcBillColl, destObjType);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            int n = successCounts;
            return n;
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(info.getId().toString());
            }
        }
    }

    private void botpTransfromSubmit(Context ctx, CoreBillBaseCollection transDownBillCol, BOSObjectType destObjType) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(transDownBillCol, destObjType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        CoreBillBaseInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (CoreBillBaseInfo)destBillColl.getObject(i);
            iBTPManager.saveRelations(destBillInfo, botRelateColl);
            this.reverseReceivingBill(ctx, destBillInfo);
        }
        this.reverseTransDownBill(ctx, botRelateColl, destBillInfo);
    }

    private void reverseTransDownBill(Context ctx, BOTRelationCollection botRelateColl, CoreBillBaseInfo destBillInfo) throws BOSException {
        String sql = "update T_FS_TransDownBillEntry set FReceiptBillId=?,FIsSendReceipt = 1 where fid = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < botRelateColl.size(); ++i) {
                BOTRelationInfo relation = botRelateColl.get(i);
                this.reverseTransDownBillEntry(ctx, relation.getRelationEntries(), stmt);
            }
            stmt.executeBatch();
            this.reverseTransDownBillStatus(ctx, destBillInfo);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private void reverseTransDownBillEntry(Context ctx, BOTRelationEntryCollection entryCollection, PreparedStatement stmt) throws BOSException {
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            BOTRelationEntryInfo tmpInfo = entryCollection.get(i);
            try {
                stmt.setString(1, tmpInfo.getDestObjectID());
                stmt.setString(2, tmpInfo.getSrcEntryID());
                stmt.addBatch();
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void reverseTransDownBillStatus(Context ctx, CoreBillBaseInfo destBillInfo) throws BOSException {
        String sql = "update T_FS_TransDownBill set FIsSendReceipt = 1 where fid = (select top 1 FParentID from T_FS_TransDownBillEntry where FReceiptBillId = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{destBillInfo.getId().toString()});
    }

    private boolean isAutoSendReceipt(IContextHelper ctxHelper, BOSUuid companyId) {
        return ctxHelper.getBooleanParam("CS013", (IObjectPK)new ObjectUuidPK(companyId));
    }

    @Override
    protected int _withdrawReceipt(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransDownBillCollection coll = this.getColl(ctx, idSet);
        TransDownBillInfo info = null;
        int successCounts = 0;
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!this.hasSendReceipt(info)) {
                throw new TransBillException(TransBillException.STATEERRORWITHDRAWRECEIPT, new Object[]{coll.get(i).getNumber()});
            }
            numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
            this.withdrawReceipt4WF(ctx, coll.get(i).getId().toString());
            successCounts += this.withdrawReceipt(ctx, info, true);
        }
        if (coll.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transdownbill_withdrawreceipt", (String)companyID, (String)"\u4e0b\u62e8\u5355\u64a4\u9500\u56de\u5355");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return successCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int withdrawReceipt(Context ctx, TransDownBillInfo info, boolean isUnConfirm) throws BOSException, EASBizException {
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance((Context)ctx);
        TransDownBillEntryCollection entryColl = info.getEntrys();
        TransDownBillEntryInfo entryInfo = null;
        ObjectUuidPK receiptPk = null;
        int successCounts = 0;
        for (int i = entryColl.size() - 1; i >= 0; --i) {
            entryInfo = entryColl.get(i);
            if (!entryInfo.isHasChange() && !isUnConfirm || !entryInfo.isIsSendReceipt() || FMHelper.isEmpty((String)entryInfo.getReceiptBillId())) continue;
            receiptPk = new ObjectUuidPK(entryInfo.getReceiptBillId());
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            try {
                Boolean resultRequest = iMutex.requestObjIDForUpdate(entryInfo.getReceiptBillId());
                if (!resultRequest.booleanValue()) {
                    throw new TransBillException(TransBillException.TRANSDOWNBILLLOCKED, new Object[]{info.getNumber(), entryInfo.getUnit().getName()});
                }
                if (iReceivingBill.exists((IObjectPK)receiptPk)) {
                    this.deleteReceivingBill(isUnConfirm, iReceivingBill, entryInfo, (IObjectPK)receiptPk);
                }
            }
            finally {
                iMutex.releaseObjIDForUpdate(entryInfo.getReceiptBillId());
            }
            entryInfo.setIsSendReceipt(false);
            entryInfo.setReceiptBillId(null);
            ++successCounts;
        }
        if (successCounts > 0) {
            IObjectPK pkOut1 = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_transdownbill_withdrawreceipt", (String)info.getCompany().getId().toString(), (String)"\u4e0b\u62e8\u5355\u64a4\u9500\u56de\u5355");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut1);
        }
        info.setIsSendReceipt(false);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        TransDownBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
        return successCounts;
    }

    private void deleteReceivingBill(boolean isUnConfirm, IReceivingBill iReceivingBill, TransDownBillEntryInfo entryInfo, IObjectPK receiptPk) throws BOSException, EASBizException, BEException {
        if (isUnConfirm) {
            iReceivingBill.delete(receiptPk);
        } else {
            try {
                iReceivingBill.delete(receiptPk);
            }
            catch (Exception ex) {
                throw new TransBillException(TransBillException.TRANSUPANDDOWNENTRYPROCESSERROR, new Object[]{new Integer(entryInfo.getSeq()), ex.getMessage()});
            }
        }
    }

    @Override
    protected boolean _hasSendReceipt(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransDownBillCollection coll = this.getColl(ctx, idSet);
        TransDownBillInfo info = null;
        int size = coll.size();
        for (int index = 0; index < size; ++index) {
            info = coll.get(index);
            if (!this.hasSendReceipt(info)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSendReceipt(TransDownBillInfo info) {
        int size = info.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            if (!info.getEntrys().get(i).isIsSendReceipt()) continue;
            return true;
        }
        return false;
    }

    private TransDownBillCollection getColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("entrys.*");
        evi.getSelector().add("entrys.unit.*");
        evi.getSelector().add("currency.*");
        evi.getSelector().add("company.*");
        evi.getSelector().add("fundFlowItem.id");
        evi.getSelector().add("fundFlowItem.number");
        evi.getSelector().add("fundFlowItem.name");
        evi.getSelector().add("motherAcctBank.*");
        evi.getSelector().add("entrys.subAcct.*");
        evi.getSelector().add("entrys.subAcct.innerAccount.*");
        evi.getSelector().add("entrys.subAcct.innerAccount.company.*");
        evi.getSelector().add("entrys.fundFlowItem.id");
        evi.getSelector().add("entrys.fundFlowItem.number");
        evi.getSelector().add("entrys.fundFlowItem.name");
        evi.getSelector().add("entrys.project.number");
        evi.getSelector().add("entrys.project.name");
        evi.getSelector().add("entrys.feeType.number");
        evi.getSelector().add("entrys.feeType.name");
        evi.getSelector().add("settleType.number");
        evi.getSelector().add("settleType.name");
        evi.getSelector().add("motherAcctBank.bank.number");
        evi.getSelector().add("motherAcctBank.bank.name");
        ITransDownBill iTrans = TransDownBillFactory.getLocalInstance(ctx);
        return iTrans.getTransDownBillCollection(evi);
    }

    @Override
    protected IObjectPK _commitToBE(Context ctx, Set idSet) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE");
        if (idSet.size() > 1) {
            throw new BEException(BEException.NOTALLOWBATCHSUBMIT);
        }
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        for (String transDownBillID : idSet) {
            String sql = "UPDATE T_FS_TransDownBill SET FID = FID WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{transDownBillID});
            TransDownBillInfo transDownBillInfo = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(transDownBillID), this.getSelectorForBe());
            this.beforeCommitToBe(ctx, transDownBillInfo);
            if (EmptyUtil.isEmpty((String)numbers)) {
                numbers = transDownBillInfo.getNumber();
                continue;
            }
            numbers = numbers + "," + transDownBillInfo.getNumber();
        }
        String afterCommitToBeLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE-afterCommitToBeLogId");
        PerfLogRecorder.endRecord((String)afterCommitToBeLogId);
        String builderName = TransDownBill2BankBillBuilder.class.getName();
        IBankTransDownBill iBankTransDownBill = BankTransDownBillFactory.getLocalInstance((Context)ctx);
        Iterator iter = idSet.iterator();
        String billId = null;
        IObjectPK id = null;
        BankTransDownBillCollection coll = new BankTransDownBillCollection();
        while (iter.hasNext()) {
            billId = (String)iter.next();
            String existsTransDownBillLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE-existsTransDownBillLogId");
            this.existsTransDownBill(ctx, billId);
            PerfLogRecorder.endRecord((String)existsTransDownBillLogId);
            String commit2BankTransDownBillLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE-commit2BankTransDownBillLogId");
            id = iBankTransDownBill.commit2BankTransDownBill(billId, builderName);
            PerfLogRecorder.endRecord((String)commit2BankTransDownBillLogId);
            String getSelectorForBeLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE-getSelectorForBeLogId");
            SelectorItemCollection sele = this.getSelectorForBe();
            PerfLogRecorder.endRecord((String)getSelectorForBeLogId);
            String getBankTransDownBillInfoLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE-getBankTransDownBillInfoLogId");
            BankTransDownBillInfo info = BankTransDownBillFactory.getLocalInstance((Context)ctx).getBankTransDownBillInfo(id, sele);
            PerfLogRecorder.endRecord((String)getBankTransDownBillInfoLogId);
            coll.add(info);
        }
        if (coll != null && coll.size() > 0) {
            try {
                String commitToBE4WFfoLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE-commitToBE4WFfoLogId");
                this.commitToBE4WF(ctx, billId);
                PerfLogRecorder.endRecord((String)commitToBE4WFfoLogId);
                String transDownLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE-transDownLogId");
                BankFacadeFactory.getLocalInstance((Context)ctx).transDown(coll);
                PerfLogRecorder.endRecord((String)transDownLogId);
                String saveId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._commitToBE-saveId");
                BankTransDownBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)coll.get(0));
                PerfLogRecorder.endRecord((String)saveId);
                String reverseSrcBillId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean.reverseSrcBillId");
                this.reverseSrcBill(ctx, coll.get(0));
                PerfLogRecorder.endRecord((String)reverseSrcBillId);
            }
            catch (Exception e) {
                throw new BEException(BEException.TRANSDOWNSUMMITFAILURE, new Object[]{e.getMessage()});
            }
        }
        if (numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transdownbill_committobe", (String)companyID, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"537_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()));
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        PerfLogRecorder.endRecord((String)pfLogId);
        return id;
    }

    @Override
    public void _autoCommitToBE4WF(Context ctx, String transDownBillId) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(transDownBillId);
        this._commitToBE(ctx, idSet);
    }

    private void reverseSrcBill(Context ctx, BankTransDownBillInfo bankTransDownBillInfo) throws EASBizException, BOSException {
        if (bankTransDownBillInfo == null || bankTransDownBillInfo.getSourceBillId() == null) {
            return;
        }
        BankTransDownBillEntryCollection bankColl = bankTransDownBillInfo.getEntrys();
        BankTransDownBillEntryInfo bankEntryInfo = null;
        HashMap<String, BankTransDownBillEntryInfo> bankMap = new HashMap<String, BankTransDownBillEntryInfo>();
        for (int i = 0; i < bankColl.size(); ++i) {
            bankEntryInfo = bankColl.get(i);
            bankMap.put(bankEntryInfo.getSrcBillNumber(), bankEntryInfo);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.bankState"));
        sic.add(new SelectorItemInfo("entrys.bankReturnInfo"));
        TransDownBillInfo billInfo = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(bankTransDownBillInfo.getSourceBillId()), sic);
        TransDownBillEntryCollection billColl = billInfo.getEntrys();
        TransDownBillEntryInfo billEntryInfo = null;
        for (int i = 0; i < billColl.size(); ++i) {
            billEntryInfo = billColl.get(i);
            bankEntryInfo = (BankTransDownBillEntryInfo)bankMap.get(billEntryInfo.getId().toString());
            if (bankEntryInfo == null) continue;
            billEntryInfo.setBankState(bankEntryInfo.getState());
            billEntryInfo.setBankReturnInfo(bankEntryInfo.getBankReturnInfo());
        }
        TransDownBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
    }

    private void existsTransDownBill(Context ctx, String billId) throws BOSException, EASBizException {
        String sql = "select fid from t_bot_relation where FDestEntityID='4B808C7F' and FSrcObjectID= ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        try {
            if (rs.next()) {
                throw new FSException(FSException.HASBANKTRANSDOWNBILL);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void beforeCommitToBe(Context ctx, TransDownBillInfo transDownBillInfo) throws BOSException, EASBizException {
        String sql = "UPDATE T_FS_TransDownBill SET  FIsCommittoBe = 1,FcommitBeTime= ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), transDownBillInfo.getId().toString()});
        if (!transDownBillInfo.getState().equals((Object)TransDownBillStateEnum.AUDITED)) {
            throw new TransBillException(TransBillException.NOTEQUAUDIT_SUBMITTOBE);
        }
        if (transDownBillInfo.isIsCommittoBe()) {
            throw new TransBillException(TransBillException.NOT_REPEAT_SUBMITTOBE);
        }
        if (transDownBillInfo.isIsCreatedFromTransDetail()) {
            throw new TransBillException(TransBillException.FROMTRANSDETAIL_NOT_SUBMITTOBE);
        }
        if (transDownBillInfo.getMotherAcctBank() == null || !transDownBillInfo.getMotherAcctBank().isIsSetBankInterface()) {
            throw new FSException(FSException.COMMON, new String[]{EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"317_TransDownBillHelper")});
        }
        if (transDownBillInfo.getMotherAcctBank().isIsOnlyRead()) {
            throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{transDownBillInfo.getMotherAcctBank().getName()});
        }
        if (transDownBillInfo.getSettleType() == null) {
            throw new TransBillException(TransBillException.SETTLEMENTTYPE_CANNOT_BE_NULL);
        }
        if (!transDownBillInfo.getSettleType().isPayThroughBE()) {
            throw new TransBillException(TransBillException.FORBEMUSTHAVESETTLETYPE);
        }
        String tmpMsg = "";
        for (int index = 0; index < transDownBillInfo.getEntrys().size(); ++index) {
            if (!EmptyUtil.isEmpty((String)transDownBillInfo.getEntrys().get(index).getRecProvince()) && !EmptyUtil.isEmpty((String)transDownBillInfo.getEntrys().get(index).getRecCity()) && !EmptyUtil.isEmpty((String)transDownBillInfo.getEntrys().get(index).getRecBank())) continue;
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"181_TransDownBillHelper");
            tmpMsg = tmpMsg + EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"318_TransDownBillHelper") + msg;
        }
        if (tmpMsg.length() > 1) {
            throw new FSException(FSException.COMMON, new String[]{tmpMsg});
        }
    }

    @Override
    protected void _cancelCommitToBE(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "UPDATE T_FS_TransDownBill set FIsCommittoBe=0 WHERE FID ='" + id + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _commitToBeAll(Context ctx, Set idSet, String bankTransDownbillId) throws BOSException, EASBizException {
        boolean debug = false;
        BankTransDownBillCollection coll = new BankTransDownBillCollection();
        SelectorItemCollection sele = this.getSelectorForBe();
        BankTransDownBillInfo info = BankTransDownBillFactory.getLocalInstance((Context)ctx).getBankTransDownBillInfo((IObjectPK)new ObjectUuidPK(bankTransDownbillId), sele);
        coll.add(info);
        if (info != null) {
            try {
                BankFacadeFactory.getLocalInstance((Context)ctx).transDown(coll);
            }
            catch (BEException e) {
                throw new BEException(BEException.SUMMITFAILURE, new Object[]{e.getMessage()});
            }
            catch (Exception err) {
                logger.error((Object)err);
            }
            if (debug) {
                throw new BEException(BEException.SUMMITFAILURE, new Object[]{"test"});
            }
        }
    }

    private SelectorItemCollection getSelectorForBe() {
        SelectorItemCollection sele = new SelectorItemCollection();
        sele.add("*");
        sele.add("SettleType.*");
        sele.add("currency.*");
        sele.add("payAccountBank.*");
        sele.add("recProvince.*");
        sele.add("recCity.*");
        sele.add("recRegion.*");
        sele.add("recOpenArea.*");
        sele.add("motherAcctBank.*");
        sele.add("entrys.*");
        sele.add("entrys.unitAcctBank.*");
        sele.add("entrys.payeeArea.number");
        sele.add("entrys.payeeArea.deptID");
        return sele;
    }

    @Override
    protected void _commitToBE4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _confirm4WF(Context ctx, IObjectValue info) throws BOSException, EASBizException {
    }

    @Override
    protected void _sendReceipt4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _unConfirm4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _autoTransDown(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"238_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + DateTimeUtils.truncateDate((Date)new Date()) + "------------"));
        TransDownBillHelper helper = new TransDownBillHelper();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("transTime", (Object)("1970-01-01 " + DateUtil.getTime().getHours() + ":00:00.0"), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("transTime", (Object)("1970-01-01 " + DateUtil.getTime().getHours() + ":59:59.0"), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)Boolean.TRUE));
        view.setSelector(this.getSelectors());
        AutoTransCollection colls = AutoTransFactory.getLocalInstance(ctx).getAutoTransCollection(view);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"239_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + colls.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"240_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
        Map idMap = helper.genTransDownBills(ctx, colls);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"241_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + idMap.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"242_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
        if (idMap.size() > 0) {
            Set idSet = idMap.keySet();
            for (String id : idSet) {
                HashSet<String> transIdSet = new HashSet<String>();
                transIdSet.add(id);
                try {
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"243_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + id + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"244_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
                    IObjectPK bankTransDownbillId = TransDownBillFacadeFactory.getLocalInstance(ctx).commitToBE(transIdSet);
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"245_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + bankTransDownbillId));
                    helper.synBankTransDownBillState(ctx, idMap);
                    TransDownBillHelper.sendTransBillMessage(ctx, true, (AutoTransHistoryCollection)((Object)idMap.get(id)), true, true);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"243_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + id + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"246_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
                    for (int i = 0; i < ((AutoTransHistoryCollection)((Object)idMap.get(id))).size(); ++i) {
                        AutoTransHistoryInfo sInfo = ((AutoTransHistoryCollection)((Object)idMap.get(id))).get(i);
                        if (!sInfo.getTransDownBill().getId().toString().equals(id)) continue;
                        sInfo.setDescription(FmBeHelper.cutString((String)e.getMessage()));
                        AutoTransHistoryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sInfo.getId()), (CoreBaseInfo)sInfo);
                    }
                    TransDownBillHelper.sendTransBillMessage(ctx, true, (AutoTransHistoryCollection)((Object)idMap.get(id)), true, false);
                }
            }
        }
        logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"247_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()));
    }

    @Override
    protected void _autoTransDownByNumber(Context ctx, String number) throws BOSException, EASBizException {
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"238_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + DateTimeUtils.truncateDate((Date)new Date()) + "------------"));
        TransDownBillHelper helper = new TransDownBillHelper();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)Boolean.TRUE));
        HashSet<String> numberSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((String)number)) {
            String[] numbers = number.split(",");
            for (int i = 0; i < numbers.length; ++i) {
                numberSet.add(numbers[i]);
            }
        }
        if (numberSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        }
        view.setSelector(this.getSelectors());
        AutoTransCollection colls = AutoTransFactory.getLocalInstance(ctx).getAutoTransCollection(view);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"239_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + colls.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"240_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
        Map idMap = helper.genTransDownBillsNew(ctx, colls);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"241_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + idMap.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"242_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
        if (idMap.size() > 0) {
            Set idSet = idMap.keySet();
            for (String id : idSet) {
                HashSet<String> transIdSet = new HashSet<String>();
                transIdSet.add(id);
                try {
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"243_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + id + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"244_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
                    IObjectPK bankTransDownbillId = TransDownBillFacadeFactory.getLocalInstance(ctx).commitToBE(transIdSet);
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"245_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + bankTransDownbillId));
                    helper.synBankTransDownBillState(ctx, idMap);
                    TransDownBillHelper.sendTransBillMessage(ctx, true, (AutoTransHistoryCollection)((Object)idMap.get(id)), true, true);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"243_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + id + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"246_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
                    for (int i = 0; i < ((AutoTransHistoryCollection)((Object)idMap.get(id))).size(); ++i) {
                        AutoTransHistoryInfo sInfo = ((AutoTransHistoryCollection)((Object)idMap.get(id))).get(i);
                        if (!sInfo.getTransDownBill().getId().toString().equals(id)) continue;
                        sInfo.setDescription(FmBeHelper.cutString((String)e.getMessage()));
                        AutoTransHistoryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sInfo.getId()), (CoreBaseInfo)sInfo);
                    }
                    TransDownBillHelper.sendTransBillMessage(ctx, true, (AutoTransHistoryCollection)((Object)idMap.get(id)), true, false);
                }
            }
        }
        logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"247_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()));
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("transTime"));
        sic.add(new SelectorItemInfo("parentAcct.number"));
        sic.add(new SelectorItemInfo("parentAcct.name"));
        sic.add(new SelectorItemInfo("parentAcct.acctName"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("isUrgent"));
        sic.add(new SelectorItemInfo("isCommitBe"));
        sic.add(new SelectorItemInfo("entrys.transDownUnit.name"));
        sic.add(new SelectorItemInfo("entrys.transDownUnit.number"));
        sic.add(new SelectorItemInfo("entrys.transDownUnit.id"));
        sic.add(new SelectorItemInfo("entrys.unitAccount.name"));
        sic.add(new SelectorItemInfo("entrys.unitAccount.number"));
        sic.add(new SelectorItemInfo("entrys.unitAccount.id"));
        sic.add(new SelectorItemInfo("entrys.unitAccount.acctName"));
        sic.add(new SelectorItemInfo("entrys.description"));
        sic.add(new SelectorItemInfo("entrys.difPlace"));
        sic.add(new SelectorItemInfo("entrys.difBank"));
        sic.add(new SelectorItemInfo("entrys.openArea.name"));
        sic.add(new SelectorItemInfo("entrys.fpItem.name"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("entrys.outBgItemNumber"));
        sic.add(new SelectorItemInfo("entrys.outBgItemName"));
        sic.add(new SelectorItemInfo("entrys.outBgItemId"));
        sic.add(new SelectorItemInfo("entrys_project.name"));
        sic.add(new SelectorItemInfo("current.name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        sic.add(new SelectorItemInfo("entrys.city"));
        sic.add(new SelectorItemInfo("entrys.recBank"));
        sic.add(new SelectorItemInfo("entrys.province"));
        sic.add(new SelectorItemInfo("creator"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("parentAcct"));
        sic.add(new SelectorItemInfo("parentAcct.id"));
        sic.add(new SelectorItemInfo("entrys.project"));
        sic.add(new SelectorItemInfo("isTransDown"));
        return sic;
    }

    private void disposeFromApplyTransDownByConfirmAndUnConfirm(Context ctx, TransDownBillInfo model, boolean isConfim) throws BOSException, EASBizException {
        if (!this.isApplyTransDown(model)) {
            return;
        }
        HashSet idSet = new HashSet();
        HashSet<BOSUuid> billSet = new HashSet<BOSUuid>();
        billSet.add(model.getId());
        model = this.getColl(ctx, billSet).get(0);
        Iterator it = model.getEntrys().iterator();
        while (it.hasNext()) {
            TransDownBillEntryInfo transDownBillEntryInfo = (TransDownBillEntryInfo)it.next();
            if (!transDownBillEntryInfo.isIsSuccessed()) continue;
            this.mergeSet(idSet, transDownBillEntryInfo.getIdSet());
        }
        String ids = FMHelper.setTran2String(idSet);
        this.applyTransDownApprove(ctx, ids, isConfim);
    }

    private void applyTransDownApprove(Context ctx, String ids, boolean isApprove) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("update T_FS_ApplyTransDown set FIsApprove = ? where fid IN ");
        sb.append(ids);
        if (isApprove) {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{"1"});
        } else {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{"0"});
        }
    }

    private void mergeSet(Set set, String idString) {
        if (FMHelper.isEmpty((String)idString)) {
            return;
        }
        String[] idSet = idString.split(",");
        for (int i = 0; i < idSet.length; ++i) {
            set.add(idSet[i]);
        }
    }

    private boolean isApplyTransDown(TransDownBillInfo model) {
        return SourceTypeEnum.APPTRANSDOWN.equals((Object)model.getSourceType());
    }

    @Override
    protected void _rejectedApplyTransDown(Context ctx, IObjectPK pk, String rejectedRemark) throws BOSException, EASBizException {
        TransDownBillInfo transDownBillInfo = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillInfo(pk);
        ctx.put((Object)"rejectedApplyTransDown", (Object)"rejectedApplyTransDown");
        if (FMHelper.isEmpty((String)transDownBillInfo.getSourceBillId())) {
            try {
                transDownBillInfo.setSourceBillId(transDownBillInfo.getEntrys().get(0).getTransDetailId().toString());
            }
            catch (Exception ex) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"248_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())});
            }
        }
        Set idSet = FMHelper.getSrcBillIdSet((Context)ctx, (String)transDownBillInfo.getId().toString());
        CoreBaseCollection coll = new CoreBaseCollection();
        for (String srcId : idSet) {
            if (!BOSUuid.read((String)srcId).getType().equals((Object)new ApplyTransDownInfo().getBOSType())) continue;
            if (!ApplyTransDownFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(srcId))) {
                throw new FSException(FSException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"229_TransDownBillControllerBean", (Locale)ctx.getLocale())});
            }
            ApplyTransDownInfo applyTransDownInfo = ApplyTransDownFactory.getLocalInstance(ctx).getApplyTransDownInfo((IObjectPK)new ObjectUuidPK(srcId));
            applyTransDownInfo.setRejectRemark(rejectedRemark);
            applyTransDownInfo.setState(ApplyTransDownStateEnum.SAVE);
            applyTransDownInfo.setAuditDate(null);
            applyTransDownInfo.setAuditor(null);
            coll.add((CoreBaseInfo)applyTransDownInfo);
        }
        ApplyTransDownFactory.getLocalInstance(ctx).update(coll);
        TransDownBillFactory.getLocalInstance(ctx).delete(pk);
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)transDownBillInfo.getNumber(), (String)"fs_transdownbill_rejected", (String)companyID, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"538_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()));
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    private void reverseReceivingBill(Context ctx, CoreBillBaseInfo destBillInfo) throws BOSException {
        String sql = "select fistempsave from t_bot_mapping AS BOTMAPPING INNER JOIN T_BOT_ExtMapping AS EXTRULE  ON BOTMAPPING.FExtMappingID = EXTRULE.FID and BOTMAPPING.FSrcEntityName ='5E920865' and BOTMAPPING.FDestEntityName ='FA44FD5B' and EXTRULE.FIsEffected =1 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            String tempSave;
            if (rs != null && rs.next() && "1".equals(tempSave = rs.getString("fistempsave"))) {
                String updateSql = "UPDATE T_CAS_ReceivingBill SET  FBillStatus = 10 WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{destBillInfo.getId().toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCommitToBe(Context ctx, Set ids) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._batchCommitToBe");
        HashMap map = new HashMap();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        String getTransDownBillCollectionLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._batchCommitToBe_getTransDownBillCollectionLogId");
        TransDownBillCollection transDownColl = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillCollection(evi);
        PerfLogRecorder.endRecord((String)getTransDownBillCollectionLogId);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < transDownColl.size(); ++i) {
            TransDownBillInfo transDownInfo = transDownColl.get(i);
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(transDownInfo.getId().toString());
            boolean isLock = false;
            try {
                IObjectPK userPK = ctx.getCaller();
                ObjectUuidPK orgPK = new ObjectUuidPK(transDownInfo.getCompany().getId());
                PermissionFactory.getLocalInstance((Context)ctx).checkDataPermission(userPK, (IObjectPK)orgPK, "TRANS_DOWN_DELETE_COMMITTOBE", (IObjectPK)new ObjectUuidPK(transDownInfo.getId()));
                String commitToBELogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransDownBillFacadeControllerBean._batchCommitToBe_commitToBELogId");
                TransDownBillFacadeFactory.getLocalInstance(ctx).commitToBE(idSet);
                isLock = iMutex.requestBizObjIDForUpdate(transDownInfo.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                PerfLogRecorder.endRecord((String)commitToBELogId);
                continue;
            }
            catch (Exception e) {
                errorMap.put(transDownInfo.getNumber(), e.getMessage());
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(transDownInfo.getId().toString());
                }
            }
        }
        PerfLogRecorder.endRecord((String)pfLogId);
        map.put("errorMap", errorMap);
        return map;
    }

    @Override
    protected Map _batchConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> idMap = new HashMap<String, String>();
        TransDownBillCollection coll = this.getColl(ctx, idSet);
        TransDownBillInfo downInfo = null;
        String msg = "";
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            TransDownBillEntryInfo entry;
            int k;
            downInfo = coll.get(i);
            int successCount = 0;
            int failCount = 0;
            BigDecimal amt = new BigDecimal(0);
            BigDecimal localAmt = new BigDecimal(0);
            TransDownBillEntryCollection entrys = downInfo.getEntrys();
            if (downInfo.isIsCommittoBe()) {
                for (k = 0; k < entrys.size(); ++k) {
                    entry = entrys.get(k);
                    if (BankPayingBillStateEnum.TS.equals((Object)entry.getBankState())) {
                        entry.setIsSuccessed(true);
                        ++successCount;
                        amt = amt.add(entry.getAmount());
                        localAmt = localAmt.add(entry.getLocalAmt());
                        continue;
                    }
                    if (!BankPayingBillStateEnum.TF.equals((Object)entry.getBankState())) continue;
                    ++failCount;
                }
                if (failCount == entrys.size()) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"234_TransDownBillControllerBean", (Locale)ctx.getLocale()) + downInfo.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"450_TransBillConfirmFail", (Locale)ctx.getLocale());
                    idMap.put(downInfo.getId().toString(), msg);
                    continue;
                }
                if (successCount + failCount < entrys.size()) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"234_TransDownBillControllerBean", (Locale)ctx.getLocale()) + downInfo.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"451_TransBillConfirmFail", (Locale)ctx.getLocale());
                    idMap.put(downInfo.getId().toString(), msg);
                    continue;
                }
            } else {
                for (k = 0; k < entrys.size(); ++k) {
                    entry = entrys.get(k);
                    entry.setIsSuccessed(true);
                    ++successCount;
                    amt = amt.add(entry.getAmount());
                    localAmt = localAmt.add(entry.getLocalAmt());
                }
            }
            downInfo.setConfirmedCounts(successCount);
            downInfo.setConfirmedAmt(amt);
            downInfo.setConfirmedLocalAmt(localAmt);
            try {
                TransDownBillFacadeFactory.getLocalInstance(ctx).confirm(downInfo);
                continue;
            }
            catch (Exception e) {
                msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"249_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + downInfo.getNumber() + "\uff1a" + e.getMessage();
                idMap.put(downInfo.getId().toString(), msg);
            }
        }
        return idMap;
    }

    @Override
    protected void _withdrawReceipt4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected int _confirmRequires(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        return this._confirm(ctx, info);
    }

    @Override
    protected Map _confirmChange(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        TransDownBillInfo downInfo = (TransDownBillInfo)info;
        this.unConfimCheck(downInfo, false);
        this.checkBeforeConfirm(ctx, downInfo, TransDownBillStateEnum.CONFIRMED);
        if (this.isHistoryBill(ctx, downInfo)) {
            throw new TransBillException(TransBillException.HISTROYBILLNOTSUPPORT);
        }
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(downInfo.getId()), (CtrlNodeEnum)CtrlNodeEnum.confirm);
        this.disposeFromApplyTransDownByConfirmAndUnConfirm(ctx, downInfo, false);
        downInfo = this.getChangeEntryInfo(ctx, downInfo);
        this.withdrawReceipt(ctx, downInfo, false);
        this.disposeBook(ctx, downInfo);
        this.sendReceipt(ctx, downInfo, true, true);
        this.disposeFromApplyTransDownByConfirmAndUnConfirm(ctx, downInfo, true);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(downInfo.getId()), (CtrlNodeEnum)CtrlNodeEnum.confirm);
        return null;
    }

    private boolean isHistoryBill(Context ctx, TransDownBillInfo info) throws BOSException, EASBizException {
        boolean isHistoryBill = false;
        ISubsidiaryLedger iSub = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        isHistoryBill = iSub.exists(" where billid='" + info.getId() + "'");
        if (isHistoryBill) {
            return true;
        }
        TransDownBillEntryInfo entryInfo = null;
        Iterator it = info.getEntrys().iterator();
        while (it.hasNext()) {
            entryInfo = (TransDownBillEntryInfo)it.next();
            isHistoryBill = iSub.exists(" where billid='" + entryInfo.getId() + "'");
            if (!isHistoryBill) continue;
            isHistoryBill = false;
            break;
        }
        return isHistoryBill;
    }

    private TransDownBillInfo getChangeEntryInfo(Context ctx, TransDownBillInfo info) throws BOSException, EASBizException {
        TransDownBillEntryInfo entryInfo = null;
        TransDownBillEntryInfo oldEntryInfo = null;
        TransDownBillEntryCollection entryColl = info.getEntrys();
        for (int i = entryColl.size() - 1; i >= 0; --i) {
            entryInfo = entryColl.get(i);
            oldEntryInfo = TransDownBillEntryFactory.getLocalInstance(ctx).getTransDownBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getId()));
            if (entryInfo.isIsSuccessed() == oldEntryInfo.isIsSuccessed()) {
                entryInfo.setHasChange(false);
                continue;
            }
            entryInfo.setHasChange(true);
        }
        return info;
    }

    private void disposeBook(Context ctx, TransDownBillInfo info) throws BOSException, EASBizException {
        IBookNotifyFacade journalFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        ISubAccountBookFacade subAcctFacade = SubAccountBookFacadeFactory.getLocalInstance((Context)ctx);
        ISubsidiaryLedger subLedgerFacade = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        TransDownBillEntryInfo entryInfo = null;
        String ID = info.getId().toString();
        String entryId = null;
        boolean bankBookNotify = this.bankBookNotify(ctx, info);
        if (!bankBookNotify) {
            journalFacade.antiBook(ID);
            this.bookBankJournal(ctx, ID);
        }
        Iterator iter = info.getEntrys().iterator();
        while (iter.hasNext()) {
            entryInfo = (TransDownBillEntryInfo)iter.next();
            entryId = entryInfo.getId().toString();
            if (!entryInfo.isHasChange()) continue;
            try {
                if (entryInfo.isIsSuccessed()) {
                    this.bookSubsidiaryLedger(ctx, ID);
                    if (!bankBookNotify) continue;
                    this.bookBankJournal(ctx, ID);
                    continue;
                }
                if (bankBookNotify) {
                    journalFacade.antiBook(entryId);
                }
                subAcctFacade.antiBook(entryId);
                subLedgerFacade.cancelBook(entryId);
            }
            catch (Exception ex) {
                throw new TransBillException(TransBillException.TRANSUPANDDOWNENTRYPROCESSERROR, new Object[]{new Integer(entryInfo.getSeq()), ex.getMessage()});
            }
        }
    }

    private boolean bankBookNotify(Context ctx, TransDownBillInfo info) {
        boolean TM106;
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        String companyId = null;
        companyId = info.getCompany() != null ? info.getCompany().getId().toString() : localInstance.getCurrentCompany().getId().toString();
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(companyId));
        return val == 0 && (TM106 = localInstance.getBooleanParam("TM106", (IObjectPK)new ObjectUuidPK(companyId)));
    }

    @Override
    protected List _getOverdraftApplyTransAmtList(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        ApplyTransDownInfo transInfo = (ApplyTransDownInfo)info;
        ArrayList transAmtList = new ArrayList();
        List motherList = this.getMotherApplyOverdraftList(ctx, transInfo);
        List subAcctInnerList = this.getInnerAcctApplyOverdraftList(ctx, transInfo);
        transAmtList.addAll(motherList);
        transAmtList.addAll(subAcctInnerList);
        return transAmtList;
    }

    @Override
    protected Map _batchRejectedApplyTransDown(Context ctx, Set ids, String rejectedRemark) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        HashMap<BOSUuid, String> errorMap = new HashMap<BOSUuid, String>();
        ArrayList idList = new ArrayList(ids);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        TransDownBillCollection transDownColl = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillCollection(evi);
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        for (int i = 0; i < transDownColl.size(); ++i) {
            TransDownBillInfo transDownBillInfo = transDownColl.get(i);
            ctx.put((Object)"rejectedApplyTransDown", (Object)"rejectedApplyTransDown");
            if (FMHelper.isEmpty((String)transDownBillInfo.getSourceBillId())) {
                try {
                    transDownBillInfo.setSourceBillId(transDownBillInfo.getEntrys().get(0).getTransDetailId().toString());
                }
                catch (Exception ex) {
                    errorMap.put(transDownBillInfo.getId(), ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"418_billNumber", (Locale)ctx.getLocale()) + transDownBillInfo.getNumber() + ": " + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"248_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + "\n");
                    ids.remove(transDownBillInfo.getId());
                    continue;
                }
            }
            Set idSet = FMHelper.getSrcBillIdSet((Context)ctx, (String)transDownBillInfo.getId().toString());
            CoreBaseCollection coll = new CoreBaseCollection();
            for (String srcId : idSet) {
                if (!BOSUuid.read((String)srcId).getType().equals((Object)new ApplyTransDownInfo().getBOSType())) continue;
                if (!ApplyTransDownFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(srcId))) {
                    errorMap.put(transDownBillInfo.getId(), ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"418_billNumber", (Locale)ctx.getLocale()) + transDownBillInfo.getNumber() + ": " + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"229_TransDownBillControllerBean", (Locale)ctx.getLocale()) + "\n");
                    ids.remove(transDownBillInfo.getId());
                    continue;
                }
                ApplyTransDownInfo applyTransDownInfo = ApplyTransDownFactory.getLocalInstance(ctx).getApplyTransDownInfo((IObjectPK)new ObjectUuidPK(srcId));
                applyTransDownInfo.setRejectRemark(rejectedRemark);
                applyTransDownInfo.setState(ApplyTransDownStateEnum.SAVE);
                applyTransDownInfo.setAuditDate(null);
                applyTransDownInfo.setAuditor(null);
                coll.add((CoreBaseInfo)applyTransDownInfo);
            }
            ApplyTransDownFactory.getLocalInstance(ctx).update(coll);
            TransDownBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(transDownBillInfo.getId()));
            numbers = EmptyUtil.isEmpty((String)numbers) ? transDownBillInfo.getNumber() : numbers + "," + transDownBillInfo.getNumber();
        }
        if (transDownColl.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransDownBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transdownbill_rejected", (String)companyID, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"538_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()));
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return errorMap;
    }

    @Override
    protected void _confirmAfterSyncState(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.getSelector().add("id");
        ev.getSelector().add("number");
        ev.getSelector().add("company.*");
        ev.getSelector().add("sourceBillId");
        ev.getSelector().add("entrys.*");
        BankTransDownBillCollection billColl = BankTransDownBillFactory.getLocalInstance((Context)ctx).getBankTransDownBillCollection(ev);
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean isNeedConfirm = false;
        String successTotal = "select count(fid) from t_fs_transdownbillentry where fissuccessed = 1 and fparentid = ?";
        HashMap<BOSUuid, Boolean> paramMap = new HashMap<BOSUuid, Boolean>();
        int size = billColl.size();
        for (int i = 0; i < size; ++i) {
            BankTransDownBillInfo bill = billColl.get(i);
            if (paramMap.containsKey(bill.getCompany().getId())) {
                isNeedConfirm = (Boolean)paramMap.get(bill.getCompany().getId());
            } else {
                isNeedConfirm = localInstance.getBooleanParam("TM019", (IObjectPK)new ObjectUuidPK(bill.getCompany().getId()));
                paramMap.put(bill.getCompany().getId(), isNeedConfirm);
            }
            try {
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)successTotal, (Object[])new String[]{bill.getSourceBillId()});
                if (!row.next() || row.getInt(1) != bill.getEntrys().size()) continue;
                TransDownBillInfo tranDownBillInfo = new TransDownBillInfo();
                HashSet<String> billSet = new HashSet<String>();
                billSet.add(bill.getSourceBillId());
                TransDownBillCollection transDownColl = this.getColl(ctx, billSet);
                if (transDownColl != null && transDownColl.size() > 0) {
                    tranDownBillInfo = transDownColl.get(0);
                }
                if (TransDownBillStateEnum.CONFIRMED.equals((Object)tranDownBillInfo.getState()) || !isNeedConfirm) continue;
                TransDownBillFacadeFactory.getLocalInstance(ctx).confirm(tranDownBillInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)(bill.getNumber() + EASResource.getString((String)resClassName, (String)"TRANSDOWNCONFIRMFAIL") + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Comparable<StringBuffer>> result = new HashMap<String, Comparable<StringBuffer>>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        TransDownBillCollection transDownColl = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillCollection(evi);
        StringBuffer failed = new StringBuffer();
        int success = 0;
        String number = EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"number");
        String LINE_SEPARATOR = System.getProperty("line.separator");
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        for (int i = 0; i < transDownColl.size(); ++i) {
            TransDownBillInfo transDownBillInfo = transDownColl.get(i);
            HashSet<String> id = new HashSet<String>();
            id.add(transDownBillInfo.getId().toString());
            try {
                isLock = iMutex.requestBizObjIDForUpdate(transDownBillInfo.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                TransDownBillFacadeFactory.getLocalInstance(ctx).audit(id);
                ++success;
                continue;
            }
            catch (EASBizException e) {
                failed.append(number + transDownBillInfo.getNumber() + e.getMessage() + LINE_SEPARATOR);
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(transDownBillInfo.getId().toString());
                }
            }
        }
        result.put("error", failed);
        result.put("success", Integer.valueOf(success));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAntiAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Comparable<StringBuffer>> result = new HashMap<String, Comparable<StringBuffer>>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        TransDownBillCollection transDownColl = TransDownBillFactory.getLocalInstance(ctx).getTransDownBillCollection(evi);
        StringBuffer failed = new StringBuffer();
        int success = 0;
        String number = EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"number");
        String LINE_SEPARATOR = System.getProperty("line.separator");
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        for (int i = 0; i < transDownColl.size(); ++i) {
            TransDownBillInfo transDownBillInfo = transDownColl.get(i);
            HashSet<String> id = new HashSet<String>();
            id.add(transDownBillInfo.getId().toString());
            try {
                isLock = iMutex.requestBizObjIDForUpdate(transDownBillInfo.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                TransDownBillFacadeFactory.getLocalInstance(ctx).antiAudit(id);
                ++success;
                continue;
            }
            catch (EASBizException e) {
                failed.append(number + transDownBillInfo.getNumber() + e.getMessage() + LINE_SEPARATOR);
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(transDownBillInfo.getId().toString());
                }
            }
        }
        result.put("error", failed);
        result.put("success", Integer.valueOf(success));
        return result;
    }
}

