/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.CasAndFmServiceAdapter;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.fs.ITransDownBill;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransDownEventServiceAdapter
extends CasAndFmServiceAdapter {
    public void beforeVerify(IServiceContext svcCtx) throws BOSException {
        Map result = this.getMethodName(svcCtx);
        Context ctx = svcCtx.getContext();
        String methodName = (String)result.get("methodName");
        Object[] parameters = svcCtx.getOperationParameters();
        if (methodName != null) {
            ArrayList<String> correctList = new ArrayList<String>();
            ArrayList<String> lockedList = new ArrayList<String>();
            try {
                this.billStatusVerify(ctx, methodName, parameters, correctList, lockedList);
            }
            catch (EASBizException e) {
                throw new PermissionServiceException(e.getMessage());
            }
            finally {
                if (correctList.size() > 0) {
                    MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
                }
            }
        }
    }

    private void billStatusVerify(Context ctx, String methodName, Object[] parameters, List<String> correctList, List<String> lockedList) throws BOSException, EASBizException {
        ArrayList<Object> allIdList;
        TransDownBillInfo oldInfo;
        int state;
        TransDownBillInfo info;
        Object object;
        ITransDownBill iTransDownBill = TransDownBillFactory.getLocalInstance(ctx);
        if (methodName.equalsIgnoreCase("save") && (object = parameters[1]) != null && object instanceof TransDownBillInfo && (info = (TransDownBillInfo)object).getId() != null && iTransDownBill.exists((IObjectPK)new ObjectUuidPK(info.getId())) && (state = (oldInfo = (TransDownBillInfo)iTransDownBill.getValue((IObjectPK)new ObjectUuidPK(info.getId()))).getState().getValue()) != 1) {
            throw new BEException(BEException.COMMON, (Object[])new String[]{"\u5355\u636e\u72b6\u6001\u5df2\u7ecf\u6539\u53d8\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01" + this.commTag});
        }
        if (methodName.equalsIgnoreCase("submit") && (object = parameters[1]) != null && object instanceof TransDownBillInfo && (info = (TransDownBillInfo)object).getId() != null && iTransDownBill.exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            allIdList = new ArrayList();
            allIdList.add(info.getId());
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            if (lockedList.size() > 0) {
                throw new BEException(BEException.COMMON, new Object[]{"\u5355\u636e\u5df2\u88ab\u9501\u5b9a" + this.commTag});
            }
        }
        if (methodName.equalsIgnoreCase("delete")) {
            object = parameters[1];
            if (object != null && object instanceof IObjectPK) {
                IObjectPK id = (IObjectPK)object;
                allIdList = new ArrayList<Object>();
                allIdList.add(id);
                this.requesMutexs(ctx, allIdList, correctList, lockedList);
                if (lockedList.size() > 0) {
                    throw new BEException(BEException.COMMON, new Object[]{"\u5355\u636e\u5df2\u88ab\u9501\u5b9a" + this.commTag});
                }
            }
        } else if (methodName.equalsIgnoreCase("batchSubmit") || methodName.equalsIgnoreCase("batchAudit") || methodName.equalsIgnoreCase("batchUnAudit") || methodName.equalsIgnoreCase("batchSubmitToBe")) {
            object = parameters[1];
            if (parameters[1] != null && parameters[1] instanceof Set) {
                Set idSet = (Set)parameters[1];
                allIdList = new ArrayList();
                allIdList.add(idSet);
                this.requesMutexs(ctx, allIdList, correctList, lockedList);
                if (lockedList != null && lockedList.size() > 0) {
                    throw new BEException(BEException.COMMON, new Object[]{"\u5355\u636e\u5df2\u88ab\u9501\u5b9a" + this.commTag});
                }
            } else if (object != null && object instanceof String[]) {
                String[] ids = (String[])object;
                allIdList = new ArrayList();
                for (int i = 0; i < ids.length; ++i) {
                    allIdList.add(ids[i]);
                }
                this.requesMutexs(ctx, allIdList, correctList, lockedList);
                if (lockedList != null && lockedList.size() > 0) {
                    throw new BEException(BEException.COMMON, new Object[]{"\u5355\u636e\u5df2\u88ab\u9501\u5b9a" + this.commTag});
                }
            }
        }
    }
}

