/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.TransUpModeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.subacct.ISubAccountBookFacade;
import com.kingdee.eas.fi.cas.subacct.SubAccountBookFacadeFactory;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransUpBillCollection;
import com.kingdee.eas.fm.be.BankTransUpBillEntryCollection;
import com.kingdee.eas.fm.be.BankTransUpBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransUpBillFactory;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.IBankTransUpBill;
import com.kingdee.eas.fm.common.CtrlNodeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.fs.ApplyTransUpFactory;
import com.kingdee.eas.fm.fs.ApplyTransUpInfo;
import com.kingdee.eas.fm.fs.ApplyTransUpStateEnum;
import com.kingdee.eas.fm.fs.AutoTransCollection;
import com.kingdee.eas.fm.fs.AutoTransFactory;
import com.kingdee.eas.fm.fs.AutoTransHistoryCollection;
import com.kingdee.eas.fm.fs.AutoTransHistoryFactory;
import com.kingdee.eas.fm.fs.AutoTransHistoryInfo;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.ITransUpBill;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.TransAmtInfo;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransDownBillHelper;
import com.kingdee.eas.fm.fs.TransUpBill2BankBillBuilder;
import com.kingdee.eas.fm.fs.TransUpBillBookNotifyBuilder;
import com.kingdee.eas.fm.fs.TransUpBillBookSubsidiaryProvider;
import com.kingdee.eas.fm.fs.TransUpBillCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryCollection;
import com.kingdee.eas.fm.fs.TransUpBillEntryFactory;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillHelper;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillStateEnum;
import com.kingdee.eas.fm.fs.app.AbstractTransUpBillFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransUpBillFacadeControllerBean
extends AbstractTransUpBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)TransUpBillFacadeControllerBean.class.getName());
    private static final String resClassName = "com.kingdee.eas.fm.fs.TransBillResource";

    @Override
    protected Map _getTransUpAcctBankAmt(Context ctx, String motherAcctBankId, String currencyId, Date date) throws BOSException, EASBizException {
        date = new Date();
        HashMap<String, TransAmtInfo> map = new HashMap<String, TransAmtInfo>();
        AccountBankCollection acctBankColl = TransUpBillHelper.getTransUpAcctBankColl(ctx, motherAcctBankId, date);
        Map balanceMap = TransUpBillHelper.getAcctBankBalance(ctx, acctBankColl, currencyId, date);
        AccountBankInfo acctBankInfo = null;
        AccountMgrStrategyInfo acctMgrInfo = null;
        TransAmtInfo transAmtInfo = null;
        TransUpModeEnum mode = null;
        String key = null;
        BigDecimal balance = Constants.ZERO;
        BigDecimal transUpAmt = Constants.ZERO;
        int size = acctBankColl.size();
        for (int i = 0; i < size; ++i) {
            acctBankInfo = acctBankColl.get(i);
            acctMgrInfo = acctBankInfo.getCtrlStrategy();
            mode = acctMgrInfo.getTransUpMode();
            key = acctBankInfo.getId().toString() + "_" + currencyId;
            balance = (BigDecimal)balanceMap.get(key);
            if (balance == null) {
                balance = Constants.ZERO;
            }
            transUpAmt = Constants.ZERO;
            BigDecimal transUpMinAmt = acctMgrInfo.getTransUpMinAmt();
            if (transUpMinAmt == null) {
                transUpMinAmt = Constants.ZERO;
            }
            if (mode.equals((Object)TransUpModeEnum.FULL)) {
                if (balance.compareTo(transUpMinAmt) >= 0) {
                    transUpAmt = balance;
                }
            } else if (mode.equals((Object)TransUpModeEnum.NORM)) {
                if (balance.compareTo(acctMgrInfo.getTransUpNormAmt()) >= 0) {
                    transUpAmt = acctMgrInfo.getTransUpNormAmt();
                }
            } else if (mode.equals((Object)TransUpModeEnum.BASE)) {
                if (balance.subtract(acctMgrInfo.getTransUpBaseAmt()).compareTo(transUpMinAmt) >= 0) {
                    transUpAmt = balance.subtract(acctMgrInfo.getTransUpBaseAmt());
                }
            } else if (mode.equals((Object)TransUpModeEnum.HAND)) {
                transUpAmt = Constants.ZERO;
            } else if (mode.equals((Object)TransUpModeEnum.INC) && balance.subtract(acctMgrInfo.getTransUpBaseAmt()).compareTo(acctMgrInfo.getTransUpIncAmt()) >= 0 && acctMgrInfo.getTransUpIncAmt().compareTo(BigDecimal.ZERO) == 1) {
                BigDecimal N = balance.subtract(acctMgrInfo.getTransUpBaseAmt()).divideToIntegralValue(acctMgrInfo.getTransUpIncAmt());
                transUpAmt = acctMgrInfo.getTransUpIncAmt().multiply(N);
            }
            transAmtInfo = new TransAmtInfo();
            transAmtInfo.setAcctBank(acctBankInfo);
            transAmtInfo.setCurrencyId(currencyId);
            transAmtInfo.setUnit(acctBankInfo.getCompany());
            transAmtInfo.setUnitInnerAcct(acctBankInfo.getInnerAcct());
            transAmtInfo.setAmount(transUpAmt);
            map.put(key, transAmtInfo);
        }
        return map;
    }

    @Override
    protected Map _getTransUpAcctBankAmt(Context ctx, Set acctBankUnitSet, String currencyId, Date date) throws BOSException, EASBizException {
        date = new Date();
        HashMap<String, TransAmtInfo> map = new HashMap<String, TransAmtInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = this.getBankAcntSelector();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)acctBankUnitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        AccountBankCollection acctBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        Map balanceMap = TransUpBillHelper.getAcctBankBalance(ctx, acctBankColl, currencyId, date);
        AccountBankInfo acctBankInfo = null;
        AccountMgrStrategyInfo acctMgrInfo = null;
        TransAmtInfo transAmtInfo = null;
        TransUpModeEnum mode = null;
        String key = null;
        BigDecimal balance = Constants.ZERO;
        BigDecimal transUpAmt = Constants.ZERO;
        int size = acctBankColl.size();
        for (int i = 0; i < size; ++i) {
            acctBankInfo = acctBankColl.get(i);
            key = acctBankInfo.getId().toString() + "_" + currencyId;
            balance = (BigDecimal)balanceMap.get(key);
            if (balance == null) {
                balance = Constants.ZERO;
            }
            transUpAmt = Constants.ZERO;
            acctMgrInfo = acctBankInfo.getCtrlStrategy();
            if (acctMgrInfo == null) {
                transAmtInfo = new TransAmtInfo();
                transAmtInfo.setBalance(balance);
                transAmtInfo.setAmount(transUpAmt);
                map.put(key, transAmtInfo);
                continue;
            }
            mode = acctMgrInfo.getTransUpMode();
            BigDecimal transUpMinAmt = acctMgrInfo.getTransUpMinAmt();
            if (transUpMinAmt == null) {
                transUpMinAmt = Constants.ZERO;
            }
            if (mode.equals((Object)TransUpModeEnum.FULL)) {
                if (balance.compareTo(transUpMinAmt) >= 0) {
                    transUpAmt = balance;
                }
            } else if (mode.equals((Object)TransUpModeEnum.NORM)) {
                if (balance.compareTo(acctMgrInfo.getTransUpNormAmt()) >= 0) {
                    transUpAmt = acctMgrInfo.getTransUpNormAmt();
                }
            } else if (mode.equals((Object)TransUpModeEnum.BASE)) {
                if (balance.subtract(acctMgrInfo.getTransUpBaseAmt()).compareTo(transUpMinAmt) >= 0) {
                    transUpAmt = balance.subtract(acctMgrInfo.getTransUpBaseAmt());
                }
            } else if (mode.equals((Object)TransUpModeEnum.HAND)) {
                transUpAmt = Constants.ZERO;
            } else if (mode.equals((Object)TransUpModeEnum.INC) && balance.subtract(acctMgrInfo.getTransUpBaseAmt()).compareTo(acctMgrInfo.getTransUpIncAmt()) >= 0 && acctMgrInfo.getTransUpIncAmt().compareTo(BigDecimal.ZERO) == 1) {
                BigDecimal N = balance.subtract(acctMgrInfo.getTransUpBaseAmt()).divideToIntegralValue(acctMgrInfo.getTransUpIncAmt());
                transUpAmt = acctMgrInfo.getTransUpIncAmt().multiply(N);
            }
            if (!EmptyUtil.isEmpty((Object)transUpMinAmt) && acctMgrInfo.isIsFromBC() && !acctBankInfo.isIsSetBankInterface()) {
                transUpAmt = Constants.ZERO;
            }
            transAmtInfo = new TransAmtInfo();
            transAmtInfo.setBalance(balance);
            transAmtInfo.setAcctBank(acctBankInfo);
            transAmtInfo.setCurrencyId(currencyId);
            transAmtInfo.setUnit(acctBankInfo.getCompany());
            transAmtInfo.setUnitInnerAcct(acctBankInfo.getInnerAcct());
            transAmtInfo.setAmount(transUpAmt);
            map.put(key, transAmtInfo);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransUpBillCollection coll = this.getColl(ctx, idSet);
        TransUpBillInfo info = null;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(new ArrayList(idSet));
            for (Object id : idSet) {
                Boolean boolResult = (Boolean)resultRequest.get(id);
                if (!boolResult.booleanValue()) continue;
                appliedList.add(id);
            }
            if (appliedList.size() < idSet.size()) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
            }
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                if (info.getState().getValue() != 2) {
                    throw new TransBillException(TransBillException.STATEERRORAUDIT);
                }
                FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info, (CtrlNodeEnum)CtrlNodeEnum.audit);
                this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), false);
                FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CtrlNodeEnum)CtrlNodeEnum.audit);
            }
            String ids = FMHelper.setTran2String((Set)idSet);
            String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
            String sql = "UPDATE T_FS_TransUpBill SET FState = ?, FAuditorId = ? WHERE FId IN " + ids;
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), userId});
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, boolean isWfInvoked) throws BOSException, EASBizException {
        if (!isWfInvoked) {
            return;
        }
        TransUpBillInfo info = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillInfo(pk);
        if (info.getState().getValue() != 2) {
            throw new TransBillException(TransBillException.STATEERRORAUDIT);
        }
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String sql = "UPDATE T_FS_TransUpBill SET FState = ?, FAuditorId = ? WHERE FId = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), userId, info.getId().toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransUpBillCollection coll = this.getColl(ctx, idSet);
        TransUpBillInfo info = null;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(new ArrayList(idSet));
            for (Object id : idSet) {
                Boolean boolResult = (Boolean)resultRequest.get(id);
                if (!boolResult.booleanValue()) continue;
                appliedList.add(id);
            }
            if (appliedList.size() < idSet.size()) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
            }
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                if (info.getState().getValue() != 3) {
                    throw new TransBillException(TransBillException.STATEERRORANTIAUDIT);
                }
                if (info.isIsCommittoBe()) {
                    throw new TransBillException(TransBillException.COMMITTOBECANUNTIAUDIT);
                }
                this.antiAudit4WF(ctx, info.getId().toString());
                FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CtrlNodeEnum)CtrlNodeEnum.audit);
            }
            String ids = FMHelper.setTran2String((Set)idSet);
            String sql = "UPDATE T_FS_TransUpBill SET FState = ?, FAuditorId = Null WHERE FId IN " + ids;
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2)});
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    @Override
    protected void _antiAudit4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _confirm(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        TransUpBillInfo upInfo = (TransUpBillInfo)info;
        this.checkBeforeConfirm(ctx, upInfo, TransUpBillStateEnum.AUDITED);
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info, (CtrlNodeEnum)CtrlNodeEnum.confirm);
        String billId = upInfo.getId().toString();
        this.updateConfirmInfo(ctx, upInfo);
        this.bookSubsidiaryLedger(ctx, billId);
        this.bookBankJournal(ctx, billId);
        BOSUuid tempCompanyID = null;
        try {
            CompanyOrgUnitInfo billOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(upInfo.getCompany().getId().toString()));
            if (billOrgUnit != null && billOrgUnit.getCU() != null) {
                if (billOrgUnit.isIsCU() && !ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().equals((Object)billOrgUnit.getId())) {
                    tempCompanyID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                    ContextUtil.getCurrentCtrlUnit((Context)ctx).setId(billOrgUnit.getId());
                } else if (!ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().equals((Object)billOrgUnit.getCU().getId())) {
                    tempCompanyID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                    ContextUtil.getCurrentCtrlUnit((Context)ctx).setId(billOrgUnit.getCU().getId());
                }
            }
            this.sendReceipt(ctx, upInfo, true, false);
        }
        finally {
            if (tempCompanyID != null) {
                ContextUtil.getCurrentCtrlUnit((Context)ctx).setId(tempCompanyID);
            }
        }
        this.confirm4WF(ctx, upInfo);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(upInfo.getId()), (CtrlNodeEnum)CtrlNodeEnum.confirm);
        this.disposeFromApplyTransUpByConfirmAndUnConfirm(ctx, upInfo, true);
        return 1;
    }

    private void checkBeforeConfirm(Context ctx, TransUpBillInfo upInfo, TransUpBillStateEnum billState) throws EASBizException, BOSException {
        TransUpBillEntryCollection entryColl = upInfo.getEntrys();
        boolean isNoneConfirm = true;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            if (!entryColl.get(i).isIsSuccessed()) continue;
            isNoneConfirm = false;
            break;
        }
        if (isNoneConfirm) {
            throw new TransBillException(TransBillException.UPCONFIRMERRORNOSUCCESS);
        }
        TransUpBillInfo dbInfo = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillInfo((IObjectPK)new ObjectUuidPK(upInfo.getId().toString()));
        if (billState.getValue() == 3 && dbInfo.getState() != billState) {
            throw new TransBillException(TransBillException.STATEERRORUPCONFIRM);
        }
        if (billState.getValue() == 4 && dbInfo.getState() != billState) {
            throw new TransBillException(TransBillException.STATEERRORCONFIRMCHANGE1, new Object[]{dbInfo.getNumber()});
        }
    }

    private void updateConfirmInfo(Context ctx, TransUpBillInfo upInfo) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((CoreBaseInfo)upInfo.getCashier())) {
            UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            upInfo.setCashier(user);
        }
        upInfo.setState(TransUpBillStateEnum.CONFIRMED);
        ObjectUuidPK pk = new ObjectUuidPK(upInfo.getId());
        TransUpBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)upInfo);
    }

    private void bookSubsidiaryLedger(Context ctx, String billId) throws BOSException, EASBizException {
        ISubsidiaryLedger facade = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        facade.book(billId, TransUpBillBookSubsidiaryProvider.class.getName());
    }

    private void bookBankJournal(Context ctx, String billId) throws BOSException, EASBizException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.book(TransUpBillBookNotifyBuilder.class.getName(), billId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _unConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransUpBillCollection coll = this.getColl(ctx, idSet);
        TransUpBillInfo info = null;
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(new ArrayList(idSet));
            for (Object id : idSet) {
                Boolean boolResult = (Boolean)resultRequest.get(id);
                if (!boolResult.booleanValue()) continue;
                appliedList.add(id);
            }
            if (appliedList.size() < idSet.size()) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
            }
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                this.unConfimCheck(info, true);
                FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CtrlNodeEnum)CtrlNodeEnum.confirm);
                this.disposeFromApplyTransUpByConfirmAndUnConfirm(ctx, info, false);
                numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
            }
            this.antiBook(ctx, idSet);
            this.updateUnConfrimProp(ctx, coll);
            int size2 = coll.size();
            for (int i = 0; i < size2; ++i) {
                this.withdrawReceipt(ctx, coll.get(i), true);
                this.unConfirm4WF(ctx, coll.get(i).getId().toString());
            }
            if (coll.size() > 0 && numbers != "") {
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_Unconfirm", (String)companyID, (String)"\u4e0a\u5212\u5355\u4e0a\u5212\u53cd\u786e\u8ba4");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            int n = size2;
            return n;
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    @Override
    protected Map _confirmChange(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        TransUpBillInfo upInfo = (TransUpBillInfo)info;
        this.unConfimCheck(upInfo, false);
        this.checkBeforeConfirm(ctx, upInfo, TransUpBillStateEnum.CONFIRMED);
        if (this.isHistoryBill(ctx, upInfo)) {
            throw new TransBillException(TransBillException.HISTROYBILLNOTSUPPORT);
        }
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(upInfo.getId()), (CtrlNodeEnum)CtrlNodeEnum.confirm);
        this.disposeFromApplyTransUpByConfirmAndUnConfirm(ctx, upInfo, false);
        upInfo = this.getChangeEntryInfo(ctx, upInfo);
        this.withdrawReceipt(ctx, upInfo, false);
        this.disposeBook(ctx, upInfo);
        this.sendReceipt(ctx, upInfo, true, true);
        this.disposeFromApplyTransUpByConfirmAndUnConfirm(ctx, upInfo, true);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(upInfo.getId()), (CtrlNodeEnum)CtrlNodeEnum.confirm);
        return null;
    }

    private boolean isHistoryBill(Context ctx, TransUpBillInfo info) throws BOSException, EASBizException {
        boolean isHistoryBill = false;
        ISubsidiaryLedger iSub = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        isHistoryBill = iSub.exists(" where billid='" + info.getId() + "'");
        if (isHistoryBill) {
            return true;
        }
        TransUpBillEntryInfo entryInfo = null;
        Iterator it = info.getEntrys().iterator();
        while (it.hasNext()) {
            entryInfo = (TransUpBillEntryInfo)it.next();
            isHistoryBill = iSub.exists(" where billid='" + entryInfo.getId() + "'");
            if (!isHistoryBill) continue;
            isHistoryBill = false;
            break;
        }
        return isHistoryBill;
    }

    private void disposeBook(Context ctx, TransUpBillInfo info) throws BOSException, EASBizException {
        IBookNotifyFacade journalFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        ISubAccountBookFacade subAcctFacade = SubAccountBookFacadeFactory.getLocalInstance((Context)ctx);
        ISubsidiaryLedger subLedgerFacade = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        TransUpBillEntryInfo entryInfo = null;
        String ID = info.getId().toString();
        String entryId = null;
        boolean bankBookNotify = this.bankBookNotify(ctx, info);
        if (!bankBookNotify) {
            journalFacade.antiBook(ID);
            this.bookBankJournal(ctx, ID);
        }
        Iterator iter = info.getEntrys().iterator();
        while (iter.hasNext()) {
            entryInfo = (TransUpBillEntryInfo)iter.next();
            entryId = entryInfo.getId().toString();
            if (!entryInfo.isHasChange()) continue;
            try {
                if (entryInfo.isIsSuccessed()) {
                    this.bookSubsidiaryLedger(ctx, ID);
                    if (!bankBookNotify) continue;
                    this.bookBankJournal(ctx, ID);
                    continue;
                }
                if (bankBookNotify) {
                    journalFacade.antiBook(entryId);
                }
                subAcctFacade.antiBook(entryId);
                subLedgerFacade.cancelBook(entryId);
            }
            catch (Exception ex) {
                throw new TransBillException(TransBillException.TRANSUPANDDOWNENTRYPROCESSERROR, new Object[]{new Integer(entryInfo.getSeq()), ex.getMessage()});
            }
        }
    }

    private boolean bankBookNotify(Context ctx, TransUpBillInfo info) {
        boolean TM106;
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        String companyId = null;
        companyId = info.getCompany() != null ? info.getCompany().getId().toString() : localInstance.getCurrentCompany().getId().toString();
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(companyId));
        return val == 0 && (TM106 = localInstance.getBooleanParam("TM106", (IObjectPK)new ObjectUuidPK(companyId)));
    }

    private void unConfimCheck(TransUpBillInfo upInfo, boolean isUnConfirm) throws TransBillException {
        if (upInfo.getState().getValue() != 4) {
            if (isUnConfirm) {
                throw new TransBillException(TransBillException.STATEERRORUNCONFIRM1, new Object[]{upInfo.getNumber()});
            }
            throw new TransBillException(TransBillException.STATEERRORCONFIRMCHANGE1, new Object[]{upInfo.getNumber()});
        }
        if (upInfo.isFivouchered()) {
            if (isUnConfirm) {
                throw new TransBillException(TransBillException.STATEERRORUNCONFIRM2, new Object[]{upInfo.getNumber()});
            }
            throw new TransBillException(TransBillException.STATEERRORCONFIRMCHANGE2, new Object[]{upInfo.getNumber()});
        }
    }

    private TransUpBillInfo getChangeEntryInfo(Context ctx, TransUpBillInfo info) throws BOSException, EASBizException {
        TransUpBillEntryInfo entryInfo = null;
        TransUpBillEntryInfo oldEntryInfo = null;
        TransUpBillEntryCollection entryColl = info.getEntrys();
        for (int i = entryColl.size() - 1; i >= 0; --i) {
            entryInfo = entryColl.get(i);
            oldEntryInfo = TransUpBillEntryFactory.getLocalInstance(ctx).getTransUpBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getId()));
            if (entryInfo.isIsSuccessed() == oldEntryInfo.isIsSuccessed()) {
                entryInfo.setHasChange(false);
                continue;
            }
            entryInfo.setHasChange(true);
        }
        return info;
    }

    private void antiBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        IBookNotifyFacade journalFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        ISubAccountBookFacade subAcctFacade = SubAccountBookFacadeFactory.getLocalInstance((Context)ctx);
        ISubsidiaryLedger subLedgerFacade = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        String billId = null;
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            billId = iter.next().toString();
            journalFacade.antiBook(billId);
            subAcctFacade.antiBook(billId);
            subLedgerFacade.cancelBook(billId);
        }
        this.antiBookEntry(ctx, idSet);
    }

    private void antiBookEntry(Context ctx, Set idSet) throws BOSException, EASBizException {
        IBookNotifyFacade journalFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        ISubAccountBookFacade subAcctFacade = SubAccountBookFacadeFactory.getLocalInstance((Context)ctx);
        ISubsidiaryLedger subLedgerFacade = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add("id");
        TransUpBillEntryCollection colls = TransUpBillEntryFactory.getLocalInstance(ctx).getTransUpBillEntryCollection(evi);
        TransUpBillEntryInfo entryInfo = null;
        Iterator iter = colls.iterator();
        while (iter.hasNext()) {
            entryInfo = (TransUpBillEntryInfo)iter.next();
            journalFacade.antiBook(entryInfo.getId().toString());
            subAcctFacade.antiBook(entryInfo.getId().toString());
            subLedgerFacade.cancelBook(entryInfo.getId().toString());
        }
    }

    private void updateUnConfrimProp(Context ctx, TransUpBillCollection coll) throws EASBizException, BOSException {
        ITransUpBill iTransUp = TransUpBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = null;
        TransUpBillInfo info = null;
        TransUpBillEntryCollection entryColl = null;
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            entryColl = info.getEntrys();
            int entrySize = entryColl.size();
            for (int j = 0; j < entrySize; ++j) {
                entryColl.get(j).setIsSuccessed(false);
                entryColl.get(j).setHasChange(true);
            }
            info.setConfirmedAmt(Constants.ZERO);
            info.setConfirmedCounts(0);
            info.setConfirmedLocalAmt(Constants.ZERO);
            info.setState(TransUpBillStateEnum.AUDITED);
            info.setCashier(null);
            numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
            pk = new ObjectUuidPK(info.getId());
            iTransUp.update((IObjectPK)pk, (CoreBaseInfo)info);
        }
    }

    @Override
    protected int _sendReceipt(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransUpBillCollection coll = this.getColl(ctx, idSet);
        int successCounts = 0;
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.get(i).getState().equals((Object)TransUpBillStateEnum.CONFIRMED)) {
                throw new TransBillException(TransBillException.STATEERRORSENDRECEIPT, new Object[]{coll.get(i).getNumber()});
            }
            successCounts += this.sendReceipt(ctx, coll.get(i), false, false);
            numbers = EmptyUtil.isEmpty((String)numbers) ? coll.get(i).getNumber() : numbers + "," + coll.get(i).getNumber();
            this.sendReceipt4WF(ctx, coll.get(i).getId().toString());
        }
        if (coll.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_sendrecipt", (String)companyID, (String)"\u4e0a\u5212\u5355\u53d1\u9001\u56de\u5355");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return successCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendReceipt(Context ctx, TransUpBillInfo info, boolean isSendWithConfirm, boolean isConfirmChange) throws BOSException, EASBizException {
        TransUpBillInfo cloneInfo = (TransUpBillInfo)info.clone();
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        TransUpBillEntryCollection entryColl = cloneInfo.getEntrys();
        TransUpBillEntryCollection entryCollOld = info.getEntrys();
        TransUpBillEntryInfo entryInfoOld = null;
        TransUpBillEntryInfo entryInfo = null;
        CompanyOrgUnitInfo company = null;
        boolean isConfirm = info.getState() == TransUpBillStateEnum.CONFIRMED;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestBizObjIDForUpdate(info.getId().toString());
            if (!isLock) {
                throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
            }
            int successCounts = 0;
            for (int i = entryColl.size() - 1; i >= 0; --i) {
                entryInfo = entryColl.get(i);
                entryInfoOld = entryCollOld.get(i);
                if (isConfirm && isSendWithConfirm) {
                    entryInfo.setIsSendReceipt(false);
                    entryInfo.setReceiptBillId(null);
                    entryInfoOld.setIsSendReceipt(false);
                    entryInfoOld.setReceiptBillId(null);
                }
                if (!entryInfo.isIsSuccessed() || entryInfo.isIsSendReceipt() || isConfirmChange && !entryInfoOld.isHasChange()) {
                    entryColl.remove(entryInfo);
                    continue;
                }
                company = entryInfo.getUnit();
                if (isSendWithConfirm && !this.isAutoSendReceipt(ctxHelper, company.getId())) {
                    entryColl.remove(entryInfo);
                    continue;
                }
                entryInfo.setIsSendReceipt(true);
                entryInfoOld.setIsSendReceipt(true);
                ++successCounts;
            }
            if (!isSendWithConfirm && entryColl.isEmpty()) {
                throw new TransBillException(TransBillException.STATEERRORSENDRECEIPT2, new Object[]{info.getNumber()});
            }
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            TransUpBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
            if (entryColl.isEmpty()) {
                int n = 0;
                return n;
            }
            CoreBillBaseCollection srcBillColl = new CoreBillBaseCollection();
            srcBillColl.add((CoreBillBaseInfo)cloneInfo);
            BOSObjectType destObjType = new PaymentBillInfo().getBOSType();
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_transupbill_sendrecipt", (String)info.getCompany().getId().toString(), (String)"\u4e0a\u5212\u5355\u53d1\u9001\u56de\u5355");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            this.botpTransfromSubmit(ctx, srcBillColl, destObjType);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            int n = successCounts;
            return n;
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(info.getId().toString());
            }
        }
    }

    private void botpTransfromSubmit(Context ctx, CoreBillBaseCollection transUpBillCol, BOSObjectType destObjType) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(transUpBillCol, destObjType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        CoreBillBaseInfo destBillInfo = null;
        PaymentBillInfo paymentBillInfo = null;
        TransUpBillInfo transUpBill = (TransUpBillInfo)transUpBillCol.get(0);
        TransUpBillEntryInfo transUpBillEntry = null;
        Object accoutBankInfo = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (CoreBillBaseInfo)destBillColl.getObject(i);
            paymentBillInfo = (PaymentBillInfo)destBillInfo;
            if (paymentBillInfo.getEntries() == null || paymentBillInfo.getEntries().size() <= 0) continue;
            String sourceEntryId = paymentBillInfo.getEntries().get(0).getSourceBillEntryId();
            transUpBillEntry = this.getSourceEntry(transUpBill, sourceEntryId);
            BigDecimal payAmt = Constants.ZERO;
            BigDecimal payLocAmt = Constants.ZERO;
            PaymentBillEntryCollection paymentBillcoll = paymentBillInfo.getEntries();
            for (int j = 0; j < paymentBillcoll.size(); ++j) {
                PaymentBillEntryInfo entryInfo = paymentBillcoll.get(j);
                payAmt = entryInfo.getActualAmt().add(payAmt);
                payLocAmt = entryInfo.getActualLocAmt().add(payLocAmt);
            }
            paymentBillInfo.setActPayAmt(payAmt);
            paymentBillInfo.setActPayLocAmt(payLocAmt);
            paymentBillInfo.setSourceSysType(com.kingdee.eas.fi.cas.SourceTypeEnum.FS);
            colls.add((CoreBaseInfo)paymentBillInfo);
        }
        Result addnewResult = PaymentBillFactory.getLocalInstance((Context)ctx).addnew(colls);
        for (int i = 0; i < addnewResult.size(); ++i) {
            Exception lineEx = addnewResult.getLineResult(i).getException();
            if (lineEx == null) continue;
            logger.error((Object)lineEx.getMessage(), (Throwable)lineEx);
            throw new BEException(BEException.COMMON, new Object[]{lineEx.getMessage()});
        }
        iBTPManager.submitRelations(botRelateColl);
        this.reverseTransUpBill(ctx, botRelateColl, destBillInfo);
    }

    private TransUpBillEntryInfo getSourceEntry(TransUpBillInfo sourceBill, String sourceBillEntryId) {
        if (sourceBill != null && sourceBill.getEntrys() != null) {
            TransUpBillEntryInfo entryInfo = null;
            for (int i = 0; i < sourceBill.getEntrys().size(); ++i) {
                entryInfo = sourceBill.getEntrys().get(i);
                if (entryInfo == null || !sourceBillEntryId.equals(entryInfo.getId().toString())) continue;
                return entryInfo;
            }
            return null;
        }
        return null;
    }

    private AccountBankInfo getBankAccountForSubAccountAndUnit(Context ctx, TransUpBillEntryInfo transUpBillEntry) throws BOSException, EASBizException {
        InnerAccountInfo subAcctInnerAcct = null;
        if (transUpBillEntry.getUnitAcctBank() != null) {
            AccountBankInfo info = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(transUpBillEntry.getUnitAcctBank().getId().toString()));
            transUpBillEntry.setUnitAcctBank(info);
        }
        if (transUpBillEntry.getUnitAcctBank() == null || transUpBillEntry.getUnitAcctBank().getInnerAcct() == null) {
            return null;
        }
        subAcctInnerAcct = transUpBillEntry.getUnitAcctBank().getInnerAcct();
        if (transUpBillEntry.getUnit() == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)transUpBillEntry.getUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", (Object)subAcctInnerAcct.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bank.inGroup", (Object)"1"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("account.*");
        AccountBankCollection ac = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        if (ac != null && ac.size() == 1) {
            return ac.get(0);
        }
        return null;
    }

    private void reverseTransUpBill(Context ctx, BOTRelationCollection botRelateColl, CoreBillBaseInfo destBillInfo) throws BOSException {
        String sql = "update T_FS_TransUpBillEntry set FReceiptBillId=?,FIsSendReceipt = 1 where fid = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < botRelateColl.size(); ++i) {
                BOTRelationInfo relation = botRelateColl.get(i);
                this.reverseTransUpBillEntry(ctx, relation.getRelationEntries(), stmt);
            }
            stmt.executeBatch();
            this.reverseTransUpBillStatus(ctx, destBillInfo);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private void reverseTransUpBillEntry(Context ctx, BOTRelationEntryCollection entryCollection, PreparedStatement stmt) throws BOSException {
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            BOTRelationEntryInfo tmpInfo = entryCollection.get(i);
            try {
                stmt.setString(1, tmpInfo.getDestObjectID());
                stmt.setString(2, tmpInfo.getSrcEntryID());
                stmt.addBatch();
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void reverseTransUpBillStatus(Context ctx, CoreBillBaseInfo destBillInfo) throws BOSException {
        String sql = "update T_FS_TransUpBill set FIsSendReceipt = 1 where fid = (select top 1 FParentID from T_FS_TransUpBillEntry where FReceiptBillId = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{destBillInfo.getId().toString()});
    }

    private boolean isAutoSendReceipt(IContextHelper ctxHelper, BOSUuid companyId) {
        return ctxHelper.getBooleanParam("CS012", (IObjectPK)new ObjectUuidPK(companyId));
    }

    @Override
    protected int _withdrawReceipt(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransUpBillCollection coll = this.getColl(ctx, idSet);
        TransUpBillInfo info = null;
        int successCounts = 0;
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!this.hasSendReceipt(info)) {
                throw new TransBillException(TransBillException.STATEERRORWITHDRAWRECEIPT, new Object[]{coll.get(i).getNumber()});
            }
            successCounts += this.withdrawReceipt(ctx, info, true);
            numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
            this.withdrawReceipt4WF(ctx, info.getId().toString());
        }
        if (coll.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_withdrowreceipt", (String)companyID, (String)"\u4e0a\u5212\u5355\u64a4\u9500\u56de\u5355");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return successCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int withdrawReceipt(Context ctx, TransUpBillInfo info, boolean isUnConfirm) throws BOSException, EASBizException {
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        TransUpBillEntryCollection entryColl = info.getEntrys();
        TransUpBillEntryInfo entryInfo = null;
        ObjectUuidPK receiptPk = null;
        int successCounts = 0;
        for (int i = entryColl.size() - 1; i >= 0; --i) {
            entryInfo = entryColl.get(i);
            if (!entryInfo.isHasChange() && !isUnConfirm || !entryInfo.isIsSendReceipt() || FMHelper.isEmpty((String)entryInfo.getReceiptBillId())) continue;
            receiptPk = new ObjectUuidPK(entryInfo.getReceiptBillId());
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            try {
                Boolean resultRequest = iMutex.requestObjIDForUpdate(entryInfo.getReceiptBillId());
                if (!resultRequest.booleanValue()) {
                    throw new TransBillException(TransBillException.TRANSUPBILLLOCKED, new Object[]{info.getNumber(), entryInfo.getUnit().getName()});
                }
                if (iPaymentBill.exists((IObjectPK)receiptPk)) {
                    this.deletePaymentBill(isUnConfirm, iPaymentBill, entryInfo, (IObjectPK)receiptPk);
                }
            }
            finally {
                iMutex.releaseObjIDForUpdate(entryInfo.getReceiptBillId());
            }
            entryInfo.setIsSendReceipt(false);
            entryInfo.setReceiptBillId(null);
            ++successCounts;
        }
        if (successCounts > 0) {
            IObjectPK withdrowreceiptPkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_transupbill_withdrowreceipt", (String)info.getCompany().getId().toString(), (String)"\u4e0a\u5212\u5355\u64a4\u9500\u56de\u5355");
            LogUtil.afterLog((Context)ctx, (IObjectPK)withdrowreceiptPkOut);
        }
        info.setIsSendReceipt(false);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        TransUpBillFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
        return successCounts;
    }

    private void deletePaymentBill(boolean isUnConfirm, IPaymentBill iPaymentBill, TransUpBillEntryInfo entryInfo, IObjectPK receiptPk) throws BOSException, EASBizException, BEException {
        if (isUnConfirm) {
            iPaymentBill.delete(receiptPk);
        } else {
            try {
                iPaymentBill.delete(receiptPk);
            }
            catch (Exception ex) {
                throw new TransBillException(TransBillException.TRANSUPANDDOWNENTRYPROCESSERROR, new Object[]{new Integer(entryInfo.getSeq()), ex.getMessage()});
            }
        }
    }

    @Override
    protected boolean _hasSendReceipt(Context ctx, Set idSet) throws BOSException, EASBizException {
        TransUpBillCollection coll = this.getColl(ctx, idSet);
        TransUpBillInfo info = null;
        int size = coll.size();
        for (int index = 0; index < size; ++index) {
            info = coll.get(index);
            if (!this.hasSendReceipt(info)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSendReceipt(TransUpBillInfo info) {
        int size = info.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            if (!info.getEntrys().get(i).isIsSendReceipt()) continue;
            return true;
        }
        return false;
    }

    private TransUpBillCollection getColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("entrys.*");
        evi.getSelector().add("entrys.unit.*");
        evi.getSelector().add("entrys.subAcct.innerAccount.id");
        evi.getSelector().add("company.number");
        evi.getSelector().add("currency.number");
        evi.getSelector().add("project.name");
        evi.getSelector().add("project.number");
        evi.getSelector().add("outBgItemNumber");
        evi.getSelector().add("outBgItemName");
        evi.getSelector().add("fpItem.*");
        evi.getSelector().add("fundFlowItem.*");
        evi.getSelector().add("mbgNumber");
        evi.getSelector().add("mbgName");
        evi.getSelector().add("entrys.project.number");
        evi.getSelector().add("entrys.project.name");
        evi.getSelector().add("entrys.feeType.number");
        evi.getSelector().add("entrys.feeType.name");
        evi.getSelector().add("settleType.number");
        evi.getSelector().add("settleType.name");
        evi.getSelector().add("motherAcctBank.number");
        evi.getSelector().add("motherAcctBank.name");
        evi.getSelector().add("motherAcctBank.bank.number");
        evi.getSelector().add("motherAcctBank.bank.name");
        ITransUpBill iTrans = TransUpBillFactory.getLocalInstance(ctx);
        return iTrans.getTransUpBillCollection(evi);
    }

    @Override
    protected IObjectPK _commitToBE(Context ctx, Set idSet) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillFacadeControllerBean._commitToBE");
        if (idSet.size() > 1) {
            throw new BEException(BEException.NOTALLOWBATCHSUBMIT);
        }
        String pfLogId1 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillFacadeControllerBean._commitToBE.afterCommitToBe");
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        for (String transUpBillID : idSet) {
            String sql = "UPDATE T_FS_TransUpBill SET FID = FID WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{transUpBillID});
            TransUpBillInfo transUpBillInfo = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillInfo((IObjectPK)new ObjectUuidPK(transUpBillID), this.getSelectorForBe());
            this.beforeCommitToBe(ctx, transUpBillInfo);
            if (EmptyUtil.isEmpty((String)numbers)) {
                numbers = transUpBillInfo.getNumber();
                continue;
            }
            numbers = numbers + "," + transUpBillInfo.getNumber();
        }
        PerfLogRecorder.endRecord((String)pfLogId1);
        String builderName = TransUpBill2BankBillBuilder.class.getName();
        IBankTransUpBill iBankTransUpBill = BankTransUpBillFactory.getLocalInstance((Context)ctx);
        String billId2 = null;
        IObjectPK bankTransUpbillId = null;
        BankTransUpBillCollection coll = new BankTransUpBillCollection();
        for (String billId2 : idSet) {
            String pfLogId2 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillFacadeControllerBean._commitToBE.existsTransUpBill");
            this.existsTransUpBill(ctx, billId2);
            PerfLogRecorder.endRecord((String)pfLogId2);
            String pfLogId3 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillFacadeControllerBean._commitToBE.commit2BankTransUpBill");
            bankTransUpbillId = iBankTransUpBill.commit2BankTransUpBill(billId2, builderName);
            PerfLogRecorder.endRecord((String)pfLogId3);
            SelectorItemCollection sele = this.getSelectorForBe();
            String pfLogId4 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillFacadeControllerBean._commitToBE.getBankTransUpBillInfo");
            BankTransUpBillInfo info = BankTransUpBillFactory.getLocalInstance((Context)ctx).getBankTransUpBillInfo(bankTransUpbillId, sele);
            PerfLogRecorder.endRecord((String)pfLogId4);
            coll.add(info);
        }
        if (coll != null && coll.size() > 0) {
            try {
                String pfLogId5 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillFacadeControllerBean._commitToBE.transUp");
                BankFacadeFactory.getLocalInstance((Context)ctx).transUp(coll);
                PerfLogRecorder.endRecord((String)pfLogId5);
                String pfLogId6 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillFacadeControllerBean._commitToBE.save");
                BankTransUpBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)coll.get(0));
                PerfLogRecorder.endRecord((String)pfLogId6);
                String pfLogId7 = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TransUpBillFacadeControllerBean._commitToBE.reverseSrcBill");
                this.reverseSrcBill(ctx, coll.get(0));
                PerfLogRecorder.endRecord((String)pfLogId7);
            }
            catch (Exception e) {
                PerfLogRecorder.endRecord((String)pfLogId);
                throw new BEException(BEException.TRANSUPSUMMITFAILURE, new Object[]{e.getMessage()});
            }
        }
        if (numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_commitToBe", (String)companyID, (String)"\u4e0a\u5212\u5355\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        PerfLogRecorder.endRecord((String)pfLogId);
        return bankTransUpbillId;
    }

    @Override
    public void _autoCommitToBE4WF(Context ctx, String transUpBillId) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(transUpBillId);
        this._commitToBE(ctx, idSet);
    }

    private void reverseSrcBill(Context ctx, BankTransUpBillInfo bankTransUpBillInfo) throws EASBizException, BOSException {
        if (bankTransUpBillInfo == null || bankTransUpBillInfo.getSourceBillId() == null) {
            return;
        }
        BankTransUpBillEntryCollection bankColl = bankTransUpBillInfo.getEntrys();
        BankTransUpBillEntryInfo bankEntryInfo = null;
        HashMap<String, BankTransUpBillEntryInfo> bankMap = new HashMap<String, BankTransUpBillEntryInfo>();
        for (int i = 0; i < bankColl.size(); ++i) {
            bankEntryInfo = bankColl.get(i);
            bankMap.put(bankEntryInfo.getSrcBillNumber(), bankEntryInfo);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.bankState"));
        sic.add(new SelectorItemInfo("entrys.bankReturnInfo"));
        TransUpBillInfo billInfo = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillInfo((IObjectPK)new ObjectUuidPK(bankTransUpBillInfo.getSourceBillId()), sic);
        TransUpBillEntryCollection billColl = billInfo.getEntrys();
        TransUpBillEntryInfo billEntryInfo = null;
        for (int i = 0; i < billColl.size(); ++i) {
            billEntryInfo = billColl.get(i);
            bankEntryInfo = (BankTransUpBillEntryInfo)bankMap.get(billEntryInfo.getId().toString());
            if (bankEntryInfo == null) continue;
            billEntryInfo.setBankState(bankEntryInfo.getState());
            billEntryInfo.setBankReturnInfo(bankEntryInfo.getBankReturnInfo());
        }
        TransUpBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
    }

    private void existsTransUpBill(Context ctx, String billId) throws BOSException, EASBizException {
        String sql = "select fid from t_bot_relation where FDestEntityID='CBED6D88' and FSrcObjectID= ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        try {
            if (rs.next()) {
                throw new FSException(FSException.HASBANKPAYBILL);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        this.commitToBE4WF(ctx, billId);
    }

    private void beforeCommitToBe(Context ctx, TransUpBillInfo transUpBillInfo) throws BOSException, EASBizException {
        String sql = "UPDATE T_FS_TransUpBill SET  FIsCommittoBe = 1,FcommitBeTime= ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), transUpBillInfo.getId().toString()});
        if (!transUpBillInfo.getState().equals((Object)TransUpBillStateEnum.AUDITED)) {
            throw new TransBillException(TransBillException.NOTEQUAUDIT_SUBMITTOBE);
        }
        if (transUpBillInfo.isIsCommittoBe()) {
            throw new TransBillException(TransBillException.NOT_REPEAT_SUBMITTOBE);
        }
        if (transUpBillInfo.isIsCreatedFromTransDetail()) {
            throw new TransBillException(TransBillException.FROMTRANSDETAIL_NOT_SUBMITTOBE);
        }
        if (transUpBillInfo.getSettleType() == null) {
            throw new TransBillException(TransBillException.SETTLEMENTTYPE_CANNOT_BE_NULL);
        }
        if (!transUpBillInfo.getSettleType().isPayThroughBE()) {
            throw new TransBillException(TransBillException.FORBEMUSTHAVESETTLETYPE);
        }
        String tmpMsg = "";
        for (int j = 0; j < transUpBillInfo.getEntrys().size(); ++j) {
            TransUpBillEntryInfo entryInfo = transUpBillInfo.getEntrys().get(j);
            if (entryInfo.getUnitAcctBank() == null || !entryInfo.getUnitAcctBank().isIsSetBankInterface()) {
                String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"408_theEntryHasnotBe"), entryInfo.getUnit() == null ? "" : entryInfo.getUnit().getName(), entryInfo.getUnitAcctBank().getName());
                tmpMsg = tmpMsg + msg;
                continue;
            }
            try {
                if (!entryInfo.getUnitAcctBank().isIsOnlyRead()) continue;
                throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{entryInfo.getUnitAcctBank().getName()});
            }
            catch (Exception e) {
                String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"407_theEntry"), e.getMessage());
                tmpMsg = tmpMsg + msg;
            }
        }
        if (tmpMsg.length() > 1) {
            throw new FSException(FSException.COMMON, new String[]{tmpMsg});
        }
    }

    @Override
    protected void _cancelCommitToBE(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "UPDATE T_FS_TransUpBill set FIsCommittoBe=0 WHERE FID ='" + id + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _commitToBeAll(Context ctx, Set idSet, String bankTransUpbillId) throws BOSException, EASBizException {
        boolean debug = false;
        BankTransUpBillCollection coll = new BankTransUpBillCollection();
        SelectorItemCollection sele = this.getSelectorForBe();
        BankTransUpBillInfo info = BankTransUpBillFactory.getLocalInstance((Context)ctx).getBankTransUpBillInfo((IObjectPK)new ObjectUuidPK(bankTransUpbillId), sele);
        coll.add(info);
        if (info != null) {
            try {
                BankFacadeFactory.getLocalInstance((Context)ctx).transUp(coll);
            }
            catch (BEException e) {
                throw new BEException(BEException.SUMMITFAILURE, new Object[]{e.getMessage()});
            }
            catch (Exception err) {
                throw new BEException(BEException.SUMMITFAILURE, new Object[]{err.getMessage()});
            }
        }
    }

    private SelectorItemCollection getSelectorForBe() {
        SelectorItemCollection sele = new SelectorItemCollection();
        sele.add("*");
        sele.add("SettleType.*");
        sele.add("currency.*");
        sele.add("payAccountBank.*");
        sele.add("motherAcctBank.*");
        sele.add("entrys.*");
        sele.add("entrys.unitAcctBank.*");
        sele.add("entrys.unit.name");
        sele.add("motherAcctBank.bank.*");
        sele.add("motherAcctBank.bank.accountBank.*");
        return sele;
    }

    @Override
    protected void _commitToBE4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _confirm4WF(Context ctx, IObjectValue info) throws BOSException, EASBizException {
    }

    @Override
    protected void _sendReceipt4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _unConfirm4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _withdrawReceipt4WF(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _autoTransUp(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"255_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + DateTimeUtils.truncateDate((Date)new Date()) + "------------"));
        TransUpBillHelper helper = new TransUpBillHelper();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("transTime", (Object)("1970-01-01 " + DateUtil.getTime().getHours() + ":00:00.0"), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("transTime", (Object)("1970-01-01 " + DateUtil.getTime().getHours() + ":59:59.0"), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)Boolean.FALSE));
        view.setSelector(this.getSelectors());
        AutoTransCollection colls = AutoTransFactory.getLocalInstance(ctx).getAutoTransCollection(view);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"256_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + colls.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"240_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
        Map idMap = helper.genTransUpBills(ctx, colls);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"257_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + idMap.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"242_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
        if (idMap.size() > 0) {
            Set idSet = idMap.keySet();
            for (String id : idSet) {
                HashSet<String> transIdSet = new HashSet<String>();
                transIdSet.add(id);
                try {
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"258_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + id + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"244_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
                    IObjectPK bankTransUpBillId = TransUpBillFacadeFactory.getLocalInstance(ctx).commitToBE(transIdSet);
                    TransDownBillHelper.sendTransBillMessage(ctx, false, (AutoTransHistoryCollection)((Object)idMap.get(id)), true, true);
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"259_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + bankTransUpBillId));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"258_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + id + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"246_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
                    for (int i = 0; i < ((AutoTransHistoryCollection)((Object)idMap.get(id))).size(); ++i) {
                        AutoTransHistoryInfo sInfo = ((AutoTransHistoryCollection)((Object)idMap.get(id))).get(i);
                        if (!sInfo.getTransUpBill().getId().toString().equals(id)) continue;
                        sInfo.setDescription(FmBeHelper.cutString((String)e.getMessage()));
                        AutoTransHistoryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sInfo.getId()), (CoreBaseInfo)sInfo);
                    }
                    TransDownBillHelper.sendTransBillMessage(ctx, false, (AutoTransHistoryCollection)((Object)idMap.get(id)), true, false);
                }
            }
            helper.synBankTransUpBillState(ctx, idMap);
        }
        logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"260_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()));
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("transTime"));
        sic.add(new SelectorItemInfo("parentAcct.number"));
        sic.add(new SelectorItemInfo("parentAcct.name"));
        sic.add(new SelectorItemInfo("parentAcct.acctName"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("isUrgent"));
        sic.add(new SelectorItemInfo("isCommitBe"));
        sic.add(new SelectorItemInfo("entrys.transDownUnit.name"));
        sic.add(new SelectorItemInfo("entrys.transDownUnit.number"));
        sic.add(new SelectorItemInfo("entrys.transDownUnit.id"));
        sic.add(new SelectorItemInfo("entrys.unitAccount.name"));
        sic.add(new SelectorItemInfo("entrys.unitAccount.number"));
        sic.add(new SelectorItemInfo("entrys.unitAccount.id"));
        sic.add(new SelectorItemInfo("entrys.unitAccount.acctName"));
        sic.add(new SelectorItemInfo("entrys.description"));
        sic.add(new SelectorItemInfo("entrys.fpItem.name"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("entrys_project.name"));
        sic.add(new SelectorItemInfo("current.name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("parentAcct"));
        sic.add(new SelectorItemInfo("parentAcct.id"));
        sic.add(new SelectorItemInfo("entrys.project"));
        sic.add(new SelectorItemInfo("recProvince"));
        sic.add(new SelectorItemInfo("recCity"));
        return sic;
    }

    private void disposeFromApplyTransUpByConfirmAndUnConfirm(Context ctx, TransUpBillInfo model, boolean isConfim) throws BOSException, EASBizException {
        if (!this.isApplyTransUp(model)) {
            return;
        }
        HashSet<BOSUuid> billSet = new HashSet<BOSUuid>();
        HashSet idSet = new HashSet();
        billSet.add(model.getId());
        model = this.getColl(ctx, billSet).get(0);
        Iterator it = model.getEntrys().iterator();
        while (it.hasNext()) {
            TransUpBillEntryInfo transUpBillEntryInfo = (TransUpBillEntryInfo)it.next();
            if (!transUpBillEntryInfo.isIsSuccessed()) continue;
            this.mergeSet(idSet, transUpBillEntryInfo.getIdSet());
        }
        String ids = FMHelper.setTran2String(idSet);
        this.applyTransUpApprove(ctx, ids, isConfim);
    }

    private void applyTransUpApprove(Context ctx, String ids, boolean isApprove) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("update T_FS_ApplyTransUp set FIsApprove = ? where fid IN ");
        sb.append(ids);
        if (isApprove) {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{"1"});
        } else {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{"0"});
        }
    }

    private void mergeSet(Set set, String idString) {
        if (FMHelper.isEmpty((String)idString)) {
            return;
        }
        String[] idSet = idString.split(",");
        for (int i = 0; i < idSet.length; ++i) {
            set.add(idSet[i]);
        }
    }

    private boolean isApplyTransUp(TransUpBillInfo model) {
        return SourceTypeEnum.APPTRANSUP.equals((Object)model.getSourceType());
    }

    @Override
    protected void _rejectedApplyTransUp(Context ctx, IObjectPK pk, String rejectedRemark) throws BOSException, EASBizException {
        TransUpBillInfo transUpBillInfo = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillInfo(pk);
        ctx.put((Object)"rejectedApplyTransUp", (Object)"rejectedApplyTransUp");
        if (FMHelper.isEmpty((String)transUpBillInfo.getSourceBillId())) {
            try {
                transUpBillInfo.setSourceBillId(transUpBillInfo.getEntrys().get(0).getTransDetailId().toString());
            }
            catch (Exception ex) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"248_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())});
            }
        }
        Set idSet = FMHelper.getSrcBillIdSet((Context)ctx, (String)transUpBillInfo.getId().toString());
        CoreBaseCollection coll = new CoreBaseCollection();
        for (String srcId : idSet) {
            if (!BOSUuid.read((String)srcId).getType().equals((Object)new ApplyTransUpInfo().getBOSType())) continue;
            if (!ApplyTransUpFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(srcId))) {
                throw new FSException(FSException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"250_TransUpBillControllerBean", (Locale)ctx.getLocale())});
            }
            ApplyTransUpInfo applyTransUpInfo = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpInfo((IObjectPK)new ObjectUuidPK(srcId));
            applyTransUpInfo.setRejectRemark(rejectedRemark);
            applyTransUpInfo.setState(ApplyTransUpStateEnum.SAVE);
            applyTransUpInfo.setAuditDate(null);
            applyTransUpInfo.setAuditor(null);
            coll.add((CoreBaseInfo)applyTransUpInfo);
        }
        ApplyTransUpFactory.getLocalInstance(ctx).update(coll);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u4e0a\u5212\u5355\u6253\u56de", (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)transUpBillInfo.getNumber(), (String)"fs_transupbill_RejectedApplyTransUp");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        TransUpBillFactory.getLocalInstance(ctx).delete(pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCommitToBe(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        TransUpBillCollection transUpColl = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(evi);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < transUpColl.size(); ++i) {
            TransUpBillInfo transUpInfo = transUpColl.get(i);
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(transUpInfo.getId().toString());
            boolean isLock = false;
            try {
                IObjectPK userPK = ctx.getCaller();
                ObjectUuidPK orgPK = new ObjectUuidPK(transUpInfo.getCompany().getId());
                PermissionFactory.getLocalInstance((Context)ctx).checkDataPermission(userPK, (IObjectPK)orgPK, "TRANS_UP_DELETE_COMMITTOBE", (IObjectPK)new ObjectUuidPK(transUpInfo.getId()));
                isLock = iMutex.requestBizObjIDForUpdate(transUpInfo.getId().toString());
                if (!isLock) {
                    throw new FSException(FSException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"412_reqMutex_ERR")});
                }
                TransUpBillFacadeFactory.getLocalInstance(ctx).commitToBE(idSet);
                continue;
            }
            catch (Exception e) {
                errorMap.put(transUpInfo.getNumber(), e.getMessage());
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(transUpInfo.getId().toString());
                }
            }
        }
        map.put("errorMap", errorMap);
        return map;
    }

    @Override
    protected Map _batchConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> idMap = new HashMap<String, String>();
        TransUpBillCollection coll = this.getColl(ctx, idSet);
        TransUpBillInfo info = null;
        String msg = "";
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            TransUpBillEntryInfo entry;
            int k;
            info = coll.get(i);
            int successCount = 0;
            int failCount = 0;
            BigDecimal amt = new BigDecimal(0);
            BigDecimal localAmt = new BigDecimal(0);
            TransUpBillEntryCollection entrys = info.getEntrys();
            if (info.isIsCommittoBe()) {
                for (k = 0; k < entrys.size(); ++k) {
                    entry = entrys.get(k);
                    if (BankPayingBillStateEnum.TS.equals((Object)entry.getBankState())) {
                        entry.setIsSuccessed(true);
                        ++successCount;
                        amt = amt.add(entry.getAmount());
                        localAmt = localAmt.add(entry.getLocalAmt());
                        continue;
                    }
                    if (!BankPayingBillStateEnum.TF.equals((Object)entry.getBankState())) continue;
                    ++failCount;
                }
                if (failCount == entrys.size()) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"234_TransDownBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"450_TransBillConfirmFail", (Locale)ctx.getLocale());
                    idMap.put(info.getId().toString(), msg);
                    continue;
                }
                if (successCount + failCount < entrys.size()) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"234_TransDownBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"451_TransBillConfirmFail", (Locale)ctx.getLocale());
                    idMap.put(info.getId().toString(), msg);
                    continue;
                }
            } else {
                for (k = 0; k < entrys.size(); ++k) {
                    entry = entrys.get(k);
                    entry.setIsSuccessed(true);
                    ++successCount;
                    amt = amt.add(entry.getAmount());
                    localAmt = localAmt.add(entry.getLocalAmt());
                }
            }
            info.setConfirmedCounts(successCount);
            info.setConfirmedAmt(amt);
            info.setConfirmedLocalAmt(localAmt);
            try {
                TransUpBillFacadeFactory.getLocalInstance(ctx).confirm(info);
                continue;
            }
            catch (Exception e) {
                msg = ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"249_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + "\uff1a" + e.getMessage();
                idMap.put(info.getId().toString(), msg);
            }
        }
        return idMap;
    }

    @Override
    protected int _confirmRequires(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        return this._confirm(ctx, info);
    }

    @Override
    protected Set _getTransUpBankCheckFlags(Context ctx, String companyId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(beginDate);
        ((Calendar)cal).add(2, -1);
        beginDate = cal.getTime();
        cal.setTime(endDate);
        ((Calendar)cal).add(7, 3);
        endDate = cal.getTime();
        EntityViewInfo entityView = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("entrys.bankCheckFlag"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCommittoBe", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS));
        entityView.setSelector(selector);
        entityView.setFilter(filterInfo);
        ITransUpBill transUpBill = TransUpBillFactory.getLocalInstance(ctx);
        CoreBaseCollection transColls = transUpBill.getCollection(entityView);
        int size = transColls.size();
        for (int i = 0; i < size; ++i) {
            TransUpBillInfo billInfo = (TransUpBillInfo)transColls.get(i);
            TransUpBillEntryCollection entryCollection = billInfo.getEntrys();
            for (int j = 0; j < entryCollection.size(); ++j) {
                if (EmptyUtil.isEmpty((String)entryCollection.get(j).getBankCheckFlag())) continue;
                set.add(entryCollection.get(j).getBankCheckFlag());
            }
        }
        return set;
    }

    @Override
    protected void _confirmAfterSyncState(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.getSelector().add("id");
        ev.getSelector().add("number");
        ev.getSelector().add("company.*");
        ev.getSelector().add("sourceBillId");
        ev.getSelector().add("entrys.*");
        BankTransUpBillCollection billColl = BankTransUpBillFactory.getLocalInstance((Context)ctx).getBankTransUpBillCollection(ev);
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean isNeedConfirm = false;
        String successTotal = "select count(fid) from t_fs_transupbillentry where fissuccessed = 1 and fparentid = ?";
        HashMap<BOSUuid, Boolean> paramMap = new HashMap<BOSUuid, Boolean>();
        int size = billColl.size();
        for (int i = 0; i < size; ++i) {
            BankTransUpBillInfo bill = billColl.get(i);
            if (paramMap.containsKey(bill.getCompany().getId())) {
                isNeedConfirm = (Boolean)paramMap.get(bill.getCompany().getId());
            } else {
                isNeedConfirm = localInstance.getBooleanParam("TM019", (IObjectPK)new ObjectUuidPK(bill.getCompany().getId()));
                paramMap.put(bill.getCompany().getId(), isNeedConfirm);
            }
            try {
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)successTotal, (Object[])new String[]{bill.getSourceBillId()});
                if (!row.next() || row.getInt(1) != bill.getEntrys().size()) continue;
                TransUpBillInfo tranUpBillInfo = new TransUpBillInfo();
                HashSet<String> billSet = new HashSet<String>();
                billSet.add(bill.getSourceBillId());
                TransUpBillCollection transUpColl = this.getColl(ctx, billSet);
                if (transUpColl != null && transUpColl.size() > 0) {
                    tranUpBillInfo = transUpColl.get(0);
                }
                if (TransUpBillStateEnum.CONFIRMED.equals((Object)tranUpBillInfo.getState()) || !isNeedConfirm) continue;
                TransUpBillFacadeFactory.getLocalInstance(ctx).confirm(tranUpBillInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)(bill.getNumber() + EASResource.getString((String)resClassName, (String)"TRANSUPCONFIRMFAIL") + e));
            }
        }
    }

    @Override
    protected Map _batchAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Comparable<StringBuffer>> result = new HashMap<String, Comparable<StringBuffer>>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        TransUpBillCollection transUpColl = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(evi);
        StringBuffer failed = new StringBuffer();
        int success = 0;
        String number = EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"number");
        String LINE_SEPARATOR = System.getProperty("line.separator");
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        for (int i = 0; i < transUpColl.size(); ++i) {
            TransUpBillInfo transUpBillInfo = transUpColl.get(i);
            HashSet<String> id = new HashSet<String>();
            id.add(transUpBillInfo.getId().toString());
            try {
                TransUpBillFacadeFactory.getLocalInstance(ctx).audit(id);
                numbers = EmptyUtil.isEmpty((String)numbers) ? transUpBillInfo.getNumber() : numbers + "," + transUpBillInfo.getNumber();
                ++success;
                continue;
            }
            catch (EASBizException e) {
                failed.append(number + transUpBillInfo.getNumber() + e.getMessage() + LINE_SEPARATOR);
            }
        }
        if (transUpColl.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_audit", (String)companyID, (String)"\u4e0a\u5212\u5355\u5ba1\u6279");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        result.put("error", failed);
        result.put("success", Integer.valueOf(success));
        return result;
    }

    @Override
    protected Map _batchAntiAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Comparable<StringBuffer>> result = new HashMap<String, Comparable<StringBuffer>>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        TransUpBillCollection transUpColl = TransUpBillFactory.getLocalInstance(ctx).getTransUpBillCollection(evi);
        StringBuffer failed = new StringBuffer();
        int success = 0;
        String number = EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"number");
        String LINE_SEPARATOR = System.getProperty("line.separator");
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        for (int i = 0; i < transUpColl.size(); ++i) {
            TransUpBillInfo transUpBillInfo = transUpColl.get(i);
            HashSet<String> id = new HashSet<String>();
            id.add(transUpBillInfo.getId().toString());
            try {
                TransUpBillFacadeFactory.getLocalInstance(ctx).antiAudit(id);
                numbers = EmptyUtil.isEmpty((String)numbers) ? transUpBillInfo.getNumber() : numbers + "," + transUpBillInfo.getNumber();
                ++success;
                continue;
            }
            catch (EASBizException e) {
                failed.append(number + transUpBillInfo.getNumber() + e.getMessage() + LINE_SEPARATOR);
            }
        }
        if (transUpColl.size() > 0 && numbers != "") {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new TransUpBillInfo().getBOSType(), null, (String)numbers, (String)"fs_transupbill_Unaudit", (String)companyID, (String)"\u4e0a\u5212\u5355\u53cd\u5ba1\u6279");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        result.put("error", failed);
        result.put("success", Integer.valueOf(success));
        return result;
    }

    @Override
    protected void _autoTransUpByNumber(Context ctx, String number) throws BOSException, EASBizException {
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"255_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + DateTimeUtils.truncateDate((Date)new Date()) + "------------"));
        TransUpBillHelper helper = new TransUpBillHelper();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashSet<String> numberSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((String)number)) {
            String[] numbers = number.split(",");
            for (int i = 0; i < numbers.length; ++i) {
                numberSet.add(numbers[i]);
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)Boolean.FALSE));
        if (numberSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        }
        view.setSelector(this.getSelectors());
        AutoTransCollection colls = AutoTransFactory.getLocalInstance(ctx).getAutoTransCollection(view);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"256_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + colls.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"240_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
        Map idMap = helper.genTransUpBillsNew(ctx, colls);
        logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"257_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + idMap.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"242_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
        if (idMap.size() > 0) {
            Set idSet = idMap.keySet();
            for (String id : idSet) {
                HashSet<String> transIdSet = new HashSet<String>();
                transIdSet.add(id);
                try {
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"258_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + id + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"244_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
                    IObjectPK bankTransUpBillId = TransUpBillFacadeFactory.getLocalInstance(ctx).commitToBE(transIdSet);
                    TransDownBillHelper.sendTransBillMessage(ctx, false, (AutoTransHistoryCollection)((Object)idMap.get(id)), true, true);
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"259_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + bankTransUpBillId));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"258_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()) + id + ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"246_TransDownBillFacadeControllerBean", (Locale)ctx.getLocale())));
                    for (int i = 0; i < ((AutoTransHistoryCollection)((Object)idMap.get(id))).size(); ++i) {
                        AutoTransHistoryInfo sInfo = ((AutoTransHistoryCollection)((Object)idMap.get(id))).get(i);
                        if (!sInfo.getTransUpBill().getId().toString().equals(id)) continue;
                        sInfo.setDescription(FmBeHelper.cutString((String)e.getMessage()));
                        AutoTransHistoryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sInfo.getId()), (CoreBaseInfo)sInfo);
                    }
                    TransDownBillHelper.sendTransBillMessage(ctx, false, (AutoTransHistoryCollection)((Object)idMap.get(id)), true, false);
                }
            }
            helper.synBankTransUpBillState(ctx, idMap);
        }
        logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"260_TransUpBillFacadeControllerBean", (Locale)ctx.getLocale()));
    }

    public SelectorItemCollection getBankAcntSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("openDate"));
        sic.add(new SelectorItemInfo("closeDate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("property.id"));
        sic.add(new SelectorItemInfo("property.name"));
        sic.add(new SelectorItemInfo("isMotherAccount"));
        sic.add(new SelectorItemInfo("isSetBankInterface"));
        sic.add(new SelectorItemInfo("ctrlStrategy.id"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("InnerAcct.id"));
        sic.add(new SelectorItemInfo("InnerAcct.name"));
        sic.add(new SelectorItemInfo("InnerAcct.number"));
        sic.add(new SelectorItemInfo("InnerAcct.number"));
        sic.add(new SelectorItemInfo("InnerAcct.clearingHouse.relatedCompany"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("subAccount.id"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("subAccount.number"));
        sic.add(new SelectorItemInfo("CtrlStrategy.*"));
        return sic;
    }
}

