/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app.service.settlementbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankPayingBill;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.app.servicenew.plugin.AbstractPlugin;
import com.kingdee.eas.fm.common.servicenew.IService;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettleBill2BankPayBillBuilder;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementSubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.app.OverDraftCheckHelper;
import com.kingdee.eas.fm.fs.app.SettlementBillBookNotifyBuilder;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SettleDisposePlugin
extends AbstractPlugin<SettlementBillInfo> {
    public static final String resourcePath = "com.kingdee.eas.fm.fs.SettlementBillUI";
    private static Logger logger = Logger.getLogger((String)SettleDisposePlugin.class.getName());
    protected Map<String, PeriodInfo> startPeriodMap = new HashMap<String, PeriodInfo>();
    protected Map<String, PeriodInfo> currentPeriodMap = new HashMap<String, PeriodInfo>();
    protected Map<String, PaymentBillInfo> paymentBillMap = new HashMap<String, PaymentBillInfo>();

    public SettleDisposePlugin(IService<SettlementBillInfo> service) {
        super(service);
    }

    public String[] getInfoProps() {
        return new String[]{"id", "number", "type", "payeeBankAcct.id", "payeeBankAcct.company.id", "payerBankAcct.Currency.id", "payeeBankAcct.Currency.id", "payeeInnerAcct.applyUnit.id", "payerBankAcct.id", "payerBankAcct.company.id", "payerInnerAcct.applyUnit.id", "sourceBillId", "company.id", "bizType.id", "currency.id", "bizType.payee", "amount", "locAmount", "payAmount", "bizType.type", "cheque", "payeeAcct.id", "payeeAcct.isBank", "payerAcct.id", "payerAcct.isBank", "bizType.type", "bizDate", "payerFullName", "PayerBank", "payerBankAcctNum", "payeeFullName", "payeeBank", "payeeBankAcctNum", "payerInnerAcct.applyUnit.name", "payerInnerAcct.clearingHouse.name", "payerInnerAcct.acctNumber", "payerInnerAcct.applyUnit.name", "payerInnerAcct.clearingHouse.name", "payerInnerAcct.acctNumber", "currency.id", "currency.precision", "payCurrency.id", "payCurrency.precision", "description", "settleType.id", "outerSettleNumber", "subAccount", "expectDealTime", "settleFeeMode", "currency.isoCode", "FRecCountry", "recProvinceStr", "recCityStr", "payeeBankAcct.company.name", "bankAcctName", "bankNumber", "usage", "settleType.isPersonPay", "settleType.isAgencyPersonPay", "isUrgent", "isForceManual", "swiftCode", "isDifferPlace", "payeeArea.id", "payeeArea.province", "payeeArea.name", "isDifBank", "payerBankAcct.isOnlyRead", "payerBankAcct.name", "payerBankAcct.maxPayAmount", "payerInnerAcct.company.id", "payeeInnerAcct.company.id", "settleType.isAgentPay"};
    }

    public String[] getParams() {
        return new String[]{"TM013", "TM101", "CS001", "TM008", "TM018", "TM014", "CS075", "TM109", "BE009"};
    }

    public void setUp() throws EASBizException, BOSException {
        String[] orgUnitIds = this.service.getOrgUnits();
        StringBuffer sql = new StringBuffer();
        sql.append("select T0.FCompanyID,T2.FID,T2.FBeginDate,T2.FIsAdjustPeriod");
        sql.append(",T3.FID AS BeginPeriodID,T3.FBeginDate AS BeginPeriodBeginDate,T3.FIsAdjustPeriod  AS BeginPeriodAdjust ");
        sql.append("from T_BD_SystemStatusCtrol T0 ");
        sql.append("inner join T_BD_SystemStatus T1 on T0.FSystemStatusID=T1.FID ");
        sql.append("inner join T_BD_Period T2 on T0.FCurrentPeriodID = T2.FID ");
        sql.append("inner join T_BD_Period T3 on T0.FStartPeriodID = T3.FID  ");
        sql.append(" and T0.FCompanyID in (");
        for (int i = 0; i < orgUnitIds.length; ++i) {
            sql.append("'" + orgUnitIds[i] + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") and T1.FName=" + SystemEnum.CASHMANAGEMENT.getValue());
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                if (iRowSet.next()) {
                    String orgUnitId = iRowSet.getString("FCompanyID");
                    String currentPeriodId = iRowSet.getString("FID");
                    if (currentPeriodId != null) {
                        PeriodInfo periodInfo = new PeriodInfo();
                        periodInfo.setId(BOSUuid.read((String)currentPeriodId));
                        periodInfo.setBeginDate((Date)iRowSet.getTimestamp("FBeginDate"));
                        periodInfo.setIsAdjustPeriod(iRowSet.getBoolean("FIsAdjustPeriod"));
                        this.currentPeriodMap.put(orgUnitId, periodInfo);
                    }
                    String startPeriodId = iRowSet.getString("BeginPeriodID");
                    if (currentPeriodId != null) {
                        PeriodInfo periodInfo = new PeriodInfo();
                        periodInfo.setId(BOSUuid.read((String)startPeriodId));
                        periodInfo.setBeginDate((Date)iRowSet.getTimestamp("BeginPeriodBeginDate"));
                        periodInfo.setIsAdjustPeriod(iRowSet.getBoolean("BeginPeriodAdjust"));
                        this.startPeriodMap.put(orgUnitId, periodInfo);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        List ids = this.getService().getIds();
        HashSet<String> paymentBillIdSet = new HashSet<String>();
        for (int i = 0; i < ids.size(); ++i) {
            SettlementBillInfo settleInfo = (SettlementBillInfo)this.getService().getInfo((String)ids.get(i));
            String sourceBillId = settleInfo.getSourceBillId();
            if (sourceBillId == null || !BOSUuid.read((String)sourceBillId).getType().equals((Object)new PaymentBillInfo().getBOSType())) continue;
            paymentBillIdSet.add(sourceBillId);
        }
        if (paymentBillIdSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", paymentBillIdSet, CompareType.INCLUDE));
            EntityViewInfo evi = EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)this.getPaymentSelector(), null);
            PaymentBillCollection paymentBillColl = PaymentBillFactory.getLocalInstance((Context)this.ctx).getPaymentBillCollection(evi);
            for (int i = 0; i < paymentBillColl.size(); ++i) {
                PaymentBillInfo paymentBill = paymentBillColl.get(i);
                this.paymentBillMap.put(paymentBill.getId().toString(), paymentBill);
            }
        }
    }

    private SelectorItemCollection getPaymentSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("payerAccount.*");
        selector.add("payerAccount.InnerAcct.*");
        selector.add("payerAccountBank.*");
        selector.add("payeeAccountBankO.*");
        selector.add("payeeAccountBankO.InnerAcct.*");
        selector.add("payerAccountBank.InnerAcct.*");
        selector.add("payerAccountBank.InnerAcct.clearingHouse.*");
        selector.add("settlementType.*");
        selector.add("settlementType.ntType.*");
        selector.add("cheque.*");
        selector.add("payerBank.*");
        selector.add("bizType.*");
        selector.add("oppInnerAcct.*");
        selector.add("oppAccount.*");
        selector.add("company.*");
        selector.add("payBillType.*");
        selector.add("actRecAccountBank.*");
        selector.add("payerInAcctID.*");
        selector.add(new SelectorItemInfo("entries.*"));
        selector.add(new SelectorItemInfo("cheque.*"));
        selector.add(new SelectorItemInfo("cheque.applyRec.applyCompany.id"));
        return selector;
    }

    public void afterService(String id) throws EASBizException, BOSException {
        boolean isInnerAcctLinkPay;
        SettlementBillInfo info = (SettlementBillInfo)this.service.getInfo(id);
        Map param = this.service.getParamMap(info.getCompany().getId().toString());
        SettBizTypeEnum settleBizType = info.getType();
        long dTime = System.currentTimeMillis();
        this.autoCashRecPay(this.ctx, info);
        System.out.println("autoCashRecPay spent: " + (System.currentTimeMillis() - dTime) + "ms.");
        dTime = System.currentTimeMillis();
        this.BookSub(this.ctx, info);
        System.out.println("BookSub spent: " + (System.currentTimeMillis() - dTime) + "ms.");
        HashSet idSet = new HashSet();
        Set srcIdSet = FMHelper.getSrcBillIdSet((Context)this.ctx, (String)id);
        idSet.addAll(srcIdSet);
        boolean tm014 = (Boolean)param.get("TM014");
        SettlementTypeInfo settlementTypeInfo = info.getSettleType();
        HashSet<String> validCommitBeIdSet = new HashSet<String>();
        if (!info.isIsDlFromBe()) {
            validCommitBeIdSet.add(info.getId().toString());
        }
        boolean isSendRec = false;
        boolean cs075_01 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS075_01", (IObjectPK)new ObjectUuidPK(info.getApplyUnit().getId()));
        if (cs075_01) {
            boolean cs075 = (Boolean)param.get("CS075");
            if (cs075) {
                isSendRec = true;
            }
        } else {
            boolean cs075Unit = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS075", (IObjectPK)new ObjectUuidPK(info.getApplyUnit().getId()));
            if (cs075Unit) {
                isSendRec = true;
            }
        }
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"224_SettleFacadeControllerBean", (Locale)this.ctx.getLocale()) + new Timestamp(System.currentTimeMillis())));
        if (isSendRec && SettBizTypeEnum.LINKPAY == info.getType() && !(isInnerAcctLinkPay = SettlementBillFactory.getLocalInstance(this.ctx).isInnerAcctLinkPay(info.getId().toString()))) {
            this.LinkPaySendRec(this.ctx, info);
        }
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"225_SettleFacadeControllerBean", (Locale)this.ctx.getLocale()) + new Timestamp(System.currentTimeMillis())));
        HashSet idSet_PayOutside = new HashSet();
        HashSet idSet_RecOutside = new HashSet();
        if (settleBizType.equals((Object)SettBizTypeEnum.PAYOUTSIDE)) {
            idSet_PayOutside.addAll(srcIdSet);
        } else if (settleBizType.equals((Object)SettBizTypeEnum.RECOUTSIDE)) {
            idSet_RecOutside.addAll(srcIdSet);
        }
        dTime = System.currentTimeMillis();
        this.cpBcSignSymbol(this.ctx, idSet, 70);
        this.loanSignSymbol(this.ctx, idSet_PayOutside, 70, "N");
        this.loanSignSymbol(this.ctx, idSet_RecOutside, 1325, "Y");
        System.out.println("SignSymbol spent: " + (System.currentTimeMillis() - dTime) + "ms.");
        dTime = System.currentTimeMillis();
        this.bookJonal(this.ctx, info, param);
        System.out.println("bookJonal spent: " + (System.currentTimeMillis() - dTime) + "ms.");
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"217_SettleFacadeControllerBean", (Locale)this.ctx.getLocale()), (BOSObjectType)new SettlementBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_settlementBill_settleAttachment");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        dTime = System.currentTimeMillis();
        IObjectPK bankPayingbillId = this.genBankPayingbill(this.ctx, info, param);
        System.out.println("genBankPayingbill spent: " + (System.currentTimeMillis() - dTime) + "ms.");
        HashMap<String, String> settleResult = (HashMap<String, String>)this.ctx.get((Object)"SettleServiceResult");
        if (settleResult == null) {
            settleResult = new HashMap<String, String>();
            this.ctx.put((Object)"SettleServiceResult", settleResult);
        }
        settleResult.put(id, bankPayingbillId.toString());
    }

    private IObjectPK genBankPayingbill(Context ctx, SettlementBillInfo info, Map<String, Object> param) throws BOSException, EASBizException {
        IObjectPK bankPayingbillId = null;
        String builderName = SettleBill2BankPayBillBuilder.class.getName();
        IBankPayingBill iBankPayingBill = BankPayingBillFactory.getLocalInstance((Context)ctx);
        boolean isCreateBankPaying = "1".equals(param.get("TM018"));
        Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
        String sql = "update t_fs_settlementbill set  FIsCommittoBe = 1,FBillStatus = 5,FBankPayState=?,FSubmitTime=? where fid=?";
        BankPayingBillStateEnum state = BankPayingBillStateEnum.OS;
        if (isCreateBankPaying) {
            state = BankPayingBillStateEnum.OP;
        }
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(state.getValue()), time, info.getId().toString()});
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        String be009 = (String)param.get("BE009");
        BankPayingBillInfo bankPayBillInfo = new SettleBill2BankPayBillBuilder().getBankPayBillInfo(ctx, info);
        bankPayingbillId = iBankPayingBill.commit2BankPayBill(bankPayBillInfo, be009);
        if (isCreateBankPaying) {
            SettleFacadeFactory.getLocalInstance(ctx).commitToBeAll4WF((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new SettlementBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_settlementBill_commitToBe");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return bankPayingbillId;
    }

    private void bookJonal(Context ctx, SettlementBillInfo info, Map<String, Object> param) throws BOSException, EASBizException {
        int cs001 = Integer.parseInt((String)param.get("CS001"));
        if (cs001 == 0) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            if (info.getCheque() == null) {
                String billId = info.getCompany().getId().toString();
                PeriodInfo startPeriod = this.startPeriodMap.get(billId);
                PeriodInfo currentPeriod = this.currentPeriodMap.get(billId);
                SettlementBillBookNotifyBuilder builder = new SettlementBillBookNotifyBuilder(info, (String)param.get("TM109"), currentPeriod, true);
                JournalCollection journalCollection = builder.getJournalColl(ctx, billId);
                if (journalCollection != null && journalCollection.size() > 0) {
                    bookNotifyFacade.book(billId, journalCollection, cs001, startPeriod, currentPeriod);
                }
            }
        }
        this.signSettledIn(ctx, info.getId().toString());
    }

    protected void signSettledIn(Context ctx, String id) throws BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        StringBuffer sql = null;
        sql = new StringBuffer("update T_FS_SettlementBill set FCashierID = ?, FsettleDate =  ?, FSettBatchID=NULL where fid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{user.getId().toString(), new java.sql.Date(new Date().getTime()), id});
    }

    protected void BookSub(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        boolean isChCompany;
        Map param = this.service.getParamMap(info.getCompany().getId().toString());
        boolean bookSub = false;
        SettBizTypeEnum settleBizType = info.getType();
        if (settleBizType.equals((Object)SettBizTypeEnum.RECOUTSIDE)) {
            if (info.getPayeeBankAcct() != null) {
                isChCompany = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(info.getPayeeBankAcct().getCompany().getId().toString());
                if (isChCompany || !info.getPayeeBankAcct().getCompany().getId().equals((Object)info.getPayeeInnerAcct().getApplyUnit().getId())) {
                    bookSub = true;
                }
            } else {
                bookSub = true;
            }
        }
        if (settleBizType.equals((Object)SettBizTypeEnum.PAYOUTSIDE) || settleBizType.equals((Object)SettBizTypeEnum.LINKPAY) || settleBizType.equals((Object)SettBizTypeEnum.PAYOUTDIFFCUR)) {
            if (info.getPayerBankAcct() != null) {
                isChCompany = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(info.getPayerBankAcct().getCompany().getId().toString());
                if (isChCompany || !info.getPayerBankAcct().getCompany().getId().equals((Object)info.getPayerInnerAcct().getApplyUnit().getId())) {
                    bookSub = true;
                }
            } else {
                bookSub = true;
            }
        }
        if (!settleBizType.equals((Object)SettBizTypeEnum.PAYOUTSIDE) && !settleBizType.equals((Object)SettBizTypeEnum.RECOUTSIDE)) {
            bookSub = true;
        }
        if (bookSub && this.isBookSubInSettle(ctx, settleBizType, param)) {
            OverDraftCheckHelper.checkOverDraft(ctx, (IObjectValue)info, 2, false, Constants.ZERO, true);
            SettlementSubsidiaryBookProvider provider = new SettlementSubsidiaryBookProvider(info);
            SubsidiaryLedgerCollection subsidiaryColl = provider.getCollection(ctx, info.getId().toString());
            SubsidiaryLedgerFactory.getLocalInstance(ctx).book(subsidiaryColl);
        }
    }

    protected void autoCashRecPay(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        String sourceBillId = info.getSourceBillId();
        if (sourceBillId == null) {
            return;
        }
        Map param = this.service.getParamMap(info.getCompany().getId().toString());
        HashSet<String> recPayIdSet = new HashSet<String>();
        recPayIdSet.add(sourceBillId);
        boolean isAutoRecPay = false;
        ctx.put((Object)("isAutoRecPayByCH" + sourceBillId), (Object)Boolean.TRUE);
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance((Context)ctx);
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        IContextHelper ictxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        if (sourceBillId != null && BOSUuid.read((String)sourceBillId).getType().equals((Object)new ReceivingBillInfo().getBOSType())) {
            boolean isRec;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billStatus"));
            sic.add(new SelectorItemInfo("company.id"));
            ReceivingBillInfo recBillInfo = iReceivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
            isAutoRecPay = ictxHelper.getBooleanParam("CS062", (IObjectPK)new ObjectUuidPK(recBillInfo.getCompany().getId()));
            boolean bl = isRec = recBillInfo.getBillStatus() == BillStatusEnum.RECED;
            if (isAutoRecPay && !isRec) {
                iReceivingBill.rec(recPayIdSet);
            }
        }
        if (sourceBillId != null && BOSUuid.read((String)sourceBillId).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
            boolean isPay;
            PaymentBillInfo paymentBill = this.paymentBillMap.get(sourceBillId);
            isAutoRecPay = ictxHelper.getBooleanParam("CS062", (IObjectPK)new ObjectUuidPK(paymentBill.getCompany().getId()));
            boolean bl = isPay = paymentBill.getBillStatus() == BillStatusEnum.PAYED;
            if (isAutoRecPay && !isPay) {
                iPaymentBill.pay((IObjectValue)paymentBill, true);
            }
        }
    }

    private boolean isBookSubInSettle(Context ctx, SettBizTypeEnum bizType, Map<String, Object> param) {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean val = (Boolean)param.get("TM013");
        boolean val_rec = (Boolean)param.get("TM101");
        boolean isPayout = SettBizTypeEnum.PAYOUTSIDE == bizType || SettBizTypeEnum.PAYOUTDIFFCUR == bizType || SettBizTypeEnum.LINKPAY == bizType;
        boolean isRec = SettBizTypeEnum.RECOUTSIDE == bizType;
        return val && isPayout || val_rec && isRec;
    }

    private void cpBcSignSymbol(Context ctx, Set idSet, int status) throws BOSException {
        if (idSet == null) {
            return;
        }
        BOSObjectType aBOSType = new BizAccountBillInfo().getBOSType();
        BOSObjectType taBOSType = new TravelAccountBillInfo().getBOSType();
        Iterator iter = idSet.iterator();
        String billId = null;
        BOSObjectType bosType = null;
        while (iter.hasNext()) {
            StringBuffer sb;
            billId = (String)iter.next();
            bosType = BOSUuid.read((String)billId).getType();
            if (bosType.equals((Object)aBOSType)) {
                sb = new StringBuffer();
                sb.append("update T_BC_BizAccountBill set fstate=? where fid=?");
                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{new Integer(status), billId});
                continue;
            }
            if (!bosType.equals((Object)taBOSType)) continue;
            sb = new StringBuffer();
            sb.append("update T_BC_TravelAccountBill set fstate=? where fid=?");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{new Integer(status), billId});
        }
    }

    private void loanSignSymbol(Context ctx, Set idSet, int status, String loanStatus) throws BOSException {
        if (idSet == null) {
            return;
        }
        BOSObjectType loanBosType = new DailyLoanBillInfo().getBOSType();
        Iterator iter = idSet.iterator();
        String billId = null;
        BOSObjectType bosType = null;
        while (iter.hasNext()) {
            billId = (String)iter.next();
            bosType = BOSUuid.read((String)billId).getType();
            if (!bosType.equals((Object)loanBosType)) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("update T_BC_DailyLoanBill set fstate=?, floanstate=? where fid=?");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{new Integer(status), loanStatus, billId});
        }
    }

    protected void commitToBEForPay(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet.size() > 1) {
            throw new BEException(BEException.NOTALLOWBATCHSUBMIT);
        }
        String sql = "UPDATE T_FS_SettlementBill SET Fnumber=Fnumber WHERE Fid in  " + FMHelper.setTran2String((Set)idSet);
        DbUtil.execute((Context)ctx, (String)sql);
        String builderName = SettleBill2BankPayBillBuilder.class.getName();
        IBankPayingBill iBankPayingBill = BankPayingBillFactory.getLocalInstance((Context)ctx);
        Iterator iter = idSet.iterator();
        String billId = null;
        while (iter.hasNext()) {
            billId = (String)iter.next();
            iBankPayingBill.commit2BankPayBill(billId, builderName);
        }
    }

    private void LinkPaySendRec(Context ctx, SettlementBillInfo settleInfo) throws BOSException, EASBizException {
        AccountBankCollection banks = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        ev.getSelector().add(new SelectorItemInfo("account.*"));
        ev.getSelector().add(new SelectorItemInfo("bank.*"));
        ev.getSelector().add(new SelectorItemInfo("company.*"));
        SelectorItemCollection si = ev.getSelector();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)settleInfo.getSubAccount().trim()));
        banks = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(ev);
        AccountBankInfo subAccount = banks.get(0);
        BOSObjectType bosType = new ReceivingBillInfo().getBOSType();
        CoreBillBaseCollection coll = new CoreBillBaseCollection();
        coll.add((CoreBillBaseInfo)settleInfo);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"227_SettleFacadeControllerBean", (Locale)ctx.getLocale()) + new Timestamp(System.currentTimeMillis())));
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(coll, bosType.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"228_SettleFacadeControllerBean", (Locale)ctx.getLocale()) + new Timestamp(System.currentTimeMillis())));
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        ReceivingBillInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (ReceivingBillInfo)destBillColl.getObject(i);
            logger.info((Object)("LinkPaySendRec-----destBillColl.size()==" + size));
            logger.info((Object)("LinkPaySendRec--i=-" + i + "--destBillColl.id()==" + destBillInfo.getId()));
            destBillInfo.setFiVouchered(false);
            destBillInfo.setPayeeAccountBank(subAccount);
            destBillInfo.setPayeeAccount(subAccount.getAccount());
            destBillInfo.setPayeeBank(subAccount.getBank());
            destBillInfo.setCompany(subAccount.getCompany());
            AccountBankCollection accountBankCol = null;
            try {
                accountBankCol = FSHelper.getAcctBankByInnerAcctCol(ctx, settleInfo.getPayerInnerAcct());
                for (int j = 0; j < accountBankCol.size(); ++j) {
                    if (!accountBankCol.get(j).getBank().isInGroup()) continue;
                    destBillInfo.setPayerAccountBank(accountBankCol.get(j).getBankAccountNumber());
                    destBillInfo.setPayerAccountBankO(accountBankCol.get(j));
                }
            }
            catch (BOSException e) {
                throw new KScriptException(e.getMessage());
            }
            destBillInfo.setCurrency(settleInfo.getCurrency());
            destBillInfo.setExchangeRate(settleInfo.getExchange());
            destBillInfo.setIsInitializeBill(false);
            if (settleInfo.getType().equals((Object)SettBizTypeEnum.LINKPAY)) {
                EntityViewInfo view = new EntityViewInfo();
                filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)"998"));
                try {
                    ReceivingBillTypeCollection receivingBillType = ReceivingBillTypeFactory.getLocalInstance((Context)ctx).getReceivingBillTypeCollection(view);
                    destBillInfo.setRecBillType(receivingBillType.get(0));
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            if (destBillInfo.getBizDate() == null) {
                destBillInfo.setBizDate(DateUtil.getDayBegin());
            }
            if (ctx != null && destBillInfo.getSourceBillId() != null) {
                BizobjectFacadeFactory.getLocalInstance((Context)ctx).copyBizRelation(destBillInfo.getSourceBillId(), destBillInfo.getId().toString());
            }
            iBTPManager.submitRelations((CoreBillBaseInfo)destBillInfo, botRelateColl);
        }
    }
}

