/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app.service.settlementbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.app.servicenew.plugin.AbstractPlugin;
import com.kingdee.eas.fm.common.servicenew.IService;
import com.kingdee.eas.fm.common.util.MessageDigestTools;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SettleValidModelPlugin
extends AbstractPlugin<SettlementBillInfo> {
    public static final String resourcePath = "com.kingdee.eas.fm.fs.SettlementBillUI";
    private static Logger logger = Logger.getLogger((String)SettleValidModelPlugin.class.getName());

    public SettleValidModelPlugin(IService<SettlementBillInfo> service) {
        super(service);
    }

    public String[] getInfoProps() {
        return new String[]{"*", "type", "isCommittoBe", "cashier.id", "acceptor.id", "payerBankAcct.id", "payerBankAcct.isSetBankInterface", "payeeFullName", "payeeBank", "payeeBankAcctNum", "settleType.id", "settleType.payThroughBE", "recCityStr", "recProvinceStr", "payeeArea.id", "isDlFromBe", "bizType.id", "bizType.type", "number", "payeeBankAcct.id", "payCurrency.id", "payCurrency.baseUnit", "sourceBillId", "payeeBankAcct.company", "payeeInnerAcct.id", "payeeInnerAcct.applyUnit.id", "payeeAcct.isBank", "payerBankAcct.company", "payerInnerAcct.id", "payerInnerAcct.applyUnit.id", "payerAcct.isBank", "isAccepted", "amount", "isDlByPay", "currency.id", "isDlByRec", "company.id", "hasEffected", "payerBankAcct.bankAccountNumber", "payerBankAcctNum", "payeeBankAcctNum", "currency.id", "editFlag", "company.baseCurrency.id", "company.baseExchangeTable.id", "payerBankAcct.isSetBankInterface", "payerBankAcct.account.id", "settleType.isAgentPay"};
    }

    public String[] getParams() {
        return new String[]{"TM012", "BE009"};
    }

    public void setUp() throws EASBizException, BOSException {
    }

    public void beforeService(String id) throws EASBizException, BOSException {
        AccountBankCollection acctColl;
        SettlementBillInfo info = (SettlementBillInfo)this.service.getInfo(id);
        Map param = this.service.getParamMap(info.getCompany().getId().toString());
        SettBizTypeEnum settleBizType = info.getType();
        if (!settleBizType.equals((Object)SettBizTypeEnum.PAYOUTSIDE) && !settleBizType.equals((Object)SettBizTypeEnum.LINKPAY)) {
            throw new FSException(FSException.PAYOUTCANTOBE);
        }
        if (info.isIsCommittoBe() || info.getCashier() != null) {
            throw new FSException(FSException.ALREADYCOMMITTOBE);
        }
        if (info.getAcceptor() == null) {
            throw new FSException(FSException.ACCEPTERCANNOTBENULL);
        }
        if (FMHelper.isEmpty((CoreBaseInfo)info.getPayerBankAcct())) {
            throw new FSException(FSException.PAYERBANKACCTCANNOTBENULL);
        }
        if (!info.getPayerBankAcct().isIsSetBankInterface()) {
            throw new FSException(FSException.NOTHAVEBANKINTERFACE);
        }
        if (FMHelper.isEmpty((String)info.getPayeeFullName())) {
            throw new FSException(FSException.PAYEEFULLNAMECANNOTBENULL);
        }
        if (FMHelper.isEmpty((String)info.getPayeeBank())) {
            throw new FSException(FSException.PAYEEBANKCANNOTBENULL);
        }
        if (FMHelper.isEmpty((String)info.getPayeeBankAcctNum())) {
            throw new FSException(FSException.PAYEEBANKACCTNUMCANNOTBENULL);
        }
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"bizType");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"currency");
        if (info.getSettleType() == null || !info.getSettleType().isPayThroughBE()) {
            throw new FSException(FSException.MUSTPAYTHROUGHBE);
        }
        boolean tm012 = (Boolean)param.get("TM012");
        if (tm012 && (settleBizType == SettBizTypeEnum.PAYOUTSIDE || settleBizType == SettBizTypeEnum.LINKPAY) && info.getAuditor() == null) {
            throw new FSException(FSException.AUDITORCANNOTBENULL);
        }
        String strValueBE009 = (String)param.get("BE009");
        if (strValueBE009 == null || "0".equals(strValueBE009)) {
            if (EmptyUtil.isEmpty((String)info.getRecCityStr()) || EmptyUtil.isEmpty((String)info.getRecProvinceStr())) {
                throw new FSException(FSException.RECCITYORPROVINCECANNOTBENULL);
            }
        } else if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeArea())) {
            throw new FSException(FSException.PAYEEAREACANNOTBENULL);
        }
        if (info.isIsDlFromBe()) {
            throw new FSException(FSException.SUBMITBEERROR, new Object[]{info.getNumber()});
        }
        if (!(settleBizType.equals((Object)SettBizTypeEnum.RECOUTSIDE) || settleBizType.equals((Object)SettBizTypeEnum.PAYOUTSIDE) || settleBizType.equals((Object)SettBizTypeEnum.RECINSIDEDIF) || settleBizType.equals((Object)SettBizTypeEnum.PAYINSIDEDIF) || settleBizType.equals((Object)SettBizTypeEnum.PAYOUTDIFFCUR) || settleBizType.equals((Object)SettBizTypeEnum.LINKPAY))) {
            throw new FSException(FSException.WRONGTYPE, new String[]{info.getNumber()});
        }
        if ((settleBizType == SettBizTypeEnum.PAYINSIDEDIF || settleBizType == SettBizTypeEnum.RECINSIDEDIF || settleBizType == SettBizTypeEnum.PAYOUTDIFFCUR) && info.getPayeeBankAcct() == null && info.getPayerBankAcct() == null) {
            throw new FSException(FSException.COMMON, new Object[]{SettleValidModelPlugin.getResource(this.ctx, "noCenterBankAcct")});
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier())) {
            throw new FSException(FSException.COMMON, new Object[]{SettleValidModelPlugin.getResource(this.ctx, "HasSettled")});
        }
        if (settleBizType == SettBizTypeEnum.PAYOUTDIFFCUR && info.getPayCurrency().getBaseUnit() != null) {
            String cur = "";
            String firstId = (String)this.service.getIds().get(0);
            SettlementBillInfo firstInfo = (SettlementBillInfo)this.service.getInfo(firstId);
            if (firstInfo.getPayCurrency().getBaseUnit() != null) {
                cur = info.getPayCurrency().getBaseUnit();
            }
            if (this.service.getIndex(id) != 0 && !cur.equals(info.getPayCurrency().getBaseUnit())) {
                throw new FSException(FSException.COMMON, new Object[]{SettleValidModelPlugin.getResource(this.ctx, "msgCurDif")});
            }
        }
        SettlementTypeInfo settlementTypeInfo = info.getSettleType();
        if (settleBizType.equals((Object)SettBizTypeEnum.PAYINSIDE) || settleBizType.equals((Object)SettBizTypeEnum.RECINSIDE)) {
            throw new FSException(FSException.INPAYRECNOSETTLE);
        }
        if (settleBizType.equals((Object)SettBizTypeEnum.RECOUTSIDE)) {
            if (info.getPayeeBankAcct() != null) {
                acctColl = RecPayHelper.getAccountBankInfo((Context)this.ctx, (CompanyOrgUnitInfo)info.getCompany(), (AccountBankInfo)info.getPayeeBankAcct());
                if (acctColl == null || acctColl.size() <= 0) {
                    FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"PayeeAcct");
                }
            } else {
                FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"PayeeAcct");
            }
            if (info.getPayeeAcct() != null && info.getPayeeAcct().isIsBank()) {
                FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"PayeeBankAcct");
            }
        }
        if (settleBizType.equals((Object)SettBizTypeEnum.PAYOUTSIDE) || settleBizType.equals((Object)SettBizTypeEnum.LINKPAY) || settleBizType.equals((Object)SettBizTypeEnum.PAYOUTDIFFCUR)) {
            if (info.getPayerBankAcct() != null) {
                acctColl = RecPayHelper.getAccountBankInfo((Context)this.ctx, (CompanyOrgUnitInfo)info.getCompany(), (AccountBankInfo)info.getPayerBankAcct());
                if (acctColl == null || acctColl.size() <= 0) {
                    FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"PayerAcct");
                }
            } else {
                FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"PayerAcct");
            }
            if (info.getPayerAcct() != null && info.getPayerAcct().isIsBank()) {
                FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"PayerBankAcct");
            }
        }
        if (settleBizType.equals((Object)SettBizTypeEnum.RECINSIDEDIF) || settleBizType.equals((Object)SettBizTypeEnum.PAYINSIDEDIF)) {
            if (info.getPayeeBankAcct() != null) {
                FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"PayeeAcct");
            }
            if (info.getPayerBankAcct() != null) {
                FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"PayerAcct");
            }
        }
        if (!info.isIsAccepted()) {
            throw new FSException(FSException.HASNOTACCEPTERRER);
        }
        if (info.getCashier() != null) {
            throw new FSException(FSException.HASSETTLEDERRER);
        }
        this.checkIfByEdited(this.ctx, info);
    }

    private void checkIfByEdited(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException, RecPayException {
        String srcPayerBankAcct = info.getPayerBankAcct() != null ? info.getPayerBankAcct().getBankAccountNumber() : "";
        String srcPayerBankAcctNum = info.getPayerBankAcctNum();
        String srcPayeeBankAcctNum = info.getPayeeBankAcctNum();
        String srcCurrency = info.getCurrency().getId().toString();
        String srcAmout = info.getAmount().toString();
        String editFlag = info.getEditFlag();
        boolean editFlagValid = MessageDigestTools.checkIfValid((String)(srcPayerBankAcct + srcPayerBankAcctNum + srcPayeeBankAcctNum + srcCurrency + srcAmout), (String)editFlag);
        if (!editFlagValid) {
            throw new FSException(FSException.SETTLEBILLINFOBYEDITED, new String[]{info.getNumber()});
        }
    }

    private static String getResource(Context ctx, String name) {
        return ResourceBase.getString((String)resourcePath, (String)name, (Locale)ctx.getLocale());
    }
}

