/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.formula.InAcctCaculaterHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InAcctBatchCaculator
implements ICalculator,
IMethodBatchQuery {
    private ICalculateContextProvider context;
    private Context serverCtx = null;
    private String reportCompanyNumber = null;
    private String reportCurrencyNumber = null;
    private Date reportBeginDate = null;
    private Date reportEndDate = null;

    public BigDecimal inAcct(String companyNumber, String innerAcctNumber, String currencyNumber, Date beginDay, Date endDay, InAcctDataTypeEnum inAcctDataType, boolean isCleaningHouse) throws BOSException, EASBizException {
        return null;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = context.getServerContext();
    }

    public boolean batchQuery(Map methods) {
        String reportCompanyId = (String)this.context.getReportAdapter().getReportProperty("Company.ID");
        try {
            this.reportCompanyNumber = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverCtx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(reportCompanyId)).getNumber();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.reportCurrencyNumber = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        this.reportBeginDate = (Date)this.context.getReportAdapter().getReportProperty("Report_StartDate");
        this.reportEndDate = (Date)this.context.getReportAdapter().getReportProperty("Report_EndDate");
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    public void execute(SortedParameterArray params) {
        HashMap<String, Object[]> paramap = new HashMap<String, Object[]>();
        HashMap<String, ArrayList<Object>> acctmap = new HashMap<String, ArrayList<Object>>();
        HashMap rstmap = new HashMap();
        this.fillCompany4Param(params);
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            Object[] args = this.getParams(param);
            String key = "";
            for (int j = 0; j < args.length; ++j) {
                if (j == 1) continue;
                key = key + args[j];
            }
            ArrayList<Object> acctlist = (ArrayList<Object>)acctmap.get(key);
            if (acctlist == null) {
                acctlist = new ArrayList<Object>();
                acctmap.put(key, acctlist);
            }
            acctlist.add(args[1]);
            paramap.put(key, args);
        }
        for (Map.Entry o : acctmap.entrySet()) {
            String key = (String)o.getKey();
            List acctList = (List)o.getValue();
            Object[] args = (Object[])paramap.get(key);
            try {
                IRowSet rs = new InAcctCaculaterHelper().getInAccBatch(this.serverCtx, acctList, args);
                this.populatRstmap(rstmap, key, acctList, rs);
            }
            catch (Exception e) {
                this.populatRstmapWithException(rstmap, key, acctList, e.getMessage());
            }
        }
        this.setValueBatch(rstmap, params);
    }

    private void fillCompany4Param(SortedParameterArray params) {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)this.serverCtx).getCurrentCompany();
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            Object[] args = this.getParams(param);
            if (args[0] != null) continue;
            args[0] = currentCompany.getNumber();
        }
    }

    private void setValueBatch(Map rstmap, SortedParameterArray params) {
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            Object[] args = this.getParams(param);
            String key = "";
            for (int j = 0; j < args.length; ++j) {
                if (j == 1) continue;
                key = key + args[j];
            }
            Object value = rstmap.get(key = key + args[1]);
            param.setValue((Object)(value == null ? Constants.ZERO : value));
        }
    }

    private void populatRstmapWithException(Map rstmap, String key, List acctList, String errorMsg) {
        for (int i = 0; i < acctList.size(); ++i) {
            String innerNumberFromParam = acctList.get(i).toString();
            String rstMapKey = key + innerNumberFromParam;
            rstmap.put(rstMapKey, errorMsg);
        }
    }

    private void populatRstmap(Map rstmap, String key, List acctList, IRowSet rs) throws Exception {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        while (rs.next()) {
            String inAcctNumberFromDB = rs.getString(1);
            BigDecimal inAcctValue = rs.getBigDecimal(2);
            map.put(inAcctNumberFromDB, inAcctValue);
        }
        for (int i = 0; i < acctList.size(); ++i) {
            BigDecimal realValue = new BigDecimal("0");
            String innerNumberFromParam = acctList.get(i).toString();
            String[] allInAcctNumber = innerNumberFromParam.split(",");
            for (int c = 0; c < allInAcctNumber.length; ++c) {
                BigDecimal rst = (BigDecimal)map.get(allInAcctNumber[c]);
                if (rst == null) continue;
                realValue = realValue.add(rst);
            }
            String rstMapKey = key + innerNumberFromParam;
            rstmap.put(rstMapKey, realValue);
        }
    }

    private Object[] getParams(Parameter param) {
        String endDate;
        String beginDate;
        String currencyNumber;
        Object[] args = param.getArgs();
        String companyNumber = args[0].toString();
        if (FMHelper.isEmpty((String)companyNumber)) {
            companyNumber = this.reportCompanyNumber;
            args[0] = companyNumber;
        }
        if (FMHelper.isEmpty((String)(currencyNumber = args[2].toString()))) {
            currencyNumber = this.reportCurrencyNumber;
            args[2] = currencyNumber;
        }
        if (FMHelper.isEmpty((String)(beginDate = args[3].toString()))) {
            beginDate = Constants.FORMAT_DAY.format(this.reportBeginDate);
            args[3] = beginDate;
        }
        if (FMHelper.isEmpty((String)(endDate = args[4].toString()))) {
            endDate = Constants.FORMAT_DAY.format(this.reportEndDate);
            args[4] = endDate;
        }
        return args;
    }
}

