/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.util.client.EASResource;

public class FundTransferRepayBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        FundTransferRepayBillInfo info = this.getFundTransferRepayBillInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfo = this.createJournalInfoAmt(info);
        journalColl.add(journalInfo);
        return journalColl;
    }

    private JournalInfo createJournalInfoAmt(FundTransferRepayBillInfo info) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getReceAcctBank());
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setCreateDate(info.getBizDate());
        journalInfo.setDebitAmount(info.getRepayAmt());
        journalInfo.setCreditAmount(Constants.ZERO);
        journalInfo.setIsDebit(true);
        journalInfo.setBizDate(info.getRepayDate());
        journalInfo.setAccountView(info.getReceAcctBank().getAccount());
        journalInfo.setBillType(BillTypeEnum.fundTransferRepayBill);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setDescription(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"47_FundTransferRepayBookNotifyBuilder"));
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private FundTransferRepayBillInfo getFundTransferRepayBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        FundTransferRepayBillInfo info = FundTransferRepayBillFactory.getLocalInstance(ctx).getFundTransferRepayBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("receAcctBank.account.*");
        return sic;
    }
}

