/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsignmentLoanException;
import com.kingdee.eas.fm.common.RateAdjustmentBaseBillInfo;
import com.kingdee.eas.fm.common.app.IRateAdjustmentBaseBillCallBack;
import com.kingdee.eas.fm.common.app.IRateAdjustmentBaseBillCallBackImp_AddNew;
import com.kingdee.eas.fm.common.app.IRateAdjustmentBaseBillCallBackImp_Delete;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillCollection;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillInfo;
import com.kingdee.eas.fm.ft.app.AbstractFundTransRateAdjustBillControllerBean;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundTransRateAdjustBillControllerBean
extends AbstractFundTransRateAdjustBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ft.app.FundTransRateAdjustBillControllerBean");

    @Override
    protected Set _batchAdjustRate(Context ctx, FundTransRateAdjustBillCollection col) throws BOSException, EASBizException {
        HashSet<String> adjustmentBillIDs = new HashSet<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            FundTransRateAdjustBillInfo rateAdjustBillInfo = col.get(i);
            rateAdjustBillInfo.setIsUsed(false);
            IObjectPK pk = this.submitForBatch(ctx, (IObjectValue)rateAdjustBillInfo);
            if (pk == null) continue;
            adjustmentBillIDs.add(pk.toString());
        }
        return adjustmentBillIDs;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IObjectPK pk = super._addnew(ctx, model);
        this.afterRateAdjustmentBillCreated(ctx, (IRateAdjustmentBaseBillCallBack)new IRateAdjustmentBaseBillCallBackImp_AddNew(ctx, (RateAdjustmentBaseBillInfo)((FundTransRateAdjustBillInfo)model)));
        return pk;
    }

    private boolean checkSubmit(FundTransRateAdjustBillInfo info) throws BOSException, EASBizException {
        return info.getLastAdjustDate() == null || DateTimeUtils.truncateDate((Date)info.getAdjustDate()).compareTo(DateTimeUtils.truncateDate((Date)info.getLastAdjustDate())) > 0;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.checkSubmit((FundTransRateAdjustBillInfo)model)) {
            return super._submit(ctx, model);
        }
        FundTransRateAdjustBillInfo fundTransRateAdjustBillInfo = (FundTransRateAdjustBillInfo)model;
        if (fundTransRateAdjustBillInfo.getAdjustSeq() > 1) {
            throw new ConsignmentLoanException(ConsignmentLoanException.ADJUST_DATE_EXC);
        }
        throw new ConsignmentLoanException(ConsignmentLoanException.ADJUST_DATE_EXC2);
    }

    private IObjectPK submitForBatch(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.checkSubmit((FundTransRateAdjustBillInfo)model)) {
            return super._submit(ctx, model);
        }
        return null;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundTransRateAdjustBillInfo rateAdjustBillInfo = this.getFundTransRateAdjustBillInfo(ctx, pk);
        super._delete(ctx, pk);
        this.afterRateAdjustBillDeleted(ctx, (IRateAdjustmentBaseBillCallBack)new IRateAdjustmentBaseBillCallBackImp_Delete(ctx, (RateAdjustmentBaseBillInfo)rateAdjustBillInfo));
    }
}

