/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanException;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.util.TransPrecisionUtil;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillCollection;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillFactory;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillCollection;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestEntriesBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestEntriesBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillCollection;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ft.ImFtAdjustIntRateCollection;
import com.kingdee.eas.fm.ft.ImFundTransferRepayInfo;
import com.kingdee.eas.fm.ft.ImFundTransferRepaymentBillCollection;
import com.kingdee.eas.fm.ft.app.AbstractFundTransferInterestBillControllerBean;
import com.kingdee.eas.fm.ft.app.InterestBizDTO;
import com.kingdee.eas.fm.ft.app.LoanIntBillBizHelper;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.fm.im.util.LoanInterestEntryInfo;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundTransferInterestBillControllerBean
extends AbstractFundTransferInterestBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ft.app.FundTransferInterestBillControllerBean");
    private boolean deleteRelated = false;

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        FundTransferInterestBillInfo intInfo = (FundTransferInterestBillInfo)model;
        TransPrecisionUtil.trancatePrecision((Context)ctx, (CoreBaseInfo)intInfo, (String[])new String[]{"shijiSumAmt", "yingjiSumAmt", "amount", "shijiIntAmt", "yingjiIntAmt", "yingjiPenaAmt", "shijiPenaAmt", "strikeAmt"}, (CurrencyInfo)intInfo.getCurrency(), null);
        if (intInfo.getNumber() == null || "".equals(intInfo.getNumber().trim())) {
            intInfo.setNumber(String.valueOf(System.currentTimeMillis()));
        }
        IObjectPK pkReturn = super._addnew(ctx, model);
        LoanIntBillBizHelper.afterIntBillSubmited(ctx, this.genBizDTO(intInfo), pkReturn);
        return pkReturn;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            FundTransferInterestBillInfo info = (FundTransferInterestBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccount(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccount(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private InterestBizDTO genBizDTO(FundTransferInterestBillInfo fundTransferInterestBillInfo) {
        return new InterestBizDTO(fundTransferInterestBillInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FundTransferRepayBillInfo repayBill;
        FundTransferInterestBillInfo oldInfo;
        FundTransferInterestBillInfo transIntBillInfo = (FundTransferInterestBillInfo)model;
        transIntBillInfo.setEffectedStatus(StateEnum.SUBMISSION);
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)transIntBillInfo);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((FundTransferInterestBillInfo)model));
        if (null != transIntBillInfo.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(transIntBillInfo.getId())) && (oldInfo = this.getFundTransferInterestBillInfo(ctx, "select * where id='" + transIntBillInfo.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        if (transIntBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT && (repayBill = transIntBillInfo.getRepayInfo()) != null) {
            BOSObjectType repayBillBOSType = repayBill.getBOSType();
            BOSUuid id = BOSUuid.create((BOSObjectType)repayBillBOSType);
            repayBill.setId(id);
            repayBill.setHasInterestBill(true);
            transIntBillInfo.getTransRepay().setId(id);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (transIntBillInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            return pk;
        }
        if (transIntBillInfo.getIntCalType().getValue() == 2) {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"11_FundTransferInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)transIntBillInfo.getBOSType(), null, (String)transIntBillInfo.getNumber(), (String)"ftinsterest_repayint");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        FundTransferInterestBillInfo sumbittedInfo = this.getFundTransferInterestBillInfo(ctx, "select * where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)sumbittedInfo);
        this.updateFpItem(ctx, pk);
        if (transIntBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            String sql = "update T_FT_FundTransferRepayBill set FAccrual=?,FPenaAccrual=?  where fid = ?";
            Object[] params = new Object[]{transIntBillInfo.getShijiIntAmt(), transIntBillInfo.getShijiPenaAmt(), transIntBillInfo.getTransRepay().getId().toString()};
            FMHelper.execute((Context)ctx, (String)sql, (Object[])params);
        }
        return pk;
    }

    private void updateFpItem(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
    }

    @Override
    protected FundTransferInterestBillInfo _repayInt(Context ctx, java.util.Date startDate, java.util.Date endDate, FundTransferRepayBillInfo transRepayInfo) throws BOSException, EASBizException {
        String loanid = transRepayInfo.getLoan().getId().toString();
        HashSet<String> loanIDSet = new HashSet<String>();
        loanIDSet.add(loanid);
        FundTransRateAdjustBillCollection adjCol = this.getFtAdjustColl(ctx, loanIDSet);
        FundTransferRepayBillCollection repayCol = this.getFtRepayCol(ctx, loanIDSet);
        FundTransferBillCollection loanCol = this.getFtLoanCol(ctx, loanIDSet);
        FundTransRateAdjustBillCollection byLoanID_adjCol = this.filtedAdjColByLoanId(adjCol, loanid);
        FundTransferRepayBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
        FundTransferBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
        IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanID_adjCol, byLoanId_RepayCol, transRepayInfo);
        LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
        return this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, transRepayInfo);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundTransferInterestBillInfo ftInterestBillInfo = this.getFundTransferInterestBillInfo(ctx, pk, this.getSelectItemCollection());
        this.deleteCheck(ctx, ftInterestBillInfo);
        LoanIntBillBizHelper.afterIntBillDeleted(ctx, this.genBizDTO(ftInterestBillInfo), pk);
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)ftInterestBillInfo, (String)ftInterestBillInfo.getCompany().getId().toString());
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    private void deleteCheck(Context ctx, FundTransferInterestBillInfo ftInterestBillInfo) throws EASBizException, BOSException {
        this.checkIsVouchered(ftInterestBillInfo);
        this.checkIsLastInt(ftInterestBillInfo, ctx);
        this.checkIsStriked(ftInterestBillInfo);
        if (!this.deleteRelated) {
            this.checkIntCalType(ftInterestBillInfo);
        }
    }

    private void checkIsStriked(FundTransferInterestBillInfo ftInterestBillInfo) throws EASBizException, BOSException {
        if (ftInterestBillInfo.getIntCalType() == IntCalTypeEnum.PRE_INT && ftInterestBillInfo.isIsStriked()) {
            throw new ConsignmentLoanException(ConsignmentLoanException.PRE_INT_BILL_HAS_STRIKED);
        }
    }

    private void checkIsLastInt(FundTransferInterestBillInfo ftInterestBillInfo, Context ctx) throws EASBizException, BOSException {
        if (ftInterestBillInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            this.deletePreInt(ftInterestBillInfo, ctx);
        } else {
            this.deleteOther(ftInterestBillInfo, ctx);
        }
    }

    private void checkIntCalType(FundTransferInterestBillInfo ftInterestBillInfo) throws BOSException, EASBizException {
        if (ftInterestBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR2);
        }
    }

    private void deleteOther(FundTransferInterestBillInfo ftInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select max(fenddate) from T_FT_FundTransferInterestBill where (fintcaltype = ? or fintcaltype=?) and FTransBillID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), new Integer(1), ftInterestBillInfo.getTransBill().getId().toString()});
        java.util.Date billEndDate = DateTimeUtils.truncateDate((java.util.Date)ftInterestBillInfo.getEndDate());
        try {
            if (rs.next()) {
                java.util.Date maxEndDate = new java.util.Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((java.util.Date)maxEndDate)) < 0) {
                    throw new ConsignmentLoanException(ConsignmentLoanException.NOT_LAST_NON_PRE_INT_BILL);
                }
            }
        }
        catch (SQLException e) {
            throw new ConsignmentLoanException(ConsignmentLoanException.NOT_LAST_NON_PRE_INT_BILL);
        }
    }

    private void deletePreInt(FundTransferInterestBillInfo ftInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select max(fenddate) from T_FT_FundTransferInterestBill where fintcaltype = ? and FTransBillID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(ftInterestBillInfo.getIntCalType().getValue()), ftInterestBillInfo.getTransBill().getId().toString()});
        java.util.Date billEndDate = DateTimeUtils.truncateDate((java.util.Date)ftInterestBillInfo.getEndDate());
        try {
            if (rs.next()) {
                java.util.Date maxEndDate = new java.util.Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((java.util.Date)maxEndDate)) < 0) {
                    throw new ConsignmentLoanException(ConsignmentLoanException.NOT_LAST_PRE_INT_BILL);
                }
            }
        }
        catch (SQLException e) {
            throw new ConsignmentLoanException(ConsignmentLoanException.NOT_LAST_PRE_INT_BILL);
        }
    }

    private void checkIsVouchered(FundTransferInterestBillInfo ftInterestBillInfo) throws EASBizException {
        if (ftInterestBillInfo.isFivouchered()) {
            throw new ConsignmentLoanException(ConsignmentLoanException.BILLHASVOUCHERED);
        }
    }

    private SelectorItemCollection getSelectItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("transRepay.*"));
        return sic;
    }

    private FundTransferInterestBillInfo transfrom(Context ctx, LoanInterestInfo loanIntInfo, FundTransferBillInfo byLoanID_LoanInfo, FundTransferRepayBillInfo transRepayInfo) throws BOSException {
        FundTransferInterestBillInfo fundTransferIntInfo = new FundTransferInterestBillInfo();
        LoanInterestEntryCollection entries = loanIntInfo.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            LoanInterestEntryInfo imEntryInfo = entries.get(i);
            FundTransferInterestEntriesBillInfo fundTransIntBillEntryInfo = new FundTransferInterestEntriesBillInfo();
            this.copyValuesToEntries(fundTransIntBillEntryInfo, imEntryInfo);
            fundTransferIntInfo.getEntries().add(fundTransIntBillEntryInfo);
        }
        this.copyValuesToHead(ctx, fundTransferIntInfo, loanIntInfo, byLoanID_LoanInfo, transRepayInfo);
        fundTransferIntInfo.setCompany(byLoanID_LoanInfo.getCompany());
        fundTransferIntInfo.setProject(transRepayInfo == null ? byLoanID_LoanInfo.getProject() : transRepayInfo.getProject());
        return fundTransferIntInfo;
    }

    private void copyValuesToHead(Context ctx, FundTransferInterestBillInfo fundTransferIntInfo, LoanInterestInfo loanIntInfo, FundTransferBillInfo fundTransferSource, FundTransferRepayBillInfo transRepayInfo) throws BOSException {
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (fundTransferIntInfo.getBizDate() != null) {
            fundTransferIntInfo.setBizDate(DateTimeUtils.truncateDate((java.util.Date)fundTransferIntInfo.getBizDate()));
        } else {
            fundTransferIntInfo.setBizDate(DateUtil.getDayBegin());
        }
        fundTransferIntInfo.setTransRepay(transRepayInfo);
        fundTransferIntInfo.setRepayInfo(transRepayInfo);
        fundTransferIntInfo.setTransBill(fundTransferSource);
        fundTransferIntInfo.setIntCalType(loanIntInfo.getIntCalType());
        fundTransferIntInfo.setCompany(CURRENT_COMPANY);
        fundTransferIntInfo.setCreator(user);
        fundTransferIntInfo.setCurrency(fundTransferSource.getCurrency());
        fundTransferIntInfo.setBizDate(loanIntInfo.getBizDate());
        fundTransferIntInfo.setStartDate(loanIntInfo.getBeginDate());
        fundTransferIntInfo.setEndDate(loanIntInfo.getEndDate());
        fundTransferIntInfo.setIntervalDays(loanIntInfo.getDays());
        fundTransferIntInfo.setAmount(loanIntInfo.getPrincipal());
        fundTransferIntInfo.setRateExpression(loanIntInfo.getIntRateTypeExp());
        fundTransferIntInfo.setRate(loanIntInfo.getIntRate());
        fundTransferIntInfo.setRateDisplay(this.getRateDisplay(loanIntInfo.getIntRateTypeExp(), loanIntInfo.getIntRate()));
        fundTransferIntInfo.setDescription(loanIntInfo.getDescription());
        fundTransferIntInfo.setOverdueDays(loanIntInfo.getOverdueDays());
        fundTransferIntInfo.setPenaAccrualType(loanIntInfo.getPunishType());
        fundTransferIntInfo.setPenaRate(loanIntInfo.getPunishIntRate());
        fundTransferIntInfo.setPenaRateDisplay(this.getPenaRateDisplay(loanIntInfo.getPunishType(), loanIntInfo.getPunishIntRate()));
        fundTransferIntInfo.setYingjiIntAmt(loanIntInfo.getInterest());
        fundTransferIntInfo.setShijiIntAmt(loanIntInfo.getInterest());
        fundTransferIntInfo.setYingjiPenaAmt(loanIntInfo.getPunishInterest());
        fundTransferIntInfo.setShijiPenaAmt(loanIntInfo.getPunishInterest());
        fundTransferIntInfo.setShijiSumAmt(FMHelper.add((BigDecimal)fundTransferIntInfo.getShijiIntAmt(), (BigDecimal)fundTransferIntInfo.getShijiPenaAmt()));
        fundTransferIntInfo.setYingjiSumAmt(FMHelper.add((BigDecimal)fundTransferIntInfo.getYingjiIntAmt(), (BigDecimal)fundTransferIntInfo.getYingjiPenaAmt()));
        if (this.setStrikamountCondition(fundTransferIntInfo, fundTransferSource)) {
            fundTransferIntInfo.setStrikeAmt(Constants.ZERO);
        } else {
            fundTransferIntInfo.setStrikeAmt(this.getStrikeAmount(ctx, fundTransferIntInfo));
        }
        fundTransferIntInfo.setIsStriked(false);
        fundTransferIntInfo.setStrilkeBy(null);
        fundTransferIntInfo.setFivouchered(false);
        fundTransferIntInfo.setTransCompany(fundTransferSource.getTransCompany());
        fundTransferIntInfo.setCustomer(fundTransferSource.getCustomer());
        fundTransferIntInfo.setRecAcctView(fundTransferSource.getSettleAcctView());
        fundTransferIntInfo.setAcctBank(fundTransferSource.getDistributeAcctBank());
        if (fundTransferIntInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            fundTransferIntInfo.setLastPreIntDate(this.getLastIntDate(ctx, "PreDate", fundTransferSource, fundTransferIntInfo));
        } else {
            fundTransferIntInfo.setLastSettleDate(this.getLastIntDate(ctx, "NON_PreDate", fundTransferSource, fundTransferIntInfo));
        }
        fundTransferIntInfo.setLoanInterestInfo(loanIntInfo);
    }

    private boolean setStrikamountCondition(FundTransferInterestBillInfo fundTransferIntInfo, FundTransferBillInfo fundTransferSource) {
        if (fundTransferIntInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            return true;
        }
        if (fundTransferIntInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            if (fundTransferIntInfo.getTransRepay() == null || fundTransferIntInfo.getTransRepay().getLoanBalance() == null) {
                return true;
            }
            if (fundTransferIntInfo.getTransRepay().getLoanBalance().compareTo(Constants.ZERO) != 0) {
                return true;
            }
        }
        return false;
    }

    private BigDecimal getStrikeAmount(Context ctx, FundTransferInterestBillInfo fundTransferIntInfo) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        BigDecimal returnValue = Constants.ZERO;
        sbSQL.append("select sum(FShijiIntAmt) from T_FT_FundTransferInterestBill ");
        sbSQL.append("where FEndDate<?  and FIntCalType=0 and  FIsStriked=? and FTransBillID = ? ");
        Object[] params = new Object[]{new Date(fundTransferIntInfo.getEndDate().getTime()), new Integer(0), fundTransferIntInfo.getTransBill().getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
        try {
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }

    private java.util.Date getLastIntDate(Context ctx, String type, FundTransferBillInfo fundTransferSource, FundTransferInterestBillInfo fundTransferIntInfo) throws BOSException {
        java.util.Date utilDate = null;
        Integer calType = new Integer(-1);
        calType = type.equals("PreDate") ? new Integer(0) : new Integer(fundTransferIntInfo.getIntCalType().getValue());
        String sql = "select max(FEndDate) from T_FT_FundTransferInterestBill where FIntCalType=? and FTransBillID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{calType, fundTransferSource.getId().toString()});
        try {
            Date sqlDate;
            if (rs.next() && (sqlDate = rs.getDate(1)) != null) {
                utilDate = new java.util.Date(sqlDate.getTime());
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getCause());
        }
        if (utilDate == null) {
            utilDate = type.equals("PreDate") ? fundTransferSource.getLastPreIntDate() : fundTransferSource.getLastSettleDate();
        }
        return utilDate;
    }

    private void copyValuesToEntries(FundTransferInterestEntriesBillInfo fundTransIntBillEntryInfo, LoanInterestEntryInfo imEntryInfo) {
        fundTransIntBillEntryInfo.setId(BOSUuid.create((BOSObjectType)fundTransIntBillEntryInfo.getBOSType()));
        fundTransIntBillEntryInfo.setSeq(imEntryInfo.getSeq());
        fundTransIntBillEntryInfo.setStartDate(imEntryInfo.getBeginDate());
        fundTransIntBillEntryInfo.setEndDate(imEntryInfo.getEndDate());
        fundTransIntBillEntryInfo.setIntervalDays(imEntryInfo.getDays());
        fundTransIntBillEntryInfo.setAmount(imEntryInfo.getPrincipal());
        fundTransIntBillEntryInfo.setRateExpression(imEntryInfo.getIntRateTypeExp());
        fundTransIntBillEntryInfo.setRate(imEntryInfo.getIntRate());
        fundTransIntBillEntryInfo.setRateDispaly(this.getRateDisplay(imEntryInfo.getIntRateTypeExp(), imEntryInfo.getIntRate()));
        fundTransIntBillEntryInfo.setIntAmt(imEntryInfo.getInterest());
        fundTransIntBillEntryInfo.setYearDays(imEntryInfo.getConvertDays());
        fundTransIntBillEntryInfo.setOverdueDay(imEntryInfo.getOverdueDays());
        fundTransIntBillEntryInfo.setPenaAccrualType(imEntryInfo.getPunishType());
        fundTransIntBillEntryInfo.setPenaRate(imEntryInfo.getPunishIntRate());
        fundTransIntBillEntryInfo.setPenaAccrualType(imEntryInfo.getPunishType());
        fundTransIntBillEntryInfo.setPenaRateDisplay(this.getPenaRateDisplay(imEntryInfo.getPunishType(), imEntryInfo.getPunishIntRate()));
        fundTransIntBillEntryInfo.setPenaAccrualAmt(imEntryInfo.getPunishInterest());
        fundTransIntBillEntryInfo.setAdjIntBillId(imEntryInfo.getAdjIntBillId());
    }

    private String getPenaRateDisplay(PenAccrualTypeEnum punishType, BigDecimal intPenaRate) {
        String penaRateDisplay = "";
        penaRateDisplay = punishType == PenAccrualTypeEnum.ADD_PERCENT ? String.valueOf(intPenaRate) + "%" : String.valueOf(intPenaRate) + "\u2030";
        return penaRateDisplay;
    }

    private String getRateDisplay(IntRateTypeExpressionEnum intRateTypeExp, BigDecimal intRate) {
        String rateDisplay = "";
        rateDisplay = intRateTypeExp == IntRateTypeExpressionEnum.YEAR ? String.valueOf(intRate) + "%" : String.valueOf(intRate) + "\u2030";
        return rateDisplay;
    }

    private IntCalModel getIntCalModel(java.util.Date startDate, java.util.Date endDate, FundTransferBillInfo byLoanID_LoanInfo, FundTransRateAdjustBillCollection byLoanID_adjCol, FundTransferRepayBillCollection byLoanId_RepayCol, FundTransferRepayBillInfo transRepayInfo) {
        ImFtAdjustIntRateCollection iAdjColl = new ImFtAdjustIntRateCollection(byLoanID_adjCol);
        ImFundTransferRepaymentBillCollection iRepayColl = new ImFundTransferRepaymentBillCollection(byLoanId_RepayCol);
        ImFundTransferRepayInfo imFundTransferRepayInfo = new ImFundTransferRepayInfo(transRepayInfo);
        IntCalModel model = new IntCalModel();
        model.setBeginDate(startDate);
        model.setEndDate(endDate);
        model.setLoanInfo((ILoanInfo)byLoanID_LoanInfo);
        model.setAdjIntRateColl((IAdjustIntRateCollection)iAdjColl);
        model.setRepayColl((IRepaymentBillCollection)iRepayColl);
        model.setRepayInfo((IRepaymentBillInfo)imFundTransferRepayInfo);
        model.setNewRequirement(false);
        return model;
    }

    private FundTransferBillInfo filtedLoanColByLoanId(FundTransferBillCollection loanCol, String loanid) {
        FundTransferBillInfo tmp = null;
        for (int i = 0; i < loanCol.size() && !(tmp = loanCol.get(i)).getId().toString().equals(loanid); ++i) {
        }
        return tmp;
    }

    private FundTransferRepayBillCollection filtedRepayColByLoanId(FundTransferRepayBillCollection repayCol, String loanid) {
        FundTransferRepayBillCollection repayColReturn = new FundTransferRepayBillCollection();
        FundTransferRepayBillInfo tmp = null;
        for (int i = 0; i < repayCol.size(); ++i) {
            tmp = repayCol.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanid)) continue;
            repayColReturn.add(tmp);
        }
        return repayColReturn;
    }

    private FundTransRateAdjustBillCollection filtedAdjColByLoanId(FundTransRateAdjustBillCollection adjustCol, String loanid) {
        FundTransRateAdjustBillCollection adjColReturn = new FundTransRateAdjustBillCollection();
        FundTransRateAdjustBillInfo tmp = null;
        for (int i = 0; i < adjustCol.size(); ++i) {
            tmp = adjustCol.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanid)) continue;
            adjColReturn.add(tmp);
        }
        return adjColReturn;
    }

    private FundTransferBillCollection getFtLoanCol(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("currency.id"));
        evi.getSelector().add(new SelectorItemInfo("currency.precision"));
        evi.getSelector().add(new SelectorItemInfo("settleAcctView.id"));
        evi.getSelector().add(new SelectorItemInfo("settleAcctView.number"));
        evi.getSelector().add(new SelectorItemInfo("settleAcctView.name"));
        evi.getSelector().add(new SelectorItemInfo("transCompany.id"));
        evi.getSelector().add(new SelectorItemInfo("transCompany.number"));
        evi.getSelector().add(new SelectorItemInfo("transCompany.name"));
        evi.getSelector().add(new SelectorItemInfo("customer.id"));
        evi.getSelector().add(new SelectorItemInfo("customer.number"));
        evi.getSelector().add(new SelectorItemInfo("customer.name"));
        evi.getSelector().add(new SelectorItemInfo("distributeAcctBank.id"));
        evi.getSelector().add(new SelectorItemInfo("distributeAcctBank.number"));
        evi.getSelector().add(new SelectorItemInfo("distributeAcctBank.name"));
        evi.getSelector().add(new SelectorItemInfo("currency.id"));
        evi.getSelector().add(new SelectorItemInfo("currency.number"));
        evi.getSelector().add(new SelectorItemInfo("currency.name"));
        evi.getSelector().add(new SelectorItemInfo("project.id"));
        evi.getSelector().add(new SelectorItemInfo("project.number"));
        evi.getSelector().add(new SelectorItemInfo("project.name"));
        return FundTransferBillFactory.getLocalInstance(ctx).getFundTransferBillCollection(evi);
    }

    private FundTransRateAdjustBillCollection getFtAdjustColl(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("adjustDate"));
        return FundTransRateAdjustBillFactory.getLocalInstance(ctx).getFundTransRateAdjustBillCollection(evi);
    }

    private FundTransferRepayBillCollection getFtRepayCol(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("repayDate"));
        return FundTransferRepayBillFactory.getLocalInstance(ctx).getFundTransferRepayBillCollection(evi);
    }

    @Override
    protected void _deleteRaleted(Context ctx, IObjectPK transRepayPK) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fil = new FilterInfo();
        fil.getFilterItems().add(new FilterItemInfo("transRepay.id", (Object)transRepayPK.toString()));
        evi.setFilter(fil);
        FundTransferInterestBillCollection col = FundTransferInterestBillFactory.getLocalInstance(ctx).getFundTransferInterestBillCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            this.deleteRelated = true;
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(col.get(i).getId()));
        }
    }

    @Override
    protected Set _batchPreInt(Context ctx, Set transferBillIDs, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        return this.batchPreInt4Log(ctx, transferBillIDs, startDate, endDate);
    }

    @Override
    protected Set _batchPreInt4Log(Context ctx, Set transferBillIDs, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        StringBuffer sbLog = new StringBuffer();
        FundTransferInterestBillInfo transferInterestInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        HashSet<String> usedAdjuectID = new HashSet<String>();
        FundTransRateAdjustBillCollection adjCol = this.getFtAdjustColl(ctx, transferBillIDs);
        FundTransferRepayBillCollection repayCol = this.getFtRepayCol(ctx, transferBillIDs);
        FundTransferBillCollection loanCol = this.getFtLoanCol(ctx, transferBillIDs);
        for (String loanid : transferBillIDs) {
            FundTransferRepayBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
            FundTransferBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
            FundTransRateAdjustBillCollection byLoanID_adjCol = this.filtedAdjColByLoanId(adjCol, loanid);
            IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanID_adjCol, byLoanId_RepayCol, null);
            LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PRE_INT).calInt(ctx, model);
            transferInterestInfo = this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, null);
            IObjectPK pk = null;
            if (FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)transferInterestInfo.getBOSType())) {
                transferInterestInfo.setEffectedStatus(StateEnum.SAVE);
                pk = super.save(ctx, (CoreBaseInfo)transferInterestInfo);
            } else {
                pk = super.submit(ctx, (CoreBaseInfo)transferInterestInfo);
            }
            InterestBizDTO genBizDTO = this.genBizDTO(transferInterestInfo);
            LoanInterestEntryCollection iCol = loanIntInfo.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                LoanIntBillBizHelper.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), genBizDTO);
                usedAdjuectID.add(imLoanInterestInfo.getAdjIntBillId());
            }
            createdIntReceivedID.add(pk);
            sbLog.append(transferInterestInfo.getNumber()).append(" | ");
        }
        LoanIntBillBizHelper.updateAdjustRateStatus(ctx, usedAdjuectID, "T_FT_FundTransRateAdjustBill");
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"12_FundTransferInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new FundTransferInterestBillInfo().getBOSType(), null, (String)sbLog.toString(), (String)"ftinsterest_preint");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return createdIntReceivedID;
    }

    @Override
    protected Set _batchRecInt(Context ctx, Set transferBillIDs, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        FundTransferInterestBillInfo transferInterestInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        FundTransRateAdjustBillCollection adjCol = this.getFtAdjustColl(ctx, transferBillIDs);
        FundTransferRepayBillCollection repayCol = this.getFtRepayCol(ctx, transferBillIDs);
        FundTransferBillCollection loanCol = this.getFtLoanCol(ctx, transferBillIDs);
        for (String loanid : transferBillIDs) {
            FundTransRateAdjustBillCollection byLoanID_adjCol = this.filtedAdjColByLoanId(adjCol, loanid);
            FundTransferRepayBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
            FundTransferBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
            IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanID_adjCol, byLoanId_RepayCol, null);
            LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REC_INT).calInt(ctx, model);
            transferInterestInfo = this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, null);
            IObjectPK pk = super.submit(ctx, (CoreBaseInfo)transferInterestInfo);
            createdIntReceivedID.add(pk);
        }
        return createdIntReceivedID;
    }

    @Override
    protected void _batchSubmit4Log(Context ctx, Set transferInterestIDs) throws BOSException, EASBizException {
        String intBillId2 = "";
        StringBuffer sbLog = new StringBuffer();
        FundTransferInterestBillInfo info = new FundTransferInterestBillInfo();
        for (String intBillId2 : transferInterestIDs) {
            info = this.getFundTransferInterestBillInfo(ctx, (IObjectPK)new ObjectUuidPK(intBillId2));
            super.submit(ctx, (CoreBaseInfo)info);
            sbLog.append(info.getNumber()).append(" | ");
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"13_FundTransferInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)info.getBOSType(), null, (String)sbLog.toString(), (String)"ftinsterest_batchsubmit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _batchSubmit(Context ctx, Set transferInterestIDs) throws BOSException, EASBizException {
        this.batchSubmit4Log(ctx, transferInterestIDs);
    }

    @Override
    protected FundTransferInterestBillCollection _batchRecIntWithFpItem(Context ctx, Set transferBillIDSet, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        HashSet<String> usedAdjuectID = new HashSet<String>();
        FundTransferInterestBillInfo transferInterestInfo = null;
        FundTransferInterestBillCollection ftIntCol = new FundTransferInterestBillCollection();
        FundTransRateAdjustBillCollection adjCol = this.getFtAdjustColl(ctx, transferBillIDSet);
        FundTransferRepayBillCollection repayCol = this.getFtRepayCol(ctx, transferBillIDSet);
        FundTransferBillCollection loanCol = this.getFtLoanCol(ctx, transferBillIDSet);
        for (String loanid : transferBillIDSet) {
            FundTransferRepayBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
            FundTransferBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
            FundTransRateAdjustBillCollection byLoanID_adjCol = this.filtedAdjColByLoanId(adjCol, loanid);
            IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanID_adjCol, byLoanId_RepayCol, null);
            LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REC_INT).calInt(ctx, model);
            transferInterestInfo = this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, null);
            transferInterestInfo.setId(BOSUuid.create((BOSObjectType)transferInterestInfo.getBOSType()));
            ftIntCol.add(transferInterestInfo);
            InterestBizDTO genBizDTO = this.genBizDTO(transferInterestInfo);
            LoanInterestEntryCollection iCol = loanIntInfo.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                LoanIntBillBizHelper.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), genBizDTO);
                usedAdjuectID.add(imLoanInterestInfo.getAdjIntBillId());
            }
            LoanIntBillBizHelper.updateAdjustRateStatus(ctx, usedAdjuectID, "T_FT_FundTransRateAdjustBill");
        }
        return ftIntCol;
    }

    @Override
    protected Set _batchSubmitWithFmItem(Context ctx, FundTransferInterestBillCollection intCol) throws BOSException, EASBizException {
        return this.batchSubmitWithFmItem4Log(ctx, intCol);
    }

    @Override
    protected Set _batchSubmitWithFmItem4Log(Context ctx, FundTransferInterestBillCollection intCol) throws BOSException, EASBizException {
        FundTransferInterestBillInfo element = new FundTransferInterestBillInfo();
        HashSet<String> returnValue = new HashSet<String>();
        StringBuffer sbLog = new StringBuffer();
        HashSet<String> usedAdjuectID = new HashSet<String>();
        IObjectPK pk = null;
        Iterator iter = intCol.iterator();
        while (iter.hasNext()) {
            element = (FundTransferInterestBillInfo)iter.next();
            if ((element.getIntCalType() == IntCalTypeEnum.PRE_INT || element.getIntCalType() == IntCalTypeEnum.REC_INT) && FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)element.getBOSType())) {
                element.setEffectedStatus(StateEnum.SAVE);
                pk = this.save(ctx, (CoreBaseInfo)element);
            } else {
                pk = this.submit(ctx, (CoreBaseInfo)element);
            }
            InterestBizDTO genBizDTO = this.genBizDTO(element);
            FundTransferInterestEntriesBillCollection iCol = element.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                FundTransferInterestEntriesBillInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                LoanIntBillBizHelper.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), genBizDTO);
                usedAdjuectID.add(imLoanInterestInfo.getAdjIntBillId());
            }
            returnValue.add(pk.toString());
            sbLog.append(element.getNumber()).append(" | ");
        }
        LoanIntBillBizHelper.updateAdjustRateStatus(ctx, usedAdjuectID, "T_FT_FundTransRateAdjustBill");
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"14_FundTransferInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)element.getBOSType(), null, (String)sbLog.toString(), (String)"ftinsterest_recint");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return returnValue;
    }

    @Override
    protected Set _batchRecInt4Log(Context ctx, java.util.Date transferBillIDs, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _updateRecmentBillID(Context ctx, IObjectPK fundTransIntID, IObjectPK recBillID) throws BOSException, EASBizException {
        if (recBillID != null) {
            String sql = "update T_FT_FundTransferInterestBill set FRecBillID = ?, FIsGatherBill = ? where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{recBillID.toString(), Boolean.TRUE, fundTransIntID.toString()});
        } else {
            String sql = "update T_FT_FundTransferInterestBill set FRecBillID = null, FIsGatherBill = ? where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{Boolean.FALSE, fundTransIntID.toString()});
        }
    }

    @Override
    protected Map _repayIntForRateAdjust(Context ctx, java.util.Date startDate, java.util.Date endDate, FundTransferRepayBillInfo transRepayInfo) throws BOSException, EASBizException {
        String loanid = transRepayInfo.getLoan().getId().toString();
        HashSet<String> loanIDSet = new HashSet<String>();
        loanIDSet.add(loanid);
        FundTransRateAdjustBillCollection adjCol = this.getFtAdjustColl(ctx, loanIDSet);
        FundTransferRepayBillCollection repayCol = this.getFtRepayCol(ctx, loanIDSet);
        FundTransferBillCollection loanCol = this.getFtLoanCol(ctx, loanIDSet);
        FundTransRateAdjustBillCollection byLoanID_adjCol = this.filtedAdjColByLoanId(adjCol, loanid);
        FundTransferRepayBillCollection byLoanId_RepayCol = this.filtedRepayColByLoanId(repayCol, loanid);
        FundTransferBillInfo byLoanID_LoanInfo = this.filtedLoanColByLoanId(loanCol, loanid);
        IntCalModel model = this.getIntCalModel(startDate, endDate, byLoanID_LoanInfo, byLoanID_adjCol, byLoanId_RepayCol, transRepayInfo);
        LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
        FundTransferInterestBillInfo info = this.transfrom(ctx, loanIntInfo, byLoanID_LoanInfo, transRepayInfo);
        HashMap<String, FundTransferInterestBillInfo> map = new HashMap<String, FundTransferInterestBillInfo>();
        map.put("fundTransferInterestBillInfo", info);
        map.put("loanInterestInfo", (FundTransferInterestBillInfo)loanIntInfo);
        return map;
    }

    @Override
    protected IObjectPK _submitForRateAdjust(Context ctx, Map map) throws BOSException, EASBizException {
        FundTransferRepayBillInfo repayBill;
        StringBuffer sbLog = new StringBuffer();
        FundTransferInterestBillInfo transIntBillInfo = (FundTransferInterestBillInfo)map.get("fundTransferInterestBillInfo");
        transIntBillInfo.setEffectedStatus(StateEnum.SUBMISSION);
        HashSet<String> usedAdjuectID = new HashSet<String>();
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        if (transIntBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT && (repayBill = transIntBillInfo.getRepayInfo()) != null) {
            BOSObjectType repayBillBOSType = repayBill.getBOSType();
            BOSUuid id = BOSUuid.create((BOSObjectType)repayBillBOSType);
            repayBill.setId(id);
            repayBill.setHasInterestBill(true);
            transIntBillInfo.getTransRepay().setId(id);
        }
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)transIntBillInfo);
        IObjectPK pk = super._submit(ctx, (IObjectValue)transIntBillInfo);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)transIntBillInfo);
        InterestBizDTO genBizDTO = this.genBizDTO(transIntBillInfo);
        LoanInterestInfo loanIntInfo = (LoanInterestInfo)map.get("loanInterestInfo");
        LoanInterestEntryCollection iCol = loanIntInfo.getEntries();
        for (int i = 0; i < iCol.size(); ++i) {
            LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
            if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
            LoanIntBillBizHelper.saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), genBizDTO);
            usedAdjuectID.add(imLoanInterestInfo.getAdjIntBillId());
        }
        createdIntReceivedID.add(pk);
        sbLog.append(transIntBillInfo.getNumber()).append(" | ");
        LoanIntBillBizHelper.updateAdjustRateStatus(ctx, usedAdjuectID, "T_FT_FundTransRateAdjustBill");
        if (transIntBillInfo.getIntCalType().getValue() == 2) {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"11_FundTransferInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)transIntBillInfo.getBOSType(), null, (String)transIntBillInfo.getNumber(), (String)"ftinsterest_repayint");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        this.updateFpItem(ctx, pk);
        if (transIntBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            String sql = "update T_FT_FundTransferRepayBill set FAccrual=?,FPenaAccrual=?  where fid = ?";
            Object[] params = new Object[]{transIntBillInfo.getShijiIntAmt(), transIntBillInfo.getShijiPenaAmt(), transIntBillInfo.getTransRepay().getId().toString()};
            FMHelper.execute((Context)ctx, (String)sql, (Object[])params);
        }
        return pk;
    }

    protected void _audit(Context ctx, Set ids) throws BOSException, EASBizException {
        String id2 = null;
        for (String id2 : ids) {
            super.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id2));
        }
    }

    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit4WF(ctx, pk);
        this.updateState(ctx, pk.toString(), true);
    }

    protected void _unAudit(Context ctx, Set ids) throws BOSException, EASBizException {
        try {
            String id2 = null;
            String sql = null;
            FundTransferInterestBillInfo billInfo = null;
            for (String id2 : ids) {
                billInfo = FundTransferInterestBillFactory.getLocalInstance(ctx).getFundTransferInterestBillInfo((IObjectPK)new ObjectUuidPK(id2));
                if (billInfo.isIsGenLoanInt()) {
                    throw new FMException(FMException.HASLOANINTNOTUNAUDIT);
                }
                sql = "select 1 from t_bot_relation where fsrcobjectid = '" + id2 + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    throw new FMException(FMException.HASDESTBILLNOTUNAUDIT);
                }
                super.unAudit4WF(ctx, (IObjectPK)new ObjectUuidPK(id2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _unAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._unAudit4WF(ctx, pk);
        this.updateState(ctx, pk.toString(), false);
    }

    protected void updateState(Context ctx, String id, boolean isAudit) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_FT_FundTransferInterestBill set FEffectedStatus = ?, fauditorID = ?, fauditTime = ? where fid = ? and FEffectedStatus = ?");
        if (isAudit) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{2, userInfo.getId().toString(), new Date(this.getCurrentDate().getTime()), id, 1});
        } else {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{0, null, null, id, 2});
        }
    }

    protected boolean _isExistPropertyName(Context ctx, CoreBaseInfo coreBaseInfo, String propertyName) {
        return false;
    }
}

