/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.cl.RepayBaseBillInfo;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestEntriesBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestEntriesBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ft.app.InterestBizDTO;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LoanIntBillBizHelper {
    private static Map botpRelationShip = new HashMap();

    public static void afterIntBillSaved(Context ctx, InterestBizDTO infoInt, IObjectPK pkReturn) throws BOSException {
        if (infoInt.getIntCalType().getValue() == 1 || infoInt.getIntCalType().getValue() == 0 || infoInt.getIntCalType().getValue() == 2) {
            // empty if block
        }
    }

    private static void afterPreIntSave(Context ctx, InterestBizDTO loanInterestBillInfo, IObjectPK pkSavedIntBill) throws BOSException {
        LoanIntBillBizHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pkSavedIntBill);
        LoanIntBillBizHelper.updateLoanBillLastPreIntDate(ctx, loanInterestBillInfo);
    }

    private static void afterRecIntSave(Context ctx, InterestBizDTO loanInterestBillInfo, IObjectPK pkSavedIntBill) throws BOSException {
        LoanIntBillBizHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pkSavedIntBill);
        LoanIntBillBizHelper.updateLoanBillLastSetteleDate(ctx, loanInterestBillInfo);
    }

    public static void afterIntBillSubmited(Context ctx, InterestBizDTO loanInterestBillInfo, IObjectPK pkSubmitedIntBill) throws EASBizException, BOSException {
        if (loanInterestBillInfo.getIntCalType().getValue() == 1) {
            LoanIntBillBizHelper.afterRecIntSubmit(ctx, loanInterestBillInfo, pkSubmitedIntBill);
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 0) {
            LoanIntBillBizHelper.afterPreIntSubmit(ctx, loanInterestBillInfo, pkSubmitedIntBill);
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 2) {
            LoanIntBillBizHelper.afterRepaySubmit(ctx, loanInterestBillInfo, pkSubmitedIntBill);
        }
    }

    private static void afterRepaySubmit(Context ctx, InterestBizDTO bizDTO, IObjectPK pkSubmitedIntBill) throws EASBizException, BOSException {
        if (bizDTO.getRepaymentBill() != null) {
            LoanIntBillBizHelper.saveRepaymentBill(ctx, bizDTO);
            LoanIntBillBizHelper.saveBOTPRelationShip(ctx, bizDTO, pkSubmitedIntBill);
            LoanIntBillBizHelper.updateLoanBillLastSetteleDate(ctx, bizDTO);
            LoanIntBillBizHelper.updateStrikeStatusAndAmt(ctx, bizDTO);
            LoanIntBillBizHelper.updateAdjustRate1(ctx, bizDTO);
        }
    }

    public static void updateAdjustRate1(Context ctx, InterestBizDTO bizDTO) throws BOSException {
        HashSet<String> usedAdjuectID = new HashSet<String>();
        if (bizDTO.getIntInfo() != null) {
            FundTransferInterestEntriesBillCollection iCol = ((FundTransferInterestBillInfo)bizDTO.getIntInfo()).getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                FundTransferInterestEntriesBillInfo entrInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)entrInfo.getAdjIntBillId())) continue;
                LoanIntBillBizHelper.saveBOTPRelationShipLoanAdjust(ctx, entrInfo.getAdjIntBillId(), bizDTO);
                usedAdjuectID.add(entrInfo.getAdjIntBillId());
            }
            LoanIntBillBizHelper.updateAdjustRateStatus(ctx, usedAdjuectID, bizDTO.getTableName_Interest());
        }
    }

    public static void updateAdjustRateStatus(Context ctx, Set usedAdjustID, String tableName) throws BOSException {
        if (usedAdjustID != null && usedAdjustID.size() > 0) {
            String sql = "update  T_FT_FundTransRateAdjustBill set fisused = 1 where " + LoanIntBillBizHelper.getFilterString(usedAdjustID);
            FMHelper.execute((Context)ctx, (String)sql, (Object[])usedAdjustID.toArray());
        }
    }

    public static void saveBOTPRelationShipLoanAdjust(Context ctx, String ajustId, InterestBizDTO bizDTO) throws BOSException {
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        botpRelationShip.clear();
        botpRelationShip.put(ajustId, bizDTO.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
    }

    private static String getFilterString(Set idSets) {
        StringBuffer sb = new StringBuffer();
        int size = idSets.size();
        for (int i = 0; i < size; ++i) {
            sb.append(" fid = ? ");
            if (i == size - 1) continue;
            sb.append(" or ");
        }
        return sb.toString();
    }

    private static void updateStrikeStatusAndAmt(Context ctx, InterestBizDTO bizDTO) throws BOSException, EASBizException {
        if (LoanIntBillBizHelper.isRecInt(bizDTO) || LoanIntBillBizHelper.isRepayIntAndRepayAll(bizDTO)) {
            String loanid = bizDTO.getLoan().getId().toString();
            String loanIntBillID = bizDTO.getId();
            BigDecimal sumAmt = LoanIntBillBizHelper.getPreIntAmt(ctx, bizDTO);
            String sqlupdate1 = "update " + bizDTO.getTableName_Interest() + " set FStrikeAmt = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sqlupdate1, (Object[])new Object[]{sumAmt, loanIntBillID});
            SQLUtil sql1 = new SQLUtil();
            sql1.appendSql("update " + bizDTO.getTableName_Interest() + " set FIsStriked=1,FStrilkeBy=?  ");
            sql1.appendSql("where  FEndDate<=? and FIsStriked=0 and fintCalType=0 and " + bizDTO.getColumn_loanID() + " = ?");
            sql1.addParams(new Object[]{loanIntBillID, DateTimeUtils.truncateDate((java.util.Date)bizDTO.getEndDate()), loanid});
            FMHelper.execute((Context)ctx, (String)sql1.getSql(), (Object[])sql1.getParamaters().toArray());
        }
    }

    private static BigDecimal getPreIntAmt(Context ctx, InterestBizDTO bizDTO) throws BOSException, EASBizException {
        BigDecimal returnValue = Constants.ZERO;
        String loanid = bizDTO.getLoan().getId().toString();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select sum(FShijiIntAmt+FShijiPenaAmt) from  ").append(bizDTO.getTableName_Interest());
        sql2.append(" where fintCalType=0 and FIsStriked =? and  ");
        sql2.append("FEndDate<=? and " + bizDTO.getColumn_loanID() + " = ?   ");
        Object[] params = new Object[]{ResourceFactory.VALUE_0, new Date(DateTimeUtils.truncateDate((java.util.Date)bizDTO.getEndDate()).getTime()), loanid};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])params);
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }

    private static void updateLoanBillLastSetteleDate(Context ctx, InterestBizDTO bizDTO) throws BOSException {
        if (LoanIntBillBizHelper.isRecInt(bizDTO) || LoanIntBillBizHelper.isRepayIntAndRepayAll(bizDTO)) {
            String sql = "update " + bizDTO.getTableName_Loan() + " set FLastSettleDate=? where fid=?";
            FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{DateTimeUtils.truncateDate((java.util.Date)bizDTO.getEndDate()), bizDTO.getLoan().getId().toString()});
        }
    }

    private static boolean isRecInt(InterestBizDTO loanInterestBillInfo) {
        return loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.REC_INT;
    }

    private static boolean isRepayIntAndRepayAll(InterestBizDTO loanInterestBillInfo) {
        boolean isRepay = loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT;
        boolean isRepayAll = LoanIntBillBizHelper.isRepayAllThisTime(loanInterestBillInfo.getRepaymentBill());
        return isRepay && isRepayAll;
    }

    private static void updateLoanBillLastPreIntDate(Context ctx, InterestBizDTO bizDTO) throws BOSException {
        String sql = "update " + bizDTO.getTableName_Loan() + " set FLastPreIntDate=? where fid=?";
        Date dataParam = new Date(DateTimeUtils.truncateDate((java.util.Date)bizDTO.getEndDate()).getTime());
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{dataParam, bizDTO.getLoan().getId().toString()});
    }

    private static void saveRepaymentBill(Context ctx, InterestBizDTO bizDTO) throws EASBizException, BOSException {
        RepayBaseBillInfo repayBaseInfo = bizDTO.getRepaymentBill();
        if (repayBaseInfo != null) {
            if (repayBaseInfo instanceof ConsingnRepaymentBillInfo) {
                LoanIntBillBizHelper.dealWithConsignRepay(ctx, (ConsingnRepaymentBillInfo)repayBaseInfo, bizDTO);
            } else if (repayBaseInfo instanceof FundTransferRepayBillInfo) {
                LoanIntBillBizHelper.dealWithTransRepay(ctx, (FundTransferRepayBillInfo)repayBaseInfo, bizDTO);
            }
        }
    }

    private static void dealWithTransRepay(Context ctx, FundTransferRepayBillInfo transferRepayInfo, InterestBizDTO bizDTO) throws EASBizException, BOSException {
        FundTransferRepayBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)transferRepayInfo);
    }

    private static void dealWithConsignRepay(Context ctx, ConsingnRepaymentBillInfo repayBill, InterestBizDTO bizDTO) throws EASBizException, BOSException {
        repayBill.setAccrual(bizDTO.getShijiIntAmt());
        repayBill.setPenaAccrual(bizDTO.getShijiPenaAmt());
        repayBill.setHandlingChargeAmt(bizDTO.getHandleChargeAmt());
        repayBill.setSaleTax(bizDTO.getSalesTax());
        ConsingnRepaymentBillFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)repayBill);
    }

    private static boolean isRepayAllThisTime(RepayBaseBillInfo repayBill) {
        return repayBill.getLoanBalance().compareTo(Constants.ZERO) == 0;
    }

    private static void afterPreIntSubmit(Context ctx, InterestBizDTO loanInterestBillInfo, IObjectPK pk) throws BOSException {
        LoanIntBillBizHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pk);
        LoanIntBillBizHelper.updateLoanBillLastPreIntDate(ctx, loanInterestBillInfo);
    }

    private static void afterRecIntSubmit(Context ctx, InterestBizDTO loanInterestBillInfo, IObjectPK pk) throws BOSException, EASBizException {
        LoanIntBillBizHelper.saveBOTPRelationShip(ctx, loanInterestBillInfo, pk);
        LoanIntBillBizHelper.updateLoanBillLastSetteleDate(ctx, loanInterestBillInfo);
        LoanIntBillBizHelper.updateStrikeStatusAndAmt(ctx, loanInterestBillInfo);
    }

    private static void saveBOTPRelationShip(Context ctx, InterestBizDTO infoInt, IObjectPK pkReturn) throws BOSException {
        botpRelationShip.clear();
        botpRelationShip.put(infoInt.getLoan().getId().toString(), pkReturn.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
        if (infoInt.getRepaymentBill() != null) {
            botpRelationShip.clear();
            botpRelationShip.put(infoInt.getRepaymentBill().getId().toString(), pkReturn.toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
        }
    }

    public static void afterIntBillDeleted(Context ctx, InterestBizDTO bizDTO, IObjectPK pkDeletedIntBill) throws BOSException {
        if (bizDTO.getIntCalType().getValue() == 1) {
            LoanIntBillBizHelper.afterRecIntDelete(ctx, bizDTO, pkDeletedIntBill);
        } else if (bizDTO.getIntCalType().getValue() == 0) {
            LoanIntBillBizHelper.afterPreIntDelete(ctx, bizDTO);
        } else if (bizDTO.getIntCalType().getValue() == 2) {
            LoanIntBillBizHelper.afterRepayDelete(ctx, bizDTO, pkDeletedIntBill);
        }
        LoanIntBillBizHelper.updateAdjustRateStatusBeforeDelete(ctx, bizDTO);
    }

    private static void updateAdjustRateStatusBeforeDelete(Context ctx, InterestBizDTO bizDTO) throws BOSException {
        HashSet<String> allUsedRate = new HashSet<String>();
        String sql1 = "select fsrcObjectID from  T_BOT_Relation where fDestObjectID != ? and  FdestentityID = 'ABE9A18C' and  FsrcentityID = '8F99404E'";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{bizDTO.getId().toString()});
        try {
            while (rs1.next()) {
                allUsedRate.add(rs1.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashSet<String> notUsedRate = new HashSet<String>();
        String sql = "select fsrcObjectID from  T_BOT_Relation where fDestObjectID = ? and  FsrcentityID = '8F99404E' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bizDTO.getId().toString()});
        try {
            while (rs.next()) {
                String sourceID = rs.getString(1);
                if (allUsedRate.contains(sourceID)) continue;
                notUsedRate.add(sourceID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (notUsedRate != null && notUsedRate.size() > 0) {
            String sqlUpdate = "update T_FT_FundTransRateAdjustBill set fisused = 0 where " + LoanIntBillBizHelper.getFilterString(notUsedRate);
            FMHelper.execute((Context)ctx, (String)sqlUpdate, (Object[])notUsedRate.toArray());
        }
    }

    private static void afterRepayDelete(Context ctx, InterestBizDTO bizDTO, IObjectPK pkDeletedIntBill) throws BOSException {
        RepayBaseBillInfo repayBill;
        if (bizDTO.getRelatedRepayInfo() != null && (repayBill = bizDTO.getRelatedRepayInfo()).getLoanBalance().compareTo(Constants.ZERO) == 0) {
            LoanIntBillBizHelper.updateStrikeStatus(ctx, bizDTO);
            LoanIntBillBizHelper.updateLoanBillLasSettleDate_Delete(ctx, bizDTO);
        }
    }

    private static void afterPreIntDelete(Context ctx, InterestBizDTO loanInterestBillInfo) throws BOSException {
        LoanIntBillBizHelper.updateLoanBillLastPreIntDate_Delete(ctx, loanInterestBillInfo);
    }

    private static void updateLoanBillLastPreIntDate_Delete(Context ctx, InterestBizDTO bizDTO) throws BOSException {
        String sql = "update " + bizDTO.getTableName_Loan() + " set FLastPreIntDate=? where fid=?";
        java.util.Date lastPreIntDate = bizDTO.getLastPreIntDate();
        lastPreIntDate = lastPreIntDate == null ? null : DateTimeUtils.truncateDate((java.util.Date)lastPreIntDate);
        Date daparam = null;
        if (lastPreIntDate != null) {
            daparam = new Date(lastPreIntDate.getTime());
        }
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{daparam, bizDTO.getLoan().getId().toString()});
    }

    private static void afterRecIntDelete(Context ctx, InterestBizDTO loanInterestBillInfo, IObjectPK pkDeletedIntBill) throws BOSException {
        LoanIntBillBizHelper.updateStrikeStatus(ctx, loanInterestBillInfo);
        LoanIntBillBizHelper.updateLoanBillLasSettleDate_Delete(ctx, loanInterestBillInfo);
    }

    private static void updateStrikeStatus(Context ctx, InterestBizDTO bizDTO) throws BOSException {
        String sql = "update " + bizDTO.getTableName_Interest() + " set FIsStriked=? where FStrilkeBy=? ";
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{ResourceFactory.VALUE_0, bizDTO.getId().toString()});
    }

    private static void updateLoanBillLasSettleDate_Delete(Context ctx, InterestBizDTO bizDTO) throws BOSException {
        String sql = "update " + bizDTO.getTableName_Loan() + " set FLastSettleDate=? where fid=?";
        java.util.Date startDate = bizDTO.getStartDate();
        java.util.Date lastSettleDate = startDate == null ? null : DateUtil.getBeforeDay((java.util.Date)startDate);
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{lastSettleDate, bizDTO.getLoan().getId().toString()});
    }
}

