/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.common.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.ft.app.RptFundTransBillSchemaSourceMaker_ByCompany;
import com.kingdee.eas.fm.ft.app.RptFundTransBillSchemaSourceMaker_ByFinPro;
import com.kingdee.eas.fm.ft.app.RptFundTransBillSchemaSourceMaker_ByTransCompany;
import com.kingdee.eas.fm.ft.app.RptFundTransferBillBalanceSumFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.util.Locale;
import java.util.Set;

public class RptFundTransBillSchemaSourceMaker {
    protected CompanyOrgUnitInfo currentCompany;
    protected CurrencyInfo baseCurrency;
    protected java.util.Date endDate = DateUtil.getDayBegin();
    protected LoanStatisticalUnitEnum amountUnit;
    protected String loc;
    protected String[] companyIDs;
    protected String[] finacingProIDs;
    protected String[] transCompanyIDs;
    protected String[] customerIDs;
    protected String unit = "1";
    protected CurrencyInfo currency;
    protected RelationshipWithLoanCompanyEnum relations;
    protected StringBuffer commonFiler;

    public static RptFundTransBillSchemaSourceMaker getInstance(RptParams params, Context ctx) throws EASBizException, BOSException {
        String queryType = (String)params.getObject("queryType");
        if ("byCompany".equals(queryType)) {
            return new RptFundTransBillSchemaSourceMaker_ByCompany(params, ctx);
        }
        if ("byTransCompany".equals(queryType)) {
            return new RptFundTransBillSchemaSourceMaker_ByTransCompany(params, ctx);
        }
        if ("byFinPro".equals(queryType)) {
            return new RptFundTransBillSchemaSourceMaker_ByFinPro(params, ctx);
        }
        return null;
    }

    public RptFundTransBillSchemaSourceMaker(RptParams params, Context ctx) throws EASBizException, BOSException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
        Set companySet = (Set)params.getObject("company");
        this.companyIDs = companySet.toArray(new String[companySet.size()]);
        this.endDate = (java.util.Date)params.getObject("endDate");
        this.currency = (CurrencyInfo)params.getObject("currency");
        this.amountUnit = (LoanStatisticalUnitEnum)params.getObject("unit");
        this.finacingProIDs = (String[])params.getObject("finPro");
        this.relations = (RelationshipWithLoanCompanyEnum)params.getObject("relations");
        this.transCompanyIDs = (String[])params.getObject("transCompany");
        this.customerIDs = (String[])params.getObject("customer");
        this.loc = this.getLoc(ctx);
        this.prepare(this.amountUnit.getValue());
    }

    public void prepare(String amountUnit) throws BOSException, EASBizException {
        this.commonFiler = this.getCommonFilter();
        if (amountUnit.equals("thousand")) {
            this.unit = "1000";
        } else if (amountUnit.equals("ten_thousand")) {
            this.unit = "10000";
        } else if (amountUnit.equals("million")) {
            this.unit = "1000000";
        } else if (amountUnit.equals("hundred_thousand")) {
            this.unit = "10000000";
        } else if (amountUnit.equals("hundred_million")) {
            this.unit = "100000000";
        }
    }

    public SchemaSource createSchemaSource() {
        SchemaSource ss = new SchemaSource();
        this.assembleSchemaSource(ss);
        return ss;
    }

    protected StringBuffer getCommonFilter() {
        StringBuffer sbCommonFilter = new StringBuffer();
        this.setDateCondition(sbCommonFilter);
        this.setCurrencyCondition(sbCommonFilter);
        this.setCompanyCondition(sbCommonFilter);
        this.setFinaProdeuctCondition(sbCommonFilter);
        this.setFixCompanyCondition(sbCommonFilter);
        this.setStatusCondition(sbCommonFilter);
        return sbCommonFilter;
    }

    protected Object[] getParams() {
        int i;
        Date endDateParam = new Date(DateTimeUtils.truncateDate((java.util.Date)this.endDate).getTime());
        Object[] endDateArray = new Object[]{endDateParam};
        Object[] currencyArray = new Object[]{this.currency.getId().toString()};
        Object[] companyParam = null;
        if (this.companyIDs != null && this.companyIDs.length > 0) {
            companyParam = new Object[this.getPlaceholderCount(this.companyIDs.length)];
            this.setParamArray(companyParam, this.companyIDs);
        }
        int companyParamCount = companyParam == null ? 0 : companyParam.length;
        Object[] finacingProductParam = null;
        if (this.finacingProIDs != null && this.finacingProIDs.length > 0) {
            finacingProductParam = new Object[this.getPlaceholderCount(this.finacingProIDs.length)];
            this.setParamArray(finacingProductParam, this.finacingProIDs);
        }
        int finacingProductParamCount = finacingProductParam == null ? 0 : finacingProductParam.length;
        Object[] fixLoanCompanyParam = null;
        if (this.relations != null) {
            if (this.relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                if (this.transCompanyIDs != null && this.transCompanyIDs.length > 0) {
                    fixLoanCompanyParam = new Object[this.getPlaceholderCount(this.transCompanyIDs.length)];
                    this.setParamArray(fixLoanCompanyParam, this.transCompanyIDs);
                }
            } else if (this.customerIDs != null && this.customerIDs.length > 0) {
                fixLoanCompanyParam = new Object[this.getPlaceholderCount(this.customerIDs.length)];
                this.setParamArray(fixLoanCompanyParam, this.customerIDs);
            }
        }
        int fixLoanCompanyParamCount = fixLoanCompanyParam == null ? 0 : fixLoanCompanyParam.length;
        int allParamCount = 2 + companyParamCount + finacingProductParamCount + fixLoanCompanyParamCount;
        Object[] allParam = new Object[allParamCount];
        int currentPos = 0;
        for (i = 0; i < endDateArray.length; ++i) {
            allParam[i] = endDateArray[i];
        }
        currentPos = endDateArray.length;
        for (i = 0; i < currencyArray.length; ++i) {
            allParam[currentPos + i] = currencyArray[i];
        }
        currentPos += currencyArray.length;
        if (companyParamCount > 0) {
            for (i = 0; i < companyParam.length; ++i) {
                allParam[currentPos + i] = companyParam[i];
            }
        }
        currentPos += companyParamCount;
        if (finacingProductParamCount > 0) {
            for (i = 0; i < finacingProductParam.length; ++i) {
                allParam[currentPos + i] = finacingProductParam[i];
            }
        }
        currentPos += finacingProductParamCount;
        if (fixLoanCompanyParamCount > 0) {
            for (i = 0; i < fixLoanCompanyParam.length; ++i) {
                allParam[currentPos + i] = fixLoanCompanyParam[i];
            }
        }
        currentPos += fixLoanCompanyParamCount;
        return allParam;
    }

    private void setParamArray(Object[] iDParams, String[] idValues) {
        for (int i = 0; i < idValues.length; ++i) {
            iDParams[i] = idValues[i].toString();
        }
        int idCount = idValues.length;
        for (int j = 0; j < iDParams.length - idCount; ++j) {
            iDParams[j + idCount] = "";
        }
    }

    private void setCompanyCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FCompanyID", this.companyIDs));
    }

    private void setStatusCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append("(").append("FStatus <>0 ").append(")");
    }

    private void setFixCompanyCondition(StringBuffer sbCommonFilter) {
        if (this.relations != null) {
            if (this.relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                this.setTransCompanyCondition(sbCommonFilter);
            } else {
                this.setCustomerCondition(sbCommonFilter);
            }
        }
    }

    protected void setCustomerCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FCustomerID", this.customerIDs)).append("FTransCompanyID is null and ");
    }

    protected void setTransCompanyCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FTransCompanyID", this.transCompanyIDs)).append("FCustomerID is null and ");
    }

    protected void setFinaProdeuctCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append(this.getSQLFilterPrepared("FFinacingProductID", this.finacingProIDs));
    }

    protected void setDateCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append("(").append("FEffectiveDate <= ? ").append(")");
        sbCommonFilter.append(" and ");
    }

    private void setCurrencyCondition(StringBuffer sbCommonFilter) {
        sbCommonFilter.append("(").append("FCurrencyID = ? ").append(")");
        sbCommonFilter.append(" and ");
    }

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    protected String getSQLFilterPrepared(String filed, String[] ids) {
        String returnValue = "";
        if (ids != null && ids.length > 0) {
            StringBuffer sb = new StringBuffer();
            int placeholderCount = this.getPlaceholderCount(ids.length);
            for (int i = 0; i < placeholderCount; ++i) {
                sb.append(filed + " = ? ");
                if (i == placeholderCount - 1) continue;
                sb.append(" or ");
            }
            returnValue = "(" + sb.toString() + ") ";
            returnValue = returnValue + " and ";
        }
        return returnValue;
    }

    protected int getPlaceholderCount(int idCount) {
        if (idCount <= 20) {
            return 20;
        }
        if (idCount > 20 && idCount <= 40) {
            return 40;
        }
        if (idCount > 40 && idCount <= 60) {
            return 60;
        }
        if (idCount > 60 && idCount <= 80) {
            return 80;
        }
        return idCount;
    }

    protected SqlParams getSqlParams() {
        SqlParams sp = new SqlParams();
        Object[] allparams = this.getParams();
        for (int i = 0; i < allparams.length; ++i) {
            sp.addObject(allparams[i]);
        }
        return sp;
    }

    protected String getSumSQLPrepared() {
        return null;
    }

    protected String getMdx() {
        return null;
    }

    protected String getConfigFileName() {
        return null;
    }

    protected void assembleSchemaSource(SchemaSource ss) {
        ss.setDataItem("Fact", this.getSumSQLPrepared(), this.getSqlParams());
        ss.setCaller(RptFundTransferBillBalanceSumFacadeControllerBean.class);
        ss.setFilename(this.getConfigFileName());
    }

    protected String getSumFields() {
        StringBuffer sb = new StringBuffer();
        sb.append("        sum(FLoanAmt)/").append(this.unit).append(" as FloanAmtSum,    \n");
        sb.append("        sum(FLoanAmt-FLoanBalanceAmt)/").append(this.unit).append(" as FRepayAmtSum,  \n");
        sb.append("        sum(FLoanBalanceAmt)/").append(this.unit).append(" as FLoanBalanceSum,  \n");
        return sb.toString();
    }
}

