/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.ibt.BillRediscountOutInfo;
import com.kingdee.eas.fm.ibt.BillRediscountReturnOutFactory;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.IbtException;
import com.kingdee.eas.fm.ibt.RediscountModeEnum;
import com.kingdee.eas.fm.ibt.app.AbstractBillRediscountOutControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BillRediscountOutControllerBean
extends AbstractBillRediscountOutControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ibt.app.BillRediscountOutControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String id;
        BillRediscountOutInfo info = this.getBillRediscountOutInfo(ctx, pk);
        if (BillTypeEnum.Submit.equals((Object)info.getBillType()) && (id = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()) != null) {
            String sql = "update T_IBT_BillRediscountOut set FBillType = '2', fauditorid ='" + id + "' where fid = '" + info.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BillRediscountOutInfo info = this.getBillRediscountOutInfo(ctx, pk);
        if (info.isIsReturnLimit()) {
            throw new IbtException(IbtException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"1_BillRediscountOutControllerBean", (Locale)ctx.getLocale())});
        }
        if (BillTypeEnum.Audit.equals((Object)info.getBillType())) {
            String sql = "update T_IBT_BillRediscountOut set FBillType = '1',fauditorid=null  where fid = '" + info.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected ArrayList _getObjectBillID(Context ctx, ArrayList listPK) throws BOSException, EASBizException {
        ArrayList<String> arrValue = new ArrayList<String>();
        for (int i = 0; i < listPK.size(); ++i) {
            String sql = "select fid from t_ibt_billredretout where fsourcebillid='" + listPK.get(i).toString() + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (!rs.next()) continue;
                arrValue.add(rs.getString("fid"));
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return arrValue;
    }

    @Override
    protected void _updateBillState(Context ctx, String number) throws BOSException, EASBizException {
        String sql = "update T_NT_ReceivableBill set fbillstate =6,FLastUpdateTime=? where fnumber =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{DateUtil.getTime(), number});
    }

    @Override
    protected boolean _getEnNumber(Context ctx, String number, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number)) {
            throw new IbtException(IbtException.ENNUMBERISNULL);
        }
        String strCompanyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        boolean isExists = true;
        String sql = "select count(*) Fcount from T_IBT_BillRediscountOut BillIn left join T_IBT_BillRediscountOutEntry BillInEn on BillIn.Fid=BillInEn.Fparentid where BillIn.Fcompanyid='" + strCompanyId + "' and BillInEn.Fnumber='" + number + "'";
        if (!StringUtils.isEmpty((String)id)) {
            sql = sql + "and BillInEn.Fparentid='" + id + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    isExists = rs.getInt("Fcount") <= 0;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                isExists = rs.getInt("Fcount") > 0;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isExists;
    }

    @Override
    protected void _updateReceBillState(Context ctx, String id, boolean flag) throws BOSException, EASBizException {
        String sql = "select fnumber from T_IBT_BillRediscountOutEntry where fparentid = '" + id + "' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> list = new ArrayList<String>();
        if (rs.size() > 0) {
            try {
                while (rs.next()) {
                    int addi = 0;
                    list.add(rs.getString("fnumber"));
                    ++addi;
                }
                for (int i = 0; i < list.size(); ++i) {
                    String sql2;
                    if (list.get(i).equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ibt.IBTAutoGenerateResource", (String)"0_BillRediscountInControllerBean", (Locale)ctx.getLocale()))) continue;
                    if (flag) {
                        sql2 = "update T_NT_ReceivableBill set FBillState =?,FLastUpdateTime=? where fnumber =?";
                        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{new Integer(8), DateUtil.getTime(), list.get(i)});
                        continue;
                    }
                    sql2 = "update T_NT_ReceivableBill set FBillState =?,FLastUpdateTime=? where fnumber =?";
                    DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{new Integer(8), DateUtil.getTime(), list.get(i)});
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    @Override
    protected boolean _isRelatBillReturn(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "select fid from T_IBT_BillRedRetOut where fsourcebillId='" + id + "'";
        boolean flag = false;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.size() > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected void _returnLimit(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        int n = arrayPK.length;
        for (int i = 0; i < n; ++i) {
            this.returnLimit(ctx, arrayPK[i]);
        }
    }

    protected void returnLimit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BillRediscountOutInfo info = (BillRediscountOutInfo)this._getValue(ctx, pk);
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocal((Context)ctx, (String)info.getId().toString());
        if (info.get("isInCredit").toString().equals("true") && info.get("isReturnLimit").toString().equals("false") && info.getRediscountMode().equals((Object)RediscountModeEnum.Monopoly) && info.getCreditLocalAmt() != null && info.getBalance() != null && info.getCreditLimit() != null && info.getBillType() == BillTypeEnum.Audit && info.getId() != null) {
            BillRediscountReturnOutFactory.getLocalInstance(ctx).returnQuantum(info.getCreditLocalAmt(), info.getBalance(), info.getCreditLimit().getId().toString(), info.getId().toString());
            StringBuffer strsql = new StringBuffer();
            strsql.append(" update T_IBT_BillRediscountOut set FIsReturnLimit=1 where fid='");
            strsql.append(info.getId());
            strsql.append("' ");
            DbUtil.execute((Context)ctx, (String)strsql.toString());
        }
    }

    @Override
    public void _reduceQuantum(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        int n = arrayPK.length;
        for (int i = 0; i < n; ++i) {
            this.reduceQuantum(ctx, arrayPK[i]);
        }
    }

    protected void reduceQuantum(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BillRediscountOutInfo info = (BillRediscountOutInfo)this._getValue(ctx, pk);
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocal((Context)ctx, (String)info.getId().toString());
        if (info.get("isInCredit").toString().equals("true") && info.get("isReturnLimit").toString().equals("true") && info.getRediscountMode().equals((Object)RediscountModeEnum.Monopoly) && info.getCreditLocalAmt() != null && info.getBalance() != null && info.getCreditLimit() != null && info.getBillType() == BillTypeEnum.Audit && info.getId() != null) {
            BillRediscountReturnOutFactory.getLocalInstance(ctx).reduceQuantum(info.getCreditLocalAmt(), info.getBalance(), info.getCreditLimit().getId().toString(), info.getId().toString());
            StringBuffer strsql = new StringBuffer();
            strsql.append(" update T_IBT_BillRediscountOut set FIsReturnLimit=0 where fid='");
            strsql.append(info.getId());
            strsql.append("' ");
            DbUtil.execute((Context)ctx, (String)strsql.toString());
        }
    }
}

