/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ibt.BillRediscountReturnOutInfo;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.app.AbstractBillRediscountReturnOutControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillRediscountReturnOutControllerBean
extends AbstractBillRediscountReturnOutControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ibt.app.BillRediscountReturnOutControllerBean");

    protected void verify(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BillRediscountReturnOutInfo info = null;
        info = this.getBillRediscountReturnOutInfo(ctx, pk);
        if (info.getBillType() == BillTypeEnum.Audit) {
            throw new LoanException(LoanException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        String auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql = "update T_IBT_BillRedRetOut set FBillType = ? , Fauditorid= ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"2", auditorId, pk.toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BillRediscountReturnOutInfo info = null;
        info = this.getBillRediscountReturnOutInfo(ctx, pk);
        if (info.getBillType() != BillTypeEnum.Audit) {
            throw new LoanException(LoanException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        if (!(FinHelper.hasDeferRecordOfLoan((Context)ctx, (String)info.getId().toString()) && FinHelper.hasIntRecordOfLoan((Context)ctx, (String)info.getId().toString()) && FinHelper.hasRepaymentOfLoan((Context)ctx, (String)info.getId().toString()))) {
            throw new LoanException(LoanException.ANTIAUDIT_HASOTHER_BILL_ERROR, new Object[]{info.getNumber()});
        }
        String sql = "update T_IBT_BillRedRetOut set FBillType = ? , Fauditorid=null where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"1", pk.toString()});
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _reduceQuantum(Context ctx, BigDecimal creditAmount, BigDecimal balance, String creditLimitId, String billId) throws BOSException, EASBizException {
        ArrayList arrlist = new ArrayList();
        Object mid = null;
        if (creditAmount != null && creditLimitId != null) {
            String sqlOld = "select * from t_fin_creditlimit where fid='" + creditLimitId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlOld);
            BigDecimal fbalance = null;
            BigDecimal usedAm = null;
            BigDecimal usedcAm = null;
            BigDecimal usedcRet = null;
            String creditlimitid = null;
            try {
                if (rs.next()) {
                    creditlimitid = rs.getString("fid");
                    fbalance = rs.getBigDecimal("fbalance");
                    usedAm = rs.getBigDecimal("fusedamount");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            BigDecimal lastUsed = usedAm.add(creditAmount);
            BigDecimal lastBalance = fbalance.subtract(creditAmount);
            String sql = null;
            sql = lastBalance.compareTo(new BigDecimal(0)) == 0 ? " update t_fin_creditlimit set fusedamount=" + lastUsed + " , fbalance= 0  where fid='" + creditLimitId + "' " : " update t_fin_creditlimit set fusedamount=" + lastUsed + " , fbalance=" + lastBalance + " where fid='" + creditLimitId + "' ";
            if (creditlimitid != null) {
                String usedcsql = "select * from t_fin_creditlimitused where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'";
                IRowSet ts = DbUtil.executeQuery((Context)ctx, (String)usedcsql);
                try {
                    while (ts.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        usedcAm = ts.getBigDecimal("fUsedQuota");
                        usedcRet = ts.getBigDecimal("freturnedquota");
                        map.put("usedcAm", usedcAm);
                        map.put("usedcRet", usedcRet);
                        map.put("fid", ts.getString("fid"));
                        arrlist.add(map);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (arrlist.size() <= 1) {
                    BigDecimal lastusedcRet = Constants.ZERO;
                    if (usedcRet != null && creditAmount != null) {
                        lastusedcRet = usedcRet.subtract(creditAmount);
                    }
                    String usedsql = null;
                    usedsql = lastusedcRet.compareTo(new BigDecimal(0)) == 0 ? " update t_fin_creditlimitused set freturnedquota= 0 where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'" : " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'";
                    DbUtil.execute((Context)ctx, (String)usedsql);
                } else {
                    int b;
                    for (int i = b = arrlist.size() - 1; i >= 0; --i) {
                        Map mapS = (Map)arrlist.get(i);
                        if (Double.parseDouble(mapS.get("usedcRet").toString()) == 0.0) continue;
                        if (!(creditAmount.doubleValue() > 0.0)) break;
                        if (Double.parseDouble(mapS.get("usedcRet").toString()) < creditAmount.doubleValue()) {
                            double lastusedcRet = 0.0;
                            String usedsql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                            DbUtil.execute((Context)ctx, (String)usedsql);
                            creditAmount = creditAmount.subtract((BigDecimal)mapS.get("usedcRet"));
                            continue;
                        }
                        BigDecimal lastusedcRet = new BigDecimal(mapS.get("usedcRet").toString()).subtract(creditAmount);
                        String usedsql = null;
                        usedsql = lastusedcRet.compareTo(new BigDecimal(0)) == 0 ? " update t_fin_creditlimitused set freturnedquota= 0 where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'" : " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                        DbUtil.execute((Context)ctx, (String)usedsql);
                        break;
                    }
                }
            }
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected void _returnQuantum(Context ctx, BigDecimal creditAmount, BigDecimal balance, String creditLimitId, String billId) throws BOSException, EASBizException {
        ArrayList arrList = new ArrayList();
        Object mid = null;
        String ffinproid = null;
        String fcreditusageid = null;
        if (creditAmount != null && creditLimitId != null) {
            String sqlOld = "select * from t_fin_creditlimit where fid='" + creditLimitId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlOld);
            BigDecimal fbalance = null;
            BigDecimal usedAm = null;
            BigDecimal usedcAm = null;
            BigDecimal usedcRet = null;
            String creditlimitid = null;
            try {
                if (rs.next()) {
                    creditlimitid = rs.getString("fid");
                    fbalance = rs.getBigDecimal("fbalance");
                    usedAm = rs.getBigDecimal("fusedamount");
                    fcreditusageid = rs.getString("fcreditusageid");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            double lastUsed = Double.parseDouble(usedAm.toString()) - Double.parseDouble(creditAmount.toString());
            double lastBalance = Double.parseDouble(fbalance.toString()) + Double.parseDouble(creditAmount.toString());
            String sql = null;
            sql = usedAm.subtract(creditAmount).compareTo(new BigDecimal(0)) == 0 ? " update t_fin_creditlimit set fusedamount= 0 , fbalance=" + fbalance.add(creditAmount) + " where fid='" + creditLimitId + "' " : " update t_fin_creditlimit set fusedamount=" + usedAm.subtract(creditAmount) + " , fbalance=" + fbalance.add(creditAmount) + " where fid='" + creditLimitId + "' ";
            if (creditlimitid != null) {
                String usedcsql = "select * from t_fin_creditlimitused where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'";
                IRowSet ts = DbUtil.executeQuery((Context)ctx, (String)usedcsql);
                try {
                    while (ts.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        usedcAm = ts.getBigDecimal("fUsedQuota");
                        usedcRet = ts.getBigDecimal("freturnedquota");
                        ffinproid = ts.getString("ffinproid");
                        map.put("usedcAm", usedcAm);
                        map.put("usedcRet", usedcRet);
                        map.put("fid", ts.getString("fid"));
                        map.put("fproperty", ts.getString("fproperty"));
                        map.put("ffinproid", ts.getString("ffinproid"));
                        arrList.add(map);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (arrList.size() <= 1) {
                    BigDecimal lastusedcRet = Constants.ZERO;
                    if (usedcRet != null && creditAmount != null) {
                        lastusedcRet = usedcRet.add(creditAmount);
                    }
                    String usedsql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + "  where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "'";
                    DbUtil.execute((Context)ctx, (String)usedsql);
                } else {
                    int b;
                    for (int i = b = arrList.size() - 1; i >= 0; --i) {
                        String retsql;
                        String usedSql;
                        BigDecimal lastusedcRet;
                        Map mapS = (Map)arrList.get(i);
                        if (!mapS.get("fproperty").equals("1") || Double.parseDouble(mapS.get("usedcRet").toString()) >= Double.parseDouble(mapS.get("usedcAm").toString())) continue;
                        if (Double.parseDouble(creditAmount.toString()) >= Double.parseDouble(mapS.get("usedcAm").toString())) {
                            if (Double.parseDouble(creditAmount.toString()) <= Double.parseDouble(mapS.get("usedcAm").toString()) - Double.parseDouble(mapS.get("usedcRet").toString())) {
                                lastusedcRet = new BigDecimal(mapS.get("usedcRet").toString()).add(creditAmount);
                                usedSql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                                retsql = "update t_fin_creditlimitentry set fbanlance=(select fsharedamount from t_fin_creditlimitentry where ffinproid='" + mapS.get("ffinproid") + "' and fparentid='" + creditlimitid + "') where ffinproid='" + mapS.get("ffinproid") + "'and fparentid='" + creditlimitid + "'";
                                DbUtil.execute((Context)ctx, (String)retsql);
                                DbUtil.execute((Context)ctx, (String)usedSql);
                                continue;
                            }
                            lastusedcRet = new BigDecimal(mapS.get("usedcAm").toString());
                            creditAmount = creditAmount.subtract(new BigDecimal(mapS.get("usedcAm").toString())).subtract(new BigDecimal(mapS.get("usedcRet").toString()));
                            usedSql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                            retsql = "update t_fin_creditlimitentry set fbanlance=(select fsharedamount from t_fin_creditlimitentry where ffinproid='" + mapS.get("ffinproid") + "' and fparentid='" + creditlimitid + "') where ffinproid='" + mapS.get("ffinproid") + "'and fparentid='" + creditlimitid + "'";
                            DbUtil.execute((Context)ctx, (String)retsql);
                            DbUtil.execute((Context)ctx, (String)usedSql);
                            continue;
                        }
                        lastusedcRet = new BigDecimal(mapS.get("usedcRet").toString()).add(creditAmount);
                        usedSql = " update t_fin_creditlimitused set freturnedquota=" + lastusedcRet + " where fcreditlimitid='" + creditlimitid + "' and fbillid='" + billId + "' and fid='" + mapS.get("fid") + "'";
                        retsql = "update t_fin_creditlimitentry set fbanlance=(select fsharedamount from t_fin_creditlimitentry where ffinproid='" + mapS.get("ffinproid") + "' and fparentid='" + creditlimitid + "') where ffinproid='" + mapS.get("ffinproid") + "'and fparentid='" + creditlimitid + "'";
                        DbUtil.execute((Context)ctx, (String)retsql);
                        DbUtil.execute((Context)ctx, (String)usedSql);
                        break;
                    }
                }
            }
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected List _getDetachList(Context ctx, String billNumber) throws BOSException, EASBizException {
        ArrayList detachList = new ArrayList();
        String sql = "select * from t_ibt_billrediscountoutentry where fparentid='" + billNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("number", rs.getString("fnumber"));
                dataMap.put("currency", rs.getString("fcurrencyid"));
                dataMap.put("rate", rs.getBigDecimal("frate"));
                dataMap.put("amountLocalCur", rs.getBigDecimal("famountLocalcur"));
                dataMap.put("amount", rs.getBigDecimal("famount"));
                dataMap.put("date", rs.getDate("fdate"));
                detachList.add(dataMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return detachList;
    }

    @Override
    protected boolean _turnWriteBalance(Context ctx, String billNum, BigDecimal balance) throws BOSException, EASBizException {
        String sql = null;
        BigDecimal big = new BigDecimal(balance.toString());
        sql = big.compareTo(new BigDecimal(0)) == 0 ? " update t_ibt_billrediscountout set fbalance=0 where fid='" + billNum + "' " : " update t_ibt_billrediscountout set fbalance=" + balance + " where fid='" + billNum + "' ";
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }

    @Override
    protected Map _getOldBillData(Context ctx, String sceBillNum) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String sql = "select * from t_ibt_billrediscountout a where a.fid='" + sceBillNum + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                String sqlc;
                IRowSet rt;
                dataMap.put("balance", rs.getBigDecimal("fbalance"));
                dataMap.put("bizDate", rs.getDate("fbizdate"));
                dataMap.put("endDate", rs.getDate("fenddate"));
                dataMap.put("isInCredit", rs.getString("fisincredit"));
                if (rs.getString("Fcreditlimitid") != null && (rt = DbUtil.executeQuery((Context)ctx, (String)(sqlc = "select * from t_fin_creditlimit where fid='" + rs.getString("fcreditlimitid") + "'"))).next()) {
                    dataMap.put("creditUsage", rt.getString("fcreditusageid"));
                    dataMap.put("shareType", rt.getString("fsharetype"));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dataMap;
    }

    @Override
    protected Map _getOldCridit(Context ctx, String billNumber) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String sql = "select * from t_ibt_billrediscountout a where a.fid='" + billNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                map.put("creditlimitid", rs.getString("FCreditLimitId"));
                map.put("balance", rs.getBigDecimal("fbalance"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected boolean _turnWriteReceivableBill(Context ctx, String billNum, boolean isAddorDel) throws BOSException, EASBizException {
        String redBill_sql = "select fvalue_l1,fvalue_l2,fvalue_l3 from t_bas_paramitem where fkeyid=select fid from t_bas_param where fnumber='NT011'";
        String etyNum_sql = "select fnumber from t_ibt_billrediscountoutentry where fparentid='" + billNum + "'";
        IRowSet redBill_rs = DbUtil.executeQuery((Context)ctx, (String)redBill_sql);
        boolean flag = false;
        try {
            while (redBill_rs.next()) {
                String b = redBill_rs.getString("fvalue_l2");
                if (!"true".equals(b)) continue;
                flag = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (flag) {
            String state = null;
            state = isAddorDel ? "8" : "6";
            String saveState_sql = "update T_NT_ReceivableBill set fbillstate=" + state + " where fnumber in (select fnumber from t_ibt_billrediscountoutentry where fparentid='" + billNum + "')";
            DbUtil.execute((Context)ctx, (String)saveState_sql);
            return true;
        }
        String state = null;
        state = isAddorDel ? "1" : "6";
        String auState_sql = "update T_NT_ReceivableBill set fbillstate=" + state + " where fnumber in (select fnumber from t_ibt_billrediscountoutentry where fparentid='" + billNum + "')";
        DbUtil.execute((Context)ctx, (String)auState_sql);
        return true;
    }

    @Override
    protected void _setIsInCredit(Context ctx, String pk, String isInCredit) throws BOSException, EASBizException {
        String sql = "update t_ibt_billredretout set fisincredit=1 where fid='" + pk + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

