/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.CreditAssetsReturnInInfo;
import com.kingdee.eas.fm.ibt.app.AbstractCreditAssetsReturnInControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditAssetsReturnInControllerBean
extends AbstractCreditAssetsReturnInControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ibt.app.CreditAssetsReturnInControllerBean");

    protected void verify(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditAssetsReturnInInfo info = null;
        info = this.getCreditAssetsReturnInInfo(ctx, pk);
        if (info.getBillType() == BillTypeEnum.Audit) {
            throw new LoanException(LoanException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        String auditorid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql = "update T_IBT_CreditAssRetIn set FBillType = ? , Fauditorid= ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"2", auditorid, pk.toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditAssetsReturnInInfo info = null;
        info = this.getCreditAssetsReturnInInfo(ctx, pk);
        if (info.getBillType() != BillTypeEnum.Audit) {
            throw new LoanException(LoanException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        if (!(FinHelper.hasDeferRecordOfLoan((Context)ctx, (String)info.getId().toString()) && FinHelper.hasIntRecordOfLoan((Context)ctx, (String)info.getId().toString()) && FinHelper.hasRepaymentOfLoan((Context)ctx, (String)info.getId().toString()))) {
            throw new LoanException(LoanException.ANTIAUDIT_HASOTHER_BILL_ERROR, new Object[]{info.getNumber()});
        }
        String sql = "update T_IBT_CreditAssRetIn set FBillType = ? , FAuditorid= null where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"1", pk.toString()});
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected Map _getOldCridit(Context ctx, String billNumber) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        String sql = "select * from T_IBT_CredAsstTransIn a where a.fid='" + billNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                map.put("yearRate", rs.getBigDecimal("fyearrate"));
                map.put("balance", rs.getBigDecimal("fbalance"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected Map _getOldBillData(Context ctx, String sceBillNum) throws BOSException, EASBizException {
        HashMap<String, Comparable<BigDecimal>> dataMap = new HashMap<String, Comparable<BigDecimal>>();
        String sql = "select * from T_IBT_CredAsstTransIn a where a.fid='" + sceBillNum + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                dataMap.put("balance", rs.getBigDecimal("fbalance"));
                dataMap.put("bizDate", rs.getDate("fbizdate"));
                dataMap.put("endDate", rs.getDate("FEXPIREDDATE"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dataMap;
    }

    @Override
    protected boolean _turnWriteBalance(Context ctx, String billNum, double balance) throws BOSException, EASBizException {
        String sql = " update T_IBT_CredAsstTransIn set fbalance=" + balance + " where fid='" + billNum + "' ";
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }
}

