/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ibt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ibt.BillTypeEnum;
import com.kingdee.eas.fm.ibt.InnerBorrowingReturnOutInfo;
import com.kingdee.eas.fm.ibt.app.AbstractInnerBorrowingReturnOutControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InnerBorrowingReturnOutControllerBean
extends AbstractInnerBorrowingReturnOutControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ibt.app.InnerBorrowingReturnOutControllerBean");

    protected void verify(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InnerBorrowingReturnOutInfo info = null;
        info = this.getInnerBorrowingReturnOutInfo(ctx, pk);
        if (info.getBillType() == BillTypeEnum.Audit) {
            throw new LoanException(LoanException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        String sql = "update T_IBT_innerBorrowingReturnOut set FBillType = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"2", pk.toString()});
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        BOSUuid userId = userInfo.getId();
        String uAuditorsql = " update t_IBT_innerBorrowingReturnOut set Fauditorid=? where fid=?";
        DbUtil.execute((Context)ctx, (String)uAuditorsql, (Object[])new Object[]{userId.toString(), pk.toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InnerBorrowingReturnOutInfo info = null;
        info = this.getInnerBorrowingReturnOutInfo(ctx, pk);
        if (info.getBillType() != BillTypeEnum.Audit) {
            throw new LoanException(LoanException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        if (!(FinHelper.hasDeferRecordOfLoan((Context)ctx, (String)info.getId().toString()) && FinHelper.hasIntRecordOfLoan((Context)ctx, (String)info.getId().toString()) && FinHelper.hasRepaymentOfLoan((Context)ctx, (String)info.getId().toString()))) {
            throw new LoanException(LoanException.ANTIAUDIT_HASOTHER_BILL_ERROR, new Object[]{info.getNumber()});
        }
        String sql = "update T_IBT_InnerBorrowingReturnOut set FBillType = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"1", pk.toString()});
        String uAuditorsql = " update t_IBT_innerBorrowingReturnout set Fauditorid=null where fid=?";
        DbUtil.execute((Context)ctx, (String)uAuditorsql, (Object[])new Object[]{pk.toString()});
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected boolean _turnWriteBln(Context ctx, String billNum, double balance) throws BOSException, EASBizException {
        String sql = " update t_ibt_innerfinborout set fbalance=" + balance + " where fid='" + billNum + "' ";
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }

    @Override
    protected java.util.Date _getOldBillData(Context ctx, String sceBillNum) throws BOSException, EASBizException {
        Date startDate = null;
        String sql = "select * from t_ibt_innerfinborout a where a.fid='" + sceBillNum + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                startDate = rs.getDate("fstartdate");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return startDate;
    }

    @Override
    protected Map _getOldCridit(Context ctx, String billNumber) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        String sql = "select * from t_ibt_innerfinborout a where a.fid='" + billNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                map.put("yearRate", rs.getBigDecimal("fyearrate"));
                map.put("balance", rs.getBigDecimal("fbalance"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }
}

