/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.app.AbstractCHLoanExtendBillControllerBean;
import com.kingdee.eas.framework.AbstractCoreBillBaseInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CHLoanExtendBillControllerBean
extends AbstractCHLoanExtendBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.CHLoanExtendBillControllerBean");
    private Map botpRelationShip = new HashMap();

    @Override
    protected Map _getInitDate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int maxExdSeq = 0;
        java.util.Date lastExdDate = null;
        HashMap<String, Comparable<Integer>> returnValue = new HashMap<String, Comparable<Integer>>();
        String sql = "select fextendseq,fafterexdate from t_ivt_chloanextendbill where fextendseq = ( select isnull(max(fextendseq),0) from t_ivt_chloanextendbill where fchloanid = ?) and fchloanid=?";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            pstmt.setString(2, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxExdSeq = rs.getInt(1);
                Date d = rs.getDate(2);
                lastExdDate = new java.util.Date(d.getTime());
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        returnValue.clear();
        returnValue.put("maxseq", new Integer(++maxExdSeq));
        returnValue.put("lastExdDate", lastExdDate);
        return returnValue;
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = new FilterInfo();
        CHLoanExtendBillInfo infp = (CHLoanExtendBillInfo)model;
        ChLoanInfo chloanInfo = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(infp.getChLoan().getId()));
        filter.getFilterItems().add(new FilterItemInfo("chLoan.loanCompany.id", (Object)chloanInfo.getLoanCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)model.getString("number")));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, info);
        if (((AbstractCoreBillBaseInfo)info).getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)((AbstractCoreBillBaseInfo)info).getSourceBillId(), (String)"1");
        }
        this._afterSubmit(ctx, info, pk);
        return pk;
    }

    private void checkSubmit(Context ctx, CHLoanExtendBillInfo info) throws EASBizException, BOSException {
        String sql = "select * from t_ivt_chloanextendbill where fchloanid =? and fextendseq=? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getChLoan().getId().toString(), new Integer(info.getExtendSeq())});
            if (rs.next()) {
                throw new CHLoanException(CHLoanException.EXTSEQ_ERROR, new Object[]{new Integer(info.getExtendSeq())});
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        CHLoanExtendBillInfo extInfo = (CHLoanExtendBillInfo)info;
        if (extInfo.getCompany() == null) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)extInfo, (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, (IObjectValue)extInfo);
        this.addNewCheck(ctx, extInfo);
        this.checkSubmit(ctx, extInfo);
        return super._addnew(ctx, info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, info);
        this._saveBOTPRelationShip(ctx, (CHLoanExtendBillInfo)info, pk);
        return pk;
    }

    private void _afterSubmit(Context ctx, IObjectValue info, IObjectPK pk) throws BOSException, EASBizException {
        this._updateChLoanInfo(ctx, (CHLoanExtendBillInfo)info, 1);
        this._saveBOTPRelationShip(ctx, (CHLoanExtendBillInfo)info, pk);
        this.updateChLoanContract(ctx, (CHLoanExtendBillInfo)info, false);
    }

    protected void updateChLoanContract(Context ctx, CHLoanExtendBillInfo info, boolean isDelete) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("chLoanContract.id"));
        ChLoanInfo chLoan = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(info.getChLoan().getId().toString()), evi.getSelector());
        if (chLoan.getChLoanContract() == null) {
            return;
        }
        if (isDelete) {
            String sql = " update T_IVT_ChLoanContract set FEndDate = ? where fid =? and FEndDate = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getBeforeExDate(), chLoan.getChLoanContract().getId().toString(), info.getAfterExDate()});
            return;
        }
        String sql = " update T_IVT_ChLoanContract set FEndDate = ? where fid =? and FEndDate < ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getAfterExDate(), chLoan.getChLoanContract().getId().toString(), info.getAfterExDate()});
    }

    private void _saveBOTPRelationShip(Context ctx, CHLoanExtendBillInfo info, IObjectPK pk) throws BOSException {
        if (FMHelper.isInstanceof((String)info.getSourceBillId(), ChLoanInfo.class)) {
            this.botpRelationShip.clear();
            this.botpRelationShip.put(info.getChLoan().getId().toString(), pk.toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            CHLoanExtendBillInfo info = (CHLoanExtendBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void _updateChLoanInfo(Context ctx, CHLoanExtendBillInfo info, int type) throws BOSException, EASBizException {
        String sql = "update t_ivt_chloan set FEndDate = ?,FHorizon=?, FIsPostponed=1  where fid = ?";
        if (info.getEffectedStatus().getValue() != 1) {
            String loanid = info.getChLoan().getId().toString();
            if (type == 1) {
                java.util.Date endDate = info.getAfterExDate();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{endDate, this.getHorizon(ctx, loanid, endDate), loanid});
            } else {
                java.util.Date endDate = info.getBeforeExDate();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{endDate, this.getHorizon(ctx, loanid, endDate), loanid});
            }
        }
    }

    private BigDecimal getHorizon(Context ctx, String loanid, java.util.Date endDate) throws EASBizException, BOSException {
        ChLoanInfo info = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(loanid));
        java.util.Date startDate = info.getStartDate();
        return FinHorizon.getHorizon((java.util.Date)startDate, (java.util.Date)endDate);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CHLoanExtendBillInfo info = this.getCHLoanExtendBillInfo(ctx, pk);
        this._updateChLoanInfo(ctx, info, 2);
        this.updateChLoanContract(ctx, info, true);
        if (info.getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)info.getSourceBillId(), (String)"0");
        }
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    @Override
    protected void _addNewCheck(Context ctx, CHLoanExtendBillInfo exchloaninfo) throws BOSException, EASBizException {
        String loanid = exchloaninfo.getChLoan().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select feffectedstatus from t_ivt_chloanextendbill ");
        sb.append("where fchloanid = ? ");
        sb.append("and fextendseq = ( ");
        sb.append("select max(fextendseq) from  t_ivt_chloanextendbill where fchloanid = ? ");
        sb.append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{loanid, loanid});
        try {
            int status;
            if (rs.next() && (status = rs.getInt(1)) == 1) {
                throw new CHLoanException(CHLoanException.ADD_NEW_ERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

