/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.util.AccountCurrencyVerifyUtil;
import com.kingdee.eas.fm.fin.LoanApplyBillFacadeFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.ChLoanCollection;
import com.kingdee.eas.fm.ivt.ChLoanContractFactory;
import com.kingdee.eas.fm.ivt.ChLoanContractInfo;
import com.kingdee.eas.fm.ivt.ChLoanEntryInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanIntPreFacadeFactory;
import com.kingdee.eas.fm.ivt.CreditLevelFactory;
import com.kingdee.eas.fm.ivt.CreditLevelInfo;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.ReturnWayEnum;
import com.kingdee.eas.fm.ivt.app.AbstractChLoanControllerBean;
import com.kingdee.eas.fm.ivt.app.ChLoanSubsidiaryBookProvider;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChLoanControllerBean
extends AbstractChLoanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.ChLoanControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CreditLevelInfo creditLevelInfo;
        ChLoanInfo info = (ChLoanInfo)model;
        if (info.getCompany() == null) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, (IObjectValue)info);
        if ((info.getCreditLevel() == null || info.getCreditLevel().getId() == null) && (creditLevelInfo = CreditLevelFactory.getLocalInstance(ctx).getDefaultCreditLevel()) != null) {
            info.setCreditLevel(creditLevelInfo);
        }
        if (info.getStartDate() != null && info.getLastSettleDate() == null) {
            info.setLastSettleDate(DateUtil.getBeforeDay((Date)info.getStartDate()));
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.updateLoanApplyBill(ctx, info);
        return pk;
    }

    private void updateLoanApplyBill(Context ctx, ChLoanInfo info) throws BOSException, EASBizException {
        if (info.getLoanApplyBill() != null) {
            LoanApplyBillFacadeFactory.getLocalInstance((Context)ctx).afterGenLoanOrgBill((IObjectPK)new ObjectUuidPK(info.getLoanApplyBill().getId()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue vo) throws BOSException, EASBizException {
        ChLoanInfo oldInfo;
        ChLoanInfo info = (ChLoanInfo)vo;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((ChLoanInfo)vo));
        info.setBillStatus(IvtBillStatusEnum.SUBMIT);
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = this.getChLoanInfo(ctx, "select * where id='" + info.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        if (info.getLoanAccountView() != null) {
            AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)ctx, (String)info.getLoanAccountView().getId().toString(), (String)info.getCurrency().getId().toString());
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        this.updateChLoanContract(ctx, (ChLoanInfo)vo, pk);
        ChLoanInfo sumbittedInfo = this.getChLoanInfo(ctx, "select * where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)sumbittedInfo);
        if (!info.isIsHistoryLoan()) {
            NTHelper.updateFpItem((Context)ctx, (IObjectPK)pk, null);
        }
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"IVT003") || info.isIsHistoryLoan()) {
            HashSet<String> idset = new HashSet<String>();
            idset.add(pk.toString());
            this.audit(ctx, idset);
            this.book(ctx, idset);
        }
        this.batchSubmitIntColl(ctx, info, pk, true);
        return pk;
    }

    private void batchSubmitIntColl(Context ctx, ChLoanInfo chLoanInfo, IObjectPK pk, boolean isSubmit) throws EASBizException, BOSException {
        LoanInterestBillCollection newIntColl = chLoanInfo.getIntCollPrediction();
        if (newIntColl != null && newIntColl.size() > 0) {
            for (int i = 0; i < newIntColl.size(); ++i) {
                LoanInterestBillInfo intInfo = newIntColl.get(i);
                intInfo.setLoanBill(chLoanInfo);
            }
            ChLoanIntPreFacadeFactory.getLocalInstance(ctx).submitChLoanInt(chLoanInfo.getId().toString(), newIntColl, isSubmit);
        }
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        return coll != null && coll.size() > 0;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            ChLoanInfo info = (ChLoanInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("chLoanContract.id"));
        sic.add(new SelectorItemInfo("chLoanContract.seq"));
        ChLoanInfo info = this.getChLoanInfo(ctx, pk, sic);
        if (info.getChLoanContract() != null) {
            int seq = info.getChLoanContract().getSeq();
            if (info.getContractSeq() != seq) {
                FMHelper.throwFMCommonException((String)ResourceBase.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"3_ConsignmentLoanBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        if (info.getContractSeq() != 1) {
            String sql1 = " update T_IVT_ChLoanContract set FAddConAmount = FAddConAmount - ?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{info.getLoanTotalAmt(), info.getChLoanContract().getId().toString()});
            String sql2 = " update T_IVT_ChLoanContract set FRemainConAmount = FRemainConAmount + ?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{info.getLoanTotalAmt(), info.getChLoanContract().getId().toString()});
            String sql3 = " update T_IVT_ChLoanContract set FSeq = FSeq - 1  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql3, (Object[])new Object[]{info.getChLoanContract().getId().toString()});
        } else if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getChLoanContract())) {
            ChLoanContractFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getChLoanContract().getId()));
        }
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        NTHelper.cancelFpItem((Context)ctx, (String)pk.toString());
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        if (info.getLoanApplyBill() != null) {
            LoanApplyBillFacadeFactory.getLocalInstance((Context)ctx).afterLoanOrgBillDeleted((IObjectPK)new ObjectUuidPK(info.getLoanApplyBill().getId()));
        }
    }

    private void doAntiBook(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
    }

    private void doBook(Context ctx, ChLoanInfo chLoanInfo) throws BOSException, EASBizException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(chLoanInfo.getId().toString(), ChLoanSubsidiaryBookProvider.class.getName());
    }

    private IObjectPK[] set2PKArray(Set ids) {
        IObjectPK[] pks = new IObjectPK[ids.size()];
        int index = 0;
        for (String pkValue : ids) {
            pks[index] = new ObjectUuidPK(pkValue);
            ++index;
        }
        return pks;
    }

    @Override
    protected String _transOverDueBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        return this._transOverDueBatch4Log(ctx, this.set2PKArray(ids));
    }

    @Override
    protected String _transOverDueBatch4Log(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        String billid = "";
        HashMap hm = new HashMap();
        for (int i = 0; i < pks.length; ++i) {
            IObjectPK objectPK = pks[i];
            billid = objectPK.toString();
            if (!this.doCheckOverDue(ctx, billid, hm)) continue;
            this.doUpdate(ctx, billid, 1);
        }
        return this.getErrorMsg(ctx, hm, 1);
    }

    private String getErrorMsg(Context ctx, Map hm, int type) {
        StringBuffer sbError = new StringBuffer();
        for (String number : hm.keySet()) {
            String msg = (String)hm.get(number);
            if (1 == type) {
                sbError.append(number).append(EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"overdue_failure_app", (Locale)ctx.getLocale())).append(msg).append("\n");
                continue;
            }
            sbError.append(number).append(EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"cancel_overdue_failure_app", (Locale)ctx.getLocale())).append(msg).append("\n");
        }
        return sbError.toString().trim();
    }

    private boolean doCheckOverDue(Context ctx, String id, Map hm) throws BOSException, EASBizException {
        boolean success = true;
        ChLoanInfo chLoanInfo = this.getChLoanInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (chLoanInfo.getBillStatus() == IvtBillStatusEnum.SAVE) {
            hm.put(chLoanInfo.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"overdue_check_msg1_app", (Locale)ctx.getLocale()));
            success = false;
        }
        if (chLoanInfo.isIsOverdue()) {
            hm.put(chLoanInfo.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"overdue_check_msg2_app", (Locale)ctx.getLocale()));
            success = false;
        } else if (chLoanInfo.getLoanBalance().compareTo(Constants.ZERO) <= 0) {
            hm.put(chLoanInfo.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"overdue_check_msg3_app", (Locale)ctx.getLocale()));
            success = false;
        } else if (chLoanInfo.getEndDate().compareTo(DateUtil.getDayBegin()) > 0) {
            hm.put(chLoanInfo.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"overdue_check_msg4_app", (Locale)ctx.getLocale()));
            success = false;
        } else if (chLoanInfo.getBillStatus() != IvtBillStatusEnum.BOOK) {
            hm.put(chLoanInfo.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"0_ChLoanControllerBean", (Locale)ctx.getLocale()));
            success = false;
        }
        return success;
    }

    @Override
    protected String _cancelOverDueBatch4Log(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        HashMap hm = new HashMap();
        for (int i = 0; i < pks.length; ++i) {
            IObjectPK objectPK = pks[i];
            String billid = objectPK.toString();
            if (!this.checkCancelOverDue(ctx, billid, hm)) continue;
            this.doUpdate(ctx, billid, 0);
        }
        return this.getErrorMsg(ctx, hm, 2);
    }

    @Override
    protected String _cancelOverDueBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        return this._cancelOverDueBatch4Log(ctx, this.set2PKArray(ids));
    }

    private boolean checkCancelOverDue(Context ctx, String id, Map hm) throws BOSException, EASBizException {
        boolean success = true;
        ChLoanInfo chLoanInfo = this.getChLoanInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (!chLoanInfo.isIsOverdue()) {
            hm.put(chLoanInfo.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"overdue_check_msg5_app", (Locale)ctx.getLocale()));
            success = false;
        } else if (chLoanInfo.getBillStatus() != IvtBillStatusEnum.BOOK) {
            hm.put(chLoanInfo.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"1_ChLoanControllerBean", (Locale)ctx.getLocale()));
            success = false;
        }
        return success;
    }

    private void doUpdate(Context ctx, String billid, int i) throws BOSException {
        String sql = "update T_IVT_ChLoan set FIsOverdue = ? where fid =?";
        Connection cn = null;
        PreparedStatement pstmt = null;
        cn = this.getConnection(ctx);
        try {
            pstmt = cn.prepareStatement(sql);
            pstmt.setInt(1, i);
            pstmt.setString(2, billid);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt, (Connection)cn);
        }
    }

    @Override
    protected void _deleteBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            pk = new ObjectUuidPK((String)iter.next());
            super.delete(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected String _batchSubmit(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap hm = new HashMap();
        for (String loanid : ids) {
            ChLoanInfo info = this.getChLoanInfo(ctx, (IObjectPK)new ObjectUuidPK(loanid), this.getSelectors());
            if (!this.checkCanSubmit(ctx, info, hm)) continue;
            this.submit(ctx, (CoreBaseInfo)info);
        }
        return this.parseErrorMgs(ctx, hm);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("fpItem.id");
        select.add("fpItem.name");
        select.add("fpItem.number");
        select.add("currency.id");
        select.add("currency.number");
        select.add("currency.name");
        select.add("company.*");
        return select;
    }

    private String parseErrorMgs(Context ctx, Map hm) {
        if (hm.size() == 0) {
            return "";
        }
        StringBuffer sbError = new StringBuffer(EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"error_msg_header_app", (Locale)ctx.getLocale()));
        for (String number : hm.keySet()) {
            String msg = (String)hm.get(number);
            sbError.append(number).append(EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"error_reason_app", (Locale)ctx.getLocale())).append(msg).append("\n");
        }
        return sbError.toString().trim();
    }

    private void submitSingle(Context ctx, ChLoanInfo info) throws EASBizException, BOSException {
        if (!info.isIsHistoryLoan()) {
            this.doBook(ctx, info);
        }
        String sql = "update t_ivt_chloan  set feffectedstatus = 2 where fid = ? ";
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
    }

    private boolean checkCanSubmit(Context ctx, ChLoanInfo info, Map hm) {
        boolean isValid = true;
        if (info.getLoanTotalAmt().compareTo(Constants.ZERO) <= 0) {
            hm.put(info.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"chloan_submit_check_msg1_app", (Locale)ctx.getLocale()));
            isValid = false;
        } else if (info.getFloorAmt().compareTo(Constants.ZERO) < 0) {
            hm.put(info.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"chloan_submit_check_msg2_app", (Locale)ctx.getLocale()));
            isValid = false;
        } else if (info.getEndDate().compareTo(info.getStartDate()) <= 0) {
            hm.put(info.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"chloan_submit_check_msg3_app", (Locale)ctx.getLocale()));
            isValid = false;
        } else if (!info.isIsHistoryLoan() && info.getStartDate().before(info.getBizDate())) {
            isValid = true;
        } else if (info.isIsHistoryLoan()) {
            Date lastSettleDate = info.getLastSettleDate();
            if (lastSettleDate.compareTo(info.getStartDate()) < 0 || lastSettleDate.compareTo(info.getEndDate()) > 0) {
                hm.put(info.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"chloan_submit_check_msg5_app", (Locale)ctx.getLocale()));
                isValid = false;
            }
        } else if (info.getExchangeRate() == null && info.getYearRate().compareTo(Constants.ZERO) < 0) {
            hm.put(info.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"chloan_submit_check_msg6_app", (Locale)ctx.getLocale()));
            isValid = false;
        } else if (info.isIsHistoryLoan()) {
            if (info.getLoanBalance().compareTo(info.getLoanTotalAmt()) > 0) {
                hm.put(info.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"chloan_submit_check_msg7_app", (Locale)ctx.getLocale()));
                isValid = false;
            } else if (this.notBetween(info.getLastSettleDate(), info.getStartDate(), info.getEndDate())) {
                hm.put(info.getNumber(), EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"chloan_submit_check_msg8_app", (Locale)ctx.getLocale()));
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean notBetween(Date lastSettleDate, Date startDate, Date endDate) {
        boolean lessThanStart = lastSettleDate.compareTo(startDate) < 0;
        boolean greaterThanStart = lastSettleDate.compareTo(endDate) > 0;
        return lessThanStart || greaterThanStart;
    }

    @Override
    protected void _editCheck(Context ctx, String id) throws BOSException, EASBizException {
        ChLoanInfo info = this.getChLoanInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (info.isIsDownLoaded()) {
            throw new CHLoanException(CHLoanException.EDIT_CHECK_ERROR6);
        }
        if (info.isFivouchered()) {
            throw new CHLoanException(CHLoanException.EDIT_CHECK_ERROR1);
        }
        if (info.isIsOverdue()) {
            throw new CHLoanException(CHLoanException.EDIT_CHECK_ERROR5);
        }
        if (ChLoanHelper.getInstance().hasExtendRecord(ctx, id)) {
            throw new CHLoanException(CHLoanException.EDIT_CHECK_ERROR2);
        }
        if (ChLoanHelper.getInstance().hasRepayRecord(ctx, id)) {
            throw new CHLoanException(CHLoanException.EDIT_CHECK_ERROR3);
        }
        if (ChLoanHelper.getInstance().hasIntRecord(ctx, id)) {
            throw new CHLoanException(CHLoanException.EDIT_CHECK_ERROR4);
        }
    }

    @Override
    protected void _postPoneCheck(Context ctx, ChLoanInfo chloan) throws BOSException, EASBizException {
        String loanid = chloan.getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select feffectedstatus from t_ivt_chloanextendbill ");
        sb.append("where fchloanid = ? ");
        sb.append("and fextendseq = ( ");
        sb.append("select max(fextendseq) from  t_ivt_chloanextendbill where fchloanid = ? ");
        sb.append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{loanid, loanid});
        try {
            int status;
            if (rs.next() && (status = rs.getInt(1)) == 1) {
                throw new CHLoanException(CHLoanException.ADD_NEW_ERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChLoanInfo info = (ChLoanInfo)model;
        info.setBillStatus(IvtBillStatusEnum.SAVE);
        IObjectPK pk = super._save(ctx, model);
        this.batchSubmitIntColl(ctx, info, pk, false);
        this.updateChLoanContract(ctx, (ChLoanInfo)model, pk);
        return pk;
    }

    private void setDefaultValue(Context ctx, ChLoanInfo info) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        info.setCompany(currentCompany);
        info.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setHandler(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        BankInfo clearingHouse = FSClientHelper.getClearingHouse();
        info.setBank(clearingHouse);
        info.setBizDate(clearingHouse.getSettleDate());
        info.setStartDate(info.getBizDate());
        info.setEndDate(info.getBizDate());
        info.setLoanTotalAmt(Constants.ZERO);
        info.setFloorAmt(Constants.ZERO);
        info.setFloatPoint(Constants.ZERO);
        info.setReturnWay(ReturnWayEnum.AT_TERM_WITH_ORI_AMT);
        info.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
        info.setYearDays(360);
        info.setLoanBalance(info.getLoanTotalAmt());
        info.setCurrency(currentCompany.getBaseCurrency());
        info.setYearRate(Constants.ZERO);
        info.setPenAccrualRate(Constants.ZERO);
        info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
        info.setRateType(IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK("lJlpCQEQEADgAAc+wKgSjiR9knQ=")));
        info.setIsHistoryLoan(false);
        ChLoanEntryInfo chLoanEntryInfo = (ChLoanEntryInfo)this.createNewDetailData(info.getEndDate());
        info.getEntrys().add(chLoanEntryInfo);
    }

    protected IObjectValue createNewDetailData(Date date) {
        ChLoanEntryInfo entry = new ChLoanEntryInfo();
        entry.setSeq(1);
        entry.setReturnDate(DateTimeUtils.truncateDate((Date)date));
        entry.setSchemeReturnAmt(Constants.ZERO);
        return entry;
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        boolean IVT003 = IvtModualUtils.getSysParam((Context)ctx, (String)"IVT003");
        ChLoanCollection col = this.getColByID(ctx, idSet);
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getBillStatus() == IvtBillStatusEnum.AUDIT) continue;
            if (!(IVT003 || col.get(i).getBillStatus() != IvtBillStatusEnum.SAVE && col.get(i).getBillStatus() != IvtBillStatusEnum.BOOK)) {
                throw new CHLoanException(CHLoanException.AUDITERROR);
            }
            String id = col.get(i).getId().toString();
            super.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK chloanPK) throws BOSException, EASBizException {
        this.updateChloan(ctx, IvtBillStatusEnum.AUDIT, chloanPK.toString());
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ChLoanCollection col = this.getColByID(ctx, idSet);
        for (int i = 0; i < col.size(); ++i) {
            IvtBillStatusEnum billStatus = col.get(i).getBillStatus();
            if (billStatus == IvtBillStatusEnum.SUBMIT) continue;
            if (billStatus == IvtBillStatusEnum.SAVE || billStatus == IvtBillStatusEnum.BOOK) {
                throw new CHLoanException(CHLoanException.ANTIAUDITERROR);
            }
            String id = col.get(i).getId().toString();
            super.antiAudit4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK chloanPK) throws BOSException {
        this.updateChloan(ctx, IvtBillStatusEnum.SUBMIT, chloanPK.toString());
    }

    private void updateChloan(Context ctx, IvtBillStatusEnum status, String id) throws BOSException {
        UserInfo curUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "";
        sql = status.equals((Object)IvtBillStatusEnum.AUDIT) ? "update T_IVT_ChLoan set FBillStatus = ? ,fauditorid = '" + curUser.getId().toString() + "' where fid = ?" : "update T_IVT_ChLoan set FBillStatus = ? ,fauditorid = null where fid = ?";
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status.getValue()), id});
    }

    @Override
    protected void _book(Context ctx, Set idSet) throws BOSException, EASBizException {
        String cashierid = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        ChLoanCollection col = this.getColByID(ctx, idSet);
        ChLoanInfo chLoanInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            chLoanInfo = col.get(i);
            IvtBillStatusEnum billStatus = chLoanInfo.getBillStatus();
            if (billStatus == IvtBillStatusEnum.BOOK) continue;
            if (billStatus == IvtBillStatusEnum.SAVE || billStatus == IvtBillStatusEnum.SUBMIT) {
                throw new CHLoanException(CHLoanException.BOOK_ERROR);
            }
            String id = chLoanInfo.getId().toString();
            this.updateChloanCashier(ctx, cashierid, IvtBillStatusEnum.BOOK, id);
            if (!chLoanInfo.isIsHistoryLoan() && !this.isBooked(ctx, id)) {
                this.newBook(ctx, (IObjectPK)new ObjectUuidPK(id), cashierid, chLoanInfo);
            }
            super.book4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _book4WF(Context ctx, IObjectPK loanPK) throws BOSException, EASBizException {
    }

    private void newBook(Context ctx, IObjectPK loanPK, String cashierid, ChLoanInfo info) throws BOSException, EASBizException {
        this.doBook(ctx, info);
    }

    @Override
    protected void _cancelBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        ChLoanCollection col = this.getColByID(ctx, idSet);
        for (int i = 0; i < col.size(); ++i) {
            IvtBillStatusEnum billStatus = col.get(i).getBillStatus();
            if (billStatus == IvtBillStatusEnum.AUDIT) continue;
            if (billStatus == IvtBillStatusEnum.SAVE || billStatus == IvtBillStatusEnum.SUBMIT) {
                throw new CHLoanException(CHLoanException.CANCELBOOKERROR);
            }
            if (col.get(i).isFivouchered()) {
                throw new CHLoanException(CHLoanException.CANCELBOOKERROR2, new Object[]{col.get(i).getNumber()});
            }
            String id = col.get(i).getId().toString();
            super.cancelBook4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _cancelBook4WF(Context ctx, IObjectPK loanPK) throws BOSException, EASBizException {
        this.newCancelBook(ctx, loanPK);
    }

    private void newCancelBook(Context ctx, IObjectPK loanPK) throws EASBizException, BOSException {
        this.doAntiBook(ctx, loanPK);
        this.updateChloanCashier(ctx, null, IvtBillStatusEnum.AUDIT, loanPK.toString());
    }

    private void updateChloanCashier(Context ctx, String cashierid, IvtBillStatusEnum status, String billid) throws BOSException {
        String sql = "update T_IVT_ChLoan set FCashierID = ?,FBillStatus=? where fid = ?";
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{cashierid, new Integer(status.getValue()), billid});
    }

    private ChLoanCollection getColByID(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(f);
        ChLoanCollection toBeBooked = ChLoanFactory.getLocalInstance(ctx).getChLoanCollection(evi);
        return toBeBooked;
    }

    @Override
    protected void _updateCreditLevel(Context ctx, IObjectPK pk, IObjectPK creditLevelPK) throws BOSException {
        try {
            ChLoanInfo chLoanInfo = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo(pk);
            CreditLevelInfo creditLevelInfo = CreditLevelFactory.getLocalInstance(ctx).getCreditLevelInfo(creditLevelPK);
            chLoanInfo.setCreditLevel(creditLevelInfo);
            super._update(ctx, pk, (IObjectValue)chLoanInfo);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void updateChLoanContract(Context ctx, ChLoanInfo info, IObjectPK pk) throws BOSException, EASBizException {
        ChLoanContractInfo contractInfo = info.getChLoanContract();
        if (info.getChLoanContract() == null || contractInfo.getUsingEntries().size() == 0) {
            return;
        }
        if (!info.isIsMulCon()) {
            if (contractInfo.getId() != null) {
                ChLoanContractFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(contractInfo.getId()));
            }
            contractInfo.setConNumber(info.getContractNo());
            IObjectPK conPk = ChLoanContractFactory.getLocalInstance(ctx).submit((CoreBaseInfo)contractInfo);
            String sql = " update T_IVT_ChLoan set FChLoanContractID = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{conPk.toString(), pk.toString()});
        } else if (info.getContractSeq() == 1) {
            if (contractInfo.getId() != null) {
                ChLoanContractFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(contractInfo.getId()));
            }
            IObjectPK conPk = ChLoanContractFactory.getLocalInstance(ctx).submit((CoreBaseInfo)contractInfo);
            String sql = " update T_IVT_ChLoan set FChLoanContractID = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{conPk.toString(), pk.toString()});
        } else {
            String sql1 = " update T_IVT_ChLoanContract set FAddConAmount = ?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{contractInfo.getAddConAmount(), info.getChLoanContract().getId().toString()});
            String sql2 = " update T_IVT_ChLoanContract set FRemainConAmount = ?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{contractInfo.getRemainConAmount(), info.getChLoanContract().getId().toString()});
            String sql3 = " update T_IVT_ChLoanContract set FSeq = ?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql3, (Object[])new Object[]{new Integer(contractInfo.getSeq()), info.getChLoanContract().getId().toString()});
        }
    }

    protected ChLoanInfo _getFirstChLoanInMul(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select fid from T_IVT_ChLoan where FChLoanContractID = ? and FIsMulCon = ? and FContractSeq = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), new Integer(1), new Integer(1)});
        String conId = "";
        try {
            if (rs.next()) {
                conId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ChLoanInfo info = null;
        if (!FMHelper.isEmpty((String)conId)) {
            info = this.getChLoanInfo(ctx, (IObjectPK)new ObjectStringPK(conId), this.getSelectorsForChLoanContact());
        }
        return info;
    }

    private SelectorItemCollection getSelectorsForChLoanContact() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("finacingProduct.id"));
        sic.add(new SelectorItemInfo("finacingProduct.name"));
        sic.add(new SelectorItemInfo("finacingProduct.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("rateType.id"));
        sic.add(new SelectorItemInfo("rateType.number"));
        sic.add(new SelectorItemInfo("rateType.name"));
        sic.add(new SelectorItemInfo("floatPoint"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("yearRate"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("penAccrualRate"));
        sic.add(new SelectorItemInfo("loanAccount.id"));
        sic.add(new SelectorItemInfo("loanAccount.name"));
        sic.add(new SelectorItemInfo("loanAccount.number"));
        sic.add(new SelectorItemInfo("loanAccount.applyUnit.*"));
        sic.add(new SelectorItemInfo("loanCompany.id"));
        sic.add(new SelectorItemInfo("loanCompany.number"));
        sic.add(new SelectorItemInfo("loanCompany.name"));
        return sic;
    }
}

