/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.RepayIntTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.util.PredictionParamCollection;
import com.kingdee.eas.fm.im.CycleTypeEnum;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntSchemeFactory;
import com.kingdee.eas.fm.im.IntSchemeInfo;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import com.kingdee.eas.fm.ivt.ChLoanCollection;
import com.kingdee.eas.fm.ivt.ChLoanEntryCollection;
import com.kingdee.eas.fm.ivt.ChLoanEntryInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillCollection;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.app.AbstractChLoanIntPreFacadeControllerBean;
import com.kingdee.eas.fm.ivt.app.IntPreHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChLoanIntPreFacadeControllerBean
extends AbstractChLoanIntPreFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.ChLoanIntPreFacadeControllerBean");

    @Override
    public Map _genChLoanIntPre(Context ctx, Map map) throws BOSException, EASBizException {
        HashMap<String, LoanInterestBillCollection> intCollMap = new HashMap<String, LoanInterestBillCollection>();
        Set keySet = map.keySet();
        for (String key : keySet) {
            PredictionParamCollection paramCollection = (PredictionParamCollection)map.get(key);
            LoanInterestBillCollection chloanIntColl = this.genChLoanIntPreColl(ctx, paramCollection);
            intCollMap.put(key, chloanIntColl);
        }
        return intCollMap;
    }

    @Override
    protected Set _genChloanIntPreFromListUI(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, PredictionParamCollection> paramMap = new HashMap<String, PredictionParamCollection>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("entrys.*");
        view.getSelector().add("payIntMode.cycleType");
        view.getSelector().add("payIntMode.settleDay");
        ChLoanCollection loanColl = ChLoanFactory.getLocalInstance(ctx).getChLoanCollection(view);
        int n = loanColl.size();
        for (int k = 0; k < n; ++k) {
            ChLoanInfo loanInfo = loanColl.get(k);
            String id = loanInfo.getId().toString();
            EntRepaymentBillCollection repayColl = new EntRepaymentBillCollection();
            ChLoanEntryCollection repayEntrys = loanInfo.getEntrys();
            for (int i = 0; i < repayEntrys.size(); ++i) {
                EntRepaymentBillInfo repayInfo = new EntRepaymentBillInfo();
                ChLoanEntryInfo loanEntryInfo = repayEntrys.get(i);
                repayInfo.setBizDate(loanEntryInfo.getReturnDate());
                repayInfo.setRepayDate(loanEntryInfo.getReturnDate());
                repayInfo.setRepayAmt(loanEntryInfo.getSchemeReturnAmt());
                RepayIntTypeEnum repayIntType = loanEntryInfo.getRepayIntType();
                if (repayIntType.equals((Object)RepayIntTypeEnum.REPAY_INT)) {
                    repayInfo.setIsRepayWithAccrual(true);
                } else {
                    repayInfo.setIsRepayWithAccrual(false);
                }
                repayColl.add(repayInfo);
            }
            PredictionParamCollection paramColl = new PredictionParamCollection();
            paramColl.setChLoanInfo(loanInfo);
            paramColl.setEntRepayColl(repayColl);
            paramMap.put(id, paramColl);
        }
        return this._batchSubmit(ctx, this._genChLoanIntPre(ctx, paramMap));
    }

    @Override
    protected Set _batchSubmit(Context ctx, Map intCollMap) throws BOSException, EASBizException {
        HashSet<Set> intIDSet = new HashSet<Set>();
        for (Map.Entry entry : intCollMap.entrySet()) {
            intIDSet.add(this._submitChLoanInt(ctx, (String)entry.getKey(), (LoanInterestBillCollection)((Object)entry.getValue()), false));
        }
        return intIDSet;
    }

    private LoanInterestBillCollection genChLoanIntPreColl(Context ctx, PredictionParamCollection paramCollection) throws BOSException, EASBizException, FinBizException {
        LoanInterestBillCollection loanIntColl = new LoanInterestBillCollection();
        Calendar tmpCal = Calendar.getInstance();
        ChLoanInfo chLoanInfo = paramCollection.getChLoanInfo();
        BOSUuid loanID = chLoanInfo.getId();
        ChLoanRateAdjustBillCollection adjColl = this.getAdjCollByChLoan(ctx, loanID);
        EntRepaymentBillCollection repayColl = paramCollection.getEntRepayColl();
        IntSchemeInfo intScInfo = chLoanInfo.getPayIntMode();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)intScInfo) && EmptyUtil.isEmpty((Object)intScInfo.getCycleType())) {
            intScInfo = IntSchemeFactory.getLocalInstance((Context)ctx).getIntSchemeInfo((IObjectPK)new ObjectUuidPK(intScInfo.getId().toString()));
        }
        if (intScInfo != null) {
            List timesList = this.getIntTimesListByCt(intScInfo, chLoanInfo.getStartDate(), chLoanInfo.getExpiredDate());
            if (timesList != null && timesList.size() > 0) {
                this.getIntTimesByEntRepayColl(repayColl, timesList);
                VOComparator vo = new VOComparator();
                Collections.sort(timesList, vo);
                Date startDate = chLoanInfo.getStartDate();
                BigDecimal balance = this.getAmtAsRepayNotIntByChloan(chLoanInfo, repayColl);
                for (int i = 0; i < timesList.size(); ++i) {
                    TimesListOfPredictionInfo tlpInfo = (TimesListOfPredictionInfo)timesList.get(i);
                    Date endDate = tlpInfo.getTime();
                    tmpCal.setTime(endDate);
                    chLoanInfo.setLoanBalance(balance);
                    if (tlpInfo.getIsLoan()) {
                        tmpCal.add(5, 1);
                        endDate = tmpCal.getTime();
                        IntCalModel model = IntPreHelper.getIntCalModel(startDate, endDate, chLoanInfo, adjColl, repayColl, tlpInfo.getEntRepaymentInfo());
                        LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REC_INT).calInt(ctx, model);
                        LoanInterestBillInfo intInfo = IntPreHelper.transfrom(ctx, loanIntInfo, chLoanInfo, tlpInfo.getEntRepaymentInfo());
                        intInfo.setBizDate(endDate);
                        intInfo.setIntAccount(chLoanInfo.getLoanAccount());
                        intInfo.setLoanCompany(chLoanInfo.getLoanCompany());
                        intInfo.setBank(chLoanInfo.getBank());
                        loanIntColl.add(intInfo);
                        startDate = endDate;
                        RepaymentInfo repayInfo = tlpInfo.getRepaymentInfo();
                        if (repayInfo == null) continue;
                        balance = balance.subtract(repayInfo.getAmount());
                        continue;
                    }
                    tmpCal.add(5, 1);
                    endDate = tmpCal.getTime();
                    EntRepaymentBillInfo repayInfo = tlpInfo.getEntRepaymentInfo();
                    IntCalModel model = IntPreHelper.getIntCalModel(startDate, endDate, chLoanInfo, adjColl, repayColl, repayInfo);
                    LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
                    LoanInterestBillInfo intInfo = IntPreHelper.transfrom(ctx, loanIntInfo, chLoanInfo, tlpInfo.getEntRepaymentInfo());
                    intInfo.setBizDate(endDate);
                    intInfo.setIntAccount(chLoanInfo.getLoanAccount());
                    intInfo.setLoanCompany(chLoanInfo.getLoanCompany());
                    intInfo.setBank(chLoanInfo.getBank());
                    loanIntColl.add(intInfo);
                    balance = balance.subtract(repayInfo.getRepayAmt());
                }
            } else {
                loanIntColl = this.predIntOnlyRepayColl(ctx, chLoanInfo, adjColl, repayColl);
            }
        } else {
            loanIntColl = this.predIntOnlyRepayColl(ctx, chLoanInfo, adjColl, repayColl);
        }
        return loanIntColl;
    }

    protected LoanInterestBillCollection predIntOnlyRepayColl(Context ctx, ChLoanInfo chLoanInfo, ChLoanRateAdjustBillCollection adjColl, EntRepaymentBillCollection repayColl) throws EASBizException, BOSException {
        LoanInterestBillCollection loanIntColl = new LoanInterestBillCollection();
        Date startDate = chLoanInfo.getStartDate();
        BigDecimal balance = this.getAmtAsRepayNotIntByChloan(chLoanInfo, repayColl);
        for (int j = 0; j < repayColl.size(); ++j) {
            EntRepaymentBillInfo repayInfo = repayColl.get(j);
            chLoanInfo.setLoanBalance(balance);
            if (!repayInfo.isIsRepayWithAccrual()) continue;
            Date endDate = repayInfo.getBizDate();
            IntCalModel model = IntPreHelper.getIntCalModel(startDate, endDate, chLoanInfo, adjColl, repayColl, repayInfo);
            LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
            LoanInterestBillInfo intInfo = IntPreHelper.transfrom(ctx, loanIntInfo, chLoanInfo, repayInfo);
            intInfo.setBizDate(endDate);
            intInfo.setBizDate(endDate);
            intInfo.setIntAccount(chLoanInfo.getLoanAccount());
            intInfo.setLoanCompany(chLoanInfo.getLoanCompany());
            intInfo.setBank(chLoanInfo.getBank());
            loanIntColl.add(intInfo);
            balance = balance.subtract(repayInfo.getRepayAmt());
        }
        return loanIntColl;
    }

    private void getIntTimesByEntRepayColl(EntRepaymentBillCollection repayColl, List timesList) {
        Date repayDate = null;
        TimesListOfPredictionInfo tlpInfo = null;
        for (int j = 0; j < repayColl.size(); ++j) {
            EntRepaymentBillInfo repayInfo = repayColl.get(j);
            if (!repayInfo.isIsRepayWithAccrual()) continue;
            repayDate = DateTimeUtils.truncateDate((Date)repayInfo.getBizDate());
            tlpInfo = new TimesListOfPredictionInfo();
            tlpInfo.setIsLoan(true);
            tlpInfo.setTime(DateUtil.getBeforeDay((Date)repayDate));
            if (timesList.contains(tlpInfo)) {
                timesList.remove(tlpInfo);
                tlpInfo.setIsLoan(true);
            } else {
                tlpInfo.setIsLoan(false);
            }
            tlpInfo.setTime(DateUtil.getBeforeDay((Date)repayDate));
            tlpInfo.setEntRepaymentInfo(repayInfo);
            timesList.add(tlpInfo);
        }
    }

    private List getIntTimesListByCt(IntSchemeInfo intScInfo, Date startDate, Date endDate) {
        TimesListOfPredictionInfo tlpInfo;
        ArrayList<TimesListOfPredictionInfo> timesList = new ArrayList<TimesListOfPredictionInfo>();
        CycleTypeEnum ctEnum = intScInfo.getCycleType();
        int settleDay = intScInfo.getSettleDay();
        startDate = DateTimeUtils.truncateDate((Date)startDate);
        endDate = DateTimeUtils.truncateDate((Date)endDate);
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        Calendar nextCalendar = Calendar.getInstance();
        if (ctEnum.equals((Object)CycleTypeEnum.YEAR)) {
            nextCalendar = IntPreHelper.getYearCalendar(startCalendar, endCalendar, settleDay);
            if (nextCalendar == null) {
                return null;
            }
            while (nextCalendar.getTime().compareTo(endDate) <= 0) {
                tlpInfo = new TimesListOfPredictionInfo();
                tlpInfo.setIsLoan(true);
                tlpInfo.setTime(DateTimeUtils.truncateDate((Date)nextCalendar.getTime()));
                timesList.add(tlpInfo);
                nextCalendar.add(1, 1);
            }
        }
        if (ctEnum.equals((Object)CycleTypeEnum.QUARTER)) {
            nextCalendar = IntPreHelper.getQuarterCalendar(startCalendar, endCalendar, settleDay);
            if (nextCalendar == null) {
                return null;
            }
            while (nextCalendar.getTime().compareTo(endDate) <= 0) {
                tlpInfo = new TimesListOfPredictionInfo();
                tlpInfo.setIsLoan(true);
                tlpInfo.setTime(DateTimeUtils.truncateDate((Date)nextCalendar.getTime()));
                timesList.add(tlpInfo);
                nextCalendar = IntPreHelper.setTimeOfNextPeriod(nextCalendar, settleDay, 3);
            }
        }
        if (ctEnum.equals((Object)CycleTypeEnum.MONTH)) {
            nextCalendar = IntPreHelper.getMonthCalendar(startCalendar, endCalendar, settleDay);
            if (nextCalendar == null) {
                return null;
            }
            while (nextCalendar.getTime().compareTo(endDate) <= 0) {
                tlpInfo = new TimesListOfPredictionInfo();
                tlpInfo.setIsLoan(true);
                tlpInfo.setTime(DateTimeUtils.truncateDate((Date)nextCalendar.getTime()));
                timesList.add(tlpInfo);
                nextCalendar = IntPreHelper.setTimeOfNextPeriod(nextCalendar, settleDay, 1);
            }
        }
        return timesList;
    }

    protected BigDecimal getAmtAsRepayNotIntByChloan(ChLoanInfo chloanInfo, EntRepaymentBillCollection repayColl) {
        BigDecimal balance = chloanInfo.getLoanTotalAmt();
        for (int i = 0; i < repayColl.size(); ++i) {
            if (repayColl.get(i).isIsRepayWithAccrual()) continue;
            balance = balance.subtract(repayColl.get(i).getRepayAmt());
        }
        return balance;
    }

    private ChLoanRateAdjustBillCollection getAdjCollByChLoan(Context ctx, BOSUuid loanID) throws BOSException {
        if (loanID == null) {
            return new ChLoanRateAdjustBillCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanID));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("adjustDate"));
        return ChLoanRateAdjustBillFactory.getLocalInstance(ctx).getChLoanRateAdjustBillCollection(evi);
    }

    @Override
    protected Set _submitChLoanInt(Context ctx, String chloanId, LoanInterestBillCollection intColl, boolean isSubmit) throws BOSException, EASBizException {
        this.deleteChLoanIntPre(ctx, chloanId);
        ChLoanInfo chinfo = this.getChLoanInfoById(ctx, chloanId);
        CoreBaseCollection coll = new CoreBaseCollection();
        HashSet<String> idSet = new HashSet<String>();
        if (intColl != null && intColl.size() > 0) {
            Iterator iter = intColl.iterator();
            while (iter.hasNext()) {
                LoanInterestBillInfo intInfo = (LoanInterestBillInfo)iter.next();
                String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)intInfo, (String)chinfo.getCompany().getId().toString());
                if (!EmptyUtil.isEmpty((String)numberSilent)) {
                    intInfo.setNumber(numberSilent);
                }
                coll.add((CoreBaseInfo)intInfo);
                idSet.add(intInfo.getId().toString());
            }
            LoanInterestBillFactory.getLocalInstance(ctx).saveBatchData(coll);
        }
        return idSet;
    }

    private ChLoanInfo getChLoanInfoById(Context ctx, String chloanId) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)chloanId));
        view.setFilter(filter);
        view.setSelector(sic);
        ChLoanCollection chColl = ChLoanFactory.getLocalInstance(ctx).getChLoanCollection(view);
        return chColl.get(0);
    }

    protected void deleteChLoanIntPre(Context ctx, String chloanID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(true)));
        filter.getFilterItems().add(new FilterItemInfo("loanBill.id", (Object)chloanID));
        LoanInterestBillFactory.getLocalInstance(ctx).delete(filter);
    }

    class VOComparator
    implements Comparator {
        VOComparator() {
        }

        public int compare(Object o1, Object o2) {
            TimesListOfPredictionInfo info1 = (TimesListOfPredictionInfo)o1;
            TimesListOfPredictionInfo info2 = (TimesListOfPredictionInfo)o2;
            return info1.getTime().compareTo(info2.getTime());
        }
    }

    class TimesListOfPredictionInfo {
        private boolean isLoan;
        private Date time;
        private RepaymentInfo repayInfo;
        private EntRepaymentBillInfo entRepayInfo;

        TimesListOfPredictionInfo() {
        }

        public void setIsLoan(boolean isLoan) {
            this.isLoan = isLoan;
        }

        public boolean getIsLoan() {
            return this.isLoan;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public Date getTime() {
            return this.time;
        }

        public void setRepaymentInfo(RepaymentInfo repayInfo) {
            this.repayInfo = repayInfo;
        }

        public RepaymentInfo getRepaymentInfo() {
            return this.repayInfo;
        }

        public void setEntRepaymentInfo(EntRepaymentBillInfo entRepayInfo) {
            this.entRepayInfo = entRepayInfo;
        }

        public EntRepaymentBillInfo getEntRepaymentInfo() {
            return this.entRepayInfo;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TimesListOfPredictionInfo)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            TimesListOfPredictionInfo info = (TimesListOfPredictionInfo)obj;
            return this.time.compareTo(info.time) == 0 && this.isLoan == info.isLoan && this.repayInfo == info.repayInfo && this.entRepayInfo == info.entRepayInfo;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

