/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.RateAdjustmentBaseBillInfo;
import com.kingdee.eas.fm.common.app.IRateAdjustmentBaseBillCallBack;
import com.kingdee.eas.fm.common.app.IRateAdjustmentBaseBillCallBackImp_AddNew;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillCollection;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillInfo;
import com.kingdee.eas.fm.ivt.app.AbstractChLoanRateAdjustBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChLoanRateAdjustBillControllerBean
extends AbstractChLoanRateAdjustBillControllerBean {
    @Override
    protected Set _batchAdjustRate(Context ctx, ChLoanRateAdjustBillCollection col, Map addValueMap) throws BOSException, EASBizException {
        HashSet<String> adjustmentBillIDs = new HashSet<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            ChLoanRateAdjustBillInfo rateAdjustBillInfo = col.get(i);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("adjustDate", (Object)rateAdjustBillInfo.getAdjustDate()));
            filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)rateAdjustBillInfo.getLoan().getId()));
            if (this._exists(ctx, filter)) {
                throw new CHLoanException(CHLoanException.SUBMITDUMP, new Object[]{rateAdjustBillInfo.getLoan().getNumber(), FMHelper.formateDate((Date)rateAdjustBillInfo.getAdjustDate())});
            }
            rateAdjustBillInfo.setModifyRateType((IntRateModifyType)addValueMap.get("rateModifyType"));
            rateAdjustBillInfo.setIntRateType((IntRateTypeInfo)addValueMap.get("rateType"));
            rateAdjustBillInfo.setFloatAction((FloatActionEnum)addValueMap.get("floatAction"));
            rateAdjustBillInfo.setBasePoints((BigDecimal)addValueMap.get("basePoints"));
            rateAdjustBillInfo.setFirstRateAdjustDate((Date)addValueMap.get("firstRateAjdust"));
            rateAdjustBillInfo.setRateAdjustPeriod(Integer.valueOf(addValueMap.get("rateAdjustPeriod").toString()));
            IObjectPK pk = super.submit(ctx, (CoreBaseInfo)rateAdjustBillInfo);
            ChLoanInfo info = rateAdjustBillInfo.getLoan();
            info.setLastAdjustDate(rateAdjustBillInfo.getAdjustDate());
            info.setAdjustRateTimes(rateAdjustBillInfo.getAdjustSeq());
            ChLoanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            adjustmentBillIDs.add(pk.toString());
        }
        return adjustmentBillIDs;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IObjectPK pk = super._addnew(ctx, model);
        this.afterRateAdjustmentBillCreated(ctx, (IRateAdjustmentBaseBillCallBack)new IRateAdjustmentBaseBillCallBackImp_AddNew(ctx, (RateAdjustmentBaseBillInfo)((ChLoanRateAdjustBillInfo)model)));
        return pk;
    }

    private void checkSubmit(ChLoanRateAdjustBillInfo info) throws BOSException, EASBizException {
        if (info.getLastAdjustDate() != null && info.getAdjustDate().compareTo(info.getLastAdjustDate()) < 0) {
            throw new CHLoanException(CHLoanException.ADJUST_DATE_EXC);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkSubmit((ChLoanRateAdjustBillInfo)model);
        IObjectPK pk = super._submit(ctx, model);
        ChLoanRateAdjustBillInfo rateAdjustBillInfo = (ChLoanRateAdjustBillInfo)model;
        ChLoanInfo info = rateAdjustBillInfo.getLoan();
        info.setLastAdjustDate(rateAdjustBillInfo.getAdjustDate());
        info.setAdjustRateTimes(rateAdjustBillInfo.getAdjustSeq());
        if (IntRateModifyType.LPR.equals((Object)rateAdjustBillInfo.getModifyRateType())) {
            info.setIsLPR(true);
        } else if (IntRateModifyType.Agreement.equals((Object)rateAdjustBillInfo.getModifyRateType())) {
            info.setIsLPR(false);
        }
        ChLoanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChLoanRateAdjustBillInfo rateAdjustBillInfo = this.getChLoanRateAdjustBillInfo(ctx, pk);
        super._delete(ctx, pk);
        StringBuffer sbUpdate = new StringBuffer();
        if (IntRateModifyType.LPR.equals((Object)rateAdjustBillInfo.getModifyRateType())) {
            sbUpdate.append("update T_IVT_ChLoan ");
            sbUpdate.append("set FAdjustRateTimes = FAdjustRateTimes - 1,FLastAdjustDate=?,FISLPR = 0 ");
            sbUpdate.append("where fid = ?");
        } else {
            sbUpdate.append("update T_IVT_ChLoan ");
            sbUpdate.append("set FAdjustRateTimes = FAdjustRateTimes - 1,FLastAdjustDate=? ");
            sbUpdate.append("where fid = ?");
        }
        FMHelper.execute((Context)ctx, (String)sbUpdate.toString(), (Object[])new Object[]{rateAdjustBillInfo.getLastAdjustDate(), rateAdjustBillInfo.getLoan().getId().toString()});
        CompanyOrgUnitInfo comp = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)rateAdjustBillInfo, (String)comp.getId().toString());
    }
}

