/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;

public class ChLoanSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        ChLoanInfo chLoanInfo = this.getChLoanInfo(ctx, billId);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        SubsidiaryLedgerInfo slInfo1 = this.createBaseLedger(chLoanInfo);
        slInfo1.setInnerAccount(chLoanInfo.getLoanAccount());
        slInfo1.setApplyUnit(chLoanInfo.getLoanCompany());
        slInfo1.setDebitAmount(chLoanInfo.getLoanTotalAmt());
        coll.add(slInfo1);
        if (chLoanInfo.getDistributeAccou() != null) {
            SubsidiaryLedgerInfo slInfo = this.createBaseLedger(chLoanInfo);
            slInfo.setInnerAccount(chLoanInfo.getDistributeAccou());
            slInfo.setApplyUnit(chLoanInfo.getLoanCompany());
            slInfo.setCreditAmount(chLoanInfo.getLoanTotalAmt());
            coll.add(slInfo);
        }
        return coll;
    }

    private ChLoanInfo getChLoanInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        return sic;
    }

    private SubsidiaryLedgerInfo createBaseLedger(ChLoanInfo chLoanInfo) {
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        slInfo.setDate(chLoanInfo.getBizDate());
        slInfo.setCurrency(chLoanInfo.getCurrency());
        slInfo.setBillId(chLoanInfo.getId());
        slInfo.setBillNumber(chLoanInfo.getNumber());
        slInfo.setExchangeRate(chLoanInfo.getExchangeRate());
        slInfo.setIsDownLoad(false);
        slInfo.setBookkeeper(chLoanInfo.getCreator());
        slInfo.setDescription(chLoanInfo.getDescription());
        slInfo.setBizType(SubsidiaryBillTypeEnum.CHLOANBILL);
        slInfo.setCompany(chLoanInfo.getCompany());
        return slInfo;
    }
}

