/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeCollection;
import com.kingdee.eas.fm.fin.GuaranteeTypeFactory;
import com.kingdee.eas.fm.fin.GuaranteeTypeInfo;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.ivt.ChLoanEntryCollection;
import com.kingdee.eas.fm.ivt.ChLoanEntryFactory;
import com.kingdee.eas.fm.ivt.ChLoanEntryInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.ReturnWayEnum;
import com.kingdee.eas.fm.ivt.app.ChloanDataImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class ChloanDataImport
extends AbstractFMDataImport {
    String resourcePath = "com.kingdee.eas.fm.ivt.CHLoanResource";
    ChLoanEntryInfo entryInfo;
    ChLoanEntryCollection entryColl;

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return ChLoanFactory.getLocalInstance(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        InnerAccountInfo accrualAccount;
        BigDecimal floorAmt;
        InnerAccountInfo distributeAccount;
        ChLoanInfo info = new ChLoanInfo();
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        String clearHouseNumber = (String)this.getData(hsData, "ClearingHouse_number");
        BankInfo clearHouse = ChloanDataImportUtil.getClearHouseByNumber(ctx, clearHouseNumber);
        CompanyOrgUnitInfo currentCompany = clearHouse.getRelatedCompany();
        UserInfo currentuser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        ObjectUuidPK userPK = new ObjectUuidPK(currentuser.getId());
        ObjectUuidPK companyPK = new ObjectUuidPK(currentCompany.getId());
        boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)companyPK, "ch_loan_14importData");
        if (!hasFunctionPermission) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"no_permission", (Locale)ctx.getLocale()));
        }
        boolean ivt001 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("IVT001", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        boolean ivt002 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("IVT002", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        info.setBank(clearHouse);
        info.setCompany(currentCompany);
        String billNumber = (String)this.getData(hsData, "FNumber");
        info.setNumber(billNumber);
        java.util.Date bizDate = this.getDate(ctx, this.getData(hsData, "FBizDate"));
        info.setBizDate(bizDate);
        String remark = (String)this.getData(hsData, "FDescription");
        info.setDescription(remark);
        String finProductNumber = (String)this.getData(hsData, "FFinacingProduct_number");
        FinancingProductsInfo finProduct = ChloanDataImportUtil.getFinancingProductByNumber(ctx, finProductNumber);
        info.setFinacingProduct(finProduct);
        String contractNo = (String)this.getData(hsData, "FContractNo");
        info.setContractNo(contractNo);
        String currencyNumber = (String)this.getData(hsData, "FCurrency_number");
        CurrencyInfo currency = RecAndPayDataImportUtil2.getCurrencyByNumber((Context)ctx, (String)currencyNumber);
        info.setCurrency(currency);
        BigDecimal loanTotalAmount = this.getAmount(ctx, this.getData(hsData, "FLoanTotalAmt"));
        if (loanTotalAmount.compareTo(BigDecimal.ZERO) < 1) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"chloan_submit_check_msg1_app", (Locale)ctx.getLocale()));
        }
        info.setLoanTotalAmt(loanTotalAmount);
        BigDecimal balance = this.getAmount(ctx, this.getData(hsData, "FLoanBalance"));
        if (balance.compareTo(BigDecimal.ZERO) < 1) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"balance_error", (Locale)ctx.getLocale()));
        }
        info.setLoanBalance(balance);
        info.setInitBalanceOfHistoryBill(balance);
        if (info.getLoanTotalAmt().compareTo(info.getLoanBalance()) < 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"loanbalance_error", (Locale)ctx.getLocale()));
        }
        BigDecimal exRate = this.getAmount(ctx, this.getData(hsData, "FExchangeRate"));
        if (exRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"exRate_error", (Locale)ctx.getLocale()));
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)currentCompany.getBaseCurrency()) && currentCompany.getBaseCurrency().getId().toString().equals(currency.getId().toString())) {
            info.setExchangeRate(BigDecimal.ONE);
        } else {
            info.setExchangeRate(exRate);
        }
        if (info.getExchangeRate().compareTo(BigDecimal.ZERO) < 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"ExchangeRate_error", (Locale)ctx.getLocale()));
        }
        info.setLocalAmt(info.getLoanTotalAmt().multiply(info.getExchangeRate()));
        java.util.Date startDate = this.getDate(ctx, this.getData(hsData, "FStartDate"));
        info.setStartDate(startDate);
        java.util.Date endDate = this.getDate(ctx, this.getData(hsData, "FEndDate"));
        info.setEndDate(endDate);
        info.setHorizon(FinHorizon.getHorizon((java.util.Date)startDate, (java.util.Date)endDate).setScale(1, 4));
        if (!endDate.after(startDate)) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"enddate_error", (Locale)ctx.getLocale()));
        }
        String isHisLoan = ((String)this.getData(hsData, "FIsHistoryLoan")).trim();
        if (!"false".equalsIgnoreCase(isHisLoan) && !"true".equalsIgnoreCase(isHisLoan)) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"isHisLoan_error", (Locale)ctx.getLocale()));
        }
        info.setIsHistoryLoan("true".equalsIgnoreCase(isHisLoan));
        String loanAccountNumber = (String)this.getData(hsData, "FLoanAccount_number");
        InnerAccountInfo loanAccount = ChloanDataImportUtil.getInnerAccountByNumber(ctx, loanAccountNumber);
        info.setLoanCompany(loanAccount.getApplyUnit());
        if (!loanAccount.getClearingHouse().getId().toString().equals(clearHouse.getId().toString())) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"account_not_match", (Locale)ctx.getLocale()));
        }
        info.setLoanAccount(loanAccount);
        String distributeAccountNumber = (String)this.getData(hsData, "FDistributeAccou_number");
        if (ivt001) {
            if (EmptyUtil.isEmpty((String)distributeAccountNumber)) throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"ivt001", (Locale)ctx.getLocale()));
            distributeAccount = ChloanDataImportUtil.getInnerAccountByNumber(ctx, distributeAccountNumber);
            info.setDistributeAccou(distributeAccount);
        } else if (!EmptyUtil.isEmpty((String)distributeAccountNumber)) {
            try {
                distributeAccount = ChloanDataImportUtil.getInnerAccountByNumber(ctx, distributeAccountNumber);
                info.setDistributeAccou(distributeAccount);
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"distAccount_not_valid", (Locale)ctx.getLocale()));
            }
        }
        BigDecimal yearRate = this.getAmount(ctx, this.getData(hsData, "FYearRate"));
        if (yearRate.compareTo(BigDecimal.ZERO) < 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"yearRate_negative", (Locale)ctx.getLocale()));
        }
        info.setYearRate(yearRate);
        int yearDays = this.getInt(ctx, this.getData(hsData, "FYearDays"));
        if (yearDays <= 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"yearDays_negative", (Locale)ctx.getLocale()));
        }
        info.setYearDays(yearDays);
        String rateTypeNumber = (String)this.getData(hsData, "FRateType_number");
        IntRateTypeInfo rateType = ChloanDataImportUtil.getIntRateTypeByNumber(ctx, rateTypeNumber);
        info.setRateType(rateType);
        BigDecimal floatPoint = this.getAmount(ctx, this.getData(hsData, "FFloatPoint"));
        if (this.isAgreeMentOrFixedRate(rateType)) {
            info.setFloatPoint(BigDecimal.ZERO);
        } else {
            info.setFloatPoint(floatPoint);
            info.setYearDays(rateType.getFactorDay());
            info.setYearRate(this.getYearRate(info, rateType, ctx));
            if (info.getYearRate().compareTo(BigDecimal.ZERO) < 0) {
                throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"yearrate_error", (Locale)ctx.getLocale()));
            }
        }
        String loanAccountViewNumber = (String)this.getData(hsData, "FLoanAccountView_number");
        if (!EmptyUtil.isEmpty((String)loanAccountViewNumber)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)loanAccountViewNumber));
            view.setFilter(filter);
            AccountViewCollection collection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            if (collection.size() > 0) {
                info.setLoanAccountView(collection.get(0));
            }
        }
        if ((floorAmt = this.getAmount(ctx, this.getData(hsData, "FFloorAmt"))).compareTo(BigDecimal.ZERO) < 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"floorAmt_negative", (Locale)ctx.getLocale()));
        }
        info.setFloorAmt(floorAmt);
        java.util.Date lastIntDate = this.getDate(ctx, this.getData(hsData, "FLastSettleDate"));
        java.util.Date lastPreIntDate = this.getDate(ctx, this.getData(hsData, "FLastPreIntDate"));
        if (info.isIsHistoryLoan()) {
            if (lastIntDate == null) {
                throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"no_lastIntDate", (Locale)ctx.getLocale()));
            }
            info.setLastSettleDate(lastIntDate);
            info.setLastPreIntDate(lastPreIntDate);
        } else if (info.getLoanTotalAmt().compareTo(info.getLoanBalance()) != 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"amt_not_equal_balance", (Locale)ctx.getLocale()));
        }
        String intRateTypeExp = (String)this.getData(hsData, "FIntRateTypeExpression");
        if (this.isAgreeMentOrFixedRate(rateType)) {
            IntRateTypeExpressionEnum intRateEnum = IntRateTypeExpressionEnum.getEnum(intRateTypeExp);
            if (intRateEnum != null) {
                info.setIntRateTypeExpression(intRateEnum);
            } else {
                info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
            }
        } else {
            info.setIntRateTypeExpression(IntRateTypeExpressionEnum.getEnum(rateType.getRateExpression().getValue()));
        }
        String penAccrualType = (String)this.getData(hsData, "FPenAccrualType");
        if (PenAccrualTypeEnum.getEnum(penAccrualType) != null) {
            info.setPenAccrualType(PenAccrualTypeEnum.getEnum(penAccrualType));
        } else {
            info.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
        }
        BigDecimal penAccrualRate = this.getAmount(ctx, this.getData(hsData, "FPenAccrualRate"));
        info.setPenAccrualRate(penAccrualRate == null ? BigDecimal.ZERO : penAccrualRate);
        String returnWay = ((String)this.getData(hsData, "FReturnWay")).trim();
        if (!("0".equals(returnWay) || "1".equals(returnWay) || "2".equals(returnWay))) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"returnWay_not_valid", (Locale)ctx.getLocale()));
        }
        ReturnWayEnum returnWayEnum = null;
        if (!EmptyUtil.isEmpty((String)returnWay)) {
            int retValue = Integer.parseInt(returnWay);
            returnWayEnum = ReturnWayEnum.getEnum(retValue);
        }
        if (returnWayEnum != null) {
            info.setReturnWay(returnWayEnum);
        } else {
            info.setReturnWay(ReturnWayEnum.AT_TERM_WITH_ORI_AMT);
        }
        String projectNumber = (String)this.getData(hsData, "FProject_number");
        try {
            ProjectInfo project = RecAndPayDataImportUtil.getProjectByNumber((Context)ctx, (String)projectNumber);
            if (project != null) {
                info.setProject(project);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fundFlowItemNumber = (String)this.getData(hsData, "FFundFlowItem_number");
        FundFlowItemInfo fundFlowItem = RecAndPayDataImportUtil2.getFundFlowItemByNumber((String)fundFlowItemNumber, (Context)ctx);
        info.setFundFlowItem(fundFlowItem);
        String accrualAccountNumber = (String)this.getData(hsData, "FAccrualAccount_number");
        if (ivt002) {
            if (EmptyUtil.isEmpty((String)accrualAccountNumber)) throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"ivt002", (Locale)ctx.getLocale()));
            accrualAccount = ChloanDataImportUtil.getInnerAccountByNumber(ctx, accrualAccountNumber);
            info.setAccrualAccount(accrualAccount);
        } else if (!EmptyUtil.isEmpty((String)accrualAccountNumber)) {
            try {
                accrualAccount = ChloanDataImportUtil.getInnerAccountByNumber(ctx, accrualAccountNumber);
                info.setAccrualAccount(accrualAccount);
            }
            catch (Exception accrualAccount2) {
                // empty catch block
            }
        }
        info.setHandler(currentuser);
        info.setCreator(currentuser);
        String assureWay_number = (String)this.getData(hsData, "FAssureWay_number");
        GuaranteeTypeInfo guaranteeType = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)assureWay_number));
        view.setFilter(filter);
        GuaranteeTypeCollection collection = GuaranteeTypeFactory.getLocalInstance((Context)ctx).getGuaranteeTypeCollection(view);
        if (collection.size() > 0) {
            guaranteeType = collection.get(0);
        }
        info.setAssureWay(guaranteeType);
        String feeType_number = (String)this.getData(hsData, "FFeeType_number");
        FeeTypeInfo feeType = RecAndPayDataImportUtil2.getFeeTypeByNumber((Context)ctx, (String)feeType_number);
        info.setFeeType(feeType);
        String guarantyName = (String)this.getData(hsData, "FGuarantyName");
        info.setGuarantyName(guarantyName);
        if (this.isSltImportUpdate()) {
            String number = info.getNumber();
            String companyid = info.getCompany().getId().toString();
            if (!this._getController(ctx).exists("where number = '" + number + "' and company.id = '" + companyid + "'")) {
                throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"no_bill_this_number", (Locale)ctx.getLocale()));
            }
            ChLoanInfo original = (ChLoanInfo)this._getController(ctx).getValue("where number = '" + info.getNumber() + "' and company.id = '" + info.getCompany().getId().toString() + "'");
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("parent", (Object)original.getId().toString()));
            view2.setFilter(filter2);
            this.entryColl = ChLoanEntryFactory.getLocalInstance(ctx).getChLoanEntryCollection(view2);
            info.setContractSeq(original.getContractSeq());
            return info;
        } else {
            this.entryInfo = new ChLoanEntryInfo();
            this.entryInfo.setSeq(1);
            this.entryInfo.setReturnDate(info.getEndDate());
            this.entryInfo.setSchemeReturnAmt(info.getLoanTotalAmt());
            this.entryInfo.setParent(info);
            info.setContractSeq(1);
        }
        return info;
    }

    protected boolean isAgreeMentOrFixedRate(IntRateTypeInfo rateType) {
        return rateType.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=") || rateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        ChLoanInfo info = (ChLoanInfo)coreBaseInfo;
        if (info.getNumber() == null) {
            return;
        }
        String number = info.getNumber();
        String companyid = info.getCompany().getId().toString();
        if (this.isSltImportUpdate()) {
            if (!this._getController(ctx).exists("where number = '" + number + "' and company.id = '" + companyid + "'")) {
                throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"no_bill_this_number", (Locale)ctx.getLocale()));
            }
            ChLoanInfo oldInfo = (ChLoanInfo)this._getController(ctx).getValue("where number = '" + info.getNumber() + "'");
            if (!oldInfo.getBillStatus().equals((Object)IvtBillStatusEnum.SAVE) && !oldInfo.getBillStatus().equals((Object)IvtBillStatusEnum.SUBMIT)) {
                throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"bill_not_allow_update", (Locale)ctx.getLocale()));
            }
            info.setId(oldInfo.getId());
            this._getController(ctx).update((IObjectPK)new ObjectUuidPK(oldInfo.getId()), (CoreBaseInfo)info);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.entryColl)) {
                for (int j = 0; j < this.entryColl.size(); ++j) {
                    ChLoanEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)this.entryColl.get(j));
                }
            }
        } else {
            if (this._getController(ctx).exists("where number = '" + number + "' and company.id = '" + companyid + "'")) {
                throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"bill_number_exists", (Locale)ctx.getLocale()));
            }
            info.setBillStatus(IvtBillStatusEnum.SAVE);
            this._getController(ctx).addnew((CoreBaseInfo)info);
            ChLoanEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)this.entryInfo);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = super.getExportFilterForQuery(ctx);
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fm.ivt.app.ChLoanExportQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String guarantyName;
            String feeTypeNumber;
            String assureWayNumber;
            String handlerNumber;
            String accrualAccountNumber;
            String fundFlowItem;
            String project;
            int returnWay;
            BigDecimal penAccrualRate;
            String intRateTypeExpression;
            Date lastPreIntDate;
            Date lastSettleDate;
            BigDecimal floorAmt;
            String loanAccountViewNumber;
            String rateTypeNumber;
            BigDecimal yearRate;
            BigDecimal floatPoint;
            String distributeAccouNumber;
            int historyBill;
            Date endDate;
            Date startDate;
            BigDecimal localCurExRate;
            BigDecimal balance;
            BigDecimal amount;
            String currency;
            String contractNum;
            String typeNumber;
            String description;
            Date bizDate;
            String loanCompanyNumber;
            String number;
            String bankNumber = this.getString(rs, "bank.number");
            if (bankNumber != null) {
                result.put("ClearingHouse_number", bankNumber);
            }
            if ((number = this.getString(rs, "number")) != null) {
                result.put("FNumber", number);
            }
            if ((loanCompanyNumber = this.getString(rs, "loanCompany.name")) != null) {
                result.put("FLoanCompany_name", loanCompanyNumber);
            }
            if ((bizDate = rs.getDate("bizDate")) != null) {
                result.put("FBizDate", DateTimeUtils.format((java.util.Date)bizDate, (String)"yyyy-MM-dd"));
            }
            if ((description = this.getString(rs, "description")) != null) {
                result.put("FDescription", description);
            }
            if ((typeNumber = this.getString(rs, "finacingProduct.number")) != null) {
                result.put("FFinacingProduct_number", typeNumber);
            }
            if ((contractNum = this.getString(rs, "contractNo")) != null) {
                result.put("FContractNo", contractNum);
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("FCurrency_number", currency);
            }
            if ((amount = rs.getBigDecimal("loanTotalAmt")) != null) {
                result.put("FLoanTotalAmt", amount);
            }
            if ((balance = rs.getBigDecimal("loanBalance")) != null) {
                result.put("FLoanBalance", balance);
            }
            if ((localCurExRate = rs.getBigDecimal("exchangeRate")) != null) {
                result.put("FExchangeRate", localCurExRate);
            }
            if ((startDate = rs.getDate("startDate")) != null) {
                result.put("FStartDate", DateTimeUtils.format((java.util.Date)startDate, (String)"yyyy-MM-dd"));
            }
            if ((endDate = rs.getDate("endDate")) != null) {
                result.put("FEndDate", DateTimeUtils.format((java.util.Date)endDate, (String)"yyyy-MM-dd"));
            }
            if ((historyBill = rs.getInt("isHistoryLoan")) == 0) {
                result.put("FIsHistoryLoan", "false");
            } else if (historyBill == 1) {
                result.put("FIsHistoryLoan", "true");
            }
            String loanAccountNumber = this.getString(rs, "loanAccount.number");
            if (loanAccountNumber != null) {
                result.put("FLoanAccount_number", loanAccountNumber);
            }
            if ((distributeAccouNumber = this.getString(rs, "distributeAccou.number")) != null) {
                result.put("FDistributeAccou_number", distributeAccouNumber);
            }
            if ((floatPoint = rs.getBigDecimal("floatPoint")) != null) {
                result.put("FFloatPoint", floatPoint);
            }
            if ((yearRate = rs.getBigDecimal("yearRate")) != null) {
                result.put("FYearRate", yearRate);
            }
            if ((rateTypeNumber = this.getString(rs, "rateType.number")) != null) {
                result.put("FRateType_number", rateTypeNumber);
            }
            if ((loanAccountViewNumber = this.getString(rs, "loanAccountView.number")) != null) {
                result.put("FLoanAccountView_number", loanAccountViewNumber);
            }
            if ((floorAmt = rs.getBigDecimal("floorAmt")) != null) {
                result.put("FFloorAmt", floorAmt);
            }
            if ((lastSettleDate = rs.getDate("lastSettleDate")) != null) {
                result.put("FLastSettleDate", DateTimeUtils.format((java.util.Date)lastSettleDate, (String)"yyyy-MM-dd"));
            }
            if ((lastPreIntDate = rs.getDate("lastPreIntDate")) != null) {
                result.put("FLastPreIntDate", DateTimeUtils.format((java.util.Date)lastPreIntDate, (String)"yyyy-MM-dd"));
            }
            if ((intRateTypeExpression = this.getString(rs, "intRateTypeExpression")) != null) {
                result.put("FIntRateTypeExpression", intRateTypeExpression);
            }
            int yearDays = rs.getInt("yearDays");
            result.put("FYearDays", yearDays);
            String penAccrualType = this.getString(rs, "penAccrualType");
            if (penAccrualType != null) {
                result.put("FPenAccrualType", penAccrualType);
            }
            if ((penAccrualRate = rs.getBigDecimal("penAccrualRate")) != null) {
                result.put("FPenAccrualRate", penAccrualRate);
            }
            if (ReturnWayEnum.getEnum(returnWay = rs.getInt("returnWay")) != null) {
                result.put("FReturnWay", returnWay);
            }
            if ((project = this.getString(rs, "project.number")) != null) {
                result.put("FProject_number", project);
            }
            if ((fundFlowItem = this.getString(rs, "fundFlowItem.number")) != null) {
                result.put("FFundFlowItem_number", fundFlowItem);
            }
            if ((accrualAccountNumber = this.getString(rs, "accrualAccount.number")) != null) {
                result.put("FAccrualAccount_number", accrualAccountNumber);
            }
            if ((handlerNumber = this.getString(rs, "handler.number")) != null) {
                result.put("FHandler_number", handlerNumber);
            }
            if ((assureWayNumber = this.getString(rs, "assureWay.number")) != null) {
                result.put("FAssureWay_number", assureWayNumber);
            }
            if ((feeTypeNumber = this.getString(rs, "feeType.number")) != null) {
                result.put("FFeeType_number", feeTypeNumber);
            }
            if ((guarantyName = this.getString(rs, "guarantyName")) != null) {
                result.put("FGuarantyName", guarantyName);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    protected String getTemplateNumber() {
        return "Chloan";
    }

    private BigDecimal getYearRate(ChLoanInfo loanInfo, IntRateTypeInfo intType, Context ctx) {
        CurrencyInfo currency = loanInfo.getCurrency();
        BigDecimal yearrate = BigDecimal.valueOf(-1.0);
        try {
            yearrate = this.calcYearRate(intType, loanInfo.getFloatPoint(), currency, loanInfo.getStartDate(), ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return yearrate;
    }

    public BigDecimal calcYearRate(IntRateTypeInfo intType, BigDecimal floating, CurrencyInfo currency, java.util.Date date, Context ctx) throws Exception {
        BigDecimal yearRate = this.getYearRateFromRateTable(date, currency.getId().toString(), intType.getId().toString(), ctx);
        floating = floating.divide(Constants.ONE_HUNDRED, 2, 4);
        BigDecimal tmp = FMHelper.add((BigDecimal)Constants.ONE, (BigDecimal)floating);
        return FMHelper.multiply((BigDecimal)yearRate, (BigDecimal)tmp);
    }

    private BigDecimal getYearRateFromRateTable(java.util.Date endDate, String currencyID, String typeID, Context ctx) throws BOSException, SQLException {
        BigDecimal yearRate = Constants.ZERO;
        String dateStr = FMConstants.FORMAT_TIME.format(endDate);
        StringBuffer sql = new StringBuffer();
        String billState = IntRateStateEnum.AUDITED.getValue();
        sql.append("select top 1 a.fid, a.fyearRate, a.ftypeid, b.ffactor ");
        sql.append("from t_int_IntRateBase as a left outer join t_int_intRateType as b on a.fTypeId = b.fid ");
        sql.append("where a.feffectiveDate <= {" + dateStr + "} and a.fcurrencyid = '" + currencyID + "' and a.ftypeid = '" + typeID + "' and a.fbillState = '" + billState + "' and FIntTermID  is null ");
        sql.append("order by a.feffectiveDate desc");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
        if (rs.next()) {
            yearRate = rs.getBigDecimal(2);
        }
        return yearRate;
    }
}

