/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fm.fin.FinancingProductsCollection;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.im.IntRateTypeCollection;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ChloanDataImportUtil {
    private static Logger logger = Logger.getLogger((String)ChloanDataImportUtil.class.getName());
    private static String resourcePath = "com.kingdee.eas.fm.ivt.CHLoanResource";

    public static BankInfo getClearHouseByNumber(Context ctx, String clearHouseNumber) throws BOSException {
        BankInfo info = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("relatedCompany.*");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("inGroup", (Object)new Boolean(true)));
        if (!EmptyUtil.isEmpty((String)clearHouseNumber)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)clearHouseNumber));
        }
        evi.setFilter(filterInfo);
        BankCollection collection = BankFactory.getLocalInstance((Context)ctx).getBankCollection(evi);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"no_clearHouse", (Locale)ctx.getLocale()));
        }
        info = collection.get(0);
        return info;
    }

    public static CompanyOrgUnitInfo getRelateCompanyByClearHouseNumber(Context ctx, String clearHouseNumber) throws BOSException {
        CompanyOrgUnitInfo company = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("relatedCompany.*");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("inGroup", (Object)new Boolean(true)));
        if (!EmptyUtil.isEmpty((String)clearHouseNumber)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)clearHouseNumber));
        }
        evi.setFilter(filterInfo);
        BankCollection collection = BankFactory.getLocalInstance((Context)ctx).getBankCollection(evi);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"no_clearHouse", (Locale)ctx.getLocale()));
        }
        BankInfo bank = collection.get(0);
        String relatedCompanyId = bank.getRelatedCompany().getId().toString();
        ICompanyOrgUnit iCompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection coll = iCompanyOrg.getCompanyOrgUnitCollection("where id='" + relatedCompanyId.trim() + "'");
        if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"no_relateCompany", (Locale)ctx.getLocale()));
        }
        company = coll.get(0);
        return company;
    }

    public static InnerAccountInfo getInnerAccountByNumber(Context ctx, String innerAccountNumber) throws BOSException {
        InnerAccountInfo info = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("clearHouseId");
        FilterInfo filterInfo = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)innerAccountNumber)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)innerAccountNumber));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        evi.setFilter(filterInfo);
        InnerAccountCollection collection = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountCollection(evi);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"no_inner_account", (Locale)ctx.getLocale()));
        }
        info = collection.get(0);
        return info;
    }

    public static FinancingProductsInfo getFinancingProductByNumber(Context ctx, String financingProductNumber) throws BOSException {
        FinancingProductsInfo info = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        FilterInfo filterInfo = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)financingProductNumber)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)financingProductNumber));
        }
        evi.setFilter(filterInfo);
        FinancingProductsCollection collection = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsCollection(evi);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"no_fin_product", (Locale)ctx.getLocale()));
        }
        info = collection.get(0);
        return info;
    }

    public static IntRateTypeInfo getIntRateTypeByNumber(Context ctx, String intRateTypeNumber) throws BOSException {
        IntRateTypeInfo info = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        FilterInfo filterInfo = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)intRateTypeNumber)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)intRateTypeNumber));
        }
        evi.setFilter(filterInfo);
        IntRateTypeCollection collection = IntRateTypeFactory.getLocalInstance((Context)ctx).getIntRateTypeCollection(evi);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"no_rateType", (Locale)ctx.getLocale()));
        }
        info = collection.get(0);
        return info;
    }
}

