/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.IEntRepaymentBill;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntRepaymentSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.ChLoanSmartFilter");
    private String failMsg = null;

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String operatorNumber = busiInfo.getOperatorNumber();
        String queryOql = "";
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id,number where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("ChLoanSmartFilter============" + iexec.getSQL()));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL());
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"148_LoanInterestSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"149_LoanInterestSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(" ( ").append(filterSql).append(" ) ");
            }
        } else {
            result.append(" ( ").append(filterSql).append(" ) ");
        }
        String operatorNumber = busiInfo.getOperatorNumber();
        if (InterfaceTypeEnum.entrepay_writeback_repay.getName().equals(operatorNumber)) {
            result.append(" and ").append(" BillStatus = 4 ");
            result.append(" and ").append(" loanBillID.isDownLoaded = 1 ");
            result.append(" and ").append(" isDownLoaded = 0 ");
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            String operatorNumber = busiInfo.getOperatorNumber();
            IEntRepaymentBill biz = EntRepaymentBillFactory.getLocalInstance(ctx);
            EntRepaymentBillCollection billColl = this.getBillColl(ctx, billList);
            if (InterfaceTypeEnum.entrepay_writeback_repay.getName().equals(operatorNumber)) {
                HashMap<String, BOTMappingInfo> botMap = new HashMap<String, BOTMappingInfo>();
                BOTMappingInfo botInfo = null;
                IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                for (int i = 0; i < billColl.size(); ++i) {
                    try {
                        EntRepaymentBillInfo billInfo = billColl.get(i);
                        CoreBillBaseCollection srcColl = new CoreBillBaseCollection();
                        srcColl.add((CoreBillBaseInfo)billInfo);
                        if (botMap.containsKey(billInfo.getCompany().getId().toString())) {
                            botInfo = (BOTMappingInfo)botMap.get(billInfo.getCompany().getId().toString());
                        } else {
                            new RepaymentInfo();
                            botInfo = EntRepaymentSmartFilter.getBotMappingInfo(ctx, billInfo.getCU(), billInfo.getBOSType().toString(), RepaymentInfo.BOSTYPE.toString(), botMapping, (CoreBillBaseInfo)billInfo);
                            botMap.put(billInfo.getCompany().getId().toString(), botInfo);
                            logger.error((Object)("\u516c\u53f8+name \uff1a" + billInfo.getCompany().getName() + "\uff0cID\uff1a" + billInfo.getCompany().getId().toString() + "\u5339\u914d\u7684botp\u89c4\u5219\u662f\uff1a" + botInfo.getAlias() + "\uff0c\u89c4\u5219ID\uff1a" + botInfo.getId().toString()));
                        }
                        this.transforBillForRepay(ctx, srcColl, botInfo);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }

    private static BOTMappingInfo getBotMappingInfo(Context ctx, CtrlUnitInfo cu, String srcBosType, String destBosType, IBOTMapping botMapping, CoreBillBaseInfo billInfo) throws BOSException, BOTPException, FMException {
        BOTMappingInfo botMappingInfo;
        if (cu == null) {
            botMappingInfo = botMapping.getMapping(billInfo, destBosType, DefineSysEnum.BTP);
        } else {
            HashMap<String, CtrlUnitInfo> transmitContext = new HashMap<String, CtrlUnitInfo>();
            transmitContext.put("TRANSMITCU", cu);
            BOTMappingCollection btps = botMapping.getMappingCollectionForSelectUseRuleFilter(srcBosType, destBosType, DefineSysEnum.BTP, transmitContext, null, null, null, null);
            if (btps.size() == 0) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"418_ChLoanSmartFilter", (Locale)ctx.getLocale()) + cu.getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"419_ChLoanSmartFilter", (Locale)ctx.getLocale()) + srcBosType + ",destType=" + destBosType});
            }
            botMappingInfo = btps.get(0);
        }
        if (botMappingInfo == null) {
            throw new FMException(FMException.NODESTBILL);
        }
        return botMappingInfo;
    }

    private EntRepaymentBillCollection getBillColl(Context ctx, List billList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("loanBillID.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)billList), CompareType.INCLUDE));
        view.setFilter(filter);
        EntRepaymentBillCollection coll = EntRepaymentBillFactory.getLocalInstance(ctx).getEntRepaymentBillCollection(view);
        return coll;
    }

    public BTPTransformResult transforBillForRepay(Context ctx, CoreBillBaseCollection srcColl, BOTMappingInfo botMapping) throws BOSException, EASBizException {
        Map srcInfoMap = this.getSrcInfoMap(srcColl);
        BTPTransformResult btpResult = null;
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        btpResult = btp.transform(srcColl, botMapping);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelateColl = btpResult.getBOTRelationCollection();
        int size = destBillCols.size();
        for (int i = 0; i < size; ++i) {
            RepaymentInfo repayInfo = (RepaymentInfo)destBillCols.getObject(i);
            EntRepaymentBillInfo entRepayInfo = (EntRepaymentBillInfo)srcInfoMap.get(repayInfo.getEntRepaymentBill().getId().toString());
            ArrayList loanList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(entRepayInfo.getLoanBillID().getId().toString(), new LoanInfo().getBOSType().toString());
            if (!EmptyUtil.isEmpty((Collection)loanList) && loanList.size() > 0) {
                repayInfo.setSourceBillId(loanList.get(0).toString());
            }
            repayInfo.setSourceType(FinancingBillTypeEnum.Loan);
            if (entRepayInfo.isIsRepayWithAccrual()) {
                repayInfo.setIsCalInt(true);
                repayInfo.setIsRepayInt(true);
            }
            if (entRepayInfo.isIsPenaAccrual()) {
                repayInfo.setIsCalInt(true);
                repayInfo.setIsRepayInt(true);
                repayInfo.setIsCalPunishInt(true);
            }
            if (!entRepayInfo.isIsRepayWithAccrual() && !entRepayInfo.isIsPenaAccrual()) {
                repayInfo.setIsCalInt(true);
            }
            repayInfo.setEntRepaymentBill(entRepayInfo);
            if (entRepayInfo.getBank() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("name.*"));
                BankInfo bankInfo = null;
                bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(entRepayInfo.getBank().getId().toString()), sic);
                repayInfo.setCreditor(bankInfo);
            }
            repayInfo.setAddAmount(entRepayInfo.getRepayTotalAmt());
            repayInfo.setPayment(entRepayInfo.getRepayAmt());
            repayInfo.setSourceCurrency(entRepayInfo.getCurrency());
            repayInfo.setSourceCurExRate(repayInfo.getSourceCurExRate() == null ? Constants.ONE : repayInfo.getSourceCurExRate());
            btp.saveRelations((CoreBillBaseInfo)destBillCols.getObject(i), botRelateColl);
        }
        return btpResult;
    }

    private Map getSrcInfoMap(CoreBillBaseCollection srcColl) {
        HashMap<String, CoreBillBaseInfo> srcInfoMap = new HashMap<String, CoreBillBaseInfo>();
        for (int i = 0; i < srcColl.size(); ++i) {
            CoreBillBaseInfo srcInfo = srcColl.get(i);
            srcInfoMap.put(srcInfo.getId().toString(), srcInfo);
        }
        return srcInfoMap;
    }
}

