/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;

public class EntRepaymentSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        EntRepaymentBillInfo entRepaymentBillInfo = this.getEntRepaymentBillInfo(ctx, billId);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        slInfo.setCompany(ChLoanHelper.getInstance().getRelatedCompany(ctx, entRepaymentBillInfo.getBank()));
        slInfo.setApplyUnit(entRepaymentBillInfo.getLoanCompany());
        slInfo.setInnerAccount(entRepaymentBillInfo.getReceiveBankAccount());
        slInfo.setCreditAmount(entRepaymentBillInfo.getRepayAmt());
        slInfo.setDate(entRepaymentBillInfo.getBizDate());
        slInfo.setCurrency(entRepaymentBillInfo.getCurrency());
        slInfo.setExchangeRate(entRepaymentBillInfo.getExchangeRate());
        slInfo.setBillId(BOSUuid.read((String)billId));
        slInfo.setBillNumber(entRepaymentBillInfo.getNumber());
        slInfo.setIsDownLoad(false);
        slInfo.setBookkeeper(entRepaymentBillInfo.getCreator());
        slInfo.setDescription(entRepaymentBillInfo.getDescription());
        slInfo.setBizType(SubsidiaryBillTypeEnum.ENTREPAYBILL);
        coll.add(slInfo);
        if (entRepaymentBillInfo.getLoanInnerAccount() != null) {
            slInfo = new SubsidiaryLedgerInfo();
            slInfo.setCompany(ChLoanHelper.getInstance().getRelatedCompany(ctx, entRepaymentBillInfo.getBank()));
            slInfo.setApplyUnit(entRepaymentBillInfo.getLoanCompany());
            slInfo.setInnerAccount(entRepaymentBillInfo.getLoanInnerAccount());
            slInfo.setDebitAmount(entRepaymentBillInfo.getRepayAmt());
            slInfo.setDate(entRepaymentBillInfo.getBizDate());
            slInfo.setCurrency(entRepaymentBillInfo.getCurrency());
            slInfo.setExchangeRate(entRepaymentBillInfo.getExchangeRate());
            slInfo.setBillId(BOSUuid.read((String)billId));
            slInfo.setBillNumber(entRepaymentBillInfo.getNumber());
            slInfo.setIsDownLoad(false);
            slInfo.setBookkeeper(entRepaymentBillInfo.getCreator());
            slInfo.setDescription(entRepaymentBillInfo.getDescription());
            slInfo.setBizType(SubsidiaryBillTypeEnum.ENTREPAYBILL);
            coll.add(slInfo);
        }
        return coll;
    }

    private EntRepaymentBillInfo getEntRepaymentBillInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return EntRepaymentBillFactory.getLocalInstance(ctx).getEntRepaymentBillInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        return sic;
    }
}

