/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ivt.BillStateEnum;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyInfo;
import com.kingdee.eas.fm.ivt.app.AbstractFinancingAccountApplyControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;

public class FinancingAccountApplyControllerBean
extends AbstractFinancingAccountApplyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.FinancingAccountApplyControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingAccountApplyInfo info = (FinancingAccountApplyInfo)model;
        info.setState(BillStateEnum.SAVED);
        if (info.getCU() == null) {
            info.setCU(info.getCompany().getCU());
        }
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            super.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBillBaseInfo)info);
        }
        return super._save(ctx, model);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        FinancingAccountApplyInfo info = (FinancingAccountApplyInfo)model;
        info.setState(BillStateEnum.SUBMITED);
        if (info.getCU() == null) {
            info.setCU(info.getCompany().getCU());
        }
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            super.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBillBaseInfo)info);
        }
        return super.submit(ctx, model);
    }

    @Override
    protected void _audit(Context ctx, List idList) throws BOSException {
        for (int i = 0; i < idList.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK((String)idList.get(i));
            this.singleAudit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _antiaudit(Context ctx, List idList) throws BOSException {
        for (int i = 0; i < idList.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK((String)idList.get(i));
            this.singleAntiAudit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _batchDelete(Context ctx, List idsList) throws BOSException, EASBizException {
        for (int i = 0; i < idsList.size(); ++i) {
            DbUtil.execute((Context)ctx, (String)"DELETE FROM T_IVT_FinancingAccountApply WHERE FID=?", (Object[])new Object[]{idsList.get(i)});
        }
    }

    @Override
    protected void _batchSubmit(Context ctx, List idsList) throws BOSException, EASBizException {
        for (int i = 0; i < idsList.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK((String)idsList.get(i));
            FinancingAccountApplyInfo info = FinancingAccountApplyFactory.getLocalInstance(ctx).getFinancingAccountApplyInfo((IObjectPK)pk);
            this.submit(ctx, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _singleAntiAudit(Context ctx, IObjectPK pk) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update T_IVT_FinancingAccountApply set FState = 1, FAuditorID = null, FAuditTime = null where FID = ?", (Object[])new Object[]{pk.toString()});
    }

    @Override
    protected void _singleAudit(Context ctx, IObjectPK pk) throws BOSException {
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        DbUtil.execute((Context)ctx, (String)"update T_IVT_FinancingAccountApply set FState = 3, FAuditorID = ?, FAuditTime = ? where FID = ?", (Object[])new Object[]{userID, currTime, pk.toString()});
    }
}

