/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ivt.BillStateEnum;
import com.kingdee.eas.fm.ivt.FinRedeemBookNotifyBuilder;
import com.kingdee.eas.fm.ivt.FinancingAccountException;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemCollection;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.ivt.FinancingStateEnum;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.app.AbstractFinancingRedeemControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class FinancingRedeemControllerBean
extends AbstractFinancingRedeemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.FinancingRedeemControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingRedeemInfo info = (FinancingRedeemInfo)model;
        if (info.getCU() == null) {
            info.setCU(info.getCompany().getCU());
        }
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            super.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBillBaseInfo)info);
        }
        String action = "ADD";
        action = FinancingRedeemFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId())) ? "Submit" : "ADD";
        if (info.getSourceBillId() != null) {
            this.rewriteSrcBill(ctx, info, action);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        FinancingRedeemInfo info = (FinancingRedeemInfo)model;
        if (info.getCU() == null) {
            info.setCU(info.getCompany().getCU());
        }
        info.setState(BillStateEnum.SUBMITED);
        if (FinancingRedeemFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            String action = "Submit";
            if (info.getSourceBillId() != null) {
                this.rewriteSrcBill(ctx, info, action);
            }
        } else {
            String action = "ADD";
            if (info.getSourceBillId() != null) {
                this.rewriteSrcBill(ctx, info, action);
            }
        }
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            super.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBillBaseInfo)info);
        }
        return super.submit(ctx, model);
    }

    private void rewriteSrcBill(Context ctx, FinancingRedeemInfo info, String action) throws EASBizException, BOSException {
        if (action == "ADD") {
            FinancingAccountInfo accountInfo = FinancingAccountFactory.getLocalInstance(ctx).getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId().toString()));
            if (info.getRedeemAmount() == null) {
                throw new FinancingAccountException(FinancingAccountException.REDEEMAMOUNTNOZERO);
            }
            accountInfo.setBalance(accountInfo.getBalance().subtract(info.getRedeemAmount()));
            accountInfo.setChangeDate(info.getRedeemDate());
            if (info.getPracticalWinAmount() != null) {
                accountInfo.setPracticalWinAmount(accountInfo.getPracticalWinAmount().add(info.getPracticalWinAmount()));
            } else {
                try {
                    this.setpracticalWinAmount(accountInfo, info);
                    accountInfo.setPracticalWinLocAmount(accountInfo.getPracticalWinAmount().multiply(info.getExchangeRate()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            accountInfo.setPracticalWinLocAmount(accountInfo.getPracticalWinAmount().multiply(info.getExchangeRate()));
            accountInfo.setSumRedeemAmount(accountInfo.getSumRedeemAmount().add(info.getRedeemAmount()));
            if (accountInfo.getBalance().compareTo(Constants.ZERO) == 0) {
                accountInfo.setState(FinancingStateEnum.CLOSE);
            }
            FinancingAccountFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(accountInfo.getId()), (CoreBaseInfo)accountInfo);
        } else if (action == "Delete") {
            FinancingAccountInfo accountInfo = FinancingAccountFactory.getLocalInstance(ctx).getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId().toString()));
            accountInfo.setBalance(accountInfo.getBalance().add(info.getRedeemAmount()));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SorterItemCollection sc = new SorterItemCollection();
            SorterItemInfo sorterItem = new SorterItemInfo("seq");
            sorterItem.setSortType(SortType.DESCEND);
            sc.add(sorterItem);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getSourceBillId(), CompareType.EQUALS));
            entityViewInfo.setSorter(sc);
            entityViewInfo.setFilter(filter);
            FinancingRedeemCollection collection = FinancingRedeemFactory.getLocalInstance(ctx).getFinancingRedeemCollection(entityViewInfo);
            if (collection.size() > 1) {
                FinancingRedeemInfo redeemInfo = collection.get(1);
                accountInfo.setChangeDate(redeemInfo.getRedeemDate());
            } else {
                accountInfo.setChangeDate(null);
            }
            accountInfo.setPracticalWinAmount(accountInfo.getPracticalWinAmount().subtract(info.getPracticalWinAmount() == null ? new BigDecimal("0") : info.getPracticalWinAmount()));
            accountInfo.setPracticalWinLocAmount(accountInfo.getPracticalWinAmount().multiply(info.getExchangeRate()));
            accountInfo.setSumRedeemAmount(accountInfo.getSumRedeemAmount().subtract(info.getRedeemAmount()));
            if (accountInfo.getState() == FinancingStateEnum.CLOSE) {
                accountInfo.setState(FinancingStateEnum.AUDIT);
            }
            FinancingAccountFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(accountInfo.getId()), (CoreBaseInfo)accountInfo);
        } else if (action == "Submit") {
            FinancingAccountInfo accountInfo = FinancingAccountFactory.getLocalInstance(ctx).getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId().toString()));
            FinancingRedeemInfo redeemInfo = FinancingRedeemFactory.getLocalInstance(ctx).getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
            accountInfo.setBalance(accountInfo.getBalance().add(redeemInfo.getRedeemAmount()).subtract(info.getRedeemAmount()));
            accountInfo.setChangeDate(info.getRedeemDate());
            accountInfo.setPracticalWinAmount(accountInfo.getPracticalWinAmount().subtract(redeemInfo.getPracticalWinAmount()).add(info.getPracticalWinAmount()));
            accountInfo.setPracticalWinLocAmount(accountInfo.getPracticalWinAmount().multiply(info.getExchangeRate()));
            accountInfo.setSumRedeemAmount(accountInfo.getSumRedeemAmount().subtract(redeemInfo.getRedeemAmount()).add(info.getRedeemAmount()));
            if (accountInfo.getBalance().compareTo(Constants.ZERO) == 0) {
                accountInfo.setState(FinancingStateEnum.CLOSE);
            } else {
                accountInfo.setState(FinancingStateEnum.AUDIT);
            }
            FinancingAccountFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(accountInfo.getId()), (CoreBaseInfo)accountInfo);
        }
    }

    private void setpracticalWinAmount(FinancingAccountInfo accountInfo, FinancingRedeemInfo info) throws Exception {
        BigDecimal days = new BigDecimal(accountInfo.getDays());
        BigDecimal practicalWinAmount = Constants.ZERO;
        BigDecimal predictWinAmount = Constants.ZERO;
        BigDecimal predictYield = Constants.ZERO;
        BigDecimal RedeemAmount = Constants.ZERO;
        BigDecimal PracticalYield = Constants.ZERO;
        BigDecimal term = Constants.ZERO;
        Date bigenDate = accountInfo.getBeginDate();
        if (DateUtil.getNextDay((Date)bigenDate).before(info.getBizDate())) {
            term = new BigDecimal(DateUtil.getDiffDays((Date)bigenDate, (Date)info.getBizDate()) - 1);
        }
        if (accountInfo.getPredictYield() != null && accountInfo.getPredictYield().compareTo(Constants.ZERO) != 0) {
            predictYield = accountInfo.getPredictYield();
            PracticalYield = accountInfo.getPredictYield();
        } else {
            predictYield = Constants.ZERO;
            PracticalYield = Constants.ZERO;
        }
        if (days.compareTo(Constants.ZERO) != 0) {
            if (accountInfo.getIntRateTypeExpression() == IntRateTypeExpressionEnum.YEAR) {
                practicalWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{RedeemAmount, PracticalYield, new BigDecimal("100"), days, term});
                info.setPracticalWinAmount(practicalWinAmount);
                predictWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{RedeemAmount, predictYield, new BigDecimal("100"), days, term});
                info.setPredictWinAmount(predictWinAmount);
                info.setPracticalWinLocAmount(practicalWinAmount.multiply(info.getExchangeRate()));
                info.setDifferenceAmount(predictWinAmount.subtract(practicalWinAmount));
            } else {
                practicalWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{RedeemAmount, PracticalYield, new BigDecimal("1000"), days, term});
                predictWinAmount = FinHelper.calcBigDecimalExprs((String)"{0}*({1}/{2})/{3}*{4}", (BigDecimal[])new BigDecimal[]{RedeemAmount, predictYield, new BigDecimal("1000"), days, term});
                info.setPredictWinAmount(predictWinAmount);
                info.setPracticalWinAmount(practicalWinAmount);
                info.setPracticalWinLocAmount(practicalWinAmount.multiply(info.getExchangeRate()));
                info.setDifferenceAmount(predictWinAmount.subtract(practicalWinAmount));
            }
        }
        if (accountInfo.getPredictYield() != null) {
            info.setPredictYield(predictYield);
        }
        if (info.getRedeemAmount() != null) {
            info.setRedeemAmount(info.getRedeemAmount());
            info.setRedeemLocAmount(info.getRedeemAmount().multiply(info.getExchangeRate()));
            info.setRedeemSumAmount(info.getRedeemAmount());
            info.setChargeAmount(Constants.ZERO);
        }
        if (accountInfo.getIntRateTypeExpression() != null) {
            info.setIntRateTypeExpression(accountInfo.getIntRateTypeExpression());
        }
        if (accountInfo.getEndDate() != null) {
            info.setEndDate(accountInfo.getEndDate());
        }
        info.setPracticalYield(PracticalYield);
        info.setRedeemDate(info.getBizDate());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FinancingRedeemInfo info = this.getFinancingRedeemInfo(ctx, pk);
        String action = "Delete";
        if (info.getSourceBillId() != null) {
            this.rewriteSrcBill(ctx, info, action);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _audit(Context ctx, List ids) throws BOSException {
        for (int i = 0; i < ids.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK((String)ids.get(i));
            this.audit4WF(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _antiaudit(Context ctx, List idList) throws BOSException {
        for (int i = 0; i < idList.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK((String)idList.get(i));
            this._antiAudit4WF(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException {
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        DbUtil.execute((Context)ctx, (String)"update T_IVT_FinancingRedeem set FState=3,FAuditorID=?,FAuditTime=? where FID=?", (Object[])new Object[]{userID, currTime, pk.toString()});
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK pk) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update T_IVT_FinancingRedeem set FState=2,FAuditorID=null,FAuditTime=null where FID=?", (Object[])new Object[]{pk.toString()});
    }

    @Override
    protected void _book(Context ctx, List ids) throws BOSException, EASBizException {
        HashSet idSet = new HashSet(ids);
        String[] str = new String[ids.size()];
        FinRedeemBookNotifyBuilder builder = new FinRedeemBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        journalColl = builder.getJournalColl(ctx, idSet);
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
        String lst = FMHelper.Array2String((String[])ids.toArray(str));
        StringBuffer sql = new StringBuffer();
        sql.append("update T_IVT_FinancingRedeem set FIsBook =1");
        sql.append(" where FID in ");
        sql.append(lst);
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _cancelbook(Context ctx, List ids) throws BOSException, EASBizException {
        String[] str = new String[ids.size()];
        String lst = FMHelper.Array2String((String[])ids.toArray(str));
        HashSet idsset = new HashSet(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", idsset, CompareType.INCLUDE));
        JournalFactory.getLocalInstance((Context)ctx).delete(filter);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_IVT_FinancingRedeem set FIsBook =0");
        sql.append(" where FID in ");
        sql.append(lst);
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        int count = sourceBillCollection.size();
        for (int index = 0; index < count; ++index) {
            FinancingRedeemInfo financingRedeemInfo = (FinancingRedeemInfo)sourceBillCollection.getObject(index);
            idSet.add(financingRedeemInfo.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)3, CompareType.EQUALS));
        CoreBillBaseCollection financingRedeemColl = FinancingRedeemFactory.getLocalInstance(ctx).getCoreBillBaseCollection(view);
        int count2 = financingRedeemColl.size();
        for (int index = 0; index < count2; ++index) {
            FinancingRedeemInfo financingRedeemInfo = (FinancingRedeemInfo)financingRedeemColl.get(index);
            if (!financingRedeemInfo.isFiVouchered() && financingRedeemInfo.getState().equals((Object)BillStateEnum.AUDITED)) continue;
            financingRedeemColl.removeObject(index);
        }
        CoreBillBaseCollection sortColls = financingRedeemColl;
        DAPTransformResult result = super._generateVoucher(ctx, (IObjectCollection)sortColls, botMappingPK);
        return result;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            FinancingRedeemInfo info = (FinancingRedeemInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFiVouchered(false);
            } else {
                info.setAccountant((UserInfo)ctx.get((Object)"UserInfo"));
                info.setFiVouchered(true);
            }
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }
}

