/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.fm.im.util.LoanInterestEntryInfo;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.ImChLoanAdjustIntRateCollection;
import com.kingdee.eas.fm.ivt.ImChloanInfo;
import com.kingdee.eas.fm.ivt.ImEntRepayInfo;
import com.kingdee.eas.fm.ivt.ImEntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.LoanInterestBillEntryInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.StrikeEnum;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class IntPreHelper {
    public static IntCalModel getIntCalModel(Date startDate, Date endDate, ChLoanInfo info, ChLoanRateAdjustBillCollection byIDAdj, EntRepaymentBillCollection byIDsRepay, EntRepaymentBillInfo repayInfo) {
        ImChloanInfo iLoanInfo = new ImChloanInfo(info);
        ImChLoanAdjustIntRateCollection iAdjColl = new ImChLoanAdjustIntRateCollection(byIDAdj);
        ImEntRepaymentBillCollection iRepayColl = new ImEntRepaymentBillCollection(byIDsRepay);
        ImEntRepayInfo iRepayInfo = new ImEntRepayInfo(repayInfo);
        IntCalModel model = new IntCalModel();
        model.setIsPrediction(true);
        model.setBeginDate(startDate);
        model.setEndDate(endDate);
        model.setLoanInfo((ILoanInfo)iLoanInfo);
        model.setAdjIntRateColl((IAdjustIntRateCollection)iAdjColl);
        model.setRepayColl((IRepaymentBillCollection)iRepayColl);
        model.setRepayInfo((IRepaymentBillInfo)iRepayInfo);
        if (startDate != null) {
            model.setNewRequirement(true);
        } else {
            model.setNewRequirement(false);
        }
        return model;
    }

    public static LoanInterestBillInfo transfrom(Context ctx, LoanInterestInfo imIntInfo, ChLoanInfo loanInfo, EntRepaymentBillInfo repaymentInfo) {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        LoanInterestBillInfo finIntInfo = new LoanInterestBillInfo();
        LoanInterestEntryCollection imIntCol = imIntInfo.getEntries();
        for (int i = 0; i < imIntCol.size(); ++i) {
            LoanInterestEntryInfo imEntryInfo = imIntCol.get(i);
            LoanInterestBillEntryInfo finEntryInfo = new LoanInterestBillEntryInfo();
            finEntryInfo.setSeq(imEntryInfo.getSeq());
            finEntryInfo.setBeginDate(imEntryInfo.getBeginDate());
            finEntryInfo.setEndDate(imEntryInfo.getEndDate());
            finEntryInfo.setDays(imEntryInfo.getDays());
            finEntryInfo.setAmount(imEntryInfo.getPrincipal());
            finEntryInfo.setYearIntRate(imEntryInfo.getIntRate());
            finEntryInfo.setInterest(imEntryInfo.getInterest());
            finEntryInfo.setYearDays(imEntryInfo.getConvertDays());
            finEntryInfo.setIntRateTypeExpression(IntPreHelper.getIntRateTypeExp(imEntryInfo.getIntRateTypeExp()));
            finEntryInfo.setDaysOverdue(imEntryInfo.getOverdueDays());
            finEntryInfo.setPunishIntRate(imEntryInfo.getPunishIntRate());
            finEntryInfo.setPunishInterest(imEntryInfo.getPunishInterest());
            finIntInfo.getEntrys().add(finEntryInfo);
        }
        finIntInfo.setEntRepaymentBillInfo(repaymentInfo);
        finIntInfo.setLoanCompany(loanInfo.getLoanCompany());
        finIntInfo.setRepayment(repaymentInfo);
        finIntInfo.setLoanInfo(loanInfo);
        finIntInfo.setLoanBill(loanInfo);
        IntPreHelper.setLoanBillInfo(finIntInfo, loanInfo);
        finIntInfo.setIntAccount(loanInfo.getAccrualAccount());
        if (imIntInfo.getIntCalType() == com.kingdee.eas.fm.im.IntCalTypeEnum.REC_INT) {
            finIntInfo.setIntCalType(IntCalTypeEnum.REC_INT);
        } else if (imIntInfo.getIntCalType() == com.kingdee.eas.fm.im.IntCalTypeEnum.PRE_INT) {
            finIntInfo.setIntCalType(IntCalTypeEnum.PRE_INT);
        } else if (imIntInfo.getIntCalType() == com.kingdee.eas.fm.im.IntCalTypeEnum.REPAY_INT) {
            finIntInfo.setIntCalType(IntCalTypeEnum.REPAY_INT);
        }
        finIntInfo.setCompany(loanInfo.getCompany());
        finIntInfo.setCreator(user);
        finIntInfo.setCurrency(imIntInfo.getCurrency());
        finIntInfo.setBank(loanInfo.getBank());
        finIntInfo.setBizDate(imIntInfo.getBizDate());
        finIntInfo.setBeginDate(imIntInfo.getBeginDate());
        finIntInfo.setEndDate(imIntInfo.getEndDate());
        finIntInfo.setDays(imIntInfo.getDays());
        finIntInfo.setAmount(imIntInfo.getPrincipal());
        finIntInfo.setYearIntRate(imIntInfo.getIntRate());
        finIntInfo.setDaysOverdue(imIntInfo.getOverdueDays());
        finIntInfo.setPunishIntType(IntPreHelper.getPunishIntRateType(imIntInfo.getPunishType()));
        finIntInfo.setPunishIntRate(imIntInfo.getPunishIntRate());
        finIntInfo.setPunishInterest(imIntInfo.getPunishInterest());
        finIntInfo.setInterest(imIntInfo.getInterest());
        finIntInfo.setStrikeStatus(StrikeEnum.NULL);
        if (finIntInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            finIntInfo.setStrikeAmount(Constants.ZERO);
        }
        finIntInfo.setFivouchered(false);
        finIntInfo.setInterest(imIntInfo.getInterest());
        finIntInfo.setPunishInterest(imIntInfo.getPunishInterest());
        finIntInfo.setInterestActual(FMHelper.add((BigDecimal)finIntInfo.getInterest(), (BigDecimal)finIntInfo.getPunishInterest()));
        finIntInfo.setInterestAcctual(imIntInfo.getInterestActual());
        finIntInfo.setPunishInterestActual(imIntInfo.getPunishInterestActual());
        finIntInfo.setInterestToPay(FMHelper.add((BigDecimal)finIntInfo.getInterestActual(), (BigDecimal)finIntInfo.getPunishInterestActual()));
        finIntInfo.setIntRateTypeExpression(IntPreHelper.getIntRateTypeExp(imIntInfo.getIntRateTypeExp()));
        finIntInfo.setLastIntDate(imIntInfo.getLastIntDate());
        BOSUuid idBOS = BOSUuid.create((BOSObjectType)finIntInfo.getBOSType());
        finIntInfo.setId(idBOS);
        finIntInfo.setIntAccount(loanInfo.getLoanAccount());
        finIntInfo.setUnVerifyAmount(Constants.ZERO);
        finIntInfo.setImIntInfo(imIntInfo);
        finIntInfo.setIsPrediction(true);
        return finIntInfo;
    }

    public static IntRateTypeExpressionEnum getIntRateTypeExp(com.kingdee.eas.fm.im.IntRateTypeExpressionEnum rateType) {
        if (rateType == com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.YEAR) {
            return IntRateTypeExpressionEnum.YEAR;
        }
        if (rateType == com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.DAY) {
            return IntRateTypeExpressionEnum.DAY;
        }
        if (rateType == com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.MONTH) {
            return IntRateTypeExpressionEnum.MONTH;
        }
        return IntRateTypeExpressionEnum.DAY;
    }

    public static void setLoanBillInfo(LoanInterestBillInfo finIntInfo, ChLoanInfo loanInfo) {
    }

    public static PenAccrualTypeEnum getPunishIntRateType(com.kingdee.eas.fm.im.PenAccrualTypeEnum type) {
        if (type == com.kingdee.eas.fm.im.PenAccrualTypeEnum.ADD_PERCENT) {
            return PenAccrualTypeEnum.ADD_PERCENT;
        }
        if (type == com.kingdee.eas.fm.im.PenAccrualTypeEnum.ADD_ACCRUAL) {
            return PenAccrualTypeEnum.ADD_ACCRUAL;
        }
        return PenAccrualTypeEnum.ADD_ACCRUAL;
    }

    public static Calendar getYearCalendar(Calendar startCalendar, Calendar endCalendar, int settleDay) {
        Calendar yearCalendar = Calendar.getInstance();
        yearCalendar.set(1, startCalendar.get(1));
        yearCalendar.set(2, 11);
        yearCalendar.set(5, settleDay);
        if (yearCalendar.getTime().compareTo(startCalendar.getTime()) <= 0) {
            yearCalendar.add(1, 1);
        }
        if (yearCalendar.getTime().compareTo(startCalendar.getTime()) > 0 && yearCalendar.getTime().compareTo(endCalendar.getTime()) <= 0) {
            return yearCalendar;
        }
        return null;
    }

    public static Calendar getQuarterCalendar(Calendar startCalendar, Calendar endCalendar, int settleDay) {
        Calendar quarterCalendar = Calendar.getInstance();
        quarterCalendar.set(1, startCalendar.get(1));
        quarterCalendar.set(5, settleDay);
        int month = startCalendar.get(2);
        if (month <= 2) {
            quarterCalendar.set(2, 2);
        }
        if (month > 2 && month <= 5) {
            quarterCalendar.set(2, 5);
            if (settleDay == 31) {
                quarterCalendar.set(5, 30);
            }
        }
        if (month > 5 && month <= 8) {
            quarterCalendar.set(2, 8);
            if (settleDay == 31) {
                quarterCalendar.set(5, 30);
            }
        }
        if (month > 8 && month <= 11) {
            quarterCalendar.set(2, 11);
        }
        if (quarterCalendar.getTime().compareTo(startCalendar.getTime()) <= 0) {
            quarterCalendar = IntPreHelper.setTimeOfNextPeriod(quarterCalendar, settleDay, 3);
        }
        if (quarterCalendar.getTime().compareTo(startCalendar.getTime()) > 0 && quarterCalendar.getTime().compareTo(endCalendar.getTime()) <= 0) {
            return quarterCalendar;
        }
        return null;
    }

    public static Calendar getMonthCalendar(Calendar startCalendar, Calendar endCalendar, int settleDay) {
        Calendar monthCalendar = Calendar.getInstance();
        monthCalendar.set(1, startCalendar.get(1));
        monthCalendar.set(2, startCalendar.get(2));
        Calendar nextCalendar = Calendar.getInstance();
        nextCalendar.set(1, startCalendar.get(1));
        nextCalendar.set(2, startCalendar.get(2));
        nextCalendar.add(2, 1);
        nextCalendar.set(5, 1);
        nextCalendar.add(5, -1);
        int curDayCount = nextCalendar.getTime().getDate();
        if (curDayCount < settleDay) {
            settleDay = curDayCount;
        }
        monthCalendar.set(5, settleDay);
        if (monthCalendar.getTime().compareTo(startCalendar.getTime()) <= 0) {
            monthCalendar = IntPreHelper.setTimeOfNextPeriod(monthCalendar, settleDay, 1);
        }
        if (monthCalendar.getTime().compareTo(startCalendar.getTime()) > 0 && monthCalendar.getTime().compareTo(endCalendar.getTime()) <= 0) {
            return monthCalendar;
        }
        return null;
    }

    public static Calendar setTimeOfNextPeriod(Calendar nextCalendar, int flashDay, int periodsMonth) {
        Calendar tmp = nextCalendar;
        if (flashDay == 29 || flashDay == 30 || flashDay == 31) {
            tmp.add(2, periodsMonth);
            int days = DateTimeUtils.daysOfMonth((int)tmp.get(1), (int)(tmp.get(2) + 1));
            if (days >= flashDay) {
                tmp.set(5, flashDay);
            } else {
                tmp.set(5, days);
            }
        } else {
            tmp.add(2, periodsMonth);
        }
        return tmp;
    }
}

