/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AbstractBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.ROMRowSet;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.common.util.TransPrecisionUtil;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.im.IMException;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.fm.im.util.LoanInterestEntryInfo;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillCollection;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillFactory;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanCollection;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillCollection;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillFactory;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.ImChLoanAdjustIntRateCollection;
import com.kingdee.eas.fm.ivt.ImChloanInfo;
import com.kingdee.eas.fm.ivt.ImEntRepayInfo;
import com.kingdee.eas.fm.ivt.ImEntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.IntReverseFacadeFactory;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.LoanIntPartInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillEntryCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillEntryInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestTypeEnum;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.StrikeEnum;
import com.kingdee.eas.fm.ivt.app.AbstractLoanInterestBillControllerBean;
import com.kingdee.eas.fm.ivt.app.ExtDateInfo;
import com.kingdee.eas.fm.ivt.app.LoanInterestBillBookSubsidiaryBookProvider;
import com.kingdee.eas.fm.ivt.app.LoanInterestBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanInterestBillControllerBean
extends AbstractLoanInterestBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.LoanInterestBillControllerBean");
    private Map botpRelationShip = new HashMap();
    private boolean deleteRelated = false;
    private static final int ROUND = 4;
    private boolean isAutoBook = false;

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        LoanInterestBillInfo info = (LoanInterestBillInfo)model;
        this.checkPreIntDate(ctx, info);
        info.setBizDate(DateUtil.getSQLBegin((Date)info.getBizDate()));
        TransPrecisionUtil.trancatePrecision((Context)ctx, (CoreBaseInfo)((CoreBaseInfo)model), (String[])new String[]{"amount", "interest", "punishInterest", "interestActual", "interestToPay", "unVerifyAmount", "strikeAmount", "punishInterestActual", "interestAcctual", "intAccountBalance", "verifyAmount"}, (CurrencyInfo)((CurrencyInfo)model.get("currency")), null);
        IObjectPK pkReturn = super._addnew(ctx, model);
        this._afterLoanInterestBillCreated(ctx, info, pkReturn);
        return pkReturn;
    }

    private void checkPreIntDate(Context ctx, LoanInterestBillInfo intInfo) throws EASBizException, BOSException {
        Date lastPreDate;
        Date startDate;
        if (intInfo.getIntCalType() == IntCalTypeEnum.PRE_INT && (startDate = DateTimeUtils.truncateDate((Date)intInfo.getBeginDate())).compareTo(lastPreDate = this.getLastPreDate(ctx, intInfo)) < 0) {
            throw new CHLoanException(CHLoanException.PREERROR, new Object[]{intInfo.getNumber()});
        }
    }

    private void addNewCheck(Context ctx, LoanInterestBillInfo infoInt) throws EASBizException, BOSException {
        if (!this.checkBalanceEnough(ctx, infoInt)) {
            throw new CHLoanException(CHLoanException.BALANCE_NOT_ENOUGH, new Object[]{infoInt.getIntAccount().getNumber() + "-" + infoInt.getIntAccount().getName()});
        }
    }

    protected void _afterLoanInterestBillCreated(Context ctx, LoanInterestBillInfo infoInt, IObjectPK pkReturn) throws EASBizException, BOSException {
        if (infoInt.getIntCalType().getValue() == 1) {
            this._afterRecIntSave(ctx, infoInt, pkReturn);
        } else if (infoInt.getIntCalType().getValue() == 0) {
            this._afterPreIntSave(ctx, infoInt, pkReturn);
        } else if (infoInt.getIntCalType().getValue() == 2) {
            this.rereSaveAjustBill(ctx, infoInt);
        }
    }

    private void _afterRecIntSave(Context ctx, LoanInterestBillInfo infoInt, IObjectPK pkReturn) throws EASBizException, BOSException {
        this._saveBOTPRelationShip(ctx, infoInt, pkReturn);
        this._action1(ctx, infoInt);
        IntReverseFacadeFactory.getLocalInstance(ctx).reverseAfterRecInt(infoInt);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ((LoanInterestBillInfo)model).setBillStatus(IvtBillStatusEnum.SAVE);
        IObjectPK pkReturn = super._save(ctx, model);
        if (((LoanInterestBillInfo)model).getIntCalType() != IntCalTypeEnum.PRE_INT && ((LoanInterestBillInfo)model).getIntCalType() != IntCalTypeEnum.REC_INT) {
            this.updateFpItem(ctx, pkReturn);
        }
        return pkReturn;
    }

    protected void doExecuteByVanke(Context ctx, LoanInterestBillInfo intInfo, IObjectPK pk) {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LoanInterestBillInfo intInfo = (LoanInterestBillInfo)model;
        ChLoanInfo chloanInfo = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(intInfo.getLoanBill().getId()));
        intInfo.setBank(chloanInfo.getBank());
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((LoanInterestBillInfo)model));
        this.submitCheck(ctx, intInfo);
        intInfo.setBillStatus(IvtBillStatusEnum.SUBMIT);
        if (!intInfo.isIsPrediction()) {
            intInfo.setIsPrediction(false);
        }
        if (!intInfo.isIsCancel()) {
            intInfo.setIsCancel(false);
        }
        if (!intInfo.isHasEffected()) {
            intInfo.setHasEffected(false);
        }
        IObjectPK pk = super._submit(ctx, model);
        LoanInterestBillInfo bgLoanInterestBillInfo = this.getLoanInterestBillInfo(ctx, "select * where id='" + pk.toString() + "'");
        if (bgLoanInterestBillInfo.getIntCalType() != IntCalTypeEnum.PRE_INT) {
            FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)bgLoanInterestBillInfo);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("intAccount.company.id"));
        sic.add(new SelectorItemInfo("intAccount.id"));
        sic.add(new SelectorItemInfo("loanBill.isHistoryLoan"));
        sic.add(new SelectorItemInfo("loanBill.lastPreIntDate"));
        LoanInterestBillInfo loanInterestBillInfo = this.getLoanInterestBillInfo(ctx, pk, sic);
        loanInterestBillInfo.setEntRepaymentBillInfo(intInfo.getEntRepaymentBillInfo());
        loanInterestBillInfo.setEntRepaymentBillInfo(intInfo.getEntRepaymentBillInfo());
        this.doExecuteByVanke(ctx, intInfo, pk);
        this._afterSubmit(ctx, loanInterestBillInfo, pk);
        if (!loanInterestBillInfo.getLoanBill().isIsHistoryLoan() && bgLoanInterestBillInfo.getIntCalType() != IntCalTypeEnum.PRE_INT) {
            this.updateFpItem(ctx, pk);
        }
        if (loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            if (IvtModualUtils.getSysParam((Context)ctx, (String)"IVT003") || this.isAutoBook) {
                loanInterestBillInfo.setBillStatus(IvtBillStatusEnum.SUBMIT);
                LoanInterestBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanInterestBillInfo.getId().toString()), (CoreBaseInfo)loanInterestBillInfo);
            }
        } else if (IvtModualUtils.getSysParam((Context)ctx, (String)"IVT003") || this.isAutoBook) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(AccessHelper.getId((Object)model));
            this.book(ctx, hashSet);
        }
        return pk;
    }

    private void submitCheck(Context ctx, LoanInterestBillInfo intInfo) throws EASBizException, BOSException {
        Date lastPreDate;
        Date startDate;
        if (intInfo.getIntCalType() == IntCalTypeEnum.PRE_INT && IvtBillStatusEnum.SAVE.equals((Object)intInfo.getBillStatus()) && (startDate = DateTimeUtils.truncateDate((Date)intInfo.getBeginDate())).compareTo(lastPreDate = this.getLastPreDate(ctx, intInfo)) < 0) {
            throw new CHLoanException(CHLoanException.PREERROR, new Object[]{intInfo.getNumber()});
        }
    }

    private Date getLastPreDate(Context ctx, LoanInterestBillInfo intInfo) throws EASBizException, BOSException {
        Date lastRec;
        ChLoanInfo info = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(intInfo.getLoanBill().getId().toString()));
        if (info.getLastPreIntDate() == null && info.getLastSettleDate() == null) {
            return info.getStartDate();
        }
        if (info.getLastPreIntDate() == null && info.getLastSettleDate() != null) {
            return info.getLastSettleDate();
        }
        if (info.getLastPreIntDate() != null && info.getLastSettleDate() == null) {
            return info.getLastPreIntDate();
        }
        Date lastPre = info.getLastPreIntDate();
        if (lastPre.compareTo(lastRec = info.getLastSettleDate()) >= 0) {
            return lastPre;
        }
        return lastRec;
    }

    protected void updateFpItem(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
    }

    private void _afterSubmit(Context ctx, LoanInterestBillInfo loanInterestBillInfo, IObjectPK pk) throws EASBizException, BOSException {
        if (loanInterestBillInfo.getIntCalType().getValue() == 1) {
            this._afterRecIntSubmit(ctx, loanInterestBillInfo, pk);
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 0) {
            this._afterPreIntSubmit(ctx, loanInterestBillInfo, pk);
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 2) {
            this._afterRepaySubmit(ctx, loanInterestBillInfo, pk);
        }
    }

    private void _afterRepaySubmit(Context ctx, LoanInterestBillInfo loanInterestBillInfo, IObjectPK pk) throws EASBizException, BOSException {
        this._saveRepayBill(loanInterestBillInfo, ctx, pk);
        this._action3(ctx, loanInterestBillInfo, pk);
        if (loanInterestBillInfo.getEntRepaymentBillInfo() != null && loanInterestBillInfo.getEntRepaymentBillInfo().getRepayTotalAmt().compareTo(loanInterestBillInfo.getEntRepaymentBillInfo().getChLoanInfo().getLoanTotalAmt()) == 0) {
            this._action1(ctx, loanInterestBillInfo);
        }
    }

    private void _saveRepayBill(LoanInterestBillInfo infoInt, Context ctx, IObjectPK pkReturn) throws EASBizException, BOSException {
        if (infoInt.getEntRepaymentBillInfo() != null) {
            this._saveRepaymentBill(ctx, infoInt, infoInt.getEntRepaymentBillInfo());
            this._saveBOTPRelationShip(ctx, infoInt, pkReturn);
            if (infoInt.getEntRepaymentBillInfo().getRepayTotalAmt().compareTo(infoInt.getEntRepaymentBillInfo().getChLoanInfo().getLoanTotalAmt()) == 0) {
                IntReverseFacadeFactory.getLocalInstance(ctx).reverseAfterRecInt(infoInt);
            }
        }
    }

    private void _afterPreIntSubmit(Context ctx, LoanInterestBillInfo loanInterestBillInfo, IObjectPK pk) throws EASBizException, BOSException {
        IntReverseFacadeFactory.getLocalInstance(ctx).reverseAfterPreInt(loanInterestBillInfo);
    }

    private void _afterPreIntSave(Context ctx, LoanInterestBillInfo loanInterestBillInfo, IObjectPK pk) throws EASBizException, BOSException {
        this._saveBOTPRelationShip(ctx, loanInterestBillInfo, pk);
        this.rereSaveAjustBill(ctx, loanInterestBillInfo);
    }

    protected void rereSaveAjustBill(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws BOSException {
        LoanInterestInfo imIntInfo = loanInterestBillInfo.getImIntInfo();
        if (imIntInfo != null) {
            LoanInterestEntryCollection iCol = imIntInfo.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                this._saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), loanInterestBillInfo);
            }
        }
    }

    private void _saveBOTPRelationShipLoanAdjust(Context ctx, String ajustId, LoanInterestBillInfo infoInt) throws BOSException {
        String sql = " update T_IVT_ChLoanRateAdjustBill set FIsUsed = 1 where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ajustId});
        this.botpRelationShip.clear();
        this.botpRelationShip.put(ajustId, infoInt.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
    }

    private void _afterRecIntSubmit(Context ctx, LoanInterestBillInfo loanInterestBillInfo, IObjectPK pk) throws EASBizException, BOSException {
        this._action3(ctx, loanInterestBillInfo, pk);
    }

    private void _action3(Context ctx, LoanInterestBillInfo loanInterestBillInfo, IObjectPK pk) throws EASBizException, BOSException {
        this.doBook(ctx, loanInterestBillInfo, pk);
    }

    private void doBook(Context ctx, LoanInterestBillInfo loanInterestBillInfo, IObjectPK pk) throws EASBizException, BOSException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            LoanInterestBillInfo info = (LoanInterestBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private BigDecimal getAccountBalance(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        Date unSettleDate = this.getClearingHouse(ctx, loanInterestBillInfo).getSettleDate();
        String companyNumber = this.getClearingHouseNUmber(ctx, loanInterestBillInfo);
        String accountNumber = this.getAccountNumber(ctx, loanInterestBillInfo.getIntAccount().getId());
        CurrencyInfo info = this.getCurrencyNumber(ctx, loanInterestBillInfo.getCurrency().getId());
        BigDecimal balance = InAcctFactory.getLocalInstance((Context)ctx).inAcct(companyNumber, accountNumber, info.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(info.getPrecision(), 4);
        return balance;
    }

    private String getClearingHouseNUmber(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        BOSUuid companyID = loanInterestBillInfo.getIntAccount().getCompany().getId();
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        if (chCompany == null) {
            throw new CHLoanException(CHLoanException.FETCH_CLEARING_ERROR);
        }
        String companyNumber = chCompany.getNumber();
        return companyNumber;
    }

    private CurrencyInfo getCurrencyNumber(Context ctx, BOSUuid id) throws EASBizException, BOSException {
        CurrencyInfo info = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        return info;
    }

    private String getAccountNumber(Context ctx, BOSUuid id) throws EASBizException, BOSException {
        InnerAccountInfo info = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(id));
        return info.getNumber();
    }

    private AbstractBankInfo getClearingHouse(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        ChLoanInfo chloanInfo = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(loanInterestBillInfo.getLoanBill().getId()));
        CompanyOrgUnitInfo curent = chloanInfo.getCompany();
        BankInfo clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(curent.getId().toString());
        return clearingHouse;
    }

    private void action2(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        String billId = loanInterestBillInfo.getId().toString();
        BigDecimal balance = this.getAccountBalance(ctx, loanInterestBillInfo);
        InnerAccountInfo innerAccountInfo = loanInterestBillInfo.getIntAccount();
        String innerAccountID = innerAccountInfo.getId().toString();
        innerAccountInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
        AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
        accountMgrStrategyInfo = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
        OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT)) {
            balance = FMHelper.add((BigDecimal)balance, (BigDecimal)accountMgrStrategyInfo.getOverDraftAmount());
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE)) {
            balance = FMHelper.subtract((BigDecimal)balance, (BigDecimal)accountMgrStrategyInfo.getLowestBalance());
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            balance = Constants.MAX_VALUE;
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            // empty if block
        }
        BigDecimal unVerifyAmount = Constants.ZERO;
        String sql = "update t_ivt_loaninterestbill set funVerifyAmount = ? where fid = ?";
        if (balance.compareTo(loanInterestBillInfo.getInterestActual()) >= 0) {
            unVerifyAmount = Constants.ZERO;
        } else if (balance.compareTo(Constants.ZERO) > 0 && balance.compareTo(loanInterestBillInfo.getInterestActual()) < 0) {
            unVerifyAmount = loanInterestBillInfo.getInterestActual().subtract(balance);
        } else if (balance.compareTo(Constants.ZERO) < 0) {
            unVerifyAmount = loanInterestBillInfo.getInterestActual();
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{unVerifyAmount, loanInterestBillInfo.getId().toString()});
        BigDecimal maxPayAmount = Constants.ZERO;
        BigDecimal amount = Constants.ZERO;
        amount = loanInterestBillInfo.getInterestAcctual().add(loanInterestBillInfo.getPunishInterestActual());
        SubsidiaryLedgerInfo subInfo = NTBookHelper.getLastBookSubsidiaryLedgerInfo((Context)ctx, (String)billId);
        maxPayAmount = balance;
        if (maxPayAmount.compareTo(Constants.ZERO) <= 0) {
            loanInterestBillInfo.setUnVerifyAmount(loanInterestBillInfo.getInterestAcctual().add(loanInterestBillInfo.getPunishInterestActual()));
            loanInterestBillInfo.setBillStatus(IvtBillStatusEnum.BOOK);
            loanInterestBillInfo.setVerifyAmount(loanInterestBillInfo.getInterestAcctual().add(loanInterestBillInfo.getPunishInterestActual()).subtract(loanInterestBillInfo.getUnVerifyAmount()));
            LoanInterestBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanInterestBillInfo.getId().toString()), (CoreBaseInfo)loanInterestBillInfo);
        } else if (maxPayAmount.compareTo(amount) >= 0) {
            loanInterestBillInfo.setUnVerifyAmount(Constants.ZERO);
            loanInterestBillInfo.setVerifyAmount(loanInterestBillInfo.getInterestAcctual().add(loanInterestBillInfo.getPunishInterestActual()).subtract(loanInterestBillInfo.getUnVerifyAmount()));
            LoanInterestBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanInterestBillInfo.getId().toString()), (CoreBaseInfo)loanInterestBillInfo);
            if (Constants.ZERO.compareTo(amount) != 0) {
                SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(billId, LoanInterestBillBookSubsidiaryBookProvider.class.getName());
            }
        } else if (maxPayAmount.compareTo(amount) < 0) {
            loanInterestBillInfo.setUnVerifyAmount(amount.subtract(maxPayAmount));
            loanInterestBillInfo.setVerifyAmount(loanInterestBillInfo.getInterestAcctual().add(loanInterestBillInfo.getPunishInterestActual()).subtract(loanInterestBillInfo.getUnVerifyAmount()));
            LoanInterestBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanInterestBillInfo.getId().toString()), (CoreBaseInfo)loanInterestBillInfo);
            if (Constants.ZERO.compareTo(amount) != 0) {
                SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(billId, LoanInterestBillBookSubsidiaryBookProvider.class.getName());
            }
        }
    }

    private SelectorItemCollection getAccountMgrStrategySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("overdraftCtrl");
        sic.add("overDraftAmount");
        sic.add("lowestBalance");
        sic.add("remind");
        return sic;
    }

    private void _action1(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        BigDecimal sumAmt = this.getSumAmt(ctx, loanInterestBillInfo);
        String sqlUpdate = "update t_ivt_loaninterestbill set FStrikeAmount = ? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{sumAmt, loanInterestBillInfo.getId().toString()});
        SQLUtil sql1 = new SQLUtil();
        sql1.appendSql("update t_ivt_loaninterestbill set FStrikeStatus=?,FPayInterestBillId=?  ");
        sql1.appendSql("where  FEndDate<=?  and fintCalType=0 and floanbillid = ? and fbillstatus <>1 and (FStrikeStatus=? or FStrikeStatus is null) ");
        sql1.addParams(new Object[]{"striked", loanInterestBillInfo.getId().toString(), new java.sql.Date(loanInterestBillInfo.getEndDate().getTime()), loanInterestBillInfo.getLoanBill().getId().toString(), "null"});
        sql1.execute(ctx);
        this.rereSaveAjustBill(ctx, loanInterestBillInfo);
    }

    private BigDecimal getSumAmt(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        BigDecimal returnValue = Constants.ZERO;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select sum(FInterestAcctual+FPunishInterestActual) from t_ivt_loaninterestbill  ");
        sqlBuffer.append("where fintCalType=0 and ");
        sqlBuffer.append(" FEndDate<=? and floanbillid = ? and (fbillstatus<>1) and (FStrikeStatus=? or FStrikeStatus is null)");
        Object[] param = new Object[]{new java.sql.Date(loanInterestBillInfo.getEndDate().getTime()), loanInterestBillInfo.getLoanBill().getId().toString(), "null"};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])param);
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }

    private void _saveBOTPRelationShip(Context ctx, LoanInterestBillInfo infoInt, IObjectPK pkReturn) throws BOSException {
        this.botpRelationShip.clear();
        this.botpRelationShip.put(infoInt.getLoanBill().getId().toString(), pkReturn.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        if (infoInt.getEntRepaymentBillInfo() != null) {
            this.botpRelationShip.clear();
            this.botpRelationShip.put(infoInt.getEntRepaymentBillInfo().getId().toString(), pkReturn.toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        }
    }

    private void _saveRepaymentBill(Context ctx, LoanInterestBillInfo infoInt, EntRepaymentBillInfo entRepaymentBillInfo) throws EASBizException, BOSException {
        entRepaymentBillInfo.setPenaAmt(infoInt.getPunishInterestActual());
        entRepaymentBillInfo.setIntAmt(infoInt.getInterestAcctual());
        entRepaymentBillInfo.setReceAmt(entRepaymentBillInfo.getIntAmt().add(entRepaymentBillInfo.getPenaAmt()));
        EntRepaymentBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)entRepaymentBillInfo);
    }

    @Override
    protected BigDecimal _getUnVerifyAmount(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        BigDecimal balance = this.getAccountBalance(ctx, loanInterestBillInfo);
        if (balance.compareTo(Constants.ZERO) < 0) {
            return loanInterestBillInfo.getInterestActual();
        }
        BigDecimal returnValue = loanInterestBillInfo.getInterestActual().subtract(balance);
        return returnValue.compareTo(Constants.ZERO) > 0 ? returnValue : Constants.ZERO;
    }

    @Override
    protected BigDecimal _getStrikeAmount(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        StringBuffer sbSQL = new StringBuffer();
        BigDecimal returnValue = Constants.ZERO;
        sbSQL.append("select sum(finterestactual) from t_ivt_loaninterestbill ");
        sbSQL.append("where FEndDate<?  and fintCalType=0 and  FStrikeStatus=? and floanbillid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{new java.sql.Date(loanInterestBillInfo.getEndDate().getTime()), "null", loanInterestBillInfo.getLoanBill().getId().toString()});
        try {
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }

    @Override
    protected void _batchSubmit(Context ctx, Set setIDs) throws BOSException, EASBizException {
        this._batchSubmit4Log(ctx, this.set2PKArray(setIDs));
    }

    @Override
    protected void _batchSubmit4Log(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        Set setIDs = this.PKArray2Set(pks);
        String intBillId2 = "";
        LoanInterestBillInfo info = null;
        for (String intBillId2 : setIDs) {
            info = this.getLoanInterestBillInfo(ctx, (IObjectPK)new ObjectUuidPK(intBillId2));
            super.submit(ctx, (CoreBaseInfo)info);
        }
    }

    private List getAllExtDate(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fchloanid,fbeforeexdate from t_ivt_chloanextendbill where  fextendseq = 1");
        ArrayList<ExtDateInfo> li = new ArrayList<ExtDateInfo>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            Date firstExpDateBeforeExt = new Date();
            ExtDateInfo info = null;
            while (rs.next()) {
                String id = rs.getString(1);
                java.sql.Date d = rs.getDate(2);
                firstExpDateBeforeExt = d != null ? DateTimeUtils.truncateDate((Date)new Date(d.getTime())) : null;
                info = new ExtDateInfo(id, firstExpDateBeforeExt);
                li.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return li;
    }

    @Override
    protected LoanInterestBillInfo _calInt(Context ctx, Date startDate, Date endDate, EntRepaymentBillInfo entRepaymentBillInfo) throws BOSException, EASBizException {
        String loanid = entRepaymentBillInfo.getLoanBillID().getId().toString();
        HashSet<String> loanBillIDSet = new HashSet<String>();
        loanBillIDSet.add(loanid);
        ChLoanRateAdjustBillCollection chloanAdjCol = this.getLoanRateAjustColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection repayColl = this.getRepayColl(ctx, loanBillIDSet);
        ChLoanCollection chloanColl = this.getLoanColl(ctx, loanBillIDSet);
        Object byIDsExt = null;
        EntRepaymentBillCollection byIDsRepay = null;
        ChLoanRateAdjustBillCollection byIDAdj = null;
        ChLoanInfo info = null;
        byIDsRepay = this.filterRepayByID(repayColl, loanid);
        info = this.filterChLoanInfoByID(chloanColl, loanid);
        byIDAdj = this.filterAdjByID(chloanAdjCol, loanid);
        IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDAdj, byIDsRepay, entRepaymentBillInfo);
        LoanInterestInfo imIntInfo = AbstractIntCalStragety.getInstance((com.kingdee.eas.fm.im.IntCalTypeEnum)com.kingdee.eas.fm.im.IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
        LoanInterestBillInfo loanInterestBillInfo = this.transfrom(ctx, imIntInfo, info, entRepaymentBillInfo);
        return loanInterestBillInfo;
    }

    private IObjectPK[] set2PKArray(Set ids) {
        IObjectPK[] pks = new IObjectPK[ids.size()];
        int index = 0;
        for (String pkValue : ids) {
            pks[index] = new ObjectUuidPK(pkValue);
            ++index;
        }
        return pks;
    }

    protected Set PKArray2Set(IObjectPK[] pks) {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            IObjectPK objectPK = pks[i];
            ids.add(objectPK.toString());
        }
        return ids;
    }

    @Override
    protected Map _batchPreInt(Context ctx, Set loanBillIDSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        return this._batchPreInt4Log(ctx, this.set2PKArray(loanBillIDSet), startDate, endDate);
    }

    @Override
    protected Map _batchPreInt4Log(Context ctx, IObjectPK[] pks, Date startDate, Date endDate) throws BOSException, EASBizException {
        StringBuffer sbLog = new StringBuffer();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        LoanInterestBillInfo loanInterestBillInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        String loanid2 = "";
        StringBuffer sb = new StringBuffer();
        Set loanBillIDSet = this.PKArray2Set(pks);
        ChLoanRateAdjustBillCollection chloanAdjCol = this.getLoanRateAjustColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection repayColl = this.getRepayColl(ctx, loanBillIDSet);
        ChLoanCollection chloanColl = this.getLoanColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection byIDsRepay = null;
        ChLoanInfo info = null;
        ChLoanRateAdjustBillCollection byIDAdj = null;
        for (String loanid2 : loanBillIDSet) {
            byIDsRepay = this.filterRepayByID(repayColl, loanid2);
            byIDAdj = this.filterAdjByID(chloanAdjCol, loanid2);
            info = this.filterChLoanInfoByID(chloanColl, loanid2);
            loanInterestBillInfo = null;
            IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDAdj, byIDsRepay, null);
            LoanInterestInfo imIntInfo = AbstractIntCalStragety.getInstance((com.kingdee.eas.fm.im.IntCalTypeEnum)com.kingdee.eas.fm.im.IntCalTypeEnum.PRE_INT).calInt(ctx, model);
            loanInterestBillInfo = this.transfrom(ctx, imIntInfo, info, null);
            IObjectPK pk = super.submit(ctx, (CoreBaseInfo)loanInterestBillInfo);
            sbLog.append(loanInterestBillInfo.getNumber()).append(" | ");
            createdIntReceivedID.add(pk);
        }
        hm.put("createdID", createdIntReceivedID);
        if (sb.length() > 0) {
            String msg = EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"errorHeader", (Locale)ctx.getLocale()) + sb.toString();
            hm.put("failureMsg", msg);
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"8_LoanInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new LoanInterestBillInfo().getBOSType(), null, (String)sbLog.toString(), (String)"chloan_insterest_preint");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return hm;
    }

    @Override
    protected Map _batchRecInt4Log(Context ctx, IObjectPK[] pks, Date startDate, Date endDate) throws BOSException, EASBizException {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        LoanInterestBillInfo loanInterestBillInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        StringBuffer sb = new StringBuffer();
        Set loanBillIDSet = this.PKArray2Set(pks);
        ChLoanRateAdjustBillCollection chloanAdjCol = this.getLoanRateAjustColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection repayColl = this.getRepayColl(ctx, loanBillIDSet);
        ChLoanCollection chloanColl = this.getLoanColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection byIDsRepay = null;
        ChLoanRateAdjustBillCollection byIDAdj = null;
        ChLoanInfo info = null;
        for (String loanid : loanBillIDSet) {
            byIDsRepay = this.filterRepayByID(repayColl, loanid);
            byIDAdj = this.filterAdjByID(chloanAdjCol, loanid);
            info = this.filterChLoanInfoByID(chloanColl, loanid);
            loanInterestBillInfo = null;
            IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDAdj, byIDsRepay, null);
            LoanInterestInfo imIntInfo = AbstractIntCalStragety.getInstance((com.kingdee.eas.fm.im.IntCalTypeEnum)com.kingdee.eas.fm.im.IntCalTypeEnum.REC_INT).calInt(ctx, model);
            loanInterestBillInfo = this.transfrom(ctx, imIntInfo, info, null);
            IObjectPK pk = this._addnew(ctx, (IObjectValue)loanInterestBillInfo);
            createdIntReceivedID.add(pk);
        }
        hm.put("createdID", createdIntReceivedID);
        if (sb.length() > 0) {
            String msg = EASCommonResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"errorHeaderRec", (Locale)ctx.getLocale()) + sb.toString();
            hm.put("failureMsg", msg);
        }
        return hm;
    }

    @Override
    protected Map _batchRecInt(Context ctx, Set loanBillIDSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        return this._batchRecInt4Log(ctx, this.set2PKArray(loanBillIDSet), startDate, endDate);
    }

    protected ChLoanInfo filterChLoanInfoByID(ChLoanCollection chloanColl, String loanid) {
        ChLoanInfo info = null;
        for (int i = 0; i < chloanColl.size() && !(info = chloanColl.get(i)).getId().toString().equals(loanid); ++i) {
        }
        return info;
    }

    protected ChLoanCollection getLoanColl(Context ctx, Set loanBillIDSet) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)loanBillIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("company.number"));
        evi.getSelector().add(new SelectorItemInfo("loanCompany.*"));
        evi.getSelector().add(new SelectorItemInfo("loanAccount.applyUnit.*"));
        evi.getSelector().add(new SelectorItemInfo("loanAccount.company.id"));
        evi.getSelector().add(new SelectorItemInfo("loanAccount.name"));
        evi.getSelector().add(new SelectorItemInfo("loanAccount.number"));
        evi.getSelector().add(new SelectorItemInfo("currency.id"));
        evi.getSelector().add(new SelectorItemInfo("currency.name"));
        evi.getSelector().add(new SelectorItemInfo("currency.number"));
        evi.getSelector().add(new SelectorItemInfo("currency.precision"));
        evi.setFilter(filter);
        return ChLoanFactory.getLocalInstance(ctx).getChLoanCollection(evi);
    }

    private CHLoanExtendBillCollection getLoanExColl(Context ctx, Set loanBillIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("chLoan.id", (Object)loanBillIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("beforeExDate"));
        return CHLoanExtendBillFactory.getLocalInstance(ctx).getCHLoanExtendBillCollection(evi);
    }

    protected EntRepaymentBillCollection filterRepayByID(EntRepaymentBillCollection repayColl, String loanid) {
        EntRepaymentBillCollection returnCol = new EntRepaymentBillCollection();
        EntRepaymentBillInfo tmp = null;
        for (int i = 0; i < repayColl.size(); ++i) {
            tmp = repayColl.get(i);
            if (!tmp.getLoanBillID().getId().toString().equals(loanid)) continue;
            returnCol.add(tmp);
        }
        return returnCol;
    }

    protected EntRepaymentBillCollection getRepayColl(Context ctx, Set loanBillIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loanBillID.id", (Object)loanBillIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("repayDate"));
        return EntRepaymentBillFactory.getLocalInstance(ctx).getEntRepaymentBillCollection(evi);
    }

    private CHLoanExtendBillCollection filterExtByID(CHLoanExtendBillCollection loanExColl, String loanid) {
        CHLoanExtendBillCollection returnCol = new CHLoanExtendBillCollection();
        CHLoanExtendBillInfo tmp = null;
        for (int i = 0; i < loanExColl.size(); ++i) {
            tmp = loanExColl.get(i);
            if (!tmp.getChLoan().getId().toString().equals(loanid)) continue;
            returnCol.add(tmp);
        }
        return returnCol;
    }

    @Override
    protected List _getInteretBillByChLoanBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select fintcaltype,fenddate from t_ivt_loaninterestbill where floanbillid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        ArrayList<LoanIntPartInfo> returnLi = new ArrayList<LoanIntPartInfo>();
        LoanIntPartInfo loanIntPartInfo = null;
        try {
            while (rs.next()) {
                loanIntPartInfo = new LoanIntPartInfo(rs.getInt(1), rs.getDate(2));
                returnLi.add(loanIntPartInfo);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(EASBizException.DBDEADLOCK);
        }
        return returnLi;
    }

    @Override
    protected void _checkSeq(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInterestBillInfo loanInterestBillInfo = this.getLoanInterestBillInfo(ctx, pk);
        this._deleteCheck(ctx, loanInterestBillInfo);
        this._afterDelete(ctx, loanInterestBillInfo);
        Map relMap = this.getAdjustRelation(ctx, loanInterestBillInfo);
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        this.updateAdjust(ctx, loanInterestBillInfo, relMap);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)loanInterestBillInfo, (String)loanInterestBillInfo.getCompany().getId().toString());
    }

    private void updateAdjust(Context ctx, LoanInterestBillInfo loanInterestInfo, Map relMap) throws BOSException, EASBizException {
        String sql1 = " select FID from t_bot_relation where FSrcObjectID = ? and FSrcEntityID =? ";
        int number = (Integer)relMap.get("number");
        Connection cn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        cn = this.getConnection(ctx);
        try {
            for (int i = 1; i <= number; ++i) {
                String srcObjectID = relMap.get("srcObjectID" + i).toString();
                String srcEntityID = relMap.get("srcEntityID" + i).toString();
                String fid = null;
                if (pstmt != null) {
                    pstmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                pstmt = cn.prepareStatement(sql1);
                pstmt.setString(1, srcObjectID);
                pstmt.setString(2, srcEntityID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    fid = rs.getString(1);
                }
                if (fid != null) continue;
                String sql2 = " update T_IVT_ChLoanRateAdjustBill set FIsUsed = 0 where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{srcObjectID});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)cn);
        }
    }

    private Map getAdjustRelation(Context ctx, LoanInterestBillInfo loanInterestInfo) throws BOSException, EASBizException {
        HashMap<String, Object> relMap = new HashMap<String, Object>();
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = " select FSrcEntityID,FDestEntityID,FSrcObjectID from t_bot_relation where FDestObjectID = ? and FSrcEntityID = 'AFA71C61' ";
        try {
            cn = this.getConnection(ctx);
            String srcEntityID = null;
            String destEntityID = null;
            String srcObjectID = null;
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, loanInterestInfo.getId().toString());
            rs = pstmt.executeQuery();
            int number = 0;
            while (rs.next()) {
                srcEntityID = rs.getString(1);
                destEntityID = rs.getString(2);
                srcObjectID = rs.getString(3);
                relMap.put("srcEntityID" + ++number, srcEntityID);
                relMap.put("destEntityID" + number, destEntityID);
                relMap.put("srcObjectID" + number, srcObjectID);
            }
            relMap.put("number", new Integer(number));
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return relMap;
    }

    private void _deleteCheck(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        if (loanInterestBillInfo.isIsPrediction()) {
            return;
        }
        if (loanInterestBillInfo.isFivouchered()) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR1);
        }
        if (loanInterestBillInfo.getBillStatus() != IvtBillStatusEnum.SAVE) {
            this._check(loanInterestBillInfo, ctx);
        }
        if (loanInterestBillInfo.getIntCalType() != IntCalTypeEnum.PRE_INT && loanInterestBillInfo.getBillStatus() == IvtBillStatusEnum.BOOK) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR5, new Object[]{loanInterestBillInfo.getNumber()});
        }
        if (!this.deleteRelated && loanInterestBillInfo.getBillType() == LoanInterestTypeEnum.INTEREST && loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT && !loanInterestBillInfo.isIsPrediction()) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR2);
        }
    }

    private void _check(LoanInterestBillInfo loanInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        this._checkIsLastInt(loanInterestBillInfo, ctx);
        if (loanInterestBillInfo.getIntCalType().getValue() == 0) {
            this._deletePreIntCheck(loanInterestBillInfo, ctx);
        }
    }

    private void _checkIsLastInt(LoanInterestBillInfo loanInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        if (loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            this.deletePreInt(loanInterestBillInfo, ctx);
        } else {
            this.deleteOther(loanInterestBillInfo, ctx);
        }
    }

    private void _deletePreIntCheck(LoanInterestBillInfo loanInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select fid from t_ivt_loaninterestbill where fstrikestatus = ? and fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"striked", loanInterestBillInfo.getId().toString()});
        try {
            if (rs.next()) {
                throw new CHLoanException(CHLoanException.INT_DELETE_ERROR4);
            }
        }
        catch (SQLException e) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR4);
        }
    }

    private void deleteOther(LoanInterestBillInfo loanInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select max(fenddate) from t_ivt_loaninterestbill where fisprediction = 0 and (fintcaltype = ? or fintcaltype=?) and floanbillid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), new Integer(1), loanInterestBillInfo.getLoanBill().getId().toString()});
        Date billEndDate = DateTimeUtils.truncateDate((Date)loanInterestBillInfo.getEndDate());
        try {
            if (rs.next() && rs.getDate(1) != null) {
                Date maxEndDate = new Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((Date)maxEndDate)) < 0) {
                    throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
                }
            }
        }
        catch (SQLException e) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
        }
    }

    private void deletePreInt(LoanInterestBillInfo loanInterestBillInfo, Context ctx) throws BOSException, CHLoanException {
        String sql = "select max(fenddate) from t_ivt_loaninterestbill where fintcaltype = ? and floanbillid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(loanInterestBillInfo.getIntCalType().getValue()), loanInterestBillInfo.getLoanBill().getId().toString()});
        Date billEndDate = DateTimeUtils.truncateDate((Date)loanInterestBillInfo.getEndDate());
        try {
            if (rs.next()) {
                if (rs.getDate(1) == null) {
                    return;
                }
                Date maxEndDate = new Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((Date)maxEndDate)) < 0) {
                    throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
                }
            }
        }
        catch (SQLException e) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
        }
    }

    private void _afterDelete(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        if (loanInterestBillInfo.isIsPrediction()) {
            return;
        }
        if (loanInterestBillInfo.getIntCalType().getValue() == 2) {
            this._antiBook(ctx, loanInterestBillInfo);
            String repayBillID = loanInterestBillInfo.getRepayment().getId().toString();
            boolean isRepayAllBill = this.isRepayAllBill(ctx, repayBillID);
            if (isRepayAllBill) {
                this._action4(ctx, loanInterestBillInfo);
                this._reverseDate(ctx, loanInterestBillInfo);
            }
        } else if (loanInterestBillInfo.getIntCalType().getValue() == 1) {
            this._antiBook(ctx, loanInterestBillInfo);
            if (loanInterestBillInfo.getVerifySourceId() == null) {
                this._action4(ctx, loanInterestBillInfo);
            }
            this._reverseDate(ctx, loanInterestBillInfo);
        } else {
            this._reverseDate(ctx, loanInterestBillInfo);
        }
    }

    private boolean isRepayAllBill(Context ctx, String repayBillID) throws BOSException {
        boolean isRepayAllBill = false;
        String sql = " select frepaytotalamt,floantotalamt from  t_ivt_entrepaymentbill,t_ivt_chloan where t_ivt_entrepaymentbill.floanbillidid = t_ivt_chloan.fid  and t_ivt_entrepaymentbill.fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{repayBillID});
        BigDecimal loanAmtTotal = Constants.ZERO;
        BigDecimal repayAmtTotal = Constants.ZERO;
        try {
            if (rs.next()) {
                repayAmtTotal = rs.getBigDecimal(1);
                isRepayAllBill = repayAmtTotal.compareTo(loanAmtTotal = rs.getBigDecimal(2)) == 0;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isRepayAllBill;
    }

    private void _reverseDate(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
        IntReverseFacadeFactory.getLocalInstance(ctx).reverseAfterDelete(loanInterestBillInfo);
    }

    private void _action4(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws BOSException {
        if (loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.REC_INT || loanInterestBillInfo.getIntCalType() == IntCalTypeEnum.REPAY_INT) {
            StringBuffer sql = new StringBuffer();
            sql.append("update t_ivt_loaninterestbill set FStrikeStatus=?,FPayInterestBillId=null ");
            sql.append("where  FPayInterestBillId=? and fintCalType=0 and floanbillid = ?");
            String billid = loanInterestBillInfo.getLoanBill().getId().toString();
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"null", loanInterestBillInfo.getId().toString(), billid});
        }
    }

    private void _antiBook(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws EASBizException, BOSException {
    }

    @Override
    protected void _deleteRaleted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fil = new FilterInfo();
        fil.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)pk));
        evi.setFilter(fil);
        LoanInterestBillCollection col = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            this.deleteRelated = true;
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(col.get(i).getId()));
        }
    }

    @Override
    protected boolean _checkBalanceEnough(Context ctx, LoanInterestBillInfo loanInterestBillInfo) throws BOSException, EASBizException {
        BigDecimal balance = this.getAccountBalance(ctx, loanInterestBillInfo);
        if (balance.compareTo(Constants.ZERO) < 0) {
            return false;
        }
        BigDecimal interestActual = loanInterestBillInfo.getInterestActual();
        BigDecimal punishInterestActual = loanInterestBillInfo.getPunishInterestActual();
        BigDecimal repayAmt = loanInterestBillInfo.getEntRepaymentBillInfo().getRepayAmt();
        BigDecimal sum = interestActual.add(punishInterestActual).add(repayAmt);
        return balance.compareTo(sum) >= 0;
    }

    @Override
    protected LoanInterestBillCollection _batchRecIntWithFpItem4Log(Context ctx, IObjectPK[] pks, Date startDate, Date endDate) throws BOSException, EASBizException {
        StringBuffer sbLog = new StringBuffer();
        Set loanBillIDSet = this.PKArray2Set(pks);
        LoanInterestBillInfo loanInterestBillInfo = null;
        LoanInterestBillCollection returnValue = new LoanInterestBillCollection();
        ChLoanRateAdjustBillCollection chloanAdjCol = this.getLoanRateAjustColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection repayColl = this.getRepayColl(ctx, loanBillIDSet);
        ChLoanCollection chloanColl = this.getLoanColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection byIDsRepay = null;
        ChLoanRateAdjustBillCollection byIDAdj = null;
        ChLoanInfo info = null;
        for (String loanid : loanBillIDSet) {
            byIDsRepay = this.filterRepayByID(repayColl, loanid);
            byIDAdj = this.filterAdjByID(chloanAdjCol, loanid);
            info = this.filterChLoanInfoByID(chloanColl, loanid);
            loanInterestBillInfo = null;
            IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDAdj, byIDsRepay, null);
            LoanInterestInfo imIntInfo = AbstractIntCalStragety.getInstance((com.kingdee.eas.fm.im.IntCalTypeEnum)com.kingdee.eas.fm.im.IntCalTypeEnum.REC_INT).calInt(ctx, model);
            loanInterestBillInfo = this.transfrom(ctx, imIntInfo, info, null);
            loanInterestBillInfo.setId(BOSUuid.create((BOSObjectType)loanInterestBillInfo.getBOSType()));
            returnValue.add(loanInterestBillInfo);
            sbLog.append(loanInterestBillInfo.getNumber()).append(" | ");
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"9_LoanInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new LoanInterestBillInfo().getBOSType(), null, (String)sbLog.toString(), (String)"chloan_insterest_recint");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return returnValue;
    }

    @Override
    protected LoanInterestBillCollection _batchRecIntWithFpItem(Context ctx, Set loanBillIDSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        return this._batchRecIntWithFpItem4Log(ctx, this.set2PKArray(loanBillIDSet), startDate, endDate);
    }

    @Override
    protected LoanInterestBillCollection _batchPreIntWithFpItem(Context ctx, Set loanIDSet, Date startDate, Date endDate) throws BOSException, EASBizException {
        return this._batchPreIntWithFpItem4Log(ctx, this.set2PKArray(loanIDSet), startDate, endDate);
    }

    protected ChLoanRateAdjustBillCollection getLoanRateAjustColl(Context ctx, Set loanBillIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanBillIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("adjustDate"));
        return ChLoanRateAdjustBillFactory.getLocalInstance(ctx).getChLoanRateAdjustBillCollection(evi);
    }

    protected ChLoanRateAdjustBillCollection filterAdjByID(ChLoanRateAdjustBillCollection repayColl, String loanid) {
        ChLoanRateAdjustBillCollection adjCol = new ChLoanRateAdjustBillCollection();
        ChLoanRateAdjustBillInfo tmp = null;
        for (int i = 0; i < repayColl.size(); ++i) {
            tmp = repayColl.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanid)) continue;
            adjCol.add(tmp);
        }
        return adjCol;
    }

    public IntRateTypeExpressionEnum getIntRateTypeExp(com.kingdee.eas.fm.im.IntRateTypeExpressionEnum rateType) {
        if (rateType == com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.YEAR) {
            return IntRateTypeExpressionEnum.YEAR;
        }
        if (rateType == com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.DAY) {
            return IntRateTypeExpressionEnum.DAY;
        }
        if (rateType == com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.MONTH) {
            return IntRateTypeExpressionEnum.MONTH;
        }
        return IntRateTypeExpressionEnum.DAY;
    }

    public PenAccrualTypeEnum getPunishIntRateType(com.kingdee.eas.fm.im.PenAccrualTypeEnum type) {
        if (type == com.kingdee.eas.fm.im.PenAccrualTypeEnum.ADD_PERCENT) {
            return PenAccrualTypeEnum.ADD_PERCENT;
        }
        if (type == com.kingdee.eas.fm.im.PenAccrualTypeEnum.ADD_ACCRUAL) {
            return PenAccrualTypeEnum.ADD_ACCRUAL;
        }
        return PenAccrualTypeEnum.ADD_ACCRUAL;
    }

    protected void setLoanBillInfo(LoanInterestBillInfo finIntInfo, ChLoanInfo loanInfo) {
    }

    protected LoanInterestBillInfo transfrom(Context ctx, LoanInterestInfo imIntInfo, ChLoanInfo loanInfo, EntRepaymentBillInfo repaymentInfo) {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        LoanInterestBillInfo finIntInfo = new LoanInterestBillInfo();
        LoanInterestEntryCollection imIntCol = imIntInfo.getEntries();
        for (int i = 0; i < imIntCol.size(); ++i) {
            LoanInterestEntryInfo imEntryInfo = imIntCol.get(i);
            LoanInterestBillEntryInfo finEntryInfo = new LoanInterestBillEntryInfo();
            finEntryInfo.setSeq(imEntryInfo.getSeq());
            finEntryInfo.setBeginDate(imEntryInfo.getBeginDate());
            finEntryInfo.setEndDate(imEntryInfo.getEndDate());
            finEntryInfo.setDays(imEntryInfo.getDays());
            finEntryInfo.setAmount(imEntryInfo.getPrincipal());
            finEntryInfo.setYearIntRate(imEntryInfo.getIntRate());
            finEntryInfo.setInterest(imEntryInfo.getInterest());
            finEntryInfo.setYearDays(imEntryInfo.getConvertDays());
            finEntryInfo.setIntRateTypeExpression(this.getIntRateTypeExp(imEntryInfo.getIntRateTypeExp()));
            finEntryInfo.setDaysOverdue(imEntryInfo.getOverdueDays());
            finEntryInfo.setPunishIntRate(imEntryInfo.getPunishIntRate());
            finEntryInfo.setPunishInterest(imEntryInfo.getPunishInterest());
            finIntInfo.getEntrys().add(finEntryInfo);
        }
        finIntInfo.setEntRepaymentBillInfo(repaymentInfo);
        finIntInfo.setLoanCompany(loanInfo.getLoanCompany());
        finIntInfo.setRepayment(repaymentInfo);
        finIntInfo.setLoanInfo(loanInfo);
        finIntInfo.setLoanBill(loanInfo);
        this.setLoanBillInfo(finIntInfo, loanInfo);
        finIntInfo.setIntAccount(loanInfo.getAccrualAccount());
        if (imIntInfo.getIntCalType() == com.kingdee.eas.fm.im.IntCalTypeEnum.REC_INT) {
            finIntInfo.setIntCalType(IntCalTypeEnum.REC_INT);
        } else if (imIntInfo.getIntCalType() == com.kingdee.eas.fm.im.IntCalTypeEnum.PRE_INT) {
            finIntInfo.setIntCalType(IntCalTypeEnum.PRE_INT);
        } else if (imIntInfo.getIntCalType() == com.kingdee.eas.fm.im.IntCalTypeEnum.REPAY_INT) {
            finIntInfo.setIntCalType(IntCalTypeEnum.REPAY_INT);
        }
        finIntInfo.setCompany(loanInfo.getCompany());
        finIntInfo.setCreator(user);
        finIntInfo.setCurrency(imIntInfo.getCurrency());
        finIntInfo.setBank(loanInfo.getBank());
        finIntInfo.setBizDate(imIntInfo.getBizDate());
        finIntInfo.setBeginDate(imIntInfo.getBeginDate());
        finIntInfo.setEndDate(imIntInfo.getEndDate());
        finIntInfo.setDays(imIntInfo.getDays());
        finIntInfo.setAmount(imIntInfo.getPrincipal());
        finIntInfo.setYearIntRate(imIntInfo.getIntRate());
        finIntInfo.setDaysOverdue(imIntInfo.getOverdueDays());
        finIntInfo.setPunishIntType(this.getPunishIntRateType(imIntInfo.getPunishType()));
        finIntInfo.setPunishIntRate(imIntInfo.getPunishIntRate());
        finIntInfo.setPunishInterest(imIntInfo.getPunishInterest());
        finIntInfo.setInterest(imIntInfo.getInterest());
        finIntInfo.setStrikeStatus(StrikeEnum.NULL);
        if (finIntInfo.getIntCalType() == IntCalTypeEnum.PRE_INT) {
            finIntInfo.setStrikeAmount(Constants.ZERO);
        }
        finIntInfo.setFivouchered(false);
        finIntInfo.setInterest(imIntInfo.getInterest());
        finIntInfo.setPunishInterest(imIntInfo.getPunishInterest());
        finIntInfo.setInterestActual(FMHelper.add((BigDecimal)finIntInfo.getInterest(), (BigDecimal)finIntInfo.getPunishInterest()));
        finIntInfo.setInterestAcctual(imIntInfo.getInterestActual());
        finIntInfo.setPunishInterestActual(imIntInfo.getPunishInterestActual());
        finIntInfo.setInterestToPay(FMHelper.add((BigDecimal)finIntInfo.getInterestActual(), (BigDecimal)finIntInfo.getPunishInterestActual()));
        finIntInfo.setIntRateTypeExpression(this.getIntRateTypeExp(imIntInfo.getIntRateTypeExp()));
        finIntInfo.setLastIntDate(imIntInfo.getLastIntDate());
        BOSUuid idBOS = BOSUuid.create((BOSObjectType)finIntInfo.getBOSType());
        finIntInfo.setId(idBOS);
        finIntInfo.setIntAccount(loanInfo.getLoanAccount());
        finIntInfo.setUnVerifyAmount(Constants.ZERO);
        finIntInfo.setImIntInfo(imIntInfo);
        return finIntInfo;
    }

    @Override
    protected LoanInterestBillCollection _batchPreIntWithFpItem4Log(Context ctx, IObjectPK[] pkArray, Date startDate, Date endDate) throws BOSException, EASBizException {
        StringBuffer sbLog = new StringBuffer();
        LoanInterestBillInfo loanInterestBillInfo = null;
        String loanid2 = "";
        List allBeforeFirstExtDate = this.getAllExtDate(ctx);
        LoanInterestBillCollection returnValue = new LoanInterestBillCollection();
        Set loanBillIDSet = this.PKArray2Set(pkArray);
        ChLoanRateAdjustBillCollection chloanAdjCol = this.getLoanRateAjustColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection repayColl = this.getRepayColl(ctx, loanBillIDSet);
        ChLoanCollection chloanColl = this.getLoanColl(ctx, loanBillIDSet);
        Object byIDsExt = null;
        ChLoanRateAdjustBillCollection byIDAdj = null;
        EntRepaymentBillCollection byIDsRepay = null;
        ChLoanInfo info = null;
        for (String loanid2 : loanBillIDSet) {
            byIDsRepay = this.filterRepayByID(repayColl, loanid2);
            byIDAdj = this.filterAdjByID(chloanAdjCol, loanid2);
            info = this.filterChLoanInfoByID(chloanColl, loanid2);
            loanInterestBillInfo = null;
            IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDAdj, byIDsRepay, null);
            LoanInterestInfo imIntInfo = AbstractIntCalStragety.getInstance((com.kingdee.eas.fm.im.IntCalTypeEnum)com.kingdee.eas.fm.im.IntCalTypeEnum.PRE_INT).calInt(ctx, model);
            loanInterestBillInfo = this.transfrom(ctx, imIntInfo, info, null);
            loanInterestBillInfo.setId(BOSUuid.create((BOSObjectType)loanInterestBillInfo.getBOSType()));
            loanInterestBillInfo.setIsPrediction(false);
            returnValue.add(loanInterestBillInfo);
            sbLog.append(loanInterestBillInfo.getNumber()).append(" | ");
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"8_LoanInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new LoanInterestBillInfo().getBOSType(), null, (String)sbLog.toString(), (String)"chloan_insterest_preint");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return returnValue;
    }

    protected IntCalModel getIntCalModel(Date startDate, Date endDate, ChLoanInfo info, ChLoanRateAdjustBillCollection byIDAdj, EntRepaymentBillCollection byIDsRepay, EntRepaymentBillInfo repayInfo) {
        ImChloanInfo iLoanInfo = new ImChloanInfo(info);
        ImChLoanAdjustIntRateCollection iAdjColl = new ImChLoanAdjustIntRateCollection(byIDAdj);
        ImEntRepaymentBillCollection iRepayColl = new ImEntRepaymentBillCollection(byIDsRepay);
        ImEntRepayInfo iRepayInfo = new ImEntRepayInfo(repayInfo);
        IntCalModel model = new IntCalModel();
        model.setBeginDate(startDate);
        model.setEndDate(endDate);
        model.setLoanInfo((ILoanInfo)iLoanInfo);
        model.setAdjIntRateColl((IAdjustIntRateCollection)iAdjColl);
        model.setRepayColl((IRepaymentBillCollection)iRepayColl);
        model.setRepayInfo((IRepaymentBillInfo)iRepayInfo);
        if (startDate != null) {
            model.setNewRequirement(true);
        } else {
            model.setNewRequirement(false);
        }
        return model;
    }

    @Override
    protected Set _batchSubmitWithFmItem(Context ctx, LoanInterestBillCollection intCollection, boolean isAutoBookParam) throws BOSException, EASBizException {
        this.isAutoBook = isAutoBookParam;
        HashSet<String> idSet = new HashSet<String>();
        IObjectPK[] pks = new IObjectPK[intCollection.size()];
        int index = 0;
        Iterator iter = intCollection.iterator();
        while (iter.hasNext()) {
            LoanInterestBillInfo element = (LoanInterestBillInfo)iter.next();
            IObjectPK pk = null;
            pk = (element.getIntCalType() == IntCalTypeEnum.PRE_INT || element.getIntCalType() == IntCalTypeEnum.REC_INT) && FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)element.getBOSType()) ? this.save(ctx, (CoreBaseInfo)element) : this.submit(ctx, (CoreBaseInfo)element);
            idSet.add(pk.toString());
            pks[index] = pk;
            ++index;
        }
        this._batchSubmitWithFmItem4Log(ctx, pks);
        this.isAutoBook = false;
        return idSet;
    }

    @Override
    protected Set _batchSubmitWithFmItem4Log(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _book(Context ctx, Set ids) throws BOSException, EASBizException {
        HashSet<String> ids2 = new HashSet<String>();
        LoanInterestBillCollection col = this.getColByID(ctx, ids);
        LoanInterestBillCollection col4Pay = (LoanInterestBillCollection)((Object)col.clone());
        for (int i = 0; i < col.size(); ++i) {
            IvtBillStatusEnum billStatus = col.get(i).getBillStatus();
            if (billStatus == IvtBillStatusEnum.BOOK) continue;
            if (billStatus == IvtBillStatusEnum.SAVE) {
                throw new CHLoanException(CHLoanException.BOOKERROR1);
            }
            String id = col.get(i).getId().toString();
            ids2.add(id);
            this.accept(ctx, id);
        }
        LoanInterestBillCollection col4Pay2 = this.getColByID(ctx, ids2);
        this.sendPaymentBill(ctx, col4Pay2);
    }

    private void sendPaymentBill(Context ctx, LoanInterestBillCollection coll) throws BOSException, EASBizException {
        LoanInterestBillCollection srcColl = new LoanInterestBillCollection();
        LoanInterestBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!this.isNeedSendPayment(ctx, info)) continue;
            srcColl.add(info);
        }
        if (srcColl.size() > 0) {
            this.botpTransToPaymentBill(ctx, srcColl);
        }
    }

    private boolean isNeedSendPayment(Context ctx, LoanInterestBillInfo intBillInfo) throws BOSException {
        int intCalType = intBillInfo.getIntCalType().getValue();
        if (intCalType != 2 && intCalType != 1) {
            return false;
        }
        CompanyOrgUnitInfo loanCompany = intBillInfo.getLoanCompany();
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean isAcceptPayBill = localInstance.getBooleanParam("CS054", (IObjectPK)new ObjectUuidPK(loanCompany.getId()));
        if (!isAcceptPayBill) {
            return false;
        }
        AccountBankInfo acctBankInfo = this.getAcctBankInfo(ctx, intBillInfo.getIntAccount());
        return acctBankInfo != null;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    private BTPTransformResult botpTransToPaymentBill(Context ctx, LoanInterestBillCollection coll) throws BOSException, EASBizException {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        CoreBillBaseCollection srcColl = new CoreBillBaseCollection();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            srcColl.add((CoreBillBaseInfo)coll.get(i));
        }
        BOSObjectType destBosType = new PaymentBillInfo().getBOSType();
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = null;
        try {
            result = iBTPManager.transformMultiBill(srcColl, destBosType.toString());
            IObjectCollection destBillColl = result.getBills();
            int size2 = destBillColl.size();
            for (int i = 0; i < size2; ++i) {
                iBTPManager.saveRelations((CoreBillBaseInfo)destBillColl.getObject(i), result.getBOTRelationCollection());
            }
        }
        catch (EASBizException e) {
            throw new CHLoanException(CHLoanException.SENDPAYMENTERROR, new Object[]{e.getMessage()});
        }
        return result;
    }

    private AccountBankInfo getAcctBankInfo(Context ctx, InnerAccountInfo innerAcctInfo) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)innerAcctInfo.getApplyUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", (Object)innerAcctInfo.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountBank iAcctBank = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection coll = iAcctBank.getAccountBankCollection(evi);
        if (coll.size() == 1) {
            return coll.get(0);
        }
        return null;
    }

    private void accept(Context ctx, String id) throws BOSException, EASBizException {
        String cashierid = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        this.updateLoanIntCashier(ctx, cashierid, IvtBillStatusEnum.BOOK, id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("intAccount.company.id"));
        sic.add(new SelectorItemInfo("intAccount.id"));
        sic.add(new SelectorItemInfo("loanBill.isHistoryLoan"));
        LoanInterestBillInfo loanInterestBillInfo = this.getLoanInterestBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sic);
        this.action2(ctx, loanInterestBillInfo);
    }

    @Override
    protected void _cancelBook(Context ctx, Set ids) throws BOSException, EASBizException {
        LoanInterestBillCollection col = this.getColByID(ctx, ids);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            IvtBillStatusEnum billStatus = col.get(i).getBillStatus();
            if (billStatus == IvtBillStatusEnum.SUBMIT) continue;
            if (billStatus == IvtBillStatusEnum.SAVE) {
                throw new CHLoanException(CHLoanException.CANCELBOOKERROR);
            }
            if (col.get(i).isFivouchered()) {
                throw new CHLoanException(CHLoanException.CANCELBOOKERROR2, new Object[]{col.get(i).getNumber()});
            }
            String id = col.get(i).getId().toString();
            idSet.add(id);
        }
        if (idSet.size() > 0) {
            this.deletePaymentBill(ctx, idSet);
        }
        for (String id : idSet) {
            this.cancelAccept(ctx, id);
        }
    }

    private void deletePaymentBill(Context ctx, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new PaymentBillInfo().getBOSType().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relationColl = iBotRelation.getCollection(evi);
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        int size = relationColl.size();
        for (int i = 0; i < size; ++i) {
            try {
                iPaymentBill.delete((IObjectPK)new ObjectUuidPK(relationColl.get(i).getDestObjectID()));
                continue;
            }
            catch (EASBizException e) {
                throw new CHLoanException(CHLoanException.DELETEPAYMENTERROR, new Object[]{e.getMessage()});
            }
        }
    }

    private void cancelAccept(Context ctx, String id) throws EASBizException, BOSException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(id);
        this.updateLoanIntCashier(ctx, null, IvtBillStatusEnum.SUBMIT, id);
    }

    private LoanInterestBillCollection getColByID(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(f);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("intAccount.*"));
        LoanInterestBillCollection toBeBooked = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillCollection(evi);
        return toBeBooked;
    }

    private void updateLoanIntCashier(Context ctx, String cashierid, IvtBillStatusEnum status, String billid) throws BOSException {
        String sql = "update T_IVT_LoanInterestBill set FAcceptor = ?,FBillStatus=? ,FUnVerifyAmount=0,FVerifyAmount=0 where fid = ?";
        FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{cashierid, new Integer(status.getValue()), billid});
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo f = new EntityViewInfo();
        f.setFilter(filter);
        LoanInterestBillCollection col = this.getLoanInterestBillCollection(ctx, f);
        IObjectPK[] pkids = super._delete(ctx, filter);
        LoanInterestBillInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            this._deleteCheck(ctx, info);
            this._afterDelete(ctx, info);
            Map relMap = this.getAdjustRelation(ctx, info);
            String sql = " delete from t_bot_relation where FDestObjectID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
            this.updateAdjust(ctx, info, relMap);
            if (info.getNumber() == null) continue;
            FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        }
        return pkids;
    }

    @Override
    protected void _cancelBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInterestBillInfo info = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillInfo(pk);
        String billId = info.getId().toString();
        try {
            BigDecimal maxPayAmount = Constants.ZERO;
            BigDecimal deviation = Constants.ZERO;
            BigDecimal amount = Constants.ZERO;
            String innerAccountID = info.getIntAccount().getId().toString();
            String currencyID = info.getCurrency().getId().toString();
            InnerAccountInfo innerAccountInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
            info.setIntAccount(innerAccountInfo);
            info.setCurrency(currencyInfo);
            amount = FMHelper.getBalanceValue((Context)ctx, (CurrencyInfo)info.getCurrency(), (InnerAccountInfo)info.getIntAccount());
            NTBookHelper.bookMoreSubsidiary((Context)ctx, (String)billId, (String)LoanInterestBillSubsidiaryBookProvider.class.getName());
            if (amount.compareTo(info.getUnVerifyAmount()) <= 0) {
                deviation = FinHelper.calcBigDecimalExprs((String)"{0}-{1}", (BigDecimal[])new BigDecimal[]{info.getUnVerifyAmount(), amount});
                info.setUnVerifyAmount(deviation);
            } else if (amount.compareTo(info.getUnVerifyAmount()) > 0) {
                info.setUnVerifyAmount(Constants.ZERO);
            }
            info.setIsCancel(true);
            LoanInterestBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkUNCancelBill(Context ctx, LoanInterestBillInfo info, int maxSeq) throws BOSException, EASBizException {
        if (info.getVerifySeq() == 0 || info.getVerifySeq() != maxSeq) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"10_LoanInterestBillControllerBean", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected void _unCancelBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInterestBillInfo info = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillInfo(pk);
        String billId = info.getId().toString();
        int leave = this.countVerifyBill(ctx, info.getVerifySourceId());
        this.checkUNCancelBill(ctx, info, leave);
        LoanInterestBillInfo sourceInfo = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(info.getVerifySourceId()));
        sourceInfo.setUnVerifyAmount(sourceInfo.getUnVerifyAmount().add(info.getVerifyAmount()));
        if (NTBookHelper.checkLastIsBook((Context)ctx, (String)billId)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"11_LoanInterestBillControllerBean", (Locale)ctx.getLocale())));
        }
        NTBookHelper.antiLastBookSubsidiaryLedgerInfo((Context)ctx, (String)billId);
        HashSet<String> ids = new HashSet<String>();
        ids.add(billId);
        LoanInterestBillFactory.getLocalInstance(ctx).cancelBook(ids);
        this.delete(ctx, pk);
        if (leave == 1) {
            sourceInfo.setIsCancel(false);
        }
        this.update(ctx, (IObjectPK)new ObjectUuidPK(sourceInfo.getId() + ""), (CoreBaseInfo)sourceInfo);
    }

    @Override
    protected void _verifyBill(Context ctx, LoanInterestBillInfo verifyBill) throws BOSException, EASBizException {
        verifyBill.setIsCancel(true);
        LoanInterestBillInfo copyBill = (LoanInterestBillInfo)verifyBill.clone();
        verifyBill.setUnVerifyAmount(verifyBill.getUnVerifyAmount().subtract(verifyBill.getVerifyAmount()));
        LoanInterestBillInfo verifyCopy2 = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(copyBill.getId() + ""));
        TransPrecisionUtil.trancatePrecision((Context)ctx, (CoreBaseInfo)verifyBill, (String[])new String[]{"amount", "interest", "punishInterest", "interestActual", "interestToPay", "unVerifyAmount", "strikeAmount", "punishInterestActual", "interestAcctual", "intAccountBalance", "verifyAmount"}, (CurrencyInfo)((CurrencyInfo)verifyBill.get("currency")), null);
        verifyBill.setVerifyAmount(verifyCopy2.getVerifyAmount());
        super.update(ctx, (IObjectPK)new ObjectUuidPK(verifyBill.getId()), (CoreBaseInfo)verifyBill);
        int seq = this.countVerifyBill(ctx, verifyBill.getId() + "") + 1;
        copyBill.setVerifySeq(seq);
        copyBill.setVerifySourceId(copyBill.getId().toString());
        LoanInterestBillEntryCollection coll = (LoanInterestBillEntryCollection)((Object)copyBill.get("entrys"));
        copyBill.setId(null);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            LoanInterestBillEntryInfo info = (LoanInterestBillEntryInfo)it.next();
            info.setId(null);
        }
        copyBill.setBillStatus(IvtBillStatusEnum.BOOK);
        copyBill.setPunishInterest(new BigDecimal(0));
        copyBill.setInterestAcctual(new BigDecimal(0));
        copyBill.setPunishInterestActual(new BigDecimal(0));
        copyBill.setStrikeAmount(new BigDecimal(0));
        copyBill.setInterest(new BigDecimal(0));
        copyBill.setDays(0);
        copyBill.setBillType(LoanInterestTypeEnum.VERIFY);
        copyBill.setNumber(copyBill.getNumber() + "_" + copyBill.getVerifySeq());
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)copyBill, (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, (IObjectValue)copyBill);
        IObjectPK pk = super.addnew(ctx, (CoreBaseInfo)copyBill);
        NTBookHelper.bookMoreSubsidiary((Context)ctx, (String)pk.toString(), (String)LoanInterestBillSubsidiaryBookProvider.class.getName());
        LoanInterestBillCollection a = new LoanInterestBillCollection();
        a.add(copyBill);
        if (this.isNeedSendPayment(ctx, copyBill)) {
            this.sendPaymentBill(ctx, a);
        }
    }

    private int countVerifyBill(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "select count(*) as countNum from T_IVT_LoanInterestBill ivt where ivt.FVerifySourceId='" + id + "'";
        ROMRowSet a = FMDBHelper.executeQuery((Context)ctx, (String)sql);
        a.next();
        return a.getInt("countNum");
    }

    @Override
    protected Map _batchRecIntWithFp(Context ctx, Set loanBillIDs, Date startDate, Date endDate) throws BOSException, EASBizException {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        StringBuffer sbLog = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        String errorMsgHeader = EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FinResource", (String)"recInt_error_header", (Locale)ctx.getLocale());
        String errorMsgBody = EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FinResource", (String)"rec_int_no_principal", (Locale)ctx.getLocale());
        Set loanBillIDSet = loanBillIDs;
        LoanInterestBillInfo loanInterestBillInfo = null;
        LoanInterestBillCollection returnValue = new LoanInterestBillCollection();
        ChLoanRateAdjustBillCollection chloanAdjCol = this.getLoanRateAjustColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection repayColl = this.getRepayColl(ctx, loanBillIDSet);
        ChLoanCollection chloanColl = this.getLoanColl(ctx, loanBillIDSet);
        EntRepaymentBillCollection byIDsRepay = null;
        ChLoanRateAdjustBillCollection byIDAdj = null;
        ChLoanInfo info = null;
        for (String loanid : loanBillIDSet) {
            byIDsRepay = this.filterRepayByID(repayColl, loanid);
            byIDAdj = this.filterAdjByID(chloanAdjCol, loanid);
            info = this.filterChLoanInfoByID(chloanColl, loanid);
            loanInterestBillInfo = null;
            IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDAdj, byIDsRepay, null);
            LoanInterestInfo imIntInfo = null;
            try {
                imIntInfo = AbstractIntCalStragety.getInstance((com.kingdee.eas.fm.im.IntCalTypeEnum)com.kingdee.eas.fm.im.IntCalTypeEnum.REC_INT).calInt(ctx, model);
            }
            catch (FinBizException e) {
                sb.append(info.getNumber()).append(errorMsgHeader).append(errorMsgBody).append("\n");
                continue;
            }
            catch (IMException imEx) {
                if ("009".equals(imEx.getSubCode())) {
                    sb.append(MessageFormat.format(imEx.getMessage(), info.getNumber())).append("\n");
                    continue;
                }
                sb.append(info.getNumber()).append(errorMsgHeader).append(imEx.getMessage()).append("\n");
                continue;
            }
            if (EmptyUtil.isEmpty((Object)imIntInfo)) continue;
            loanInterestBillInfo = this.transfrom(ctx, imIntInfo, info, null);
            loanInterestBillInfo.setId(BOSUuid.create((BOSObjectType)loanInterestBillInfo.getBOSType()));
            returnValue.add(loanInterestBillInfo);
            sbLog.append(loanInterestBillInfo.getNumber()).append(" | ");
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"9_LoanInterestBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new LoanInterestBillInfo().getBOSType(), null, (String)sbLog.toString(), (String)"chloan_insterest_recint");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        hm.put("IntBillColl", (Object)returnValue);
        if (sb.length() > 0) {
            String msg = EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FinResource", (String)"errorHeaderRec", (Locale)ctx.getLocale()) + sb.toString();
            hm.put("failureMsg", msg);
        }
        return hm;
    }
}

