/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class LoanInterestBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    private BigDecimal innerAccount = Constants.ZERO;

    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        SubsidiaryLedgerCollection collection = new SubsidiaryLedgerCollection();
        LoanInterestBillInfo info = this.getLoanInterestBillInfo(ctx, billId);
        if (billId == null) {
            return collection;
        }
        this.innerAccount = FMHelper.getBalanceValue((Context)ctx, (CurrencyInfo)info.getCurrency(), (InnerAccountInfo)info.getIntAccount());
        String innerAccountID = info.getIntAccount().getId().toString();
        InnerAccountInfo innerAccountInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
        AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
        accountMgrStrategyInfo = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
        OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT)) {
            this.innerAccount = FMHelper.add((BigDecimal)this.innerAccount, (BigDecimal)accountMgrStrategyInfo.getOverDraftAmount());
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE)) {
            this.innerAccount = FMHelper.subtract((BigDecimal)this.innerAccount, (BigDecimal)accountMgrStrategyInfo.getLowestBalance());
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            this.innerAccount = Constants.MAX_VALUE;
        }
        BigDecimal amount = info.getVerifyAmount();
        if (this.innerAccount.compareTo(amount) >= 0) {
            if (amount.compareTo(Constants.ZERO) > 0 && info.getLoanBill().getAccrualAccount() != null) {
                collection.add(this.createLoanInterestBookMaxOne(info, ctx));
                collection.add(this.createLoanInterestBookMaxTwo(info, ctx));
            } else if (this.innerAccount.compareTo(amount) >= 0) {
                collection.add(this.createLoanInterestBookMaxOne(info, ctx));
            }
        } else if (this.innerAccount.compareTo(amount) < 0) {
            if (amount.compareTo(Constants.ZERO) > 0 && info.getLoanBill().getAccrualAccount() != null) {
                collection.add(this.createLoanInterestBookMinOne(info, ctx));
                collection.add(this.createLoanInterestBookMinTwo(info, ctx));
            } else if (amount.compareTo(this.innerAccount) > 0) {
                collection.add(this.createLoanInterestBookMinOne(info, ctx));
            }
        }
        return collection;
    }

    private SubsidiaryLedgerInfo createLoanInterestBookMaxOne(LoanInterestBillInfo info, Context ctx) {
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.LOANINTERESTBILL);
        subInfo.setCompany(info.getCompany());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getIntAccount())) {
            subInfo.setApplyUnit(info.getIntAccount().getApplyUnit());
        }
        subInfo.setInnerAccount(info.getIntAccount());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"7_LoanInterestBillBookSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(info.getVerifyAmount());
        subInfo.setDebitAmount(Constants.ZERO);
        subInfo.setExchangeRate(info.getLoanBill().getExchangeRate());
        subInfo.setLocalAmount(info.getAmount());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private SubsidiaryLedgerInfo createLoanInterestBookMaxTwo(LoanInterestBillInfo info, Context ctx) {
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.LOANINTERESTBILL);
        subInfo.setCompany(info.getCompany());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getLoanBill().getAccrualAccount())) {
            subInfo.setApplyUnit(info.getLoanBill().getAccrualAccount().getApplyUnit());
        }
        subInfo.setInnerAccount(info.getLoanBill().getAccrualAccount());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"7_LoanInterestBillBookSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(Constants.ZERO);
        subInfo.setDebitAmount(info.getVerifyAmount());
        subInfo.setExchangeRate(info.getLoanBill().getExchangeRate());
        subInfo.setLocalAmount(info.getAmount());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private SubsidiaryLedgerInfo createLoanInterestBookMinOne(LoanInterestBillInfo info, Context ctx) {
        BigDecimal maxPayAmount = Constants.ZERO;
        AccountBankInfo accountBankInfo = null;
        if (info.getIntAccount() != null) {
            accountBankInfo = info.getIntAccount().getDeFaultAcctBank();
        }
        if (accountBankInfo != null) {
            maxPayAmount = accountBankInfo.getMaxPayAmount();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.LOANINTERESTBILL);
        subInfo.setCompany(info.getCompany());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getIntAccount())) {
            subInfo.setApplyUnit(info.getIntAccount().getApplyUnit());
        }
        subInfo.setInnerAccount(info.getIntAccount());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"7_LoanInterestBillBookSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(this.innerAccount);
        subInfo.setDebitAmount(Constants.ZERO);
        subInfo.setExchangeRate(info.getLoanBill().getExchangeRate());
        subInfo.setLocalAmount(info.getAmount());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private SubsidiaryLedgerInfo createLoanInterestBookMinTwo(LoanInterestBillInfo info, Context ctx) {
        BigDecimal maxPayAmount = new BigDecimal("0");
        AccountBankInfo accountBankInfo = null;
        if (info.getIntAccount() != null) {
            accountBankInfo = info.getIntAccount().getDeFaultAcctBank();
        }
        if (accountBankInfo != null) {
            maxPayAmount = accountBankInfo.getMaxPayAmount();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.LOANINTERESTBILL);
        subInfo.setCompany(info.getCompany());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getLoanBill().getAccrualAccount())) {
            subInfo.setApplyUnit(info.getLoanBill().getAccrualAccount().getApplyUnit());
        }
        subInfo.setInnerAccount(info.getLoanBill().getAccrualAccount());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(new Date());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"7_LoanInterestBillBookSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        subInfo.setCreditAmount(Constants.ZERO);
        subInfo.setDebitAmount(this.innerAccount);
        subInfo.setExchangeRate(info.getLoanBill().getExchangeRate());
        subInfo.setLocalAmount(info.getAmount());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        return subInfo;
    }

    private LoanInterestBillInfo getLoanInterestBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        LoanInterestBillInfo info = null;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        info = LoanInterestBillFactory.getLocalInstance(ctx).getLoanInterestBillInfo((IObjectPK)pk);
        String loanID = info.getLoanBill().getId().toString();
        String innerAccountID = info.getIntAccount().getId().toString();
        String currencyID = info.getCurrency().getId().toString();
        ChLoanInfo loanInfo = ChLoanFactory.getLocalInstance(ctx).getChLoanInfo((IObjectPK)new ObjectUuidPK(loanID));
        InnerAccountInfo innerAccountInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        info.setIntAccount(innerAccountInfo);
        info.setCurrency(currencyInfo);
        if (loanInfo.getAccrualAccount() != null) {
            String accralAccountId = loanInfo.getAccrualAccount().getId().toString();
            InnerAccountInfo accralAccountInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(accralAccountId));
            loanInfo.setAccrualAccount(accralAccountInfo);
        }
        info.setLoanBill(loanInfo);
        return info;
    }

    private SelectorItemCollection getAccountMgrStrategySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("overdraftCtrl");
        sic.add("overDraftAmount");
        sic.add("lowestBalance");
        sic.add("remind");
        return sic;
    }
}

