/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillCollection;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.EntRepaymentBillCollection;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.app.AbstractIntCalStragety;
import com.kingdee.eas.fm.ivt.app.ExtDateInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RepayIntCalStragety
extends AbstractIntCalStragety {
    @Override
    protected java.util.Date getBeginDate(Context ctx, java.util.Date condBeginDate, ChLoanInfo loanInfo) throws EASBizException, BOSException {
        java.util.Date loanStartDate = loanInfo.getStartDate();
        java.util.Date lastIntDate = loanInfo.getLastSettleDate();
        lastIntDate = lastIntDate == null ? loanStartDate : DateUtil.getAfterDay((java.util.Date)lastIntDate);
        return this.maxDate(loanStartDate, lastIntDate);
    }

    @Override
    protected java.util.Date getEndDate(java.util.Date condEndDate, EntRepaymentBillInfo repayBillInfo) {
        if (repayBillInfo.getRepayDate().compareTo(repayBillInfo.getChLoanInfo().getStartDate()) == 0) {
            return repayBillInfo.getRepayDate();
        }
        return DateUtil.getBeforeDay((java.util.Date)repayBillInfo.getRepayDate());
    }

    private java.util.Date maxDate(java.util.Date date1, java.util.Date date2) {
        int i = date1.compareTo(date2);
        switch (i) {
            case 1: {
                return date1;
            }
            case -1: {
                return date2;
            }
            case 0: {
                return date1;
            }
        }
        return date1;
    }

    @Override
    protected List getSubBeginDateList(Context ctx, java.util.Date beginDate, java.util.Date endDate, String loanId, boolean isAccordIntRate, CHLoanExtendBillCollection loanExColl, EntRepaymentBillInfo repayBillInfo, List allFirstExdDate) throws EASBizException, BOSException {
        StringBuffer sbSQL = new StringBuffer();
        String billState = IntRateStateEnum.AUDITED.getValue();
        sbSQL.append("select c.FEffectiveDate beginDate,2 type from T_IVT_CHLoan a  ");
        sbSQL.append("join T_INT_IntRateType b on a.FRateTypeId = b.FID ");
        sbSQL.append("join T_INT_IntRateBase c on b.FID = c.FTypeID ");
        sbSQL.append(" and c.FbillState = '" + billState + "'");
        sbSQL.append("where  c.FEffectiveDate > ? and c.FEffectiveDate <= ? and FIntTermID is null and c.FCurrencyID=? and a.fid=? ");
        sbSQL.append("union ");
        sbSQL.append("select e.fbeforeexdate beginDate, 3 type from T_IVT_CHLoan d ");
        sbSQL.append("join t_ivt_chloanextendbill e on d.FID=e.fchloanid ");
        sbSQL.append("where e.fbeforeexdate > ? and e.fbeforeexdate <= ? and d.FID = ? ");
        sbSQL.append("union ");
        sbSQL.append("select g.frepaydate beginDate, 1 type from T_IVT_CHLoan f ");
        sbSQL.append("join T_IVT_ENTREPAYMENTBILL g on f.fid=g.floanbillidid ");
        sbSQL.append("where g.frepaydate > ? and g.frepaydate <= ? and g.fisrepaywithaccr = 0 and f.fid = ? ");
        sbSQL.append("order by beginDate ");
        Date sBeginDate = new Date(beginDate.getTime());
        Date sEndDate = new Date(endDate.getTime());
        Object[] params = new Object[]{sBeginDate, sEndDate, this.currencyID, loanId, sBeginDate, sEndDate, loanId, sBeginDate, sEndDate, loanId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
        java.util.Date firstExpDateBeforeExt = this.getFirstExpDateBeforeExt(allFirstExdDate, loanId);
        ArrayList<java.util.Date> subList = new ArrayList<java.util.Date>();
        java.util.Date date = null;
        Integer type = null;
        try {
            while (rs.next()) {
                boolean isAllRepay;
                date = DateTimeUtils.truncateDate((java.util.Date)rs.getDate("beginDate"));
                type = new Integer(rs.getInt("type"));
                if (this.isLessOrEqualsFirstExtend(date, firstExpDateBeforeExt) && isAccordIntRate && type == 2 || !this.isLessOrEqualsFirstExtend(date, firstExpDateBeforeExt) && type == 2) continue;
                boolean bl = isAllRepay = repayBillInfo.getRemAmt().compareTo(Constants.ZERO) == 0;
                if (!isAllRepay && type == 1 || subList.contains(date)) continue;
                subList.add(date);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return subList;
    }

    private boolean isLessOrEqualsFirstExtend(java.util.Date date, java.util.Date firstExpDateBeforeExt) {
        if (firstExpDateBeforeExt == null) {
            return true;
        }
        return date.compareTo(firstExpDateBeforeExt) <= 0;
    }

    @Override
    protected boolean isCalPunishInt(java.util.Date beginDate, java.util.Date endDate, java.util.Date expiredDate, EntRepaymentBillInfo repayBillInfo) {
        return repayBillInfo.isIsPenaAccrual();
    }

    @Override
    protected BigDecimal getIntPrinciple(BigDecimal balance, BigDecimal intFreeAmt, java.util.Date subBeginDate, EntRepaymentBillCollection repayColl, EntRepaymentBillInfo info) {
        boolean isAllRepay;
        boolean bl = isAllRepay = info.getRemAmt().compareTo(Constants.ZERO) == 0;
        if (!isAllRepay) {
            return info.getRepayAmt();
        }
        BigDecimal repayTotalAmt = Constants.ZERO;
        EntRepaymentBillInfo repayInfo = null;
        for (int i = repayColl.size() - 1; i >= 0; --i) {
            repayInfo = repayColl.get(i);
            if (repayInfo.isIsRepayWithAccrual() || repayInfo.getRepayDate().compareTo(subBeginDate) <= 0) continue;
            repayTotalAmt = repayTotalAmt.add(repayInfo.getRepayAmt());
        }
        return balance.add(repayTotalAmt).add(intFreeAmt.negate());
    }

    @Override
    protected IntCalTypeEnum getIntCalType() {
        return IntCalTypeEnum.REPAY_INT;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("isHistoryLoan"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("loanTotalAmt"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("loanBalance"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("assureWay.name"));
        sic.add(new SelectorItemInfo("rateType.name"));
        sic.add(new SelectorItemInfo("floatPoint"));
        sic.add(new SelectorItemInfo("yearRate"));
        sic.add(new SelectorItemInfo("returnWay"));
        sic.add(new SelectorItemInfo("floorAmt"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("penAccrualRate"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("isReturned"));
        sic.add(new SelectorItemInfo("isOverdue"));
        sic.add(new SelectorItemInfo("isPostponed"));
        sic.add(new SelectorItemInfo("fivouchered"));
        sic.add(new SelectorItemInfo("lastSettleDate"));
        sic.add(new SelectorItemInfo("lastPreIntDate"));
        sic.add(new SelectorItemInfo("finacingProduct.name"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("handler.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("rateType.*"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("loanAccount.*"));
        sic.add(new SelectorItemInfo("loanAccount.applyUnit.*"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        return sic;
    }

    private java.util.Date getFirstExpDateBeforeExt(Context ctx, String loanId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 a.FStartDate, b.fbeforeexdate from T_IVT_CHLoan a").append(" left join t_ivt_chloanextendbill b on a.FID=b.fchloanid ").append(" where a.fid = ? ").append(" order by b.fbeforeexdate ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{loanId});
        try {
            if (rs.next()) {
                return rs.getDate(2);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private java.util.Date getFirstExpDateBeforeExt(List allFirstExdDate, String loanId) throws BOSException {
        ExtDateInfo info = null;
        java.util.Date FirstExpDateBeforeExt = null;
        for (int i = 0; i < allFirstExdDate.size(); ++i) {
            info = (ExtDateInfo)allFirstExdDate.get(i);
            if (!info.getChloanid().equals(loanId)) continue;
            FirstExpDateBeforeExt = info.getFirstExpDateBeforeExt();
            break;
        }
        return FirstExpDateBeforeExt;
    }
}

