/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fm.be.AccountBankBalanceCollection;
import com.kingdee.eas.fm.be.AccountBankBalanceFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DealCapitalDataRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.DealCapitalDataRunnable");
    private final String sql = " INSERT INTO T_LI_CapitalData ( FBizDate,FOrgID,FAccID,FBalance,FCurrencyID,FCashOrBank,FInAmount,FOutAmount) VALUES ( ?,?,?,?,?,?,?,?) ";
    private Context ctx;
    private String type;
    private CompanyOrgUnitInfo companyInfo;
    private AccountBankInfo acctBankInfo;
    private CurrencyCollection currencyCol;
    private Date dealDate;

    public DealCapitalDataRunnable(Context ctx, CompanyOrgUnitInfo companyInfo, CurrencyCollection currencyCol, Date dealDate) {
        this.ctx = ctx;
        this.type = "cashAcctView";
        this.companyInfo = companyInfo;
        this.currencyCol = currencyCol;
        this.dealDate = dealDate;
    }

    public DealCapitalDataRunnable(Context ctx, AccountBankInfo acctBankInfo, CurrencyCollection currencyCol, Date dealDate) {
        this.ctx = ctx;
        this.type = "acctBank";
        this.acctBankInfo = acctBankInfo;
        this.currencyCol = currencyCol;
        this.dealDate = dealDate;
    }

    @Override
    public void run() {
        if (this.type.equals("acctBank")) {
            this.dealAcctBankData();
        } else {
            this.dealCashData();
        }
    }

    private void dealCashData() {
        try {
            String orgId = this.companyInfo.getId().toString();
            AccountViewCollection accountCol = FMHelper.getAccountViewCollection((Context)this.ctx, (String)orgId, (String)this.companyInfo.getAccountTable().getId().toString(), null, (EntityViewInfo)this.getAccountViewFilterForCash());
            for (int j = 0; j < accountCol.size(); ++j) {
                String acctViewId = accountCol.get(j).getId().toString();
                for (int k = 0; k < this.currencyCol.size(); ++k) {
                    String currencyId = this.currencyCol.get(k).getId().toString();
                    BigDecimal balance = CashManagementFactory.getLocalInstance((Context)this.ctx).getCashData(orgId, acctViewId, currencyId, this.dealDate, this.dealDate, CashDataTypeEnum.Y, false);
                    DbUtil.execute((Context)this.ctx, (String)" INSERT INTO T_LI_CapitalData ( FBizDate,FOrgID,FAccID,FBalance,FCurrencyID,FCashOrBank,FInAmount,FOutAmount) VALUES ( ?,?,?,?,?,?,?,?) ", (Object[])new Object[]{new Timestamp(this.dealDate.getTime()), orgId, acctViewId, balance, currencyId, 1, BigDecimal.ZERO, BigDecimal.ZERO});
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8d44\u91d1\u6d1e\u5bdf:\u6570\u636e\u51c6\u5907>>" + this.companyInfo.getName() + ">>\u5904\u7406\u73b0\u91d1\u79d1\u76ee\u5f02\u5e38"));
            logger.error((Object)e);
        }
    }

    private void dealAcctBankData() {
        try {
            if (this.acctBankInfo.isIsByCurrency()) {
                String currencyId = this.acctBankInfo.getCurrency().getId().toString();
                this.dealData(currencyId);
            } else {
                for (int j = 0; j < this.currencyCol.size(); ++j) {
                    String currencyId = this.currencyCol.get(j).getId().toString();
                    this.dealData(currencyId);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8d44\u91d1\u6d1e\u5bdf:\u6570\u636e\u51c6\u5907>>" + this.acctBankInfo.getName() + ">>\u5904\u7406\u94f6\u884c\u8d26\u6237\u4f59\u989d\u5f02\u5e38"));
            logger.error((Object)e);
        }
    }

    private EntityViewInfo getAccountViewFilterForCash() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isCash", (Object)"1"));
        return view;
    }

    private void dealData(String currencyId) throws BOSException, EASBizException {
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal inAmount = BigDecimal.ZERO;
        BigDecimal outAmount = BigDecimal.ZERO;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.dealDate);
        calendar.add(5, -7);
        Date oneWeekBefore = calendar.getTime();
        String acctBankId = this.acctBankInfo.getId().toString();
        String companyId = this.acctBankInfo.getCompany().getId().toString();
        if (this.acctBankInfo.isIsSetBankInterface()) {
            AccountBankBalanceCollection balanceCol = AccountBankBalanceFactory.getLocalInstance((Context)this.ctx).getAccountBankBalanceCollection(this.getAcctBankBalanceFilter(acctBankId, currencyId, oneWeekBefore));
            if (balanceCol.size() > 0) {
                balance = balanceCol.get(0).getBalance();
            }
            String detailSql = " select sum(fDebitAmount) outAmount,sum(fCreditAmount) inAmount from T_BE_TransDetail  where fbankaccountid=? and fcurrencyid=? and fbizdate=? ";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)detailSql, (Object[])new Object[]{acctBankId, currencyId, new Timestamp(this.dealDate.getTime())});
            try {
                while (rs.next()) {
                    inAmount = rs.getBigDecimal("inAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("inAmount");
                    outAmount = rs.getBigDecimal("outAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("outAmount");
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf:\u6570\u636e\u5904\u7406>>\u5904\u7406\u94f6\u4f01\u8d26\u6237\u7684\u652f\u51fa\u6536\u5165\u6570\u636e\u5f02\u5e38");
                logger.error((Object)e);
            }
        } else {
            balance = CashManagementFactory.getLocalInstance((Context)this.ctx).getBankData(companyId, acctBankId, currencyId, this.dealDate, this.dealDate, CashDataTypeEnum.Y, false);
            String detailSql = " select sum(fDebitAmount) inAmount,sum(fCreditAmount) outAmount from T_CAS_Journal  where faccountbankid=? and fcurrencyid=? and fbizdate=? ";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)detailSql, (Object[])new Object[]{acctBankId, currencyId, new Timestamp(this.dealDate.getTime())});
            try {
                while (rs.next()) {
                    inAmount = rs.getBigDecimal("inAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("inAmount");
                    outAmount = rs.getBigDecimal("outAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("outAmount");
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf:\u6570\u636e\u5904\u7406>>\u5904\u7406\u975e\u94f6\u4f01\u8d26\u6237\u7684\u652f\u51fa\u6536\u5165\u6570\u636e\u5f02\u5e38");
                logger.error((Object)e);
            }
        }
        DbUtil.execute((Context)this.ctx, (String)" INSERT INTO T_LI_CapitalData ( FBizDate,FOrgID,FAccID,FBalance,FCurrencyID,FCashOrBank,FInAmount,FOutAmount) VALUES ( ?,?,?,?,?,?,?,?) ", (Object[])new Object[]{new Timestamp(this.dealDate.getTime()), companyId, acctBankId, balance, currencyId, 2, inAmount, outAmount});
    }

    private EntityViewInfo getAcctBankBalanceFilter(String acctBankId, String currencyId, Date oneWeekBefore) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("accountBank", (Object)acctBankId));
        items.add(new FilterItemInfo("currency", (Object)currencyId));
        items.add(new FilterItemInfo("bizDate", (Object)oneWeekBefore, CompareType.GREATER));
        items.add(new FilterItemInfo("bizDate", (Object)this.dealDate, CompareType.LESS_EQUALS));
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("bizDate");
        sortInfo.setSortType(SortType.DESCEND);
        sort.add(sortInfo);
        view.setSorter(sort);
        return view;
    }
}

