/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.AccountParam;
import com.kingdee.eas.fm.liquid.LiquidConstant;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.LiquidFacadeFactory;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.StockItemInfo;
import com.kingdee.eas.fm.liquid.app.AbstractFundStockFacadeControllerBean;
import com.kingdee.eas.fm.liquid.app.BalanceAndLocalBalance;
import com.kingdee.eas.fm.liquid.app.LiquidAppConstants;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeControllerBean;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class FundStockFacadeControllerBean
extends AbstractFundStockFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.FundStockFacadeControllerBean");

    @Override
    protected IRowSet _getStockStructure(Context ctx, Map filterParamMap) throws BOSException, EASBizException {
        LiquidHelper.printTime("begin getStockStructure", new java.util.Date());
        int queryCycle = 0;
        java.util.Date beginDate = LiquidFacadeHelper.checkDateIsValid(filterParamMap, "beginDate", ResourceBase.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"0_FundStockFacadeControllerBean", (Locale)ctx.getLocale()));
        java.util.Date endDate = LiquidFacadeHelper.checkDateIsValid(filterParamMap, "endDate", ResourceBase.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"1_FundStockFacadeControllerBean", (Locale)ctx.getLocale()));
        Object value = filterParamMap.get("queryCycle");
        if (value != null && !"-1".equals(value)) {
            queryCycle = Integer.parseInt((String)value);
        }
        filterParamMap.put("isFromPc", "true");
        IRowSet irs = LiquidFacadeFactory.getLocalInstance(ctx).getAccountsInfomation(filterParamMap);
        LiquidHelper.printTime("end getAccountsInfomation", new java.util.Date());
        ArrayList acctParamList = LiquidHelper.getAcctParamListByRs(irs, "1");
        LiquidHelper.printTime("end getAcctParamListByRs", new java.util.Date());
        if (queryCycle == 0) {
            irs = this.executeAcctRsInfoByAcctAndDate(ctx, beginDate, endDate, irs, acctParamList, null);
        } else {
            try {
                irs = this.getStockStructureByPeriod(ctx, queryCycle, beginDate, endDate, irs, acctParamList);
            }
            catch (EASBizException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        LiquidHelper.printTime("end getStockStructure", new java.util.Date());
        return irs;
    }

    private IRowSet getStockStructureByPeriod(Context ctx, int queryCycle, java.util.Date beginDate, java.util.Date endDate, IRowSet irs, ArrayList acctParamList) throws EASBizException, BOSException, SQLException, Exception {
        DynamicRowSet resultRs = null;
        BgPeriodCollection bgPeriodCol = LiquidHelper.getBeginAndEndDates(ctx, beginDate, endDate, queryCycle);
        int count = bgPeriodCol.size();
        if (count == 0) {
            throw new LiquidException(LiquidException.NOPERIODS);
        }
        resultRs = this.executeWithSingleThread(ctx, irs, acctParamList, bgPeriodCol);
        return resultRs;
    }

    private IRowSet executeSigleTask(Context ctx, IRowSet rowSet, ArrayList acctParamList, BgPeriodInfo bgPeriodInfo) throws EASBizException, BOSException {
        System.out.println("Thread(" + Thread.currentThread().getName() + ") - " + bgPeriodInfo.getName() + " is runninng ");
        return this.executeAcctRsInfoByAcctAndDate(ctx, bgPeriodInfo.getBeginDate(), bgPeriodInfo.getEndDate(), rowSet, acctParamList, bgPeriodInfo);
    }

    private DynamicRowSet executeWithSingleThread(Context ctx, IRowSet irs, ArrayList acctParamList, BgPeriodCollection bgPeriodCol) throws EASBizException, BOSException, SQLException {
        DynamicRowSet resultRs = null;
        IRowSet rowSet = irs;
        int size = bgPeriodCol.size();
        for (int i = 0; i < size; ++i) {
            BgPeriodInfo bgPeriodInfo = bgPeriodCol.get(i);
            rowSet = this.executeSigleTask(ctx, rowSet, acctParamList, bgPeriodInfo);
            if (i == 0) {
                resultRs = (DynamicRowSet)rowSet.createCopy();
                continue;
            }
            if (resultRs == null) continue;
            resultRs.merge((DynamicRowSet)rowSet.createCopy());
        }
        return resultRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicRowSet executeWithMultiThread(final Context ctx, IRowSet irs, final ArrayList acctParamList, BgPeriodCollection bgPeriodCol) throws InterruptedException, SQLException, ExecutionException {
        int THREAD_COUNT = 8;
        int size = bgPeriodCol.size();
        final ArrayBlockingQueue<IRowSet> datasetQueue = new ArrayBlockingQueue<IRowSet>(size);
        for (int i = 0; i < size; ++i) {
            datasetQueue.put(irs.createCopy());
        }
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        try {
            ExecutorCompletionService<IRowSet> completionService = new ExecutorCompletionService<IRowSet>(executorService);
            for (int i = 0; i < size; ++i) {
                final BgPeriodInfo bgPeriodInfo = bgPeriodCol.get(i);
                completionService.submit(new Callable<IRowSet>(){

                    @Override
                    public IRowSet call() throws Exception {
                        return FundStockFacadeControllerBean.this.executeSigleTask(ctx, (IRowSet)datasetQueue.take(), acctParamList, bgPeriodInfo);
                    }
                });
            }
            DynamicRowSet resultRs = null;
            for (int i = 0; i < size; ++i) {
                IRowSet rowSet = (IRowSet)completionService.take().get();
                if (resultRs == null) {
                    resultRs = (DynamicRowSet)rowSet;
                    continue;
                }
                resultRs.merge((DynamicRowSet)rowSet);
            }
            DynamicRowSet dynamicRowSet = resultRs;
            return dynamicRowSet;
        }
        finally {
            if (!executorService.isShutdown()) {
                executorService.shutdown();
            }
        }
    }

    private IRowSet executeAcctRsInfoByAcctAndDate(Context ctx, java.util.Date beginDate, java.util.Date endDate, IRowSet irs, ArrayList acctParamList, BgPeriodInfo bgPeriodInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        LiquidHelper.printTime("begin getBalancesByAccounts", new java.util.Date());
        Map balanceResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getBalancesByAccounts(acctParamList, DateUtil.getBeforeDay((java.util.Date)beginDate));
        LiquidHelper.printTime("end getBalancesByAccounts", new java.util.Date());
        Map detailResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getDetailsByAccounts(acctParamList, beginDate, endDate);
        LiquidHelper.printTime("end getDetailsByAccounts", new java.util.Date());
        String cashBankName = ResourceBase.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"7_LiquidConstant", (Locale)ctx.getLocale());
        try {
            HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
            while (irs.next()) {
                String accountBankName;
                String key = irs.getString("FAccountBankId") + "1" + irs.getString("FCurrencyId");
                AccountParam acctParamBalance = (AccountParam)balanceResultMap.get(key);
                AccountParam acctParamDetail = (AccountParam)detailResultMap.get(key);
                if (acctParamBalance != null) {
                    BigDecimal initBalance = acctParamBalance.getBalance();
                    BigDecimal localInitBalance = acctParamBalance.getLocalBalance();
                    irs.updateBigDecimal("FBeginingBalance", initBalance);
                    irs.updateBigDecimal("FLocalBeginingBalance", localInitBalance);
                }
                if (acctParamDetail != null) {
                    BigDecimal inAmount = acctParamDetail.getInAmount();
                    BigDecimal outAmount = acctParamDetail.getOutAmount();
                    BigDecimal localInAmount = acctParamDetail.getLocalInAmount();
                    BigDecimal localOutAmount = acctParamDetail.getLocalOutAmount();
                    irs.updateBigDecimal("FIncomeAmount", inAmount);
                    irs.updateBigDecimal("FOutcomeAmount", outAmount);
                    irs.updateBigDecimal("FLocalIncomeAmount", localInAmount);
                    irs.updateBigDecimal("FLocalOutcomeAmount", localOutAmount);
                }
                BigDecimal endBalance = null;
                BigDecimal localEndBalance = null;
                if (acctParamBalance != null && acctParamDetail != null) {
                    BigDecimal exchangeRate;
                    BigDecimal initBalance = acctParamBalance.getBalance();
                    BigDecimal inAmount = acctParamDetail.getInAmount();
                    BigDecimal outAmount = acctParamDetail.getOutAmount();
                    if (initBalance != null) {
                        endBalance = initBalance.add(inAmount).subtract(outAmount);
                    }
                    if ((exchangeRate = (BigDecimal)exchangeRateMap.get(irs.getString("FCurrencyId"))) == null) {
                        exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, irs.getString("FCurrencyId"), currentOrg, endDate);
                        exchangeRateMap.put(irs.getString("FCurrencyId"), exchangeRate);
                    }
                    if (endBalance != null && exchangeRate != null) {
                        localEndBalance = endBalance.multiply(exchangeRate);
                    }
                }
                irs.updateBigDecimal("FEndingBalance", endBalance);
                irs.updateBigDecimal("FLocalEndingBalance", localEndBalance != null ? localEndBalance : BigDecimal.ZERO);
                if (bgPeriodInfo != null) {
                    irs.updateString("FQueryCycleId", bgPeriodInfo.getId().toString());
                    irs.updateString("FQueryCycleName", bgPeriodInfo.getName());
                    irs.updateDate("FQueryCycleBeginDate", new Date(bgPeriodInfo.getBeginDate().getTime()));
                    irs.updateDate("FQueryCycleEndDate", new Date(bgPeriodInfo.getEndDate().getTime()));
                } else {
                    irs.updateString("FQueryCycleName", ResourceBase.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"2_FundStockFacadeControllerBean", (Locale)ctx.getLocale()));
                    irs.updateDate("FQueryCycleBeginDate", new Date(beginDate.getTime()));
                    irs.updateDate("FQueryCycleEndDate", new Date(endDate.getTime()));
                }
                if (EmptyUtil.isEmpty((String)(accountBankName = irs.getString("FAccountBankName")))) continue;
                String bankName = irs.getString("FBankName");
                if (cashBankName.equals(bankName)) {
                    if (accountBankName.startsWith(cashBankName + "-")) continue;
                    irs.updateString("FAccountBankName", cashBankName + "-" + accountBankName);
                    continue;
                }
                String bankAccountNumber = irs.getString("FBankAccountNumber");
                if (EmptyUtil.isEmpty((String)bankAccountNumber)) continue;
                if (bankAccountNumber.length() > 4) {
                    bankAccountNumber = bankAccountNumber.substring(bankAccountNumber.length() - 4);
                }
                if (accountBankName.endsWith("-" + bankAccountNumber)) continue;
                irs.updateString("FAccountBankName", accountBankName + "-" + bankAccountNumber);
            }
            irs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        LiquidHelper.printTime("end executeAcctRsInfoByAcctAndDate", new java.util.Date());
        return irs;
    }

    @Override
    protected IRowSet _getStockAnalysis(Context ctx, Map filterParamMap) throws BOSException, EASBizException {
        IRowSet companyRs4;
        IRowSet companyRs3;
        IRowSet companyRs2;
        IRowSet companyRs1;
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getStockAnalysis", beginTime);
        int queryCycle = 0;
        java.util.Date queryDate = LiquidFacadeHelper.checkDateIsValid(filterParamMap, "queryDate", ResourceBase.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"3_FundStockFacadeControllerBean", (Locale)ctx.getLocale()));
        Object value = filterParamMap.get("queryCycle");
        if (value != null && ((String)value).length() > 0) {
            queryCycle = Integer.parseInt((String)value);
        }
        filterParamMap.put("isFromPc", "true");
        IRowSet irs = LiquidFacadeFactory.getLocalInstance(ctx).getAccountsInfomation(filterParamMap);
        ArrayList acctParamList = LiquidHelper.getAcctParamListByRs(irs, "1");
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getAccountsInfomation", beginTime);
        java.util.Date lastEndingDate = LiquidHelper.getLastBgPeriodDate(ctx, queryDate, queryCycle);
        java.util.Date lastYearPeriodDate = LiquidHelper.getLastBgPeriodDateForYear(ctx, queryDate, queryCycle);
        java.util.Date thisYearBeginDate = LiquidHelper.getFirstDay(queryDate);
        thisYearBeginDate = DateUtil.getBeforeDay((java.util.Date)thisYearBeginDate);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end queryCycle", beginTime);
        IRowSet companyRs = LiquidFacadeFactory.getLocalInstance(ctx).getCompanyInfomation(filterParamMap);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getCompanyInfomation", beginTime);
        try {
            companyRs1 = companyRs.createCopy();
            companyRs2 = companyRs.createCopy();
            companyRs3 = companyRs.createCopy();
            companyRs4 = companyRs.createCopy();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end companyRs.createCopy", beginTime);
        Map stockItemsMap = LiquidFacadeHelper.getStockItems(ctx);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getCompanyBalanceMap", beginTime);
        Map companyBalanceMap = this.getCompanyBalanceMap(ctx, acctParamList, queryDate);
        Map companyBalanceLastEndingMap = this.getCompanyBalanceMap(ctx, acctParamList, lastEndingDate);
        Map companyBalanceLastYearPeriodMap = this.getCompanyBalanceMap(ctx, acctParamList, lastYearPeriodDate);
        Map companyBalanceThisYearBegingMap = this.getCompanyBalanceMap(ctx, acctParamList, thisYearBeginDate);
        DynamicRowSet resultTotalBalance = (DynamicRowSet)this.executeCompanyRsForStockItem(ctx, companyRs, "001", stockItemsMap, companyBalanceMap, companyBalanceLastEndingMap, companyBalanceLastYearPeriodMap, companyBalanceThisYearBegingMap);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getCompanyBalanceMap", beginTime);
        Map safetyStock = this.getSafetyStockMap(ctx, filterParamMap, queryDate);
        Map safetyStockLastEnding = this.getSafetyStockMap(ctx, filterParamMap, lastEndingDate);
        Map safetyStockLastYearPeriod = this.getSafetyStockMap(ctx, filterParamMap, lastYearPeriodDate);
        Map safetyStockThisYearBegin = this.getSafetyStockMap(ctx, filterParamMap, thisYearBeginDate);
        DynamicRowSet resultSafetyStock = (DynamicRowSet)this.executeCompanyRsForStockItem(ctx, companyRs2, "004", stockItemsMap, safetyStock, safetyStockLastEnding, safetyStockLastYearPeriod, safetyStockThisYearBegin);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getSafetyStockMap", beginTime);
        Map limitedBalanceMap = this.getLimitedBalanceMap(ctx, acctParamList, queryDate);
        Map limitedBalanceLastEndingMap = this.getLimitedBalanceMap(ctx, acctParamList, lastEndingDate);
        Map limitedBalanceLastYearPeriodMap = this.getLimitedBalanceMap(ctx, acctParamList, lastYearPeriodDate);
        Map limitedBalanceThisYearBegingMap = this.getLimitedBalanceMap(ctx, acctParamList, thisYearBeginDate);
        DynamicRowSet resultLitmitedBalance = (DynamicRowSet)this.executeCompanyRsForStockItem(ctx, companyRs1, "002", stockItemsMap, limitedBalanceMap, limitedBalanceLastEndingMap, limitedBalanceLastYearPeriodMap, limitedBalanceThisYearBegingMap);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getLimitedBalanceMap", beginTime);
        Map canUsedBalanceMap = this.getSubstractBalanceMap(companyBalanceMap, limitedBalanceMap);
        Map canUsedBalanceLastEndingMap = this.getSubstractBalanceMap(companyBalanceLastEndingMap, limitedBalanceLastEndingMap);
        Map canUsedBalanceLastYearPeriodMap = this.getSubstractBalanceMap(companyBalanceLastYearPeriodMap, limitedBalanceLastYearPeriodMap);
        Map canUsedBalanceThisYearBegingMap = this.getSubstractBalanceMap(companyBalanceThisYearBegingMap, limitedBalanceThisYearBegingMap);
        DynamicRowSet resultCanusedBalance = (DynamicRowSet)this.executeCompanyRsForStockItem(ctx, companyRs3, "003", stockItemsMap, canUsedBalanceMap, canUsedBalanceLastEndingMap, canUsedBalanceLastYearPeriodMap, canUsedBalanceThisYearBegingMap);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end canUsedBalanceMap", beginTime);
        Map surplusOrGapMap = this.getSubstractBalanceMap(canUsedBalanceMap, safetyStock);
        Map surplusOrGapLastEndingMap = this.getSubstractBalanceMap(canUsedBalanceLastEndingMap, safetyStockLastEnding);
        Map surplusOrGapLastYearPeriodMap = this.getSubstractBalanceMap(canUsedBalanceLastYearPeriodMap, safetyStockLastYearPeriod);
        Map surplusOrGapThisYearBegingMap = this.getSubstractBalanceMap(canUsedBalanceThisYearBegingMap, safetyStockThisYearBegin);
        DynamicRowSet surplusOrGap = (DynamicRowSet)this.executeCompanyRsForStockItem(ctx, companyRs4, "005", stockItemsMap, surplusOrGapMap, surplusOrGapLastEndingMap, surplusOrGapLastYearPeriodMap, surplusOrGapThisYearBegingMap);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end surplusOrGapMap", beginTime);
        resultTotalBalance.merge(resultLitmitedBalance);
        resultTotalBalance.merge(resultCanusedBalance);
        resultTotalBalance.merge(resultSafetyStock);
        resultTotalBalance.merge(surplusOrGap);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getStockAnalysis", beginTime);
        return resultTotalBalance;
    }

    private Map getSubstractBalanceMap(Map companyBalanceMap, Map limitedBalanceMap) {
        HashMap<String, BalanceAndLocalBalance> subStractMap = new HashMap<String, BalanceAndLocalBalance>();
        for (Map.Entry entry : companyBalanceMap.entrySet()) {
            String key = (String)entry.getKey();
            BalanceAndLocalBalance balance = (BalanceAndLocalBalance)entry.getValue();
            BalanceAndLocalBalance limit = (BalanceAndLocalBalance)limitedBalanceMap.get(key);
            BalanceAndLocalBalance canUsed = new BalanceAndLocalBalance();
            if (balance.getBalance() != null) {
                if (limit != null && limit.getBalance() != null) {
                    canUsed.setBalance(balance.getBalance().subtract(limit.getBalance()));
                } else {
                    canUsed.setBalance(balance.getBalance());
                }
            }
            if (balance.getLocalBalance() != null) {
                if (limit != null && limit.getLocalBalance() != null) {
                    canUsed.setLocalBalance(balance.getLocalBalance().subtract(limit.getLocalBalance()));
                } else {
                    canUsed.setLocalBalance(balance.getLocalBalance());
                }
            }
            subStractMap.put(key, canUsed);
        }
        return subStractMap;
    }

    private Map getLimitedBalanceMap(Context ctx, ArrayList acctParamList, java.util.Date queryDate) throws EASBizException, BOSException {
        HashMap<String, BalanceAndLocalBalance> companyLimitedBalanceMap = new HashMap<String, BalanceAndLocalBalance>();
        Map limitedResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getLimitBalanceByAccounts(acctParamList, queryDate);
        for (Map.Entry entry : limitedResultMap.entrySet()) {
            BalanceAndLocalBalance balAndLocal;
            AccountParam acctParam = (AccountParam)entry.getValue();
            String key = acctParam.getCompanyId() + acctParam.getCurrencyId();
            if (acctParam.getLimitAmount() != null) {
                if (companyLimitedBalanceMap.get(key) != null) {
                    balAndLocal.setBalance((balAndLocal = (BalanceAndLocalBalance)companyLimitedBalanceMap.get(key)).getBalance() == null ? BigDecimal.ZERO.add(acctParam.getLimitAmount()) : balAndLocal.getBalance().add(acctParam.getLimitAmount()));
                    companyLimitedBalanceMap.put(key, balAndLocal);
                } else {
                    balAndLocal = new BalanceAndLocalBalance();
                    balAndLocal.setBalance(acctParam.getLimitAmount());
                    companyLimitedBalanceMap.put(key, balAndLocal);
                }
            }
            if (acctParam.getLocalLimitAmount() == null) continue;
            if (companyLimitedBalanceMap.get(key) != null) {
                balAndLocal.setLocalBalance((balAndLocal = (BalanceAndLocalBalance)companyLimitedBalanceMap.get(key)).getLocalBalance() == null ? BigDecimal.ZERO.add(acctParam.getLocalLimitAmount()) : balAndLocal.getLocalBalance().add(acctParam.getLocalLimitAmount()));
                companyLimitedBalanceMap.put(key, balAndLocal);
                continue;
            }
            balAndLocal = new BalanceAndLocalBalance();
            balAndLocal.setLocalBalance(acctParam.getLocalLimitAmount());
            companyLimitedBalanceMap.put(key, balAndLocal);
        }
        return companyLimitedBalanceMap;
    }

    private Map getCompanyBalanceMap(Context ctx, ArrayList acctParamList, java.util.Date queryDate) throws EASBizException, BOSException {
        Map balanceResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getBalancesByAccounts(acctParamList, queryDate);
        HashMap<String, BalanceAndLocalBalance> companyBalanceMap = new HashMap<String, BalanceAndLocalBalance>();
        for (Map.Entry entry : balanceResultMap.entrySet()) {
            BalanceAndLocalBalance balAndLocal;
            AccountParam acctParam = (AccountParam)entry.getValue();
            String key = acctParam.getCompanyId() + acctParam.getCurrencyId();
            if (acctParam.getBalance() != null) {
                if (companyBalanceMap.get(key) == null) {
                    balAndLocal = new BalanceAndLocalBalance();
                    balAndLocal.setBalance(acctParam.getBalance());
                    companyBalanceMap.put(key, balAndLocal);
                } else {
                    balAndLocal.setBalance((balAndLocal = (BalanceAndLocalBalance)companyBalanceMap.get(key)).getBalance() == null ? balAndLocal.getBalance() : balAndLocal.getBalance().add(acctParam.getBalance()));
                    companyBalanceMap.put(key, balAndLocal);
                }
            }
            if (acctParam.getLocalBalance() == null) continue;
            if (companyBalanceMap.get(key) == null) {
                balAndLocal = new BalanceAndLocalBalance();
                balAndLocal.setLocalBalance(acctParam.getLocalBalance());
                companyBalanceMap.put(key, balAndLocal);
                continue;
            }
            balAndLocal.setLocalBalance((balAndLocal = (BalanceAndLocalBalance)companyBalanceMap.get(key)).getLocalBalance() == null ? acctParam.getLocalBalance() : balAndLocal.getLocalBalance().add(acctParam.getLocalBalance()));
            companyBalanceMap.put(key, balAndLocal);
        }
        return companyBalanceMap;
    }

    private Map getSafetyStockMap(Context ctx, Map filterParamMap, java.util.Date queryDate) throws EASBizException {
        HashMap<String, BalanceAndLocalBalance> safetyStockMap = new HashMap<String, BalanceAndLocalBalance>();
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("queryDate", LiquidAppConstants.sdf.format(queryDate.getTime()));
            paramMap.put("companyIdSet", (String)filterParamMap.get("parentCompanyId"));
            paramMap.put("currencyIdSet", (String)filterParamMap.get("currencyIdSet"));
            IRowSet rs = LiquidFacadeFactory.getLocalInstance(ctx).getSafetyStock(paramMap);
            while (rs.next()) {
                String key = rs.getString("FCompanyId") + rs.getString("FCurrencyId");
                BalanceAndLocalBalance balAndLocal = new BalanceAndLocalBalance();
                balAndLocal.setBalance(rs.getBigDecimal("famount"));
                balAndLocal.setLocalBalance(rs.getBigDecimal("flocalAmount"));
                safetyStockMap.put(key, balAndLocal);
            }
        }
        catch (BOSException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            LiquidFacadeControllerBean.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return safetyStockMap;
    }

    private BalanceAndLocalBalance getValuesRatio(BalanceAndLocalBalance value1, BalanceAndLocalBalance value2) {
        BalanceAndLocalBalance result = new BalanceAndLocalBalance();
        if (value1 != null && value2 != null) {
            if (value1.getBalance() != null && value2.getBalance() != null && value2.getBalance().compareTo(BigDecimal.ZERO) != 0) {
                result.setBalance(value1.getBalance().subtract(value2.getBalance()).divide(value2.getBalance(), 4, LiquidConstant.roundingMode));
            }
            if (value1.getLocalBalance() != null && value2.getLocalBalance() != null && value2.getLocalBalance().compareTo(BigDecimal.ZERO) != 0) {
                result.setLocalBalance(value1.getLocalBalance().subtract(value2.getLocalBalance()).divide(value2.getLocalBalance(), 4, LiquidConstant.roundingMode));
            }
        }
        return result;
    }

    private IRowSet executeCompanyRsForStockItem(Context ctx, IRowSet irs, String stockItemName, Map stockItemsMap, Map safetyStockMap, Map safetyStockLastEnding, Map safetyStockLastYearPeriod, Map safetyStockThisYearBegin) throws EASBizException {
        try {
            StockItemInfo stockItem;
            if (stockItemsMap != null && stockItemsMap.get(stockItemName) != null) {
                stockItem = (StockItemInfo)stockItemsMap.get(stockItemName);
            } else {
                throw new LiquidException(LiquidException.NOTBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"4_FundStockFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            while (irs.next()) {
                BalanceAndLocalBalance thisYearbalAndLocale;
                BalanceAndLocalBalance lastYearbalAndLocale;
                BalanceAndLocalBalance lastbalAndLocal;
                String key = irs.getString("FCompanyId") + irs.getString("FCurrencyId");
                BalanceAndLocalBalance balAndLocal = (BalanceAndLocalBalance)safetyStockMap.get(key);
                irs.updateString("FStockItemId", stockItem.getId());
                irs.updateString("FStockItemName", stockItem.getName());
                irs.updateString("FStockItemNumber", stockItem.getNumber());
                irs.updateString("FStockItemParentId", stockItem.getParentid());
                if (balAndLocal != null) {
                    irs.updateBigDecimal("FThisEndingBalance", balAndLocal.getBalance());
                    irs.updateBigDecimal("FLocalThisEndingBalance", balAndLocal.getLocalBalance());
                }
                if ((lastbalAndLocal = (BalanceAndLocalBalance)safetyStockLastEnding.get(key)) != null) {
                    irs.updateBigDecimal("FLastEndingBalance", lastbalAndLocal.getBalance());
                    irs.updateBigDecimal("FLocalLastEndingBalance", lastbalAndLocal.getLocalBalance());
                }
                if ((lastYearbalAndLocale = (BalanceAndLocalBalance)safetyStockLastYearPeriod.get(key)) != null) {
                    irs.updateBigDecimal("FLastYearPeriodBalance", lastYearbalAndLocale.getBalance());
                    irs.updateBigDecimal("FLocalLastYearPeriodBalance", lastYearbalAndLocale.getLocalBalance());
                }
                if ((thisYearbalAndLocale = (BalanceAndLocalBalance)safetyStockThisYearBegin.get(key)) == null) continue;
                irs.updateBigDecimal("FThisYearBeginBalance", thisYearbalAndLocale.getBalance());
                irs.updateBigDecimal("FLocalThisYearBeginBalance", thisYearbalAndLocale.getLocalBalance());
            }
            irs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return irs;
    }
}

