/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.AccountParam;
import com.kingdee.eas.fm.liquid.CompanyLiquidInfo;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.LiquidFacadeFactory;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.AbstractMobileLiquidFacadeControllerBean;
import com.kingdee.eas.fm.liquid.app.LiquidAppConstants;
import com.kingdee.eas.fm.liquid.app.LiquidFacadeHelper;
import com.kingdee.eas.fm.liquid.app.MobileFacadeHelper;
import com.kingdee.eas.fm.liquid.app.backcal.util.DateUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MobileLiquidFacadeControllerBean
extends AbstractMobileLiquidFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.MobileLiquidFacadeControllerBean");

    @Override
    protected Map _getCompanyBalanceAndLimtsByCompamy(Context ctx, String conmpanyId, java.util.Date queryDate) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%tF]", conmpanyId, queryDate));
        java.util.Date newQueryDate = DateUtil.fixedDate(queryDate);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(conmpanyId);
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getCompanyBalanceAndLimtsByCompamy", beginTime);
        HashMap<String, CompanyLiquidInfo> resultMap = new HashMap<String, CompanyLiquidInfo>();
        ArrayList companyLiquidList = LiquidFacadeHelper.getCompanyLiquidByIdSet(ctx, idSet);
        CompanyLiquidInfo comLiquidInfo = (CompanyLiquidInfo)companyLiquidList.get(0);
        comLiquidInfo.setQueryDate(newQueryDate);
        BigDecimal totalBalance = BigDecimal.ZERO;
        BigDecimal totalLimited = BigDecimal.ZERO;
        Map balanceResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getBalancesByCompamys(idSet, newQueryDate);
        totalBalance = (BigDecimal)balanceResultMap.get(conmpanyId + "1");
        Map limitedResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getLimitBalanceByCompanys(idSet, newQueryDate);
        totalLimited = (BigDecimal)limitedResultMap.get(conmpanyId + "1");
        comLiquidInfo.setLocalBalance(totalBalance != null ? totalBalance : BigDecimal.ZERO);
        comLiquidInfo.setHaveBalance(totalBalance != null);
        comLiquidInfo.setLocalLimitAmount(totalLimited != null ? totalLimited : BigDecimal.ZERO);
        resultMap.put(conmpanyId, comLiquidInfo);
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getCompanyBalanceAndLimtsByCompamy", beginTime);
        return resultMap;
    }

    @Override
    protected Map _getAllCompanyBalanceAndLimtsByCompamy(Context ctx, String companyId, java.util.Date queryDate) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%tF]", companyId, queryDate));
        HashMap<String, CompanyLiquidInfo> resultMap = new HashMap<String, CompanyLiquidInfo>();
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getAllCompanyBalanceAndLimtsByCompamy", beginTime);
        Set idSet = LiquidFacadeHelper.getAllCompanyById(ctx, companyId);
        if (idSet.size() == 0) {
            return resultMap;
        }
        Map balanceResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getBalancesByCompamys(idSet, queryDate);
        Map limitResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getLimitBalanceByCompanys(idSet, queryDate);
        ArrayList companyLiquidList = LiquidFacadeHelper.getCompanyLiquidByIdSet(ctx, idSet);
        for (int i = 0; i < companyLiquidList.size(); ++i) {
            CompanyLiquidInfo comLiquidInfo = (CompanyLiquidInfo)companyLiquidList.get(i);
            comLiquidInfo.setQueryDate(queryDate);
            BigDecimal totalBalance = (BigDecimal)balanceResultMap.get(comLiquidInfo.getCompanyid() + "1");
            comLiquidInfo.setLocalBalance(totalBalance);
            BigDecimal totalLimitAmount = (BigDecimal)limitResultMap.get(comLiquidInfo.getCompanyid() + "1");
            comLiquidInfo.setLocalLimitAmount(totalLimitAmount);
            resultMap.put(comLiquidInfo.getCompanyid(), comLiquidInfo);
        }
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getAllCompanyBalanceAndLimtsByCompamy", beginTime);
        return resultMap;
    }

    @Override
    protected Map _getAllBankBalanceAndLimtsByCompamy(Context ctx, String companyId, java.util.Date queryDate) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%tF]", companyId, queryDate));
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getAllBankBalanceAndLimtsByCompamy", beginTime);
        HashMap resultMap = new HashMap();
        Set idSet = LiquidFacadeHelper.getAllParentBankById(ctx, companyId);
        idSet.add("cash0000");
        Map balanceMap = LiquidFacadeFactory.getLocalInstance(ctx).getBalancesByOnelvelBankIds(companyId, idSet, queryDate);
        Map limitBalanceMap = LiquidFacadeFactory.getLocalInstance(ctx).getLimitedBalancesByOnelvelBankIds(companyId, idSet, queryDate);
        for (String bankid : idSet) {
            Map oneResultMap = this.getBankBalanceAndLimtsByOneLevelBank(ctx, companyId, queryDate, bankid, balanceMap, limitBalanceMap);
            resultMap.putAll(oneResultMap);
        }
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getAllBankBalanceAndLimtsByCompamy", beginTime);
        return resultMap;
    }

    private Map getBankBalanceAndLimtsByOneLevelBank(Context ctx, String companyId, java.util.Date queryDate, String bankId, Map balanceMap, Map limitBalanceMap) throws EASBizException {
        HashMap<String, CompanyLiquidInfo> resultMap = new HashMap<String, CompanyLiquidInfo>();
        BankInfo bank = LiquidFacadeHelper.getBankById(ctx, bankId);
        CompanyLiquidInfo comLiquidInfo = new CompanyLiquidInfo();
        comLiquidInfo.setCompanyid(companyId);
        comLiquidInfo.setBankId(bankId);
        comLiquidInfo.setQueryDate(queryDate);
        comLiquidInfo.setBankName(bank.getName());
        comLiquidInfo.setBankNumber(bank.getNumber());
        comLiquidInfo.setLeaf(bank.isIsLeaf());
        BigDecimal totalBalance = BigDecimal.ZERO;
        BigDecimal totalLimited = BigDecimal.ZERO;
        String key = companyId + bankId + "1";
        totalBalance = (BigDecimal)balanceMap.get(key);
        totalLimited = (BigDecimal)limitBalanceMap.get(key);
        boolean hasAcct = false;
        if (totalBalance != null) {
            hasAcct = true;
        }
        comLiquidInfo.setLocalBalance(totalBalance != null ? totalBalance : BigDecimal.ZERO);
        comLiquidInfo.setLocalLimitAmount(totalLimited != null ? totalLimited : BigDecimal.ZERO);
        comLiquidInfo.setHasAcct(hasAcct);
        resultMap.put(companyId + bankId, comLiquidInfo);
        return resultMap;
    }

    @Override
    protected Map _getAllAcctBalanceAndLimtsByCompanyAndBank(Context ctx, String companyId, String bankId, java.util.Date queryDate) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%s][%tF]", companyId, bankId, queryDate));
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getAllAcctBalanceAndLimtsByCompanyAndBank", beginTime);
        HashMap<String, CompanyLiquidInfo> resultMap = new HashMap<String, CompanyLiquidInfo>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashSet<String> companyIdSet = new HashSet<String>();
        companyIdSet.add(companyId);
        paramMap.put("companyIdSet", companyIdSet);
        paramMap.put("parentBankId", bankId);
        if (bankId.equals("cash0000")) {
            paramMap.put("isIncludeCash", String.valueOf(true));
            paramMap.put("isIncludeBank", String.valueOf(false));
        } else {
            paramMap.put("isIncludeCash", String.valueOf(false));
            paramMap.put("isIncludeBank", String.valueOf(true));
        }
        IRowSet irs = LiquidFacadeFactory.getLocalInstance(ctx).getAccountsInfomation(paramMap);
        ArrayList acctParamList = LiquidHelper.getAcctParamListByRs(irs, "1");
        Map balanceResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getBalancesByAccounts(acctParamList, queryDate);
        Map limitedResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getLimitBalanceByAccounts(acctParamList, queryDate);
        try {
            while (irs.next()) {
                AccountParam acctParamLimted;
                String key = irs.getString("FAccountBankId") + "1" + irs.getString("FCurrencyId");
                CompanyLiquidInfo comLiquidInfo = LiquidFacadeHelper.getCompanyLiquidById(ctx, companyId);
                comLiquidInfo.setQueryDate(queryDate);
                comLiquidInfo.setBankId(irs.getString("FBankId"));
                comLiquidInfo.setBankName(irs.getString("FBankName"));
                comLiquidInfo.setAccountBankID(irs.getString("FAccountBankId"));
                comLiquidInfo.setAccountBankName(irs.getString("FAccountBankName"));
                comLiquidInfo.setAccountNumber(irs.getString("FBankAccountNumber"));
                comLiquidInfo.setCurrencyId(irs.getString("FCurrencyId"));
                comLiquidInfo.setAcctCurrencyType(irs.getString("acct_currency_type"));
                comLiquidInfo.setSrcCurrencyName(irs.getString("FCurrencyName"));
                comLiquidInfo.setSrcCurrencyIsoCode(irs.getString("FISOCode"));
                comLiquidInfo.setAccountProperty(irs.getString("FPropertyName"));
                AccountParam acctParamBalance = (AccountParam)balanceResultMap.get(key);
                if (acctParamBalance != null) {
                    comLiquidInfo.setBalance(acctParamBalance.getBalance());
                    comLiquidInfo.setLocalBalance(acctParamBalance.getLocalBalance());
                }
                if ((acctParamLimted = (AccountParam)limitedResultMap.get(key)) != null) {
                    if (acctParamLimted.getLimitAmount().compareTo(BigDecimal.ZERO) != 0) {
                        comLiquidInfo.setLimit(true);
                    } else {
                        comLiquidInfo.setLimit(false);
                    }
                    comLiquidInfo.setLimitAmount(acctParamBalance.getLimitAmount());
                    comLiquidInfo.setLocalLimitAmount(acctParamBalance.getLocalLimitAmount());
                }
                resultMap.put(comLiquidInfo.getAccountBankID() + "1" + comLiquidInfo.getCurrencyId(), comLiquidInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getAllAcctBalanceAndLimtsByCompanyAndBank", beginTime);
        return resultMap;
    }

    @Override
    protected Map _getChangeByCompany(Context ctx, String companyId, Set dateSet) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%s]", companyId, Arrays.toString((Object[])dateSet.toArray())));
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getChangeByCompany", beginTime);
        HashMap resultMap = new HashMap();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(companyId);
        Map balanceMap = LiquidFacadeFactory.getLocalInstance(ctx).getCompanyBalancesByDates(companyId, dateSet);
        Map limitBalanceMap = LiquidFacadeFactory.getLocalInstance(ctx).getCompanyLimitBalancesByDates(companyId, dateSet);
        for (java.util.Date date : dateSet) {
            CompanyLiquidInfo comLiquidInfo = new CompanyLiquidInfo();
            comLiquidInfo.setCompanyid(companyId);
            Map oneResultMap = this.getCompanyBalanceAndLimtsByCompamyAndDate(ctx, comLiquidInfo, date, balanceMap, limitBalanceMap);
            resultMap.put(companyId + date, oneResultMap.get(companyId));
        }
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getChangeByCompany", beginTime);
        return resultMap;
    }

    private Map getCompanyBalanceAndLimtsByCompamyAndDate(Context ctx, CompanyLiquidInfo comLiquidInfo, java.util.Date date, Map balanceMap, Map limitBalanceMap) {
        HashMap<String, CompanyLiquidInfo> resultMap = new HashMap<String, CompanyLiquidInfo>();
        comLiquidInfo.setQueryDate(date);
        BigDecimal totalBalance = BigDecimal.ZERO;
        BigDecimal totalLimited = BigDecimal.ZERO;
        String key = LiquidAppConstants.sdf.format(date.getTime()) + "1";
        totalBalance = (BigDecimal)balanceMap.get(key);
        totalLimited = (BigDecimal)limitBalanceMap.get(key);
        comLiquidInfo.setLocalBalance(totalBalance != null ? totalBalance : BigDecimal.ZERO);
        comLiquidInfo.setLocalLimitAmount(totalLimited != null ? totalLimited : BigDecimal.ZERO);
        resultMap.put(comLiquidInfo.getCompanyid(), comLiquidInfo);
        return resultMap;
    }

    @Override
    protected Map _getChangeByBank(Context ctx, String companyId, String bankId, Set dateSet) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%s][%s]", companyId, bankId, Arrays.toString((Object[])dateSet.toArray())));
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getChangeByBank", beginTime);
        HashMap resultMap = new HashMap();
        Set acctIdSet = LiquidFacadeHelper.getAcctIdByCompanyAndBank(ctx, companyId, bankId);
        Map balanceMap = LiquidFacadeFactory.getLocalInstance(ctx).getBalancesByDates(acctIdSet, dateSet);
        Map limitBalanceMap = LiquidFacadeFactory.getLocalInstance(ctx).getLimitBalancesByDates(acctIdSet, dateSet);
        for (java.util.Date date : dateSet) {
            Map oneResultMap = this.getBankBalanceAndLimtsByCompamy(ctx, companyId, bankId, date, balanceMap, limitBalanceMap, acctIdSet);
            resultMap.put(companyId + bankId + date, oneResultMap.get(companyId + bankId));
        }
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getChangeByBank", beginTime);
        return resultMap;
    }

    @Override
    protected Map _getChangeByAcct(Context ctx, String acctId, String currencyId, Set dateSet) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%s][%s]", acctId, currencyId, Arrays.toString((Object[])dateSet.toArray())));
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getChangeByAcct", beginTime);
        HashMap resultMap = new HashMap();
        Map balanceMap = LiquidFacadeFactory.getLocalInstance(ctx).getOneAcctBalancesByDates(acctId, currencyId, dateSet);
        Map limitBalanceMap = LiquidFacadeFactory.getLocalInstance(ctx).getOneAcctLimitBalancesByDates(acctId, currencyId, dateSet);
        for (java.util.Date date : dateSet) {
            Map oneResultMap = this.getAcctBalanceByAcctId(ctx, acctId, currencyId, date, balanceMap, limitBalanceMap);
            resultMap.putAll(oneResultMap);
        }
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getChangeByAcct", beginTime);
        return resultMap;
    }

    private Map getBankBalanceAndLimtsByCompamy(Context ctx, String companyId, String bankId, java.util.Date queryDate, Map balanceMap, Map limitBalanceMap, Set acctIdSet) throws BOSException, EASBizException {
        HashMap<String, CompanyLiquidInfo> resultMap = new HashMap<String, CompanyLiquidInfo>();
        CompanyLiquidInfo comLiquidInfo = new CompanyLiquidInfo();
        comLiquidInfo.setCompanyid(companyId);
        comLiquidInfo.setBankId(bankId);
        comLiquidInfo.setQueryDate(queryDate);
        BigDecimal totalBalance = BigDecimal.ZERO;
        BigDecimal totalLimited = BigDecimal.ZERO;
        String key = LiquidAppConstants.sdf.format(queryDate.getTime()) + "1";
        totalBalance = (BigDecimal)balanceMap.get(key);
        totalLimited = (BigDecimal)limitBalanceMap.get(key);
        boolean hasAcct = false;
        if (acctIdSet.size() > 0) {
            hasAcct = true;
        }
        comLiquidInfo.setLocalBalance(totalBalance != null ? totalBalance : BigDecimal.ZERO);
        comLiquidInfo.setLocalLimitAmount(totalLimited != null ? totalLimited : BigDecimal.ZERO);
        comLiquidInfo.setHasAcct(hasAcct);
        resultMap.put(companyId + bankId, comLiquidInfo);
        return resultMap;
    }

    private Map getAcctBalanceByAcctId(Context ctx, String acctId, String currencyId, java.util.Date queryDate, Map balanceMap, Map limitBalanceMap) throws BOSException, EASBizException {
        HashMap<String, CompanyLiquidInfo> resultMap = new HashMap<String, CompanyLiquidInfo>();
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        ArrayList<AccountParam> acctParamList = new ArrayList<AccountParam>();
        AccountParam acctParam = new AccountParam();
        acctParam.setAcctid(acctId);
        acctParam.setDateType("1");
        acctParam.setCurrencyId(currencyId);
        acctParamList.add(acctParam);
        String key = LiquidAppConstants.sdf.format(queryDate.getTime()) + "1";
        BigDecimal localBalance = (BigDecimal)balanceMap.get(key);
        BigDecimal localLimitedBalance = (BigDecimal)limitBalanceMap.get(key);
        CompanyLiquidInfo comLiquidInfo = new CompanyLiquidInfo();
        comLiquidInfo.setQueryDate(queryDate);
        comLiquidInfo.setAccountBankID(acctId);
        comLiquidInfo.setAccountBankID(acctId);
        comLiquidInfo.setCurrencyId(currencyId);
        comLiquidInfo.setLocalBalance(localBalance != null ? localBalance : BigDecimal.ZERO);
        comLiquidInfo.setLocalLimitAmount(localLimitedBalance != null ? localLimitedBalance : BigDecimal.ZERO);
        resultMap.put(key + queryDate, comLiquidInfo);
        return resultMap;
    }

    @Override
    protected Map _getFundConceration(Context ctx, String companyId, java.util.Date queryDate) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%tF]", companyId, queryDate));
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("motherBalance", BigDecimal.ZERO);
        resultMap.put("subBalance", BigDecimal.ZERO);
        resultMap.put("otherBalance", BigDecimal.ZERO);
        resultMap.put("motherAcctCounts", 0);
        return resultMap;
    }

    private BigDecimal getAcctIdsBalance(Context ctx, java.util.Date queryDate, Set acctIdSet) throws BOSException, EASBizException, LiquidException {
        BigDecimal balance = BigDecimal.ZERO;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("accountBankIds", acctIdSet);
        paramMap.put("isIncludeCash", String.valueOf(false));
        IRowSet irs = LiquidFacadeFactory.getLocalInstance(ctx).getAccountsInfomation(paramMap);
        ArrayList acctParamList = LiquidHelper.getAcctParamListByRs(irs, "1");
        Map balanceResultMap = LiquidFacadeFactory.getLocalInstance(ctx).getBalancesByAccounts(acctParamList, queryDate);
        try {
            while (irs.next()) {
                BigDecimal localnInitBalance;
                String key = irs.getString("FAccountBankId") + "1" + irs.getString("FCurrencyId");
                AccountParam acctParamBalance = (AccountParam)balanceResultMap.get(key);
                if (acctParamBalance == null || (localnInitBalance = acctParamBalance.getLocalBalance()) == null) continue;
                balance = balance.add(localnInitBalance);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return balance;
    }

    @Override
    protected Map _getNewestBizDate(Context ctx, String companyId, java.util.Date queryDate) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%tF]", companyId, queryDate));
        java.util.Date beginTime = new java.util.Date();
        LiquidHelper.printTime("begin getNewestBizDate", beginTime);
        HashMap<String, Date> newestBizDateMap = new HashMap<String, Date>();
        Date newestBizDate = null;
        newestBizDateMap.put("newestBizDate", newestBizDate);
        StringBuffer detailTimeSql = new StringBuffer();
        detailTimeSql.append(" select max(fupdateDate) newestBizDate from ").append("T_Liquid_Process").append("\n");
        logger.debug((Object)("detailTimeSql:" + detailTimeSql));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)detailTimeSql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                newestBizDate = rs.getDate("newestBizDate");
                newestBizDateMap.put("newestBizDate", newestBizDate);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        beginTime = new java.util.Date();
        LiquidHelper.printTime("end getNewestBizDate", beginTime);
        return newestBizDateMap;
    }

    @Override
    protected Map _getCompanyBalanceOrder(Context ctx, String companyId, java.util.Date queryDate) throws BOSException, EASBizException {
        logger.info((Object)String.format("MobileCalledLiquid:[%s][%tF]", companyId, queryDate));
        CompanyOrgUnitInfo currentOrg = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, CompanyLiquidInfo> resultMap = new HashMap<String, CompanyLiquidInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select  a.fcompanyid,a.fcurrencyid,a.fbizdate,a.fbalance,a.ftype,company.fid,company.fname_l2 fcompanyName from ");
        sql.append("( ").append("\n");
        sql.append("  select balance.fcompanyid,balance.fcurrencyid,balance.fbizdate,balance.fbalance,balance.ftype ").append("\n");
        sql.append("  from t_liquid_companybalance as balance   ").append("\n");
        sql.append("  WHERE balance.FBIZDATE ={ts'").append(LiquidAppConstants.sdf.format(queryDate.getTime())).append("'}\n");
        sql.append(") as a  ").append("\n");
        sql.append(" right outer JOIN t_org_company  AS  company   ").append("\n");
        sql.append(" on a.fcompanyid=company.fid ").append("\n");
        sql.append("  where company.fisleaf=1 ").append("\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                CompanyLiquidInfo comLiquidInfo;
                if (rs.getBigDecimal("FBALANCE") == null) {
                    CompanyLiquidInfo comLiquidInfo2 = new CompanyLiquidInfo();
                    comLiquidInfo2.setCompanyid(rs.getString("fcompanyid"));
                    comLiquidInfo2.setCompanyName(rs.getString("fcompanyName"));
                    comLiquidInfo2.setLocalBalance(BigDecimal.ZERO);
                    resultMap.put(rs.getString("fcompanyid"), comLiquidInfo2);
                    continue;
                }
                BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get(rs.getString("FCURRENCYID"));
                if (exchangeRate == null) {
                    exchangeRate = LiquidFacadeHelper.getExRateInfo(ctx, rs.getString("FCURRENCYID"), currentOrg, queryDate);
                    exchangeRateMap.put(rs.getString("FCURRENCYID"), exchangeRate);
                }
                BigDecimal localBalance = exchangeRate != null ? rs.getBigDecimal("FBALANCE").multiply(exchangeRate) : BigDecimal.ZERO;
                if (resultMap.get(rs.getString("fcompanyid")) == null) {
                    comLiquidInfo = new CompanyLiquidInfo();
                    comLiquidInfo.setCompanyid(rs.getString("fcompanyid"));
                    comLiquidInfo.setCompanyName(rs.getString("fcompanyName"));
                    comLiquidInfo.setLocalBalance(localBalance);
                    resultMap.put(rs.getString("fcompanyid"), comLiquidInfo);
                    continue;
                }
                comLiquidInfo = (CompanyLiquidInfo)resultMap.get(rs.getString("fcompanyid"));
                comLiquidInfo.setLocalBalance(comLiquidInfo.getLocalBalance().add(localBalance));
                resultMap.put(rs.getString("fcompanyid"), comLiquidInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LiquidException(LiquidException.GETDATAERROR, e, new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    @Override
    protected void _recalculateBalanceTableForUser(Context ctx) throws BOSException, EASBizException {
        MobileFacadeHelper.createBalanceTableForUser(ctx, new java.util.Date());
    }
}

