/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.backcal.util;

import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.liquid.app.LiquidAppConstants;
import com.kingdee.eas.fm.mobile.util.TimestampSetUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DateUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.app.backcal.util.DateUtil");

    public static Date truncate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date makeDate(String strDate) throws FMException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMException(FMException.COMMMONEXCEPTION, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static ArrayList getDateList(Date date) throws FMException {
        ArrayList<Date> dateList = new ArrayList<Date>();
        TimestampSetUtil setUtil = new TimestampSetUtil(date);
        dateList.addAll(setUtil.getDaysWithMonthOfYear());
        dateList.addAll(setUtil.getDaysWithWeekOfMonth());
        TimestampSetUtil setUtilNow = new TimestampSetUtil(new Date());
        dateList.addAll(setUtilNow.getDaysWithDayOfWeek());
        ArrayList<Date> newDateList = new ArrayList<Date>();
        for (int i = 0; i < dateList.size(); ++i) {
            Date aDate = DateUtil.truncate((Date)dateList.get(i));
            if (newDateList.contains(aDate)) continue;
            newDateList.add(aDate);
        }
        return newDateList;
    }

    public static String buildIn(ArrayList dateList) {
        StringBuffer inSql = new StringBuffer();
        if (dateList.size() == 1) {
            inSql.append("(").append("{").append(LiquidAppConstants.sdf.format(dateList.get(0))).append("})");
        } else {
            for (int i = 0; i < dateList.size(); ++i) {
                if (i == 0) {
                    inSql.append("(").append("{").append(LiquidAppConstants.sdf.format(dateList.get(i))).append("}");
                    continue;
                }
                if (i == dateList.size() - 1) {
                    inSql.append(",{").append(LiquidAppConstants.sdf.format(dateList.get(i))).append("})");
                    continue;
                }
                inSql.append(",{").append(LiquidAppConstants.sdf.format(dateList.get(i))).append("}");
            }
        }
        return inSql.toString();
    }

    public static Date fixedDate(Date date) {
        Date now = new Date();
        if (date.after(now)) {
            return now;
        }
        return date;
    }
}

