/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;

public class LiquidFlowDataSetHelper {
    private static final String PARAM_LIQUID001 = "LIQUID001";
    private static final String SQL_TABLE_FLOW_DETAIL = "CREATE TABLE {0} (FItemId VARCHAR(44),FCompanyId VARCHAR(44),FCurrencyId VARCHAR(44),FCreateDate DATETIME,{1}FIncomeAmount NUMERIC(19,4),FOutcomeAmount NUMERIC(19,4))";
    private static final String SQL_INSERT_FIELD_FLOW_DETAIL = "INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FCreateDate{1},FIncomeAmount,FOutcomeAmount)\n";
    private static final String SQL_DATA_FLOW_DETAIL_FROM_TABLE = "SELECT JOURNAL.FItemId,JOURNAL.FCompanyId,JOURNAL.FCurrencyId,JOURNAL.FCreateDate,{3} \nFROM {0} JOURNAL \nINNER JOIN {2} COMPANY ON JOURNAL.FCompanyId = COMPANY.FID \nINNER JOIN {1} FLOWITEM ON JOURNAL.FItemId = FLOWITEM.FID \n{4}";
    private static final String SQL_DATA_FLOW_DETAIL_AMOUNT_FIELD = "SUM((2 - FLOWITEM.FDirection) * JOURNALFLOW.FAmount) FIncomeAmount,\nSUM((FLOWITEM.FDirection - 1) * JOURNALFLOW.FAmount) FOutcomeAmount \n";
    private static final String SQL_DATA_FLOW_DETAIL_BALANCE_FIELD = "SUM((3 - 2 * FLOWITEM.FDirection) * JOURNALFLOW.FAmount) FIncomeAmount,0.00 FOutcomeAmount \n";
    private static final String SQL_DATA_FLOW_DETAIL_JOURNAL = "SELECT JOURNALFLOW.FFundFlowItemId,JOURNAL.FCompanyId,JOURNAL.FCurrencyId,JOURNAL.FCreateDate{3},\n{4}FROM T_CAS_JOURNAL JOURNAL \nINNER JOIN {2} COMPANY ON JOURNAL.FCompanyId = COMPANY.FID \nINNER JOIN {0} JOURNALFLOW ON JOURNAL.FID = JOURNALFLOW.FParentId \nINNER JOIN {1} FLOWITEM ON JOURNALFLOW.FFundFlowItemId = FLOWITEM.FID \n{5} GROUP BY JOURNALFLOW.FFundFlowItemId,JOURNAL.FCompanyId,JOURNAL.FCurrencyId,JOURNAL.FCreateDate{3}";
    private static final String SQL_INDEX_LIQUID_FLOWDETAIL_FCREATEDATE = "CREATE CLUSTERED INDEX IX_FLOWDETAIL_FCREATEDATE ON {0}(FCreateDate ASC)";
    private static final String SQL_INSERT_FIELD_LIQUID_FLOWDETAIL = "INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FCreateDate,FIncomeAmount,FOutcomeAmount)\nSELECT JOURNALFLOW.FFundFlowItemId,JOURNAL.FCompanyId,JOURNAL.FCurrencyId,JOURNAL.FCreateDate,\nSUM((2 - FLOWITEM.FDirection) * JOURNALFLOW.FAmount) FIncomeAmount,\nSUM((FLOWITEM.FDirection - 1) * JOURNALFLOW.FAmount) FOutcomeAmount \nFROM T_CAS_JOURNAL JOURNAL \nINNER JOIN {1} JOURNALFLOW ON JOURNAL.FID = JOURNALFLOW.FParentId \nINNER JOIN {2} FLOWITEM ON JOURNALFLOW.FFundFlowItemId = FLOWITEM.FID \n{3}GROUP BY JOURNALFLOW.FFundFlowItemId,JOURNAL.FCompanyId,JOURNAL.FCurrencyId,JOURNAL.FCreateDate";
    private static final String SQL_MAX_BIZDATE_LIQUID_FLOWDETAIL = "SELECT MAX(FCreateDate) FROM {0}";
    private static final String SQL_DELETE_BY_BIZDATE = "DELETE FROM {0} WHERE FCreateDate >= {1}";
    private static final String SQL_TABLE_FLOWITEM = "CREATE TABLE {0} (FId VARCHAR(44),FName_{1} NVARCHAR(80),FNumber NVARCHAR(255),FLongNumber NVARCHAR(255),FIsLeaf NUMERIC(4),FLevel NUMERIC(4),FParentId VARCHAR(44),FDirection NUMERIC(4),FProperty NUMERIC(4),FState NUMERIC(4),FItemType NUMERIC(4) DEFAULT 0, CONSTRAINT PK_{2} PRIMARY KEY (FId))";
    private static final String SQL_INSERT_FIELD_FLOWITEM = "INSERT INTO {0} (FID,FName_{1},FNumber,FLongNumber,FIsLeaf,FLevel,FParentId,FDirection,FProperty,FState,FItemType)\n";
    private static final String SQL_INSERT_VALUES_FLOWITEM = "VALUES (''{0}'', ''{1}'', ''{2}'', ''{2}'', 1, 1, NULL, 0, 4, 1, {3});\n";
    private static final String SQL_FLOWITEM_DATA = "SELECT FID,FName_{1},FNumber,FLongNumber,FIsLeaf,FLevel,FParentId,FDirection,FProperty,FState,0 FItemType FROM {0} ";

    public static int getParamLiquid001Value(Context ctx) throws BOSException, EASBizException {
        int beforeDays = 0;
        OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
        if (currentOrgUnit != null) {
            ObjectUuidPK orgUnitID = new ObjectUuidPK(currentOrgUnit.getId());
            String beforeDaysValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)orgUnitID, (String)PARAM_LIQUID001);
            if (beforeDaysValue != null && Integer.parseInt(beforeDaysValue) > 0) {
                beforeDays = Integer.parseInt(beforeDaysValue);
            }
        } else {
            beforeDays = 10000;
        }
        return beforeDays;
    }

    private static String getFilterSql(String filterSql) {
        String filter = filterSql.trim();
        if (filter.length() > 0) {
            if (filter.startsWith("AND")) {
                filter = filter.replaceFirst("AND", "");
            }
            filter = "WHERE" + filter + "\n";
        }
        return filter;
    }

    private static String createFlowDetailTable(Context ctx, String tableName, String extraFields) throws BOSException, EASBizException {
        String flowDetailTable = !EmptyUtil.isEmpty((String)tableName) ? tableName : LiquidDataSetHelper.getTemporaryTableName(ctx, "FLOW_DETAIL");
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_FLOW_DETAIL, flowDetailTable, StringUtils.cnulls((String)extraFields)));
        return flowDetailTable;
    }

    private static String getFlowDetailFromFlowDetailTable(Context ctx, Map<String, Object> filterParamMap, String filterSql, String companyTable, boolean isQueryBalance) throws BOSException, EASBizException {
        String flowDetailTable = LiquidFlowDataSetHelper.createFlowDetailTable(ctx, null, "");
        String insertSql = MessageFormat.format(SQL_INSERT_FIELD_FLOW_DETAIL, flowDetailTable, "");
        String amountFields = !isQueryBalance ? "JOURNAL.FIncomeAmount,JOURNAL.FOutcomeAmount" : "JOURNAL.FIncomeAmount - JOURNAL.FOutcomeAmount, 0.00";
        Object[] args = new Object[]{"T_LIQUID_FLOWDETAIL", "T_CAS_FUNDFLOWITEM", companyTable, amountFields, LiquidFlowDataSetHelper.getFilterSql(filterSql)};
        String sql = insertSql + MessageFormat.format(SQL_DATA_FLOW_DETAIL_FROM_TABLE, args);
        LiquidDataSetHelper.execute(ctx, sql);
        return flowDetailTable;
    }

    private static String getFlowDetailFromJournal(Context ctx, Map<String, Object> filterParamMap, String filterSql, String companyTable, Object extraFields, boolean isQueryBalance) throws BOSException, EASBizException {
        String[] fields = new String[]{};
        if (!EmptyUtil.isEmpty((Object)extraFields)) {
            fields = extraFields.toString().split(",");
        }
        StringBuilder createFields = new StringBuilder();
        StringBuilder insertFields = new StringBuilder();
        StringBuilder groupFields = new StringBuilder();
        for (String field : fields) {
            if (field.equals("FOppUnit")) {
                createFields.append("FOppUnit NVARCHAR(80),");
                insertFields.append(",FOppUnit");
                groupFields.append(",JOURNAL.FOppUnit");
                continue;
            }
            if (!field.equals("FBillId")) continue;
            createFields.append("FBillId VARCHAR(44),");
            insertFields.append(",FBillId");
            groupFields.append(",JOURNAL.FId");
        }
        String flowDetailTable = LiquidFlowDataSetHelper.createFlowDetailTable(ctx, null, createFields.toString());
        String insertSql = MessageFormat.format(SQL_INSERT_FIELD_FLOW_DETAIL, flowDetailTable, insertFields.toString());
        String amountFields = !isQueryBalance ? SQL_DATA_FLOW_DETAIL_AMOUNT_FIELD : SQL_DATA_FLOW_DETAIL_BALANCE_FIELD;
        Object[] args = new Object[]{"T_CAS_JOURNALFLOWITEMS", "T_CAS_FUNDFLOWITEM", companyTable, groupFields.toString(), amountFields, LiquidFlowDataSetHelper.getFilterSql(filterSql)};
        String sql = insertSql + MessageFormat.format(SQL_DATA_FLOW_DETAIL_JOURNAL, args);
        LiquidDataSetHelper.execute(ctx, sql);
        return flowDetailTable;
    }

    public static String getFlowDetailTable(Context ctx, Map<String, Object> filterParamMap, String filterSql, String companyTable) throws BOSException, EASBizException {
        boolean isQueryBalance;
        boolean isFlowDetailTable = LiquidFlowDataSetHelper.getParamLiquid001Value(ctx) > 0;
        Object extraFields = filterParamMap.get("extraFields");
        Object queryBalanceObj = filterParamMap.get("isQueryBalance");
        boolean bl = isQueryBalance = queryBalanceObj != null && Boolean.valueOf(queryBalanceObj.toString()) != false;
        if (isFlowDetailTable && EmptyUtil.isEmpty((Object)extraFields) && LiquidDataSetHelper.getTableManagerFacade(ctx).existTable("T_LIQUID_FLOWDETAIL")) {
            return LiquidFlowDataSetHelper.getFlowDetailFromFlowDetailTable(ctx, filterParamMap, filterSql, companyTable, isQueryBalance);
        }
        return LiquidFlowDataSetHelper.getFlowDetailFromJournal(ctx, filterParamMap, filterSql, companyTable, extraFields, isQueryBalance);
    }

    public static void initFlowDetailTable(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        int beforeDays = LiquidFlowDataSetHelper.getParamLiquid001Value(ctx);
        if (beforeDays == 0) {
            return;
        }
        if (LiquidDataSetHelper.getTableManagerFacade(ctx).existTable("T_LIQUID_FLOWDETAIL")) {
            LiquidFlowDataSetHelper.insertFlowDetailTable(ctx, beforeDays);
        } else {
            LiquidFlowDataSetHelper.createFlowDetailTable(ctx, "T_LIQUID_FLOWDETAIL", "");
            String sql = MessageFormat.format(SQL_INDEX_LIQUID_FLOWDETAIL_FCREATEDATE, "T_LIQUID_FLOWDETAIL");
            LiquidDataSetHelper.execute(ctx, sql);
            sql = MessageFormat.format(SQL_INSERT_FIELD_LIQUID_FLOWDETAIL, "T_LIQUID_FLOWDETAIL", "T_CAS_JOURNALFLOWITEMS", "T_CAS_FUNDFLOWITEM", "");
            LiquidDataSetHelper.execute(ctx, sql);
        }
    }

    private static void insertFlowDetailTable(Context ctx, int beforeDays) throws BOSException {
        String sql = MessageFormat.format(SQL_MAX_BIZDATE_LIQUID_FLOWDETAIL, "T_LIQUID_FLOWDETAIL");
        IRowSet rowset = LiquidDataSetHelper.executeQuery(ctx, sql);
        Date maxDate = null;
        try {
            if (rowset.first()) {
                maxDate = rowset.getDate(1);
            }
            String filter = "";
            if (maxDate != null) {
                String dateString = LiquidDataSetHelper.dateFormat(DateUtil.getNextDay((java.util.Date)maxDate, (int)(-1 * beforeDays)));
                sql = MessageFormat.format(SQL_DELETE_BY_BIZDATE, "T_LIQUID_FLOWDETAIL", dateString);
                LiquidDataSetHelper.execute(ctx, sql);
                filter = MessageFormat.format("WHERE JOURNAL.FCreateDate >= {0} \n", dateString);
            }
            sql = MessageFormat.format(SQL_INSERT_FIELD_LIQUID_FLOWDETAIL, "T_LIQUID_FLOWDETAIL", "T_CAS_JOURNALFLOWITEMS", "T_CAS_FUNDFLOWITEM", filter);
            LiquidDataSetHelper.execute(ctx, sql);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getInsertFlowItemSql(String id, String name, String longNumber, int type) {
        return MessageFormat.format(SQL_INSERT_VALUES_FLOWITEM, id, name, longNumber, 1);
    }

    public static String createFlowItemTable(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String currentLocaleString = BOSLocaleUtil.getDefaultLocale().getLanguage();
        String flowItemTable = LiquidDataSetHelper.getTemporaryTableName(ctx, "LIQUID_FLOWITEM");
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_FLOWITEM, flowItemTable, currentLocaleString, flowItemTable.substring(4)));
        StringBuilder sqlBuilder = new StringBuilder();
        String insertSql = MessageFormat.format(SQL_INSERT_FIELD_FLOWITEM, flowItemTable, currentLocaleString);
        String sql = MessageFormat.format(SQL_FLOWITEM_DATA, "T_CAS_FUNDFLOWITEM", currentLocaleString);
        sqlBuilder.append(insertSql).append(sql).append(";\n");
        String name = LiquidHelper.getLiquidResource(ctx, "FLOWITEM_NETWORTH");
        sqlBuilder.append(insertSql).append(LiquidFlowDataSetHelper.getInsertFlowItemSql("FLOWITEM003", name, "ZZ1002", 2));
        name = LiquidHelper.getLiquidResource(ctx, "FLOWITEM_BEGINING_BALANCE");
        sqlBuilder.append(insertSql).append(LiquidFlowDataSetHelper.getInsertFlowItemSql("FLOWITEM004", name, "ZZ1003", 3));
        name = LiquidHelper.getLiquidResource(ctx, "FLOWITEM_ENDING_BALANCE");
        sqlBuilder.append(insertSql).append(LiquidFlowDataSetHelper.getInsertFlowItemSql("FLOWITEM005", name, "ZZ1004", 4));
        LiquidDataSetHelper.execute(ctx, sqlBuilder.toString());
        return flowItemTable;
    }
}

