/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow.mobile;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.fm.liquid.app.flow.AbstractFlowMobileDataSetTemplet;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;

public class FlowSubFlowItemDataSet
extends AbstractFlowMobileDataSetTemplet {
    private static final String SQL_FILTER_FLOWITEM = "EXISTS(SELECT FLOWITEM.FID FROM {1} FLOWITEM WHERE {0}.FItemId=FLOWITEM.FID AND FLOWITEM.FLevel >= {2})";
    private static final String SQL_TABLE_FLOW_PERIOD_SUM = "CREATE TABLE {0} (FItemId VARCHAR(44),FLocalIncomeAmount NUMERIC(19,4),FLocalOutcomeAmount NUMERIC(19,4),FLocalLastYearPeriodIncoming NUMERIC(19,4),FLocalLastYearPeriodOutcoming NUMERIC(19,4))";
    private static final String SQL_INSERT_FLOW_PERIOD_SUM = "INSERT INTO {0} (FItemId,FLocalIncomeAmount,FLocalOutcomeAmount,FLocalLastYearPeriodIncoming,FLocalLastYearPeriodOutcoming)\n";
    private static final String SQL_DATA_FLOW_PERIOD_SUM = "SELECT DETAIL.FItemId \n, SUM(CASE FPERIODTYPE WHEN 1 THEN FIncomeAmount ELSE 0 END * EXRATE.FExchangeRate) FLocalIncomeAmount \n, SUM(CASE FPERIODTYPE WHEN 1 THEN FOutcomeAmount ELSE 0 END * EXRATE.FExchangeRate) FLocalOutcomeAmount \n, SUM(CASE FPERIODTYPE WHEN 3 THEN FIncomeAmount ELSE 0 END * EXRATE.FExchangeRate) FLocalLastYearPeriodIncoming \n, SUM(CASE FPERIODTYPE WHEN 3 THEN FOutcomeAmount ELSE 0 END * EXRATE.FExchangeRate) FLocalLastYearPeriodOutcoming \nFROM {1} DETAIL \nLEFT JOIN {2} EXRATE ON DETAIL.FCurrencyId = EXRATE.FCurrencyId \nGROUP BY DETAIL.FItemId";
    private static final String SQL_FLOW_DATA = "SELECT FLOWITEM.FID FFlowItemId, FLOWITEM.FName_{2} FFlowItemName, FLOWITEM.FLongNumber FFlowItemNumber, FLOWITEM.FIsLeaf FFlowItemIsLeaf, FLOWITEM.FDirection FFlowItemDirection, FLOWITEM.FLevel FFlowItemLevel\n, DETAIL.FLocalIncomeAmount FLocalIncomeAmount, DETAIL.FLocalOutcomeAmount FLocalOutcomeAmount,DETAIL.FLocalLastYearPeriodIncoming FLocalLastYearPeriodIncoming,DETAIL.FLocalLastYearPeriodOutcoming FLocalLastYearPeriodOutcoming\nFROM {0} DETAIL \nINNER JOIN {1} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID \nORDER BY FLOWITEM.FLongNumber";

    @Override
    protected String getFilterSql(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        BgPeriodInfo periodInfo;
        String filter = super.getFilterSql(ctx, filterParamMap);
        StringBuilder filterBuilder = new StringBuilder(filter);
        String beginDateString = (String)filterParamMap.get("beginDate");
        String endDateString = (String)filterParamMap.get("endDate");
        int queryCycle = Integer.parseInt((String)filterParamMap.get("queryCycle"));
        Date lastPeriodBeginDate = LiquidHelper.getLastBgPeriodDateForYear(ctx, DateUtil.stringToDate((String)beginDateString), queryCycle);
        if (lastPeriodBeginDate != null && (periodInfo = LiquidHelper.getBgPeriodInfoByDateAndCycle(ctx, lastPeriodBeginDate, queryCycle)) != null) {
            beginDateString = DateUtil.DateToString((Date)periodInfo.getBeginDate());
        }
        this.getDateFilterSql(filterBuilder, beginDateString, endDateString);
        return filterBuilder.toString();
    }

    @Override
    protected String getFlowPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable) throws BOSException, EASBizException {
        String flowPeriodTable = this.periodTypeHandler.createFlowPeriodTable(ctx);
        this.periodTypeHandler.insertThisPeriodData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        this.periodTypeHandler.insertLastYearPeriodData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumData(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        this.periodTypeHandler.summarizeDataByFlowItem(ctx, flowPeriodTable, filterParamMap, 100);
        this.periodTypeHandler.summarizeDataByCompany(ctx, flowPeriodTable, this.getCompanyTable(ctx, filterParamMap), filterParamMap);
        this.deleteNotNeedData(ctx, filterParamMap, flowPeriodTable);
        return flowPeriodTable;
    }

    private void deleteNotNeedData(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        String flowItemParentId;
        StringBuilder filterBuilder = new StringBuilder();
        String companyId = (String)filterParamMap.get("parentCompanyId");
        CoreBaseInfo orgInfo = LiquidCompanyHelper.getOrgInfo(ctx, companyId);
        if (!LiquidCompanyHelper.isOrgLeaf(ctx, orgInfo)) {
            filterBuilder.append("FCompanyId <> '").append(orgInfo.getId().toString()).append("'");
        }
        if (!EmptyUtil.isEmpty((String)(flowItemParentId = (String)filterParamMap.get("flowParentItemId")))) {
            FundFlowItemInfo flowItemInfo = LiquidCompanyHelper.getFlowItemInfo(ctx, flowItemParentId);
            if (!flowItemInfo.isIsLeaf()) {
                if (filterBuilder.length() > 0) {
                    filterBuilder.append(" OR ");
                }
                filterBuilder.append("FItemId = '").append(flowItemParentId).append("'");
                String filter = MessageFormat.format(SQL_FILTER_FLOWITEM, flowPeriodTable, "T_CAS_FUNDFLOWITEM", new Integer(flowItemInfo.getLevel() + 2));
                filterBuilder.append(" OR ").append(filter);
            }
        } else {
            String filter = MessageFormat.format(SQL_FILTER_FLOWITEM, flowPeriodTable, "T_CAS_FUNDFLOWITEM", new Integer(2));
            if (filterBuilder.length() > 0) {
                filterBuilder.append(" OR ");
            }
            filterBuilder.append(filter);
        }
        if (filterBuilder.length() > 0) {
            String sql = MessageFormat.format("DELETE FROM {0} WHERE {1}", flowPeriodTable, filterBuilder.toString());
            LiquidDataSetHelper.execute(ctx, sql);
        }
    }

    @Override
    protected String getFlowSumDataByPeriodType(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable, String exchangeRateTable) throws BOSException, EASBizException {
        String flowDataTable = LiquidDataSetHelper.getTemporaryTableName(ctx, "SQL_TABLE_FLOW_PERIOD");
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_FLOW_PERIOD_SUM, flowDataTable));
        String sql = MessageFormat.format("INSERT INTO {0} (FItemId,FLocalIncomeAmount,FLocalOutcomeAmount,FLocalLastYearPeriodIncoming,FLocalLastYearPeriodOutcoming)\nSELECT DETAIL.FItemId \n, SUM(CASE FPERIODTYPE WHEN 1 THEN FIncomeAmount ELSE 0 END * EXRATE.FExchangeRate) FLocalIncomeAmount \n, SUM(CASE FPERIODTYPE WHEN 1 THEN FOutcomeAmount ELSE 0 END * EXRATE.FExchangeRate) FLocalOutcomeAmount \n, SUM(CASE FPERIODTYPE WHEN 3 THEN FIncomeAmount ELSE 0 END * EXRATE.FExchangeRate) FLocalLastYearPeriodIncoming \n, SUM(CASE FPERIODTYPE WHEN 3 THEN FOutcomeAmount ELSE 0 END * EXRATE.FExchangeRate) FLocalLastYearPeriodOutcoming \nFROM {1} DETAIL \nLEFT JOIN {2} EXRATE ON DETAIL.FCurrencyId = EXRATE.FCurrencyId \nGROUP BY DETAIL.FItemId", flowDataTable, flowPeriodTable, exchangeRateTable);
        LiquidDataSetHelper.execute(ctx, sql);
        return flowDataTable;
    }

    @Override
    protected String getQueryFlowSql(Context ctx, Map<String, Object> filterParamMap, String flowSumDataTable, String exchangeRateTable) throws BOSException, EASBizException {
        return MessageFormat.format(SQL_FLOW_DATA, flowSumDataTable, "T_CAS_FUNDFLOWITEM", LiquidDataSetHelper.getCurrentLanguage(ctx));
    }
}

