/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.fm.liquid.app.flow.AbstractFlowDataSetTemplet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FlowIODetailDataSet
extends AbstractFlowDataSetTemplet {
    private boolean isDiffYear;
    private static final String SQL_FILTER_SUB_FLOWITEM = " AND EXISTS(SELECT FLOWITEM1.FID FROM {0} FLOWITEM1 WHERE CHARINDEX(FLOWITEM1.FLongNumber,FLOWITEM.FLongNumber) >= 1 AND FLOWITEM1.FID IN {1})";
    private static final String SQL_TABLE_FLOW_PERIOD_SUM = "CREATE TABLE {0} (FItemId VARCHAR(44),FCompanyId VARCHAR(44),FCurrencyId VARCHAR(44),FOppUnit NVARCHAR(80),FThisEndingBalance NUMERIC(19,4),FThisYearEndBalance NUMERIC(19,4))";
    private static final String SQL_INSERT_FLOW_PERIOD_SUM = "INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FOppUnit,FThisEndingBalance,FThisYearEndBalance)\n";
    private static final String SQL_DATA_FLOW_CURRENT_YEAR = ", 0.00 FThisYearEndBalance \n";
    private static final String SQL_DATA_FLOW_CURRENT_YEAR_SUM = ",SUM(CASE FPERIODTYPE WHEN 2 THEN (FIncomeAmount + FOutcomeAmount) ELSE 0 END) FThisYearEndBalance \n";
    private static final String SQL_DATA_FLOW_PERIOD_SUM = "SELECT FItemId,FCompanyId,FCurrencyId,FOppUnit \n,SUM(CASE FPERIODTYPE WHEN 1 THEN (FIncomeAmount + FOutcomeAmount)  ELSE 0 END) FThisEndingBalance \n{2}FROM {1} \nGROUP BY FItemId,FCompanyId,FCurrencyId,FOppUnit";
    private static final String SQL_FLOW_DATA = "SELECT FLOWITEM.FID FFlowItemId\n, FLOWITEM.FName_{4} FFlowItemName\n, FLOWITEM.FNumber FFlowItemNumber\n, FLOWITEM.FParentId FFlowItemParentId\n, FLOWITEM.FIsLeaf FFlowItemIsLeaf\n, FLOWITEM.FLevel FFlowItemLevel\n, COMPANY.FID FCompanyId\n, COMPANY.FName_{4} FCompanyName\n, COMPANY.FLongNumber FCompanyLongNumber\n, COMPANY.FParentId FCompanyParentId\n, COMPANY.FIsLeaf FCompanyIsLeaf\n, COMPANY.FLevel FCompanyLevel\n, CURRENCY.FID FCurrencyId\n, CURRENCY.FName_{4} FCurrencyName\n, CURRENCY.FNumber FCurrencyNumber\n, DETAIL.FOppUnit FOppUnit\n, DETAIL.FThisEndingBalance FThisEndingBalance\n, DETAIL.FThisEndingBalance * EXRATE.FExchangeRate FLocalThisEndingBalance\n, DETAIL.FThisYearEndBalance FThisYearEndBalance\n, DETAIL.FThisYearEndBalance * EXRATE.FExchangeRate FLocalThisYearEndBalance\nFROM {0} DETAIL \nINNER JOIN {1} COMPANY ON DETAIL.FCompanyId = COMPANY.FID \nINNER JOIN T_BD_CURRENCY CURRENCY ON DETAIL.FCurrencyId = CURRENCY.FID \nINNER JOIN {2} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID \nLEFT JOIN {3} EXRATE ON DETAIL.FCurrencyId = EXRATE.FCurrencyId";

    @Override
    protected String getFilterSql(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String filter = super.getFilterSql(ctx, filterParamMap);
        StringBuilder filterBuilder = new StringBuilder(filter);
        String beginDateString = (String)filterParamMap.get("beginDate");
        String endDateString = (String)filterParamMap.get("endDate");
        String isDiffYearString = (String)filterParamMap.get("isDiffYear");
        this.isDiffYear = "true".equalsIgnoreCase(isDiffYearString);
        if (!this.isDiffYear) {
            beginDateString = DateUtil.DateToString((Date)DateUtil.getFirstYearDate((Date)DateUtil.stringToDate((String)beginDateString)));
        }
        this.getDateFilterSql(filterBuilder, beginDateString, endDateString);
        Set flowItemIdSet = (Set)filterParamMap.get("flowItemIdSet");
        if (!EmptyUtil.isEmpty((Collection)flowItemIdSet)) {
            String sql = MessageFormat.format(SQL_FILTER_SUB_FLOWITEM, "T_CAS_FUNDFLOWITEM", FMHelper.setTran2String((Set)flowItemIdSet));
            filterBuilder.append(sql);
        }
        return filterBuilder.toString();
    }

    @Override
    protected String getFlowPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable) throws BOSException, EASBizException {
        HashMap<String, String> extendFields = new HashMap<String, String>();
        extendFields.put("FOppUnit", "NVARCHAR(80)");
        this.periodTypeHandler.setCustomMapFields(extendFields);
        String flowPeriodTable = this.periodTypeHandler.createFlowPeriodTable(ctx);
        this.periodTypeHandler.insertThisPeriodData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        if (!this.isDiffYear) {
            this.periodTypeHandler.insertThisYearData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        }
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumData(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        String queryType = (String)filterParamMap.get("queryType");
        if ("1".equals(queryType)) {
            this.periodTypeHandler.summarizeNetWorthByCompany(ctx, flowPeriodTable, this.getCompanyTable(ctx, filterParamMap), filterParamMap);
        } else if ("2".equals(queryType)) {
            this.periodTypeHandler.summarizeDataByCompany(ctx, flowPeriodTable, this.getCompanyTable(ctx, filterParamMap), filterParamMap);
        }
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumDataByPeriodType(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        String flowDataTable = LiquidDataSetHelper.getTemporaryTableName(ctx, "SQL_TABLE_FLOW_PERIOD");
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_FLOW_PERIOD_SUM, flowDataTable));
        String currentYearData = !this.isDiffYear ? SQL_DATA_FLOW_CURRENT_YEAR_SUM : SQL_DATA_FLOW_CURRENT_YEAR;
        String sql = MessageFormat.format("INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FOppUnit,FThisEndingBalance,FThisYearEndBalance)\nSELECT FItemId,FCompanyId,FCurrencyId,FOppUnit \n,SUM(CASE FPERIODTYPE WHEN 1 THEN (FIncomeAmount + FOutcomeAmount)  ELSE 0 END) FThisEndingBalance \n{2}FROM {1} \nGROUP BY FItemId,FCompanyId,FCurrencyId,FOppUnit", flowDataTable, flowPeriodTable, currentYearData);
        LiquidDataSetHelper.execute(ctx, sql);
        return flowDataTable;
    }

    @Override
    protected String getQueryFlowSql(Context ctx, Map<String, Object> filterParamMap, String flowSumDataTable, String exchangeRateTable) throws BOSException, EASBizException {
        return MessageFormat.format(SQL_FLOW_DATA, flowSumDataTable, this.getCompanyTable(ctx, filterParamMap), "T_CAS_FUNDFLOWITEM", exchangeRateTable, LiquidDataSetHelper.getCurrentLanguage(ctx));
    }
}

