/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.app.flow.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.liquid.app.dataset.LiquidDataSetHelper;
import com.kingdee.eas.fm.liquid.app.flow.AbstractFlowDataSetTemplet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class FlowWarnDataSet
extends AbstractFlowDataSetTemplet {
    private boolean isDiffYear;
    private static final String SQL_FLOWITEM_IO_FILTER = "AND FLOWITEM1.FDIRECTION = 0 AND FLOWITEM1.FIsLeaf = 0";
    private static final String SQL_FLOWITEM_FILTER = " AND (EXISTS(SELECT FLOWITEM1.FID FROM {0} FLOWITEM1 WHERE CHARINDEX(FLOWITEM1.FLongNumber,FLOWITEM.FLongNumber) >= 1 {1}))";
    private static final String SQL_TABLE_FLOW_PERIOD_SUM = "CREATE TABLE {0} (FItemId VARCHAR(44),FCompanyId VARCHAR(44),FCurrencyId VARCHAR(44),FIncomeAmount NUMERIC(19,4),FOutcomeAmount NUMERIC(19,4),FThisYearIncoming NUMERIC(19,4),FThisYearOutcoming NUMERIC(19,4))";
    private static final String SQL_INSERT_FLOW_PERIOD_SUM = "INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FIncomeAmount,FOutcomeAmount,FThisYearIncoming,FThisYearOutcoming)\n";
    private static final String SQL_DATA_FLOW_CURRENT_YEAR = ", 0.00 FThisYearIncoming , 0.00 FThisYearOutcoming \n";
    private static final String SQL_DATA_FLOW_CURRENT_YEAR_SUM = ", SUM(CASE FPeriodType WHEN 2 THEN FIncomeAmount ELSE 0 END) FThisYearIncoming \n, SUM(CASE FPeriodType WHEN 2 THEN FOutcomeAmount ELSE 0 END) FThisYearOutcoming \n";
    private static final String SQL_DATA_FLOW_PERIOD_SUM = "SELECT FItemId,FCompanyId,FCurrencyId \n, SUM(CASE FPeriodType WHEN 1 THEN FIncomeAmount ELSE 0 END) FIncomeAmount \n, SUM(CASE FPeriodType WHEN 1 THEN FOutcomeAmount ELSE 0 END) FOutcomeAmount \n{2}FROM {1} \nGROUP BY FItemId,FCompanyId,FCurrencyId";
    private static final String SQL_FLOW_DATA = "SELECT FLOWITEM.FID FFlowItemId\n, FLOWITEM.FName_{4} FFlowItemName\n, FLOWITEM.FNumber FFlowItemNumber\n, FLOWITEM.FParentId FFlowItemParentId\n, FLOWITEM.FIsLeaf FFlowItemIsLeaf\n, FLOWITEM.FLevel FFlowItemLevel\n, FLOWITEM.FProperty FFlowItemProperty\n, COMPANY.FID FCompanyId\n, COMPANY.FName_{4} FCompanyName\n, COMPANY.FLongNumber FCompanyLongNumber\n, COMPANY.FParentId FCompanyParentId\n, COMPANY.FIsLeaf FCompanyIsLeaf\n, COMPANY.FLevel FCompanyLevel\n, CURRENCY.FID FCurrencyId\n, CURRENCY.FName_{4} FCurrencyName\n, CURRENCY.FNumber FCurrencyNumber\n, DETAIL.FIncomeAmount FIncomeAmount\n, DETAIL.FOutcomeAmount FOutcomeAmount\n, DETAIL.FIncomeAmount * EXRATE.FExchangeRate FLocalIncomeAmount\n, DETAIL.FOutcomeAmount * EXRATE.FExchangeRate FLocalOutcomeAmount\n, CASE WHEN DETAIL.FIncomeAmount = 0 THEN 0 ELSE DETAIL.FOutcomeAmount/DETAIL.FIncomeAmount END FLinkRelativeRatio\n, CASE WHEN DETAIL.FIncomeAmount = 0 AND DETAIL.FOutcomeAmount <> 0 THEN 1 ELSE 0 END FOVERRATIO \n, DETAIL.FThisYearIncoming FThisYearIncoming\n, DETAIL.FThisYearOutcoming FThisYearOutcoming\n, DETAIL.FThisYearIncoming * EXRATE.FExchangeRate FLocalThisYearIncoming\n, DETAIL.FThisYearOutcoming * EXRATE.FExchangeRate FLocalThisYearOutcoming\n, CASE WHEN DETAIL.FThisYearIncoming = 0 THEN 0 ELSE DETAIL.FThisYearOutcoming/DETAIL.FThisYearIncoming END FCurrentYearRatio\n, CASE WHEN DETAIL.FThisYearIncoming = 0 AND DETAIL.FThisYearOutcoming <> 0 THEN 1 ELSE 0 END FCURRENTYEAROVERRATIO \nFROM {0} DETAIL \nINNER JOIN {1} COMPANY ON DETAIL.FCompanyId = COMPANY.FID \nINNER JOIN T_BD_CURRENCY CURRENCY ON DETAIL.FCurrencyId = CURRENCY.FID \nINNER JOIN {2} FLOWITEM ON DETAIL.FItemId = FLOWITEM.FID \nLEFT JOIN {3} EXRATE ON DETAIL.FCurrencyId = EXRATE.FCurrencyId \nWHERE {5}";

    private void getFlowItemFilter(Map<String, Object> filterParamMap, StringBuilder filterBuilder) {
        StringBuilder flowItemBuilder = new StringBuilder();
        Set flowItemIdSet = (Set)filterParamMap.get("flowItemIdSet");
        if (EmptyUtil.isEmpty((Collection)flowItemIdSet)) {
            flowItemBuilder.append(SQL_FLOWITEM_IO_FILTER);
        } else {
            flowItemBuilder.append(" AND FLOWITEM1.FID IN ").append(FMHelper.setTran2String((Set)flowItemIdSet));
        }
        filterBuilder.append(MessageFormat.format(SQL_FLOWITEM_FILTER, "T_CAS_FUNDFLOWITEM", flowItemBuilder.toString()));
    }

    @Override
    protected String getFilterSql(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String filter = super.getFilterSql(ctx, filterParamMap);
        StringBuilder filterBuilder = new StringBuilder(filter);
        String beginDateString = (String)filterParamMap.get("beginDate");
        String endDateString = (String)filterParamMap.get("endDate");
        String isDiffYearString = (String)filterParamMap.get("isDiffYear");
        this.isDiffYear = "true".equalsIgnoreCase(isDiffYearString);
        if (!this.isDiffYear) {
            beginDateString = DateUtil.DateToString((Date)DateUtil.getFirstYearDate((Date)DateUtil.stringToDate((String)beginDateString)));
        }
        this.getDateFilterSql(filterBuilder, beginDateString, endDateString);
        this.getFlowItemFilter(filterParamMap, filterBuilder);
        return filterBuilder.toString();
    }

    @Override
    protected String getFlowPeriodData(Context ctx, Map<String, Object> filterParamMap, String flowDetailTable) throws BOSException, EASBizException {
        String flowPeriodTable = this.periodTypeHandler.createFlowPeriodTable(ctx);
        this.periodTypeHandler.insertThisPeriodData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        if (!this.isDiffYear) {
            this.periodTypeHandler.insertThisYearData(ctx, filterParamMap, flowDetailTable, flowPeriodTable);
        }
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumData(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        int maxFlowItemLevel = 1;
        Set flowItemIdSet = (Set)filterParamMap.get("flowItemIdSet");
        if (!EmptyUtil.isEmpty((Collection)flowItemIdSet)) {
            maxFlowItemLevel = 100;
        }
        this.periodTypeHandler.summarizeDataByFlowItem(ctx, flowPeriodTable, filterParamMap, maxFlowItemLevel);
        this.periodTypeHandler.summarizeDataByCompany(ctx, flowPeriodTable, this.getCompanyTable(ctx, filterParamMap), filterParamMap);
        return flowPeriodTable;
    }

    @Override
    protected String getFlowSumDataByPeriodType(Context ctx, Map<String, Object> filterParamMap, String flowPeriodTable) throws BOSException, EASBizException {
        String flowDataTable = LiquidDataSetHelper.getTemporaryTableName(ctx, "SQL_TABLE_FLOW_PERIOD");
        LiquidDataSetHelper.execute(ctx, MessageFormat.format(SQL_TABLE_FLOW_PERIOD_SUM, flowDataTable));
        String currentYearData = !this.isDiffYear ? SQL_DATA_FLOW_CURRENT_YEAR_SUM : SQL_DATA_FLOW_CURRENT_YEAR;
        String sql = MessageFormat.format("INSERT INTO {0} (FItemId,FCompanyId,FCurrencyId,FIncomeAmount,FOutcomeAmount,FThisYearIncoming,FThisYearOutcoming)\nSELECT FItemId,FCompanyId,FCurrencyId \n, SUM(CASE FPeriodType WHEN 1 THEN FIncomeAmount ELSE 0 END) FIncomeAmount \n, SUM(CASE FPeriodType WHEN 1 THEN FOutcomeAmount ELSE 0 END) FOutcomeAmount \n{2}FROM {1} \nGROUP BY FItemId,FCompanyId,FCurrencyId", flowDataTable, flowPeriodTable, currentYearData);
        LiquidDataSetHelper.execute(ctx, sql);
        return flowDataTable;
    }

    @Override
    protected String getQueryFlowSql(Context ctx, Map<String, Object> filterParamMap, String flowSumDataTable, String exchangeRateTable) throws BOSException, EASBizException {
        StringBuilder filterBuilder = new StringBuilder();
        Set flowItemIdSet = (Set)filterParamMap.get("flowItemIdSet");
        if (!EmptyUtil.isEmpty((Collection)flowItemIdSet)) {
            filterBuilder.append("FLOWITEM.FID IN ").append(FMHelper.setTran2String((Set)flowItemIdSet));
        } else {
            filterBuilder.append("FLOWITEM.FDirection = 0 AND FLOWITEM.FIsLeaf = 0");
        }
        return MessageFormat.format(SQL_FLOW_DATA, flowSumDataTable, this.getCompanyTable(ctx, filterParamMap), "T_CAS_FUNDFLOWITEM", exchangeRateTable, LiquidDataSetHelper.getCurrentLanguage(ctx), filterBuilder.toString());
    }
}

