/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.common.CapitalHelper;
import com.kingdee.eas.fm.mobile.util.LiquidDetailVo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalWarningHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.common.CapitalWarningHelper");

    public Map getInitData(Context ctx) throws BOSException, EASBizException {
        Map<String, Object> result = new HashMap<String, Object>();
        Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "CAPITAL_STORE_USE");
        if (idSet.size() == 0) {
            result.put("error", 1);
            result.put("errorMsg", "\u8be5\u7528\u6237\u65e0\u4efb\u4f55\u8d22\u52a1\u7ec4\u7ec7\u7684\u8d44\u91d1\u5b58\u91cf\u53ca\u6d41\u6c34\u67e5\u8be2\u6743\u9650");
        } else {
            List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
            CompanyOrgUnitInfo company = null;
            if (companyList.size() == 1) {
                company = companyList.get(0);
            }
            if (companyList.size() > 1) {
                company = CapitalHelper.getDefaultCompany(ctx, companyList);
            }
            if (company != null) {
                String companyId = company.getId().toString();
                String currencyId = company.getBaseCurrency().getId().toString();
                java.util.Date today = new java.util.Date();
                result = this.getDataByFilter(ctx, companyId, currencyId, today, today, BigDecimal.ZERO);
            }
            result.put("idSet", idSet);
        }
        return result;
    }

    public Map getDataByFilter(Context ctx, String companyId, String currencyId, java.util.Date startDate, java.util.Date endDate, BigDecimal amount) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String startDateS = df.format(startDate);
            startDate = df.parse(startDateS);
            String endDateS = df.format(endDate);
            endDate = df.parse(endDateS);
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            List payList = this.getPayList(ctx, company, currencyId, startDate, endDate, amount);
            List recList = this.getRecList(ctx, company, currencyId, startDate, endDate, amount);
            result.put("currency", currency);
            result.put("company", company);
            result.put("startDate", startDateS);
            result.put("endDate", endDateS);
            result.put("amount", amount);
            result.put("payList", payList);
            result.put("recList", recList);
        }
        catch (Exception e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>>\u5f02\u5e38\u63d0\u793a");
            logger.error((Object)e);
            result.put("error", 1);
            result.put("errorMsg", e);
            return result;
        }
        return result;
    }

    protected List getPayList(Context ctx, CompanyOrgUnitInfo company, String currencyId, java.util.Date startDate, java.util.Date endDate, BigDecimal amount) throws BOSException, EASBizException {
        ArrayList<LiquidDetailVo> List2 = new ArrayList<LiquidDetailVo>();
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT top 100 pay,bizdate,opp,desciption,companyName FROM ( ");
        sb.append("  (SELECT top 100  t0.FDEBITAMOUNT  pay,t0.FBIZTIME bizdate,t0.FOPPUNIT opp,t0.FDESCRIPTION desciption, main.FNAME_L2 companyName");
        sb.append("  FROM  T_ORG_COMPANY main ");
        sb.append("  left join T_BE_TRANSDETAIL t0 on main.fid=t0.fcompanyid ");
        sb.append("  left join T_BD_AccountBanks t1 on t0.FBANKACCOUNTID = t1.FID ");
        sb.append("  where  t0.FISDEBIT =1 and t0.FDEBITAMOUNT is not null and t1.FISSETBANKINTERFACE = 1 and");
        sb.append(this.commonFilter(startDate, endDate));
        sb.append("  order by t0.FDEBITAMOUNT desc ) ");
        sb.append(" union all");
        sb.append("  (SELECT top 100 t0.FCREDITAMOUNT pay ,t0.FBIZDATE bizdate,t0.FOPPUNIT opp,t0.FDESCRIPTION desciption, main.FNAME_L2 companyName");
        sb.append("  FROM T_ORG_COMPANY main");
        sb.append("  left join T_CAS_JOURNAL t0 on main.fid=t0.FCOMPANYID");
        sb.append("  left join T_BD_AccountBanks t1 on t0.FACCOUNTBANKID = t1.FID ");
        sb.append("  where  t0.FISDEBIT =0 and t1.FISSETBANKINTERFACE = 0 and ");
        sb.append(this.commonFilter(startDate, endDate));
        sb.append("  order by t0.FCREDITAMOUNT desc ) ");
        sb.append("  ) t ");
        sb.append("  where pay >= " + amount.toPlainString());
        sb.append("  order by pay desc");
        Object[] param = this.getParam(company, currencyId, startDate, endDate);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        try {
            while (rs.next()) {
                BigDecimal pay = rs.getBigDecimal("pay") == null ? BigDecimal.ZERO : rs.getBigDecimal("pay");
                Date bizDate = rs.getDate("bizdate");
                String opp = rs.getString("opp");
                String desc = rs.getString("desciption");
                String companyName = rs.getString("companyName");
                LiquidDetailVo vo = new LiquidDetailVo();
                vo.setPayOrRec("pay");
                vo.setAmount(pay);
                vo.setBizDate(bizDate);
                vo.setOppUnit(opp);
                vo.setDesc(desc);
                if (!company.isIsLeaf()) {
                    vo.setCompanyName(companyName);
                }
                List2.add(vo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return List2;
    }

    protected List getRecList(Context ctx, CompanyOrgUnitInfo company, String currencyId, java.util.Date startDate, java.util.Date endDate, BigDecimal amount) throws BOSException, EASBizException {
        ArrayList<LiquidDetailVo> List2 = new ArrayList<LiquidDetailVo>();
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT top 100 rec,bizdate,opp,desciption,companyName FROM ( ");
        sb.append("  (SELECT top 100  t0.FCREDITAMOUNT  rec,t0.FBIZTIME bizdate,t0.FOPPUNIT opp,t0.FDESCRIPTION desciption, main.FNAME_L2 companyName");
        sb.append("  FROM  T_ORG_COMPANY main ");
        sb.append("  left join T_BE_TRANSDETAIL t0 on main.fid=t0.fcompanyid ");
        sb.append("  left join T_BD_AccountBanks t1 on t0.FBANKACCOUNTID = t1.FID ");
        sb.append("  where  t0.FISDEBIT =0 and t0.FCREDITAMOUNT is not null and t1.FISSETBANKINTERFACE = 1 and ");
        sb.append(this.commonFilter(startDate, endDate));
        sb.append("  order by t0.FCREDITAMOUNT desc ) ");
        sb.append(" union all");
        sb.append("  (SELECT top 100 t0.FDEBITAMOUNT rec ,t0.FBIZDATE bizdate,t0.FOPPUNIT opp,t0.FDESCRIPTION desciption, main.FNAME_L2 companyName ");
        sb.append("  FROM T_ORG_COMPANY main");
        sb.append("  left join T_CAS_JOURNAL t0 on main.fid=t0.FCOMPANYID");
        sb.append("  left join T_BD_AccountBanks t1 on t0.FACCOUNTBANKID = t1.FID ");
        sb.append("  where  t0.FISDEBIT =1 and t1.FISSETBANKINTERFACE = 0 and ");
        sb.append(this.commonFilter(startDate, endDate));
        sb.append("  order by t0.FDEBITAMOUNT desc ) ");
        sb.append("  ) t ");
        sb.append("  where rec >= " + amount.toPlainString());
        sb.append("  order by rec desc");
        Object[] param = this.getParam(company, currencyId, startDate, endDate);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        try {
            while (rs.next()) {
                BigDecimal rec = rs.getBigDecimal("rec") == null ? BigDecimal.ZERO : rs.getBigDecimal("rec");
                Date bizDate = rs.getDate("bizdate");
                String opp = rs.getString("opp");
                String desc = rs.getString("desciption");
                String companyName = rs.getString("companyName");
                LiquidDetailVo vo = new LiquidDetailVo();
                vo.setPayOrRec("rec");
                vo.setAmount(rec);
                vo.setBizDate(bizDate);
                vo.setOppUnit(opp);
                vo.setDesc(desc);
                if (!company.isIsLeaf()) {
                    vo.setCompanyName(companyName);
                }
                List2.add(vo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return List2;
    }

    protected String commonFilter(java.util.Date startDate, java.util.Date endDate) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ( main.flongnumber LIKE ? or main.fid = ? ) ");
        sb.append(" and main.fISFREEZE=0 and main.fIsSealUp=0");
        if (startDate.compareTo(endDate) == 0) {
            sb.append("  and t0.FBIZDATE =? ");
        } else {
            sb.append("  and t0.FBIZDATE >=? and t0.FBIZDATE <=? ");
        }
        sb.append(" and t0.FCURRENCYID =? ");
        return sb.toString();
    }

    protected Object[] getParam(CompanyOrgUnitInfo company, String currencyId, java.util.Date startDate, java.util.Date endDate) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (startDate.compareTo(endDate) == 0) {
            params.add(company.getLongNumber() + "!%");
            params.add(company.getId().toString());
            params.add(new Timestamp(startDate.getTime()));
            params.add(currencyId);
            params.add(company.getLongNumber() + "!%");
            params.add(company.getId().toString());
            params.add(new Timestamp(startDate.getTime()));
            params.add(currencyId);
        } else {
            params.add(company.getLongNumber() + "!%");
            params.add(company.getId().toString());
            params.add(new Timestamp(startDate.getTime()));
            params.add(new Timestamp(endDate.getTime()));
            params.add(currencyId);
            params.add(company.getLongNumber() + "!%");
            params.add(company.getId().toString());
            params.add(new Timestamp(startDate.getTime()));
            params.add(new Timestamp(endDate.getTime()));
            params.add(currencyId);
        }
        return params.toArray();
    }
}

