/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.IFundFlowItem;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LiquidCompanyHelper {
    private static OrgStructureInfo getOrgStructureInfo(Context ctx, String companyId, String structureId) throws BOSException, EASBizException {
        IOrgStructure orgStructure = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
        if (EmptyUtil.isEmpty((String)structureId)) {
            return orgStructure.getOrgStructureInfo("where unit = '" + companyId + "'");
        }
        return orgStructure.getOrgStructureInfo((IObjectPK)new ObjectUuidPK(structureId));
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        ICompanyOrgUnit companyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
    }

    public static FullOrgUnitInfo getFullOrgUnitInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        IFullOrgUnit fullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        return fullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
    }

    public static CoreBaseInfo getOrgInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        BOSObjectType bosType = BOSUuid.read((String)companyId).getType();
        if (bosType.equals((Object)new CompanyOrgUnitInfo().getBOSType())) {
            return LiquidCompanyHelper.getCompanyOrgUnitInfo(ctx, companyId);
        }
        if (bosType.equals((Object)new FullOrgUnitInfo().getBOSType())) {
            FullOrgUnitInfo fullOrgUnitInfo = LiquidCompanyHelper.getFullOrgUnitInfo(ctx, companyId);
            if (fullOrgUnitInfo.isIsCompanyOrgUnit()) {
                return LiquidCompanyHelper.getCompanyOrgUnitInfo(ctx, companyId);
            }
            if (fullOrgUnitInfo.isIsUnion()) {
                return LiquidCompanyHelper.getOrgStructureInfo(ctx, companyId, null);
            }
            return fullOrgUnitInfo;
        }
        if (bosType.equals((Object)new OrgStructureInfo().getBOSType())) {
            return LiquidCompanyHelper.getOrgStructureInfo(ctx, null, companyId);
        }
        return null;
    }

    public static CoreBaseInfo getOrgUnitInfo(Context ctx, String orgId) throws BOSException, EASBizException {
        BOSObjectType bosType = BOSUuid.read((String)orgId).getType();
        if (bosType.equals((Object)new CompanyOrgUnitInfo().getBOSType())) {
            return LiquidCompanyHelper.getCompanyOrgUnitInfo(ctx, orgId);
        }
        if (bosType.equals((Object)new FullOrgUnitInfo().getBOSType())) {
            FullOrgUnitInfo fullOrgUnitInfo = LiquidCompanyHelper.getFullOrgUnitInfo(ctx, orgId);
            if (fullOrgUnitInfo.isIsCompanyOrgUnit()) {
                return LiquidCompanyHelper.getCompanyOrgUnitInfo(ctx, orgId);
            }
            return fullOrgUnitInfo;
        }
        if (bosType.equals((Object)new OrgStructureInfo().getBOSType())) {
            OrgStructureInfo structureInfo = LiquidCompanyHelper.getOrgStructureInfo(ctx, null, orgId);
            return LiquidCompanyHelper.getFullOrgUnitInfo(ctx, structureInfo.getUnit().getId().toString());
        }
        return null;
    }

    public static boolean isOrgLeaf(Context ctx, CoreBaseInfo orgInfo) throws BOSException, EASBizException {
        return orgInfo.getBoolean("isLeaf");
    }

    public static int getOrgLevel(Context ctx, CoreBaseInfo orgInfo) throws BOSException, EASBizException {
        return orgInfo.getInt("level");
    }

    public static String getOrgLongNumber(Context ctx, CoreBaseInfo orgInfo) throws BOSException, EASBizException {
        return orgInfo.getString("longNumber");
    }

    public static boolean isOrgLeaf(Context ctx, String companyId) throws BOSException, EASBizException {
        return LiquidCompanyHelper.isOrgLeaf(ctx, LiquidCompanyHelper.getOrgInfo(ctx, companyId));
    }

    public static int getOrgLevel(Context ctx, String companyId) throws BOSException, EASBizException {
        return LiquidCompanyHelper.getOrgLevel(ctx, LiquidCompanyHelper.getOrgInfo(ctx, companyId));
    }

    public static String getOrgLongNumber(Context ctx, String companyId) throws BOSException, EASBizException {
        return LiquidCompanyHelper.getOrgLongNumber(ctx, LiquidCompanyHelper.getOrgInfo(ctx, companyId));
    }

    public static CompanyOrgUnitInfo getLocalCompanyInfo(Context ctx, Map<String, Object> filterParamMap) throws BOSException, EASBizException {
        String companyId = null;
        CompanyOrgUnitInfo companyInfo = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)ctx);
        companyId = !EmptyUtil.isEmpty((CoreBaseInfo)companyInfo) ? companyInfo.getId().toString() : (String)filterParamMap.get("parentCompanyId");
        return LiquidCompanyHelper.getCompanyOrgUnitInfo(ctx, companyId);
    }

    public static FundFlowItemInfo getFlowItemInfo(Context ctx, String flowItemId) throws BOSException, EASBizException {
        IFundFlowItem iflowItem = ctx == null ? FundFlowItemFactory.getRemoteInstance() : FundFlowItemFactory.getLocalInstance((Context)ctx);
        return iflowItem.getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(flowItemId));
    }

    private static IPermission getPermissionInterface(Context ctx) throws BOSException {
        IPermission iPermission = null;
        iPermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        return iPermission;
    }

    public static OrgTreeCollection getAllUnionTrees(Context ctx, String userId, Date date) throws EASBizException, BOSException {
        if (userId == null) {
            return new OrgTreeCollection();
        }
        OrgTreeCollection trees = null;
        IPermission iPermission = LiquidCompanyHelper.getPermissionInterface(ctx);
        ObjectStringPK pk = new ObjectStringPK(userId);
        trees = date == null ? iPermission.getAllUnionTrees((IObjectPK)pk) : iPermission.getAllUnionTrees((IObjectPK)pk, new Timestamp(date.getTime()));
        return trees;
    }

    public static Set<String> getUnionUnitOfTree(Context ctx, String userId, String orgTreeId, Date date) throws EASBizException, BOSException {
        HashSet<String> orgUnionTrees = new HashSet<String>();
        if (userId == null) {
            return orgUnionTrees;
        }
        IPermission iPermission = LiquidCompanyHelper.getPermissionInterface(ctx);
        ObjectStringPK userPk = new ObjectStringPK(userId);
        ObjectStringPK orgTreePk = new ObjectStringPK(orgTreeId);
        if (date == null) {
            orgUnionTrees.addAll(iPermission.getUnionUnits((IObjectPK)userPk, (IObjectPK)orgTreePk).keySet());
        } else {
            orgUnionTrees.addAll(iPermission.getUnionUnits((IObjectPK)userPk, (IObjectPK)orgTreePk, new Timestamp(date.getTime())).keySet());
        }
        return orgUnionTrees;
    }

    public static Set<String> getAuthorizedOrg(Context ctx, String userId, String orgTreeId, String permItemName) throws EASBizException, BOSException {
        FullOrgUnitCollection companys;
        HashSet<String> authUnionOrgIds = new HashSet<String>();
        if (userId == null) {
            return authUnionOrgIds;
        }
        IPermission iPermission = LiquidCompanyHelper.getPermissionInterface(ctx);
        ObjectStringPK userPk = new ObjectStringPK(userId);
        ObjectStringPK treeOrgPk = null;
        if (orgTreeId != null) {
            treeOrgPk = new ObjectStringPK(orgTreeId);
        }
        if (EmptyUtil.isEmpty((String)permItemName)) {
            IMetaDataPK uiPK = null;
            IMetaDataPK actionPK = null;
            companys = iPermission.getAuthorizedOrg((IObjectPK)userPk, OrgType.Company, (IObjectPK)treeOrgPk, uiPK, actionPK);
        } else {
            companys = iPermission.getAuthorizedOrg((IObjectPK)userPk, OrgType.Company, (IObjectPK)treeOrgPk, permItemName);
        }
        int size = companys.size();
        for (int i = 0; i < size; ++i) {
            authUnionOrgIds.add(companys.get(i).getId().toString());
        }
        return authUnionOrgIds;
    }
}

