/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowCollection;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowInfo;
import com.kingdee.eas.fm.mnt.IForecastedBlockingFlowGenerator;
import com.kingdee.eas.fm.mnt.SourceTypeEnum;
import java.util.Date;

public class LGForecastedBlockingFlowGenerator
implements IForecastedBlockingFlowGenerator {
    @Override
    public ForecastedBlockingFlowCollection genForecastedBlockingFlowColl(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("entrys.*");
        selectors.add("company.id");
        selectors.add("company.name");
        selectors.add("Institution.id");
        selectors.add("Institution.name");
        selectors.add("BlockFlowType.*");
        selectors.add("BlockFlowType.id");
        selectors.add("BlockFlowType.IsInFlow");
        LetterOfGuaranteeInfo srcInfo = LetterOfGuaranteeFactory.getLocalInstance((Context)ctx).getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(billId), selectors);
        if (srcInfo.isIsExposure()) {
            if (srcInfo.getBlockFlowType() == null) {
                return new ForecastedBlockingFlowCollection();
            }
            if (srcInfo.getGuaranteeDate() != null && !FinUtils.dayAfterEquals((Date)srcInfo.getGuaranteeDate(), (Date)DateUtil.getDayBegin())) {
                return new ForecastedBlockingFlowCollection();
            }
        } else {
            if (srcInfo.getBlockFlowType() == null) {
                return new ForecastedBlockingFlowCollection();
            }
            if (srcInfo.getExpiredDate() != null && !FinUtils.dayAfterEquals((Date)srcInfo.getExpiredDate(), (Date)DateUtil.getDayBegin())) {
                return new ForecastedBlockingFlowCollection();
            }
        }
        ForecastedBlockingFlowCollection destColl = new ForecastedBlockingFlowCollection();
        String billTypeName = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityAlias(srcInfo.getId().toString());
        ForecastedBlockingFlowInfo destInfo = new ForecastedBlockingFlowInfo();
        destInfo.setNumber(srcInfo.getNumber());
        destInfo.setAmount(srcInfo.getAmount());
        destInfo.setOriginalAmount(srcInfo.getAmount());
        destInfo.setBillId(srcInfo.getId().toString());
        destInfo.setCompany(srcInfo.getCompany());
        destInfo.setCounterPart(srcInfo.getInstitution().getName());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setDescription(billTypeName + srcInfo.getNumber());
        destInfo.setExchangeRate(srcInfo.getLocalCurExRate());
        destInfo.setExpectedDate(srcInfo.getExpiredDate());
        destInfo.setIsInsider(false);
        destInfo.setIsInFlow(srcInfo.getBlockFlowType().isIsInFlow());
        destInfo.setRegion(srcInfo.getRegion());
        destInfo.setSourceType(SourceTypeEnum.system);
        destInfo.setBlockFlowType(srcInfo.getBlockFlowType());
        destColl.add(destInfo);
        return destColl;
    }
}

