/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.mnt.DepositInControlInfo;
import com.kingdee.eas.fm.mnt.app.AbstractDepositInControlControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public class DepositInControlControllerBean
extends AbstractDepositInControlControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.DepositInControlControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, (IObjectValue)((CoreBaseInfo)model));
        DepositInControlInfo info = (DepositInControlInfo)model;
        this._checkNumberDup(ctx, pk, (IObjectValue)info);
        this.verify(ctx, model);
        return pk;
    }

    protected void verify(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"Bank");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"BankAcct");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"BeginDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"EndDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"Region");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"Currency");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)info, (String)"Amount");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)info, (String)"ExchageRate");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)info, (String)"LocalAmount");
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DepositInControlInfo info = this.getDepositInControlInfo(ctx, pk);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DepositInControlInfo info = (DepositInControlInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }
}

