/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowCollection;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowFactory;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowGeneratorFactory;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowInfo;
import com.kingdee.eas.fm.mnt.IForecastedBlockingFlowGenerator;
import com.kingdee.eas.fm.mnt.app.AbstractForecastedBlockingFlowControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class ForecastedBlockingFlowControllerBean
extends AbstractForecastedBlockingFlowControllerBean {
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ForecastedBlockingFlowInfo info = (ForecastedBlockingFlowInfo)model;
        this.verify(ctx, info);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    private void verify(Context ctx, ForecastedBlockingFlowInfo fbfInfo) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)fbfInfo, (String)"ExpectedDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)fbfInfo, (String)"BlockFlowType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)fbfInfo, (String)"Region");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)fbfInfo, (String)"Currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)fbfInfo, (String)"CounterPart");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)fbfInfo, (String)"Amount");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)fbfInfo, (String)"ExchangeRate");
    }

    @Override
    protected void _deleteForecastedBlockingFlow(Context ctx, BOSUuid srcBillId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillId", (Object)srcBillId));
        ForecastedBlockingFlowFactory.getLocalInstance(ctx).delete(filter);
    }

    @Override
    protected void _genForecastedBlockingFlow(Context ctx, BOSUuid billId, String generatorName) throws BOSException, EASBizException {
        if (billId == null) {
            throw new BOSException("billId can not empty!");
        }
        if (FMHelper.isEmpty((String)generatorName)) {
            throw new BOSException("generatorName can not empty!");
        }
        IForecastedBlockingFlowGenerator generator = ForecastedBlockingFlowGeneratorFactory.getInstance(generatorName);
        this._deleteForecastedBlockingFlow(ctx, billId);
        ForecastedBlockingFlowCollection coll = generator.genForecastedBlockingFlowColl(ctx, billId.toString());
        for (int i = 0; i < coll.size(); ++i) {
            this.submit(ctx, (CoreBaseInfo)coll.get(i));
        }
    }

    private String getNextNumber(Context ctx, String number) throws EASBizException, BOSException {
        int i = 0;
        String tmp = number;
        while (this.existsNumber(ctx, tmp)) {
            tmp = number + i;
            ++i;
        }
        return tmp;
    }

    private boolean existsNumber(Context ctx, String num) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)num));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId()));
        return this._exists(ctx, filter);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ForecastedBlockingFlowInfo info = (ForecastedBlockingFlowInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            throw new FSException(FSException.SETTLEBILLNUMBERNULL);
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ForecastedBlockingFlowInfo info = this.getForecastedBlockingFlowInfo(ctx, pk);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _editForecastBlockingFlow(Context ctx, BOSUuid billId, BigDecimal amount) throws BOSException, EASBizException {
        if (billId == null || amount == null) {
            throw new BOSException("billId or amount is empty!");
        }
        if (amount.compareTo(Constants.ZERO) > 0) {
            try {
                this.doAmountBigThanZero(ctx, billId, amount);
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (amount.compareTo(Constants.ZERO) < 0) {
            try {
                this.doAmountLessThanZero(ctx, billId, amount);
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void doAmountLessThanZero(Context ctx, BOSUuid billId, BigDecimal amount) throws BOSException, SQLException {
        String sql = "Select FID,FExpectedDate,FAmount ,FOriginalAmount from T_MNT_ForecastedBlockingFlow  where FBillId= ? order by FExpectedDate desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId.toString()});
        amount = amount.abs();
        StringBuffer sqlUpdate1 = null;
        StringBuffer sqlUpdate2 = null;
        while (rs.next()) {
            if (rs.getBigDecimal("FOriginalAmount").compareTo(rs.getBigDecimal("FAmount")) == 0) continue;
            if (rs.getBigDecimal("FOriginalAmount").compareTo(rs.getBigDecimal("FAmount").add(amount)) >= 0) {
                sqlUpdate1 = new StringBuffer();
                sqlUpdate1.append("update T_MNT_ForecastedBlockingFlow set  FAmount =" + rs.getBigDecimal("FAmount").add(amount) + " WHERE FID ='" + rs.getString("FID") + "';");
                DbUtil.execute((Context)ctx, (String)sqlUpdate1.toString());
                amount = Constants.ZERO;
            } else {
                amount = amount.subtract(rs.getBigDecimal("FOriginalAmount").subtract(rs.getBigDecimal("FAmount")));
                sqlUpdate2 = new StringBuffer();
                sqlUpdate2.append("update T_MNT_ForecastedBlockingFlow set  FAmount =" + rs.getBigDecimal("FOriginalAmount") + " WHERE FID ='" + rs.getString("FID") + "';");
                DbUtil.execute((Context)ctx, (String)sqlUpdate2.toString());
            }
            if (amount.compareTo(Constants.ZERO) != 0) continue;
            break;
        }
    }

    private void doAmountBigThanZero(Context ctx, BOSUuid billId, BigDecimal amount) throws BOSException, SQLException {
        String sql = "Select FID,FExpectedDate,FAmount from T_MNT_ForecastedBlockingFlow  where FBillId= ? order by FExpectedDate ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId.toString()});
        StringBuffer sqlUpdate1 = null;
        StringBuffer sqlUpdate2 = null;
        while (rs.next()) {
            if (rs.getBigDecimal("FAmount").compareTo(Constants.ZERO) == 0) continue;
            if (amount.compareTo(rs.getBigDecimal("FAmount")) >= 0) {
                amount = amount.subtract(rs.getBigDecimal("FAmount"));
                sqlUpdate1 = new StringBuffer();
                sqlUpdate1.append("update T_MNT_ForecastedBlockingFlow set  FAmount =" + Constants.ZERO + " WHERE FID = '" + rs.getString("FID") + "';");
                DbUtil.execute((Context)ctx, (String)sqlUpdate1.toString());
                continue;
            }
            sqlUpdate2 = new StringBuffer();
            sqlUpdate2.append("update T_MNT_ForecastedBlockingFlow set  FAmount =" + rs.getBigDecimal("FAmount").subtract(amount) + " WHERE FID = '" + rs.getString("FID") + "';");
            DbUtil.execute((Context)ctx, (String)sqlUpdate2.toString());
            break;
        }
    }
}

