/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.mnt.CompanyAnotherNameCollection;
import com.kingdee.eas.fm.mnt.DataSourceSettingInfo;
import com.kingdee.eas.fm.mnt.FundFlowDayReportFactory;
import com.kingdee.eas.fm.mnt.FundFlowDayReportInfo;
import com.kingdee.eas.fm.mnt.IFundFlowDayReport;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.MerageUnitCollection;
import com.kingdee.eas.fm.mnt.MerageUnitFactory;
import com.kingdee.eas.fm.mnt.MerageUnitInfo;
import com.kingdee.eas.fm.mnt.app.AbstractFundDateReportFacadeControllerBean;
import com.kingdee.eas.fm.mnt.app.service.AgentPay2DayReportBuilderImpl;
import com.kingdee.eas.fm.mnt.app.service.FundFlowDayReportBuilderFactory;
import com.kingdee.eas.fm.mnt.app.service.IFundFlowDayReportBuilder;
import com.kingdee.eas.fm.mnt.app.service.Payment2DayReportBuilderImpl;
import com.kingdee.eas.fm.mnt.app.service.Receiving2DayReportBuilderImpl;
import com.kingdee.eas.fm.mnt.app.service.TransDetail2DayReportBuilderImpl;
import com.kingdee.eas.fm.mnt.app.service.TransDown2DayReportBuilderImpl;
import com.kingdee.eas.fm.mnt.app.service.TransUp2DayReportBuilderImpl;
import com.kingdee.eas.fm.mnt.utils.MNTUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundDateReportFacadeControllerBean
extends AbstractFundDateReportFacadeControllerBean {
    private static final long serialVersionUID = -240470593433091582L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.FundDateReportFacadeControllerBean");
    private static String RESOURCE = "com.kingdee.eas.fm.mnt.ReportResource";

    @Override
    protected void _getData(Context ctx, String userNo, int intervalDays) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer();
        if (intervalDays < 0) {
            msg.append("param is error! intervalDays = " + intervalDays);
            logger.error((Object)msg);
            this.sendMessage(ctx, msg.toString(), userNo);
            return;
        }
        Date endDate = DateTimeUtils.truncateDate((Date)new Date());
        Date beginDate = DateHelper.getNextDay((Date)endDate, (int)(0 - intervalDays));
        try {
            String result = this._getData4UI(ctx, beginDate, endDate);
            this.sendMessage(ctx, result, userNo);
        }
        catch (MNTException e) {
            msg.append(e.getMessage());
            this.sendMessage(ctx, msg.toString(), userNo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _getData4UI(Context ctx, Date beginDate, Date endDate) throws BOSException, EASBizException {
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        DataSourceSettingInfo dsInfo = MNTUtils.getDataSourceSetting(ctx, cu.getId().toString());
        if (dsInfo == null) {
            logger.error((Object)"\u6570\u636e\u6e90(DataSourceSettingInfo)\u8bbe\u7f6e\u4e3a\u7a7a\uff01");
            throw new MNTException(MNTException.FUNDFLOWDAYRPT_DATASOURCESETTING_ISNULL);
        }
        Map<String, List<String>> aliasMap = this.getCompanyAliasMap(ctx);
        if (aliasMap.size() == 0) {
            logger.error((Object)"\u7ec4\u7ec7\u5355\u5143\u5206\u7ec4(MerageUnitInfo)\u8bbe\u7f6e\u4e3a\u7a7a\uff01");
            throw new MNTException(MNTException.FUNDFLOWDAYRPT_MERAGEUNIT_ISNULL);
        }
        endDate = FMHelper.getLastEndDate((Date)DateUtil.getNextDay((Date)endDate));
        IFundFlowDayReport iFundFlowDayReport = FundFlowDayReportFactory.getLocalInstance(ctx);
        Map<String, FundFlowDayReportInfo> bKMap = this.getModifiedFundFlowID(ctx, beginDate, endDate);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)endDate, CompareType.LESS_EQUALS));
        IObjectPK[] pks = iFundFlowDayReport.delete(filter);
        this.deleteBOTPRelation(ctx, pks);
        logger.error((Object)("delete FundFlowDayReport from " + DateHelper.formatDate2((Date)beginDate) + " to " + DateHelper.formatDate2((Date)endDate) + " is sucess! Count = " + pks.length));
        CoreBaseCollection colls = this.doProcess(ctx, dsInfo.isIsBizBill(), aliasMap, beginDate, endDate);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)colls)) {
            this.updateFundFlowItems(ctx, colls, bKMap);
            iFundFlowDayReport.saveBatchData(colls);
        }
        return ResourceBase.getString((String)RESOURCE, (String)"ScheduleResult", (Locale)ctx.getLocale(), (Object[])new Object[]{colls.size()});
    }

    private void updateFundFlowItems(Context ctx, CoreBaseCollection colls, Map bKMap) throws BOSException {
        for (int i = 0; i < colls.size(); ++i) {
            FundFlowDayReportInfo info = (FundFlowDayReportInfo)colls.get(i);
            String key = info.getSourceBillId();
            if (info.getSourceBillEntryId() != null) {
                key = key + "_" + info.getSourceBillEntryId();
            }
            if (!bKMap.containsKey(key)) continue;
            FundFlowDayReportInfo bKInfo = (FundFlowDayReportInfo)bKMap.get(key);
            info.setFundFlowItem(bKInfo.getFundFlowItem());
        }
    }

    private Map<String, FundFlowDayReportInfo> getModifiedFundFlowID(Context ctx, Date beginDate, Date endDate) throws BOSException {
        HashMap<String, FundFlowDayReportInfo> infoMap = new HashMap<String, FundFlowDayReportInfo>();
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("select bk.FID,bk.FSourceBillID, bk.FFundFlowItemID,bk.FSourceBillEntryId from T_MNT_FundFlowDayReportBK bk ");
            sql.append("inner join T_MNT_FundFlowDayReport a on bk.FSourceBillID = a.FSourceBillID");
            sql.append(" where bk.FBizDate >= {d'").append(DateHelper.formatDate2((Date)beginDate)).append("'}");
            sql.append(" and bk.FBizDate <= {d'").append(DateHelper.formatDate2((Date)endDate)).append("'}");
            sql.append("order by bk.FBizDate desc");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            rs.beforeFirst();
            while (rs.next()) {
                String sourceBillId = rs.getString("FSourceBillID");
                String sourceBillEntryId = rs.getString("FSourceBillEntryId");
                String key = sourceBillId;
                if (sourceBillEntryId != null) {
                    key = key + "_" + sourceBillEntryId;
                }
                FundFlowDayReportInfo info = new FundFlowDayReportInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setSourceBillId(sourceBillId);
                info.setSourceBillEntryId(sourceBillEntryId);
                FundFlowItemInfo item = new FundFlowItemInfo();
                item.setId(BOSUuid.read((String)rs.getString("FFundFlowItemID")));
                info.setFundFlowItem(item);
                infoMap.put(key, info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return infoMap;
    }

    private CoreBaseCollection doProcess(Context ctx, boolean isBizBill, Map<String, List<String>> aliasMap, Date beginDate, Date endDate) throws BOSException, EASBizException {
        CoreBaseCollection colls = null;
        String builderName = null;
        IFundFlowDayReportBuilder builder = null;
        if (isBizBill) {
            CoreBaseCollection transDownColls;
            CoreBaseCollection transUpColls;
            CoreBaseCollection agentPayColls;
            CoreBaseCollection payColls;
            colls = new CoreBaseCollection();
            builderName = Receiving2DayReportBuilderImpl.class.getName();
            builder = FundFlowDayReportBuilderFactory.getInstance(builderName);
            CoreBaseCollection recColls = builder.getFundFlowDayReportColl(ctx, aliasMap, beginDate, endDate);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)recColls)) {
                colls.addCollection(recColls);
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)(payColls = (builder = FundFlowDayReportBuilderFactory.getInstance(builderName = Payment2DayReportBuilderImpl.class.getName())).getFundFlowDayReportColl(ctx, aliasMap, beginDate, endDate)))) {
                colls.addCollection(payColls);
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)(agentPayColls = (builder = FundFlowDayReportBuilderFactory.getInstance(builderName = AgentPay2DayReportBuilderImpl.class.getName())).getFundFlowDayReportColl(ctx, aliasMap, beginDate, endDate)))) {
                colls.addCollection(agentPayColls);
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)(transUpColls = (builder = FundFlowDayReportBuilderFactory.getInstance(builderName = TransUp2DayReportBuilderImpl.class.getName())).getFundFlowDayReportColl(ctx, aliasMap, beginDate, endDate)))) {
                colls.addCollection(transUpColls);
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)(transDownColls = (builder = FundFlowDayReportBuilderFactory.getInstance(builderName = TransDown2DayReportBuilderImpl.class.getName())).getFundFlowDayReportColl(ctx, aliasMap, beginDate, endDate)))) {
                colls.addCollection(transDownColls);
            }
        } else {
            builderName = TransDetail2DayReportBuilderImpl.class.getName();
            builder = FundFlowDayReportBuilderFactory.getInstance(builderName);
            colls = builder.getFundFlowDayReportColl(ctx, aliasMap, beginDate, endDate);
        }
        return colls;
    }

    private Map<String, List<String>> getCompanyAliasMap(Context ctx) throws BOSException {
        HashMap<String, List<String>> aliasMap = new HashMap<String, List<String>>();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("companyOtherName.*"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sc);
        MerageUnitCollection colls = MerageUnitFactory.getLocalInstance(ctx).getMerageUnitCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            MerageUnitInfo info = colls.get(i);
            String key = info.getCompany().getId().toString();
            ArrayList<String> lst = (ArrayList<String>)aliasMap.get(key);
            if (lst == null) {
                lst = new ArrayList<String>();
            }
            CompanyAnotherNameCollection entries = info.getCompanyOtherName();
            for (int j = 0; j < entries.size(); ++j) {
                if (EmptyUtil.isEmpty((String)entries.get(j).getName())) continue;
                lst.add(entries.get(j).getName());
            }
            aliasMap.put(key, lst);
        }
        return aliasMap;
    }

    private Set<String> getCompanyIds(Context ctx) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("companyOtherName.*"));
        MerageUnitCollection colls = MerageUnitFactory.getLocalInstance(ctx).getMerageUnitCollection();
        for (int i = 0; i < colls.size(); ++i) {
            MerageUnitInfo info = colls.get(i);
            ids.add(info.getCompany().getId().toString());
        }
        return ids;
    }

    private void sendMessage(Context ctx, String msg, String msgReceiver) throws BOSException {
        if (msg.endsWith("\uff0c")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        this.sendByMessage(ctx, "\u8d44\u91d1\u6d41\u91cf\u65e5\u62a5\u8868\u6570\u636e\u4e0b\u8f7d\u8c03\u5ea6", "administrator", msg, msgReceiver);
    }

    private void sendByMessage(Context ctx, String msgTitle, String msgSender, String msgBody, String msgReceiver) throws BOSException {
        if (!EmptyUtil.isEmpty((String)msgReceiver)) {
            SenderAgent senderAgent = SenderAgent.getSenderAgent();
            Locale[] lcla = FundDateReportFacadeControllerBean.getContextLocales(ctx);
            Locale locale2 = null;
            Message message = MessageFactory.newMessage((String)"kingdee.workflow");
            String[] userNumbers = msgReceiver.split(",");
            HashSet<String> userNumberset = new HashSet<String>();
            for (int i = 0; i < userNumbers.length; ++i) {
                userNumberset.add(userNumbers[i]);
            }
            if (userNumberset.size() <= 0) {
                return;
            }
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", userNumberset, CompareType.INCLUDE));
            view.setFilter(fi);
            UserCollection collection = iUser.getUserCollection(view);
            StringBuffer users = new StringBuffer("");
            for (Locale locale2 : lcla) {
                message.setLocaleStringHeader("title", msgTitle, locale2);
                message.setLocaleStringHeader("sender", msgSender, locale2);
                message.setLocaleStringHeader("body", msgBody, locale2);
            }
            for (int i = 0; i < collection.size(); ++i) {
                UserInfo userInfo = collection.get(i);
                if (i == 0) {
                    users.append(userInfo.getId().toString());
                    continue;
                }
                users.append(";" + userInfo.getId().toString());
            }
            message.setIntHeader("type", 0);
            message.setIntHeader("bizType", 50);
            message.setIntHeader("sourceStatus", 0);
            message.setIntHeader("priority", 10);
            message.setStringHeader("databaseCenter", ctx.getAIS());
            message.setStringHeader("solution", ctx.getSolution());
            if (!"".equals(users.toString())) {
                message.setStringHeader("receiver", users.toString());
                senderAgent.sendMessage(message);
            }
        }
    }

    private void deleteBOTPRelation(Context ctx, IObjectPK[] pks) throws BOSException {
        if (pks == null || pks.length <= 0) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            ids.append("'").append(pks[i].toString());
            ids.append("',");
        }
        if (ids.length() > 1) {
            ids.deleteCharAt(ids.length() - 1);
            StringBuffer sql = new StringBuffer();
            sql.append("delete from T_BOT_Relation where FDestObjectID in(").append(ids.toString()).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }
}

