/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mnt.FundFlowDayReportCollection;
import com.kingdee.eas.fm.mnt.FundFlowDayReportInfo;
import com.kingdee.eas.fm.mnt.MNTException;
import com.kingdee.eas.fm.mnt.app.AbstractFundFlowDayReportControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundFlowDayReportControllerBean
extends AbstractFundFlowDayReportControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.app.FundFlowDayReportControllerBean");
    private static final String resPath = "com.kingdee.eas.fm.mnt.MNTAutoGenerateResource";
    private static final String resKey = "586_FundFlowDayReportControllerBean";

    @Override
    protected Map _batchDelete(Context ctx, List idList) throws BOSException, EASBizException {
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet idSet = new HashSet(idList);
        FundFlowDayReportCollection coll = this.getFundFlowDayReportColl(ctx, idSet);
        ObjectUuidPK[] pkArray = new ObjectUuidPK[coll.size()];
        FundFlowDayReportInfo info = null;
        int validCount = 0;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            try {
                if (info.isIsByManual()) {
                    throw new MNTException(MNTException.FUNDFLOWDAYRPT_AUTOGEN_CANNOTDEL);
                }
                pkArray[validCount++] = new ObjectUuidPK(info.getId().toString());
                continue;
            }
            catch (Exception ex) {
                errorDetail = errorDetail + this.getErrorMsg(ctx, info.getNumber(), ex) + "\n";
            }
        }
        this.deleteBatchData(ctx, (IObjectPK[])pkArray);
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    private FundFlowDayReportCollection getFundFlowDayReportColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        FundFlowDayReportCollection coll = this.getFundFlowDayReportCollection(ctx, evi);
        return coll;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("isByManual");
        sel.add("id");
        sel.add("number");
        return sel;
    }

    private String getErrorMsg(Context ctx, String number, Exception ex) {
        return ResourceBase.getString((String)resPath, (String)resKey, (Locale)ctx.getLocale()) + number + "\uff1a" + ex.getMessage();
    }

    @Override
    protected void _backUpFlowItem(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList != null && idList.size() > 0) {
            StringBuffer idBuffer = new StringBuffer();
            Iterator iter = idList.iterator();
            while (iter.hasNext()) {
                idBuffer.append("'");
                idBuffer.append((String)iter.next());
                idBuffer.append("'");
                idBuffer.append(",");
            }
            idBuffer.deleteCharAt(idBuffer.length() - 1);
            StringBuffer sql = new StringBuffer();
            sql.append("delete from T_MNT_FundFlowDayReportBK where fid in(");
            sql.append("select bk.fid from T_MNT_FundFlowDayReportBK bk inner join  T_MNT_FundFlowDayReport a ");
            sql.append("on bk.fsourceBillId = a.fsourceBillId  and isnull(bk.fsourceBillEntryId,'id') = isnull(a.fsourceBillEntryId,'id') where a.fid in(");
            sql.append(idBuffer.toString()).append("))");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("insert into T_MNT_FundFlowDayReportBK ");
            sql.append("select Fid,FFundFlowItemID,FSourceBillID,FSourceBillEntryId,FBizDate from T_MNT_FundFlowDayReport where fid in(");
            sql.append(idBuffer.toString());
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

